/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.MdmSystemLoginService;
import com.biz.crm.nebular.mdm.login.MdmLoginEncryptReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.LoginEncryptUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmSystemLoginController"})
@Api(tags={"MDM-\u767b\u5f55\u767b\u51fa-\u7cfb\u7edf\u540e\u53f0"})
@CrmGlobalLog
public class MdmSystemLoginController {
    @Autowired
    private MdmSystemLoginService mdmSystemLoginService;

    @ApiOperation(value="\u767b\u5f55\uff08\u8d26\u53f7+\u5bc6\u7801\uff09")
    @PostMapping(value={"/login"})
    public Result<MdmLoginRespVo> login(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmSystemLoginService.login(this.revert(reqVo)));
    }

    @ApiOperation(value="\u767b\u5f55\uff08\u624b\u673a\u53f7+\u5bc6\u7801\uff09")
    @PostMapping(value={"/loginByPhone"})
    public Result<MdmLoginRespVo> loginByPhone(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmSystemLoginService.loginByPhone(this.revert(reqVo)));
    }

    @ApiOperation(value="\u767b\u5f55\uff08\u90ae\u7bb1+\u5bc6\u7801\uff09")
    @PostMapping(value={"/loginByEmail"})
    public Result<MdmLoginRespVo> loginByEmail(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmSystemLoginService.loginByEmail(this.revert(reqVo)));
    }

    @ApiOperation(value="\u767b\u5f55\uff08\u624b\u673a\u53f7+\u9a8c\u8bc1\u7801\uff09")
    @PostMapping(value={"/loginByPhoneVerification"})
    public Result<MdmLoginRespVo> loginByPhoneVerification(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmSystemLoginService.loginByPhoneVerification(this.revert(reqVo)));
    }

    @ApiOperation(value="\u767b\u5f55\uff08\u90ae\u7bb1+\u9a8c\u8bc1\u7801\uff09")
    @PostMapping(value={"/loginByEmailVerification"})
    public Result<MdmLoginRespVo> loginByEmailVerification(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmSystemLoginService.loginByEmailVerification(this.revert(reqVo)));
    }

    @ApiOperation(value="\u6821\u9a8c\u624b\u673a\u53f7\u662f\u5426\u5b58\u5728\u4e14\u53ef\u7528\uff08\u7528\u4e8e\u767b\u5f55\u540e\u53f0\uff09")
    @PostMapping(value={"/checkPhoneExistAndUsable"})
    public Result checkPhoneExistAndUsable(@RequestBody MdmLoginEncryptReqVo reqVo) {
        this.mdmSystemLoginService.checkPhoneExistAndUsable(this.revert(reqVo));
        return Result.ok();
    }

    @ApiOperation(value="\u6821\u9a8c\u90ae\u7bb1\u662f\u5426\u5b58\u5728\u4e14\u53ef\u7528\uff08\u7528\u4e8e\u767b\u5f55\u540e\u53f0\uff09")
    @PostMapping(value={"/checkEmailExistAndUsable"})
    public Result checkEmailExistAndUsable(@RequestBody MdmLoginEncryptReqVo reqVo) {
        this.mdmSystemLoginService.checkEmailExistAndUsable(this.revert(reqVo));
        return Result.ok();
    }

    @ApiOperation(value="\u53d1\u9001\u767b\u5f55\u9a8c\u8bc1\u7801\uff08\u624b\u673a\u53f7\uff09")
    @PostMapping(value={"/sendVerificationForLoginByMessage"})
    public Result sendVerificationForLoginByMessage(@RequestBody MdmLoginEncryptReqVo reqVo) {
        this.mdmSystemLoginService.sendVerificationForLoginByMessage(this.revert(reqVo));
        return Result.ok();
    }

    @ApiOperation(value="\u53d1\u9001\u767b\u5f55\u9a8c\u8bc1\u7801\uff08\u90ae\u7bb1\uff09")
    @PostMapping(value={"/sendVerificationForLoginByEmail"})
    public Result sendVerificationForLoginByEmail(@RequestBody MdmLoginEncryptReqVo reqVo) {
        this.mdmSystemLoginService.sendVerificationForLoginByEmail(this.revert(reqVo));
        return Result.ok();
    }

    @ApiOperation(value="\u9a8c\u8bc1\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u7801\u5e76\u767b\u5f55\uff08\u624b\u673a\u53f7+\u9a8c\u8bc1\u7801\uff09")
    @PostMapping(value={"/loginAndResetByPhoneVerification"})
    public Result<MdmLoginRespVo> loginAndResetByPhoneVerification(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmSystemLoginService.loginAndResetByPhoneVerification(this.revert(reqVo)));
    }

    @ApiOperation(value="\u9a8c\u8bc1\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u7801\u5e76\u767b\u5f55\uff08\u90ae\u7bb1+\u9a8c\u8bc1\u7801\uff09")
    @PostMapping(value={"/loginAndResetByEmailVerification"})
    public Result<MdmLoginRespVo> loginAndResetByEmailVerification(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmSystemLoginService.loginAndResetByEmailVerification(this.revert(reqVo)));
    }

    @ApiOperation(value="\u53d1\u9001\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u7801\uff08\u624b\u673a\u53f7\uff09")
    @PostMapping(value={"/sendVerificationForLoginAndResetByMessage"})
    public Result sendVerificationForLoginAndResetByMessage(@RequestBody MdmLoginEncryptReqVo reqVo) {
        this.mdmSystemLoginService.sendVerificationForLoginAndResetByMessage(this.revert(reqVo));
        return Result.ok();
    }

    @ApiOperation(value="\u53d1\u9001\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u7801\uff08\u90ae\u7bb1\uff09")
    @PostMapping(value={"/sendVerificationForLoginAndResetByEmail"})
    public Result sendVerificationForLoginAndResetByEmail(@RequestBody MdmLoginEncryptReqVo reqVo) {
        this.mdmSystemLoginService.sendVerificationForLoginAndResetByEmail(this.revert(reqVo));
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u767b\u5f55\u65b9\u5f0f\u7684\u63a7\u5236\u53c2\u6570")
    @PostMapping(value={"/getLoginTypeControlConfig"})
    public Result<MdmLoginTypeControlVo> getLoginTypeControlConfig() {
        return Result.ok((Object)this.mdmSystemLoginService.getLoginTypeControlConfig());
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55\uff08\u9000\u51fa\u5f53\u524d\u4f1a\u8bdd\uff09")
    @PostMapping(value={"/logout"})
    public Result logout() {
        UserUtils.logout();
        return Result.ok();
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55\uff08\u9000\u51fa\u5f53\u524d\u4f1a\u8bdd\u8d26\u53f7\u5728\u540e\u53f0\u7684\u5168\u90e8\u4f1a\u8bdd\uff09")
    @PostMapping(value={"/logoutFromType"})
    public Result logoutFromType() {
        UserUtils.logout((String)LoginFromTypeEnum.CONSOLE.getValue());
        return Result.ok();
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55\uff08\u9000\u51fa\u5f53\u524d\u4f1a\u8bdd\u8d26\u53f7\u5728\u6240\u6709\u5e73\u53f0\u7684\u5168\u90e8\u4f1a\u8bdd\uff09")
    @PostMapping(value={"/logoutAll"})
    public Result logoutAll() {
        UserRedis user = UserUtils.getUser();
        if (user != null && StringUtils.isNotEmpty((String)user.getUsername())) {
            UserUtils.deleteUser((String)user.getUsername());
        }
        return Result.ok();
    }

    private MdmLoginReqVo revert(MdmLoginEncryptReqVo reqVo) {
        MdmLoginReqVo loginReqVo = new MdmLoginReqVo();
        loginReqVo.setVfymoeapvkxygsef(reqVo.getVfymoeapvkxygsef());
        if (StringUtils.isNotEmpty((String)reqVo.getUjlrwebjruzddjnu())) {
            loginReqVo.setUserName(reqVo.getUjlrwebjruzddjnu());
            loginReqVo.setUjlrwebjruzddjnu(reqVo.getUjlrwebjruzddjnu());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getPazjofxkyvyoosot())) {
            loginReqVo.setPassword(LoginEncryptUtil.decrypt(reqVo.getPazjofxkyvyoosot()));
            loginReqVo.setPazjofxkyvyoosot(reqVo.getPazjofxkyvyoosot());
        } else if (StringUtils.isNotEmpty((String)reqVo.getPenijmgsbybkfjvr())) {
            loginReqVo.setPassword(reqVo.getPenijmgsbybkfjvr());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getTwpbmjhfxodboggf())) {
            loginReqVo.setUserPhone(reqVo.getTwpbmjhfxodboggf());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getExzvsxwhvcvcctyk())) {
            loginReqVo.setEmail(reqVo.getExzvsxwhvcvcctyk());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getVfymxygsefoeapvk())) {
            loginReqVo.setVerificationCode(reqVo.getVfymxygsefoeapvk());
        }
        loginReqVo.setFromType(LoginFromTypeEnum.CONSOLE.getValue());
        return loginReqVo;
    }
}

