/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pricesetting.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.PriceSettingFieldEnum;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.pricesetting.mapper.MdmPriceConditionGroupRelFieldMapper;
import com.biz.crm.pricesetting.mapper.MdmPriceConditionTypeMapper;
import com.biz.crm.pricesetting.mapper.MdmPriceSettingMapper;
import com.biz.crm.pricesetting.model.MdmPriceConditionGroupRelFieldEntity;
import com.biz.crm.pricesetting.model.MdmPriceConditionTypeEntity;
import com.biz.crm.pricesetting.model.MdmPriceSettingEntity;
import com.biz.crm.pricesetting.service.IMdmPriceSettingService;
import com.biz.crm.product.model.MdmProductEntity;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmPriceSettingServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(MdmPriceSettingServiceHelper.class);
    @Resource
    private MdmPriceSettingMapper mdmPriceSettingMapper;
    @Autowired
    private IMdmPriceSettingService iMdmPriceSettingService;
    @Resource
    private MdmPriceConditionGroupRelFieldMapper mdmPriceConditionGroupRelFieldMapper;
    @Resource
    private MdmPriceConditionTypeMapper mdmPriceConditionTypeMapper;
    @Resource
    private MdmProductService mdmProductService;
    @Resource
    private CrmLogSendUtil crmLogSendUtil;

    public void saveCheck(MdmPriceSettingReqVo reqVo) {
        this.dataRequired(reqVo);
    }

    private List<MdmPriceConditionGroupRelFieldEntity> dataIllegal(MdmPriceSettingReqVo reqVo) {
        List conditionTypeEntities = this.mdmPriceConditionTypeMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(MdmPriceConditionTypeEntity::getConditionTypeCode, (Object)reqVo.getConditionTypeCode()));
        AssertUtils.isNotEmpty((Collection)conditionTypeEntities, (String)"\u6761\u4ef6\u7c7b\u578b\u7f16\u7801\u4e0d\u5b58\u5728");
        List fieldEntities = this.mdmPriceConditionGroupRelFieldMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, (Object)reqVo.getConditionGroupCode()));
        AssertUtils.isNotEmpty((Collection)fieldEntities, (String)"\u6761\u4ef6\u5b57\u6bb5\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
        return fieldEntities;
    }

    public void dataUniqueSaveOrUpdate(MdmPriceSettingReqVo reqVo) {
        MdmPriceSettingEntity oldEntity;
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        String menuString = "";
        if (menuObject != null) {
            menuString = menuObject.toString();
        }
        MdmPriceSettingReqVo oldReqVo = null;
        if (StringUtils.isNotEmpty((String)reqVo.getId()) && (oldEntity = (MdmPriceSettingEntity)this.mdmPriceSettingMapper.selectById((Serializable)((Object)reqVo.getId()))) != null) {
            oldReqVo = (MdmPriceSettingReqVo)CrmBeanUtil.copy((Object)oldEntity, MdmPriceSettingReqVo.class);
        }
        if (YesNoEnum.yesNoEnum.Y.getValue().equalsIgnoreCase(ParamUtil.getParameterValueNoException((String)"price_chunk_config"))) {
            MdmPriceSettingEntity entity2 = (MdmPriceSettingEntity)CrmBeanUtil.copy((Object)reqVo, MdmPriceSettingEntity.class);
            entity2.setPriceSettingCode(CodeUtil.createOneCode((String)"mdm_price_setting"));
            this.iMdmPriceSettingService.saveOrUpdate(entity2);
            CrmBeanUtil.copyProperties((Object)entity2, (Object)reqVo);
            if (StringUtils.isNotEmpty((String)menuString)) {
                if (oldReqVo != null && StringUtils.isNotEmpty((String)oldReqVo.getId())) {
                    this.crmLogSendUtil.sendForUpdate(menuString, oldReqVo.getId(), oldReqVo.getPriceSettingCode(), (Object)oldReqVo, (Object)reqVo);
                } else {
                    this.crmLogSendUtil.sendForAdd(menuString, reqVo.getId(), reqVo.getPriceSettingCode(), (Object)reqVo);
                }
            }
            return;
        }
        QueryWrapper<MdmPriceSettingEntity> wrapper = this.wrapperCondition(reqVo);
        List list = this.mdmPriceSettingMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List mdmPriceSettingReqVos = CrmBeanUtil.copyList((List)list, MdmPriceSettingReqVo.class);
            List<MdmPriceSettingReqVo> mdmPriceSettingReqVoList = this.timeTruncation(reqVo, mdmPriceSettingReqVos);
            if (CollectionUtil.listNotEmpty(mdmPriceSettingReqVoList)) {
                MdmPriceSettingReqVo finalOldReqVo = oldReqVo;
                String finalMenuString = menuString;
                ArrayList entityList = new ArrayList();
                mdmPriceSettingReqVoList.forEach(mdmPriceSettingReqVo -> {
                    Date beginDate = DateUtil.localDateTimeConvertToDate((LocalDateTime)mdmPriceSettingReqVo.getBeginDateTime());
                    Date endDate = DateUtil.localDateTimeConvertToDate((LocalDateTime)mdmPriceSettingReqVo.getEndDateTime());
                    mdmPriceSettingReqVo.setBeginDate(DateUtil.getFormatDateStr((Date)beginDate, (String)"yyyy-MM-dd"));
                    mdmPriceSettingReqVo.setBeginDateSecond(DateUtil.getFormatDateStr((Date)beginDate, (String)"HH:mm:ss"));
                    mdmPriceSettingReqVo.setEndDate(DateUtil.getFormatDateStr((Date)endDate, (String)"yyyy-MM-dd"));
                    mdmPriceSettingReqVo.setEndDateSecond(DateUtil.getFormatDateStr((Date)endDate, (String)"HH:mm:ss"));
                    MdmPriceSettingEntity entity = (MdmPriceSettingEntity)CrmBeanUtil.copy((Object)mdmPriceSettingReqVo, MdmPriceSettingEntity.class);
                    entityList.add(entity);
                });
                this.iMdmPriceSettingService.saveOrUpdateBatch(entityList);
                entityList.forEach(entity -> {
                    MdmPriceSettingReqVo logData = (MdmPriceSettingReqVo)CrmBeanUtil.copy((Object)entity, MdmPriceSettingReqVo.class);
                    if (finalOldReqVo != null && StringUtils.isNotEmpty((String)finalOldReqVo.getId()) && finalOldReqVo.getId().equals(logData.getId())) {
                        this.crmLogSendUtil.sendForUpdate(finalMenuString, logData.getId(), logData.getPriceSettingCode(), (Object)finalOldReqVo, (Object)logData);
                    } else {
                        this.crmLogSendUtil.sendForAdd(finalMenuString, reqVo.getId(), reqVo.getPriceSettingCode(), (Object)logData);
                    }
                });
            }
        } else {
            MdmPriceSettingEntity entity3 = (MdmPriceSettingEntity)CrmBeanUtil.copy((Object)reqVo, MdmPriceSettingEntity.class);
            entity3.setPriceSettingCode(CodeUtil.createOneCode((String)"mdm_price_setting"));
            this.iMdmPriceSettingService.saveOrUpdate(entity3);
            CrmBeanUtil.copyProperties((Object)entity3, (Object)reqVo);
            if (oldReqVo != null && StringUtils.isNotEmpty((String)oldReqVo.getId())) {
                this.crmLogSendUtil.sendForUpdate(menuString, oldReqVo.getId(), oldReqVo.getPriceSettingCode(), (Object)oldReqVo, (Object)reqVo);
            } else if (StringUtils.isNotEmpty((String)entity3.getId())) {
                this.crmLogSendUtil.sendForAdd(menuString, entity3.getId(), entity3.getPriceSettingCode(), (Object)reqVo);
            }
        }
    }

    protected QueryWrapper<MdmPriceSettingEntity> wrapperCondition(MdmPriceSettingReqVo reqVo) {
        MdmProductEntity product;
        if (StringUtils.isNotEmpty((String)reqVo.getProductCode()) && (product = (MdmProductEntity)((LambdaQueryChainWrapper)this.mdmProductService.lambdaQuery().eq(MdmProductEntity::getProductCode, (Object)reqVo.getProductCode())).select(new SFunction[]{MdmProductEntity::getProductName}).one()) != null) {
            reqVo.setProductName(product.getProductName());
        }
        QueryWrapper<MdmPriceSettingEntity> wrapper = this.setUpWrapper(reqVo);
        this.setFieldCondition(wrapper, reqVo);
        return wrapper;
    }

    protected QueryWrapper<MdmPriceSettingEntity> setUpWrapper(MdmPriceSettingReqVo reqVo) {
        QueryWrapper wrapper = new QueryWrapper();
        Map map = DictUtil.dictMap((String)"price_truncation");
        if (map.containsKey("condition_type_code") && !StringUtils.isEmpty((String)reqVo.getConditionTypeCode())) {
            wrapper.eq((Object)"condition_type_code", (Object)reqVo.getConditionTypeCode());
        }
        if (map.containsKey("condition_group_code") && !StringUtils.isEmpty((String)reqVo.getConditionGroupCode())) {
            wrapper.eq((Object)"condition_group_code", (Object)reqVo.getConditionGroupCode());
        }
        if (map.containsKey("currency_type") && !StringUtils.isEmpty((String)reqVo.getCurrencyType())) {
            wrapper.eq((Object)"currency_type", (Object)reqVo.getCurrencyType());
        }
        if (map.containsKey("price_unit") && !StringUtils.isEmpty((String)reqVo.getPriceUnit())) {
            wrapper.eq((Object)"price_unit", (Object)reqVo.getPriceUnit());
        }
        if (map.containsKey("unit_type") && !StringUtils.isEmpty((String)reqVo.getUnitType())) {
            wrapper.eq((Object)"unit_type", (Object)reqVo.getUnitType());
        }
        if (map.containsKey("ext1") && !StringUtils.isEmpty((String)reqVo.getExt1())) {
            wrapper.eq((Object)"ext1", (Object)reqVo.getExt1());
        }
        if (map.containsKey("ext2") && !StringUtils.isEmpty((String)reqVo.getExt2())) {
            wrapper.eq((Object)"ext2", (Object)reqVo.getExt2());
        }
        if (map.containsKey("ext3") && !StringUtils.isEmpty((String)reqVo.getExt3())) {
            wrapper.eq((Object)"ext3", (Object)reqVo.getExt3());
        }
        if (map.containsKey("ext4") && !StringUtils.isEmpty((String)reqVo.getExt4())) {
            wrapper.eq((Object)"ext4", (Object)reqVo.getExt4());
        }
        if (map.containsKey("ext5") && !StringUtils.isEmpty((String)reqVo.getExt5())) {
            wrapper.eq((Object)"ext5", (Object)reqVo.getExt5());
        }
        if (map.containsKey("ext6") && !StringUtils.isEmpty((String)reqVo.getExt6())) {
            wrapper.eq((Object)"ext6", (Object)reqVo.getExt6());
        }
        if (map.containsKey("ext7") && !StringUtils.isEmpty((String)reqVo.getExt7())) {
            wrapper.eq((Object)"ext7", (Object)reqVo.getExt7());
        }
        if (map.containsKey("ext8") && !StringUtils.isEmpty((String)reqVo.getExt8())) {
            wrapper.eq((Object)"ext8", (Object)reqVo.getExt8());
        }
        if (map.containsKey("ext9") && !StringUtils.isEmpty((String)reqVo.getExt9())) {
            wrapper.eq((Object)"ext9", (Object)reqVo.getExt9());
        }
        if (map.containsKey("ext10") && !StringUtils.isEmpty((String)reqVo.getExt10())) {
            wrapper.eq((Object)"ext10", (Object)reqVo.getExt10());
        }
        return wrapper;
    }

    public void setFieldCondition(QueryWrapper<MdmPriceSettingEntity> wrapper, MdmPriceSettingReqVo reqVo) {
        List<MdmPriceConditionGroupRelFieldEntity> fieldEntities = this.dataIllegal(reqVo);
        wrapper.eq((Object)"enable_status", (Object)CrmEnableStatusEnum.ENABLE.getCode());
        wrapper.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
        fieldEntities.forEach(fieldEntity -> {
            if (PriceSettingFieldEnum.CHANNEL.getCode().equals(fieldEntity.getFieldCode())) {
                AssertUtils.isNotEmpty((String)reqVo.getChannel(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
                wrapper.eq((Object)"channel", (Object)reqVo.getChannel());
            }
            if (PriceSettingFieldEnum.CUSTOMER_CODE.getCode().equals(fieldEntity.getFieldCode())) {
                AssertUtils.isNotEmpty((String)reqVo.getCustomerCode(), (String)"\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
                wrapper.eq((Object)"customer_code", (Object)reqVo.getCustomerCode());
            }
            if (PriceSettingFieldEnum.ORG_CODE.getCode().equals(fieldEntity.getFieldCode())) {
                AssertUtils.isNotEmpty((String)reqVo.getOrgCode(), (String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
                wrapper.eq((Object)"org_code", (Object)reqVo.getOrgCode());
            }
            if (PriceSettingFieldEnum.PRODUCT_CODE.getCode().equals(fieldEntity.getFieldCode())) {
                AssertUtils.isNotEmpty((String)reqVo.getProductCode(), (String)"\u4ea7\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
                wrapper.eq((Object)"product_code", (Object)reqVo.getProductCode());
            }
            if (PriceSettingFieldEnum.TERMINAL.getCode().equals(fieldEntity.getFieldCode())) {
                AssertUtils.isNotEmpty((String)reqVo.getTerminalCode(), (String)"\u7ec8\u7aef\u4e0d\u80fd\u4e3a\u7a7a");
                wrapper.eq((Object)"terminal_code", (Object)reqVo.getTerminalCode());
            }
            if (PriceSettingFieldEnum.PRICE_GROUP.getCode().equals(fieldEntity.getFieldCode())) {
                AssertUtils.isNotEmpty((String)reqVo.getPriceGroup(), (String)"\u4ef7\u683c\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
                wrapper.eq((Object)"price_group", (Object)reqVo.getPriceGroup());
            }
        });
    }

    private List<MdmPriceSettingReqVo> timeTruncation(MdmPriceSettingReqVo reqVo, List<MdmPriceSettingReqVo> list) {
        reqVo.setBeginDateTime(DateUtil.dateConvertToLocalDateTime((Date)DateUtil.str2Date((String)reqVo.getBeginDate().trim().concat(" ").concat(reqVo.getBeginDateSecond()), (SimpleDateFormat)DateUtil.datetimeFormat)));
        reqVo.setEndDateTime(DateUtil.dateConvertToLocalDateTime((Date)DateUtil.str2Date((String)reqVo.getEndDate().trim().concat(" ").concat(reqVo.getEndDateSecond()), (SimpleDateFormat)DateUtil.datetimeFormat)));
        reqVo.setPriceSettingCode(CodeUtil.createOneCode((String)"mdm_price_setting"));
        ArrayList<MdmPriceSettingReqVo> priceSettingReqVos = new ArrayList<MdmPriceSettingReqVo>();
        for (MdmPriceSettingReqVo priceSetting : list) {
            priceSetting.setBeginDateTime(DateUtil.dateConvertToLocalDateTime((Date)DateUtil.str2Date((String)priceSetting.getBeginDate().trim().concat(" ").concat(priceSetting.getBeginDateSecond()), (SimpleDateFormat)DateUtil.datetimeFormat)));
            priceSetting.setEndDateTime(DateUtil.dateConvertToLocalDateTime((Date)DateUtil.str2Date((String)priceSetting.getEndDate().trim().concat(" ").concat(priceSetting.getEndDateSecond()), (SimpleDateFormat)DateUtil.datetimeFormat)));
            priceSettingReqVos.addAll(this.generate(priceSetting, reqVo));
        }
        List collect = priceSettingReqVos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MdmPriceSettingReqVo>(Comparator.comparing(MdmPriceSettingReqVo::getPriceSettingCode))), ArrayList::new));
        return collect;
    }

    private List<MdmPriceSettingReqVo> generate(MdmPriceSettingReqVo oldData, MdmPriceSettingReqVo newData) {
        ArrayList<MdmPriceSettingReqVo> list = new ArrayList<MdmPriceSettingReqVo>();
        long oldBeginDate = oldData.getBeginDateTime().toEpochSecond(ZoneOffset.of("+8"));
        long oldEndDate = oldData.getEndDateTime().toEpochSecond(ZoneOffset.of("+8"));
        long newBeginDate = newData.getBeginDateTime().toEpochSecond(ZoneOffset.of("+8"));
        long newEndDate = newData.getEndDateTime().toEpochSecond(ZoneOffset.of("+8"));
        if (newBeginDate == oldEndDate && newEndDate == oldBeginDate) {
            newData.setId(oldData.getId());
            list.add(newData);
        } else if (newBeginDate >= oldEndDate || newEndDate <= oldBeginDate) {
            if (newBeginDate == oldEndDate) {
                newData.setBeginDateTime(oldData.getEndDateTime().plusSeconds(1L));
            }
            if (newEndDate == oldBeginDate) {
                newData.setEndDateTime(oldData.getBeginDateTime().plusSeconds(-1L));
            }
            newData.setId("");
            newData.setPriceSettingCode(CodeUtil.createOneCode((String)"mdm_price_setting"));
            list.add(newData);
            list.add(oldData);
        } else {
            if (newBeginDate == oldBeginDate) {
                if (newEndDate > oldEndDate) {
                    newData.setBeginDateTime(oldData.getEndDateTime().plusSeconds(-1L));
                    newData.setId("");
                    newData.setPriceSettingCode(CodeUtil.createOneCode((String)"mdm_price_setting"));
                } else {
                    oldData.setBeginDateTime(newData.getEndDateTime().plusSeconds(1L));
                    newData.setId("");
                    newData.setPriceSettingCode(CodeUtil.createOneCode((String)"mdm_price_setting"));
                }
            } else if (newBeginDate < oldBeginDate) {
                if (newEndDate > oldEndDate) {
                    MdmPriceSettingReqVo data3 = (MdmPriceSettingReqVo)CrmBeanUtil.copy((Object)newData, MdmPriceSettingReqVo.class);
                    data3.setBeginDateTime(oldData.getEndDateTime().plusSeconds(1L));
                    data3.setId("");
                    data3.setPriceSettingCode(CodeUtil.createOneCode((String)"mdm_price_setting"));
                    newData.setEndDateTime(oldData.getBeginDateTime().plusSeconds(-1L));
                    newData.setId(oldData.getId());
                    newData.setPriceSettingCode(oldData.getPriceSettingCode());
                    list.add(data3);
                } else {
                    newData.setEndDateTime(oldData.getBeginDateTime().plusSeconds(-1L));
                }
            } else if (newEndDate >= oldEndDate) {
                oldData.setEndDateTime(newData.getBeginDateTime().plusSeconds(-1L));
                newData.setId("");
                newData.setBeginDateTime(oldData.getEndDateTime().plusSeconds(1L));
                newData.setPriceSettingCode(CodeUtil.createOneCode((String)"mdm_price_setting"));
            } else {
                MdmPriceSettingReqVo data3 = (MdmPriceSettingReqVo)CrmBeanUtil.copy((Object)oldData, MdmPriceSettingReqVo.class);
                oldData.setEndDateTime(newData.getBeginDateTime().plusSeconds(-1L));
                newData.setId("");
                newData.setBeginDateTime(oldData.getEndDateTime().plusSeconds(1L));
                newData.setPriceSettingCode(CodeUtil.createOneCode((String)"mdm_price_setting"));
                data3.setBeginDateTime(newData.getEndDateTime().plusSeconds(-1L));
                data3.setId("");
                data3.setPriceSettingCode(CodeUtil.createOneCode((String)"mdm_price_setting"));
                list.add(data3);
            }
            list.add(newData);
            list.add(oldData);
        }
        return list;
    }

    private void dataRequired(MdmPriceSettingReqVo reqVo) {
        long dateEnd;
        long dateStart;
        AssertUtils.isNotEmpty((String)reqVo.getConditionTypeCode(), (String)"\u6761\u4ef6\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getConditionGroupCode(), (String)"\u6761\u4ef6\u5b57\u6bb5\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getPrice(), (String)"\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getCurrencyType(), (String)"\u5e01\u79cd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getBeginDate(), (String)"\u6709\u6548\u671f\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotNull((Object)reqVo.getEndDate(), (String)"\u6709\u6548\u671f\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isEmpty((String)reqVo.getBeginDateSecond())) {
            reqVo.setBeginDateSecond("00:00:00");
        }
        if (StringUtils.isEmpty((String)reqVo.getEndDateSecond())) {
            reqVo.setEndDateSecond("23:59:59");
        }
        AssertUtils.isTrue(((dateStart = DateUtil.str2Date((String)reqVo.getBeginDate().trim().concat(" ").concat(reqVo.getBeginDateSecond()), (SimpleDateFormat)DateUtil.datetimeFormat).getTime()) < (dateEnd = DateUtil.str2Date((String)reqVo.getEndDate().trim().concat(" ").concat(reqVo.getEndDateSecond()), (SimpleDateFormat)DateUtil.datetimeFormat).getTime()) ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u6216\u8005\u7b49\u4e8e\u7ed3\u675f\u65e5\u671f");
    }
}

