/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.role.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.role.mapper.MdmRoleCustomerMapper;
import com.biz.crm.role.mode.MdmRoleCustomerEntity;
import com.biz.crm.role.service.MdmRoleCustomerService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmRoleCustomerServiceExpandImpl"})
@Transactional(rollbackFor={Exception.class})
public class MdmRoleCustomerServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmRoleCustomerMapper, MdmRoleCustomerEntity>
implements MdmRoleCustomerService {
    private static final Logger log = LoggerFactory.getLogger(MdmRoleCustomerServiceImpl.class);

    @Override
    public void addCustomerRole(String customerCode, String roleCode) {
        List list;
        if (StringUtils.isNotEmpty((String)customerCode) && StringUtils.isNotEmpty((String)roleCode) && CollectionUtil.listEmpty((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRoleCustomerEntity::getCustomerCode, (Object)customerCode)).eq(MdmRoleCustomerEntity::getRoleCode, (Object)roleCode)).list()))) {
            MdmRoleCustomerEntity entity = new MdmRoleCustomerEntity();
            entity.setCustomerCode(customerCode);
            entity.setRoleCode(roleCode);
            this.save(entity);
        }
    }

    @Override
    public void replaceCustomerRole(String customerCode, String roleCode) {
        if (StringUtils.isNotEmpty((String)customerCode)) {
            this.removeByCustomerCode(customerCode);
            if (StringUtils.isNotEmpty((String)roleCode)) {
                this.addCustomerRole(customerCode, roleCode);
            }
        }
    }

    @Override
    public void removeByCustomerCode(String customerCode) {
        if (StringUtils.isNotEmpty((String)customerCode)) {
            this.removeByCustomerCodes(Collections.singletonList(customerCode));
        }
    }

    @Override
    public void removeByCustomerCodes(List<String> customerCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(customerCodes)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmRoleCustomerEntity::getCustomerCode, customerCodes)).remove();
        }
    }

    @Override
    public void removeByRoleCode(String roleCode) {
        if (StringUtils.isNotEmpty((String)roleCode)) {
            this.removeByRoleCodes(Collections.singletonList(roleCode));
        }
    }

    @Override
    public void removeByRoleCodes(List<String> roleCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(roleCodes)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmRoleCustomerEntity::getRoleCode, roleCodes)).remove();
        }
    }
}

