/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.MdmDmsMallLoginService;
import com.biz.crm.nebular.mdm.login.MdmLoginEncryptReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.LoginEncryptUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmDmsMallLoginController"})
@Api(tags={"MDM-\u767b\u5f55\u767b\u51fa-DMS\u5546\u57ce"})
@CrmGlobalLog
public class MdmDmsMallLoginController {
    @Autowired
    private MdmDmsMallLoginService mdmDmsMallLoginService;

    @ApiOperation(value="\u767b\u5f55\uff08\u8d26\u53f7+\u5bc6\u7801\uff09")
    @PostMapping(value={"/login"})
    public Result<MdmLoginRespVo> login(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmDmsMallLoginService.login(this.revert(reqVo)));
    }

    @ApiOperation(value="\u767b\u5f55\uff08\u624b\u673a\u53f7+\u5bc6\u7801\uff09")
    @PostMapping(value={"/loginByPhone"})
    public Result<MdmLoginRespVo> loginByPhone(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmDmsMallLoginService.loginByPhone(this.revert(reqVo)));
    }

    @ApiOperation(value="\u767b\u5f55\uff08\u90ae\u7bb1+\u5bc6\u7801\uff09")
    @PostMapping(value={"/loginByEmail"})
    public Result<MdmLoginRespVo> loginByEmail(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmDmsMallLoginService.loginByEmail(this.revert(reqVo)));
    }

    @ApiOperation(value="\u767b\u5f55\uff08\u624b\u673a\u53f7+\u9a8c\u8bc1\u7801\uff09")
    @PostMapping(value={"/loginByPhoneVerification"})
    public Result<MdmLoginRespVo> loginByPhoneVerification(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmDmsMallLoginService.loginByPhoneVerification(this.revert(reqVo)));
    }

    @ApiOperation(value="\u767b\u5f55\uff08\u90ae\u7bb1+\u9a8c\u8bc1\u7801\uff09")
    @PostMapping(value={"/loginByEmailVerification"})
    public Result<MdmLoginRespVo> loginByEmailVerification(@RequestBody MdmLoginEncryptReqVo reqVo) {
        return Result.ok((Object)this.mdmDmsMallLoginService.loginByEmailVerification(this.revert(reqVo)));
    }

    @ApiOperation(value="\u53d1\u9001\u624b\u673a\u53f7\u767b\u5f55\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/sendVerificationForLoginByMessage"})
    public Result sendVerificationForLoginByMessage(@RequestBody MdmLoginEncryptReqVo reqVo) {
        this.mdmDmsMallLoginService.sendVerificationForLoginByMessage(this.revert(reqVo));
        return Result.ok();
    }

    @ApiOperation(value="\u53d1\u9001\u90ae\u7bb1\u767b\u5f55\u9a8c\u8bc1\u7801")
    @PostMapping(value={"/sendVerificationForLoginByEmail"})
    public Result sendVerificationForLoginByEmail(@RequestBody MdmLoginEncryptReqVo reqVo) {
        this.mdmDmsMallLoginService.sendVerificationForLoginByEmail(this.revert(reqVo));
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u53d6\u767b\u5f55\u65b9\u5f0f\u7684\u63a7\u5236\u53c2\u6570")
    @PostMapping(value={"/getLoginTypeControlConfig"})
    public Result<MdmLoginTypeControlVo> getLoginTypeControlConfig() {
        return Result.ok((Object)this.mdmDmsMallLoginService.getLoginTypeControlConfig());
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55\uff08\u9000\u51fa\u5f53\u524d\u4f1a\u8bdd\uff09")
    @PostMapping(value={"/logout"})
    public Result logout() {
        UserUtils.logout();
        return Result.ok();
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55\uff08\u9000\u51fa\u5f53\u524d\u4f1a\u8bdd\u8d26\u53f7\u5728DMS\u5546\u57ce\u7684\u5168\u90e8\u4f1a\u8bdd\uff09")
    @PostMapping(value={"/logoutFromType"})
    public Result logoutFromType() {
        UserUtils.logout((String)LoginFromTypeEnum.WEB_DMS.getValue());
        return Result.ok();
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55\uff08\u9000\u51fa\u5f53\u524d\u4f1a\u8bdd\u8d26\u53f7\u5728\u6240\u6709\u5e73\u53f0\u7684\u5168\u90e8\u4f1a\u8bdd\uff09")
    @PostMapping(value={"/logoutAll"})
    public Result logoutAll() {
        UserRedis user = UserUtils.getUser();
        if (user != null && StringUtils.isNotEmpty((String)user.getUsername())) {
            UserUtils.deleteUser((String)user.getUsername());
        }
        return Result.ok();
    }

    private MdmLoginReqVo revert(MdmLoginEncryptReqVo reqVo) {
        ThreadLocalUtil.delObj();
        MdmLoginReqVo loginReqVo = new MdmLoginReqVo();
        if (StringUtils.isNotEmpty((String)reqVo.getUjlrwebjruzddjnu())) {
            loginReqVo.setUserName(reqVo.getUjlrwebjruzddjnu());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getPazjofxkyvyoosot())) {
            loginReqVo.setPassword(LoginEncryptUtil.decrypt(reqVo.getPazjofxkyvyoosot()));
        } else if (StringUtils.isNotEmpty((String)reqVo.getPenijmgsbybkfjvr())) {
            loginReqVo.setPassword(reqVo.getPenijmgsbybkfjvr());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getTwpbmjhfxodboggf())) {
            loginReqVo.setUserPhone(reqVo.getTwpbmjhfxodboggf());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getExzvsxwhvcvcctyk())) {
            loginReqVo.setEmail(reqVo.getExzvsxwhvcvcctyk());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getVfymxygsefoeapvk())) {
            loginReqVo.setVerificationCode(reqVo.getVfymxygsefoeapvk());
        }
        loginReqVo.setFromType(LoginFromTypeEnum.WEB_DMS.getValue());
        return loginReqVo;
    }
}

