/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tableconfig.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.function.model.MdmFunctionEntity;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmButtonConfigRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubButtonReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubRespVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionObjReqVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionObjRespVo;
import com.biz.crm.tableconfig.mapper.MdmFunctionSubMapper;
import com.biz.crm.tableconfig.model.MdmColumnConfigEntity;
import com.biz.crm.tableconfig.model.MdmFunctionSubButtonEntity;
import com.biz.crm.tableconfig.model.MdmFunctionSubEntity;
import com.biz.crm.tableconfig.service.IMdmColumnConfigService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubButtonService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.cache.TableConfigUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmFunctionSubServiceExpandImpl"})
@CacheConfig(cacheManager="cacheManager", cacheNames={"mdmFunctionSub"})
public class MdmFunctionSubServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmFunctionSubMapper, MdmFunctionSubEntity>
implements IMdmFunctionSubService {
    private static final Logger log = LoggerFactory.getLogger(MdmFunctionSubServiceImpl.class);
    @Resource
    private MdmFunctionSubMapper mdmFunctionSubMapper;
    @Resource
    private MdmFunctionService mdmFunctionService;
    @Resource
    private IMdmFunctionSubButtonService mdmFunctionSubButtonService;
    @Resource
    private IMdmColumnConfigService mdmColumnConfigService;

    @Override
    public PageResult<MdmFunctionSubRespVo> findList(MdmFunctionSubReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmFunctionSubRespVo> list = this.mdmFunctionSubMapper.findList((Page<MdmFunctionSubRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmFunctionSubRespVo query(String id) {
        Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        MdmFunctionSubEntity one = (MdmFunctionSubEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one();
        return (MdmFunctionSubRespVo)CrmBeanUtil.copy((Object)one, MdmFunctionSubRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(allEntries=true)
    public void save(MdmFunctionSubReqVo reqVo) {
        String parentCode = reqVo.getParentCode();
        Assert.hasText((String)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.valid(parentCode);
        String functionCode = reqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmFunctionSubEntity::getParentCode, (Object)parentCode)).eq(MdmFunctionSubEntity::getFunctionCode, (Object)functionCode)).count();
        Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u529f\u80fd\u7f16\u7801\u5df2\u5b58\u5728");
        MdmFunctionSubEntity entity = (MdmFunctionSubEntity)CrmBeanUtil.copy((Object)reqVo, MdmFunctionSubEntity.class);
        this.save(entity);
        TableConfigUtil.removeListConfig((String)reqVo.getParentCode(), (String)reqVo.getFunctionCode());
    }

    private void valid(String parentCode) {
        Assert.hasText((String)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmFunctionReqVo mdmFunctionReqVo = new MdmFunctionReqVo();
        mdmFunctionReqVo.setFunctionCode(parentCode);
        MdmFunctionRespVo mdmFunctionRespVo = this.mdmFunctionService.query(mdmFunctionReqVo);
        Assert.notNull((Object)mdmFunctionRespVo, (String)"\u83dc\u5355\u4e0d\u5b58\u5728");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(allEntries=true)
    public void update(MdmFunctionSubReqVo reqVo) {
        String functionCode = reqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String functionName = reqVo.getFunctionName();
        Assert.hasText((String)functionName, (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        String parentCode = reqVo.getParentCode();
        Assert.hasText((String)reqVo.getId(), (String)"\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        MdmFunctionSubEntity entity = (MdmFunctionSubEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)reqVo.getId())).select(new SFunction[]{BaseIdEntity::getId, MdmFunctionSubEntity::getFunctionCode}).one();
        Assert.notNull((Object)entity, (String)"\u529f\u80fd\u5217\u8868\u4e0d\u5b58\u5728");
        this.valid(parentCode);
        long count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmFunctionSubEntity::getParentCode, (Object)parentCode)).eq(MdmFunctionSubEntity::getFunctionCode, (Object)reqVo.getFunctionCode())).select(new SFunction[]{BaseIdEntity::getId}).list().stream().filter(x -> !entity.getId().equals(x.getId())).count();
        Assert.isTrue((count < 1L ? 1 : 0) != 0, (String)"\u529f\u80fd\u7f16\u7801\u5df2\u5b58\u5728");
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmFunctionSubEntity.class));
        if (!functionCode.equals(entity.getFunctionCode())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmFunctionSubButtonService.lambdaUpdate().eq(MdmFunctionSubButtonEntity::getParentCode, (Object)parentCode)).eq(MdmFunctionSubButtonEntity::getFunctionCode, (Object)entity.getFunctionCode())).set(MdmFunctionSubButtonEntity::getFunctionCode, (Object)functionCode)).update();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmColumnConfigService.lambdaUpdate().eq(MdmColumnConfigEntity::getParentCode, (Object)parentCode)).eq(MdmColumnConfigEntity::getFunctionCode, (Object)entity.getFunctionCode())).set(MdmColumnConfigEntity::getFunctionCode, (Object)functionCode)).update();
        }
        TableConfigUtil.removeListConfig((String)reqVo.getParentCode(), (String)reqVo.getFunctionCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(allEntries=true)
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).select(new SFunction[]{MdmFunctionSubEntity::getParentCode, MdmFunctionSubEntity::getFunctionCode}).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            MdmFunctionSubEntity mdmFunctionSubEntity;
            String parentCode;
            List parentCodeList = list.stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getParentCode())).map(MdmFunctionSubEntity::getParentCode).collect(Collectors.toList());
            List functionCodeList = list.stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getFunctionCode())).map(MdmFunctionSubEntity::getFunctionCode).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(parentCodeList) && !CollectionUtils.isEmpty(functionCodeList)) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmFunctionSubButtonService.lambdaUpdate().in(MdmFunctionSubButtonEntity::getParentCode, parentCodeList)).in(MdmFunctionSubButtonEntity::getFunctionCode, functionCodeList)).remove();
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmColumnConfigService.lambdaUpdate().in(MdmColumnConfigEntity::getParentCode, parentCodeList)).in(MdmColumnConfigEntity::getFunctionCode, functionCodeList)).remove();
            }
            if (!StringUtils.isEmpty((Object)(parentCode = (mdmFunctionSubEntity = (MdmFunctionSubEntity)list.get(0)).getParentCode()))) {
                TableConfigUtil.removeFunction((String)parentCode);
            }
        }
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(allEntries=true)
    public void enableBatch(MdmFunctionSubReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(allEntries=true)
    public void disableBatch(MdmFunctionSubReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public PageResult<MdmFunctionRespVo> functionPage(MdmFunctionReqVo mdmFunctionReqVo) {
        mdmFunctionReqVo.setPageConfig(YesNoEnum.yesNoEnum.YES.getValue());
        return this.mdmFunctionService.functionPage(mdmFunctionReqVo);
    }

    @Override
    @Cacheable(sync=true)
    public List<MdmFunctionSubRespVo> findSubList(MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        return this.mdmFunctionSubMapper.findSubList(mdmFunctionSubReqVo);
    }

    @Override
    public List<MdmFunctionSubRespVo> findPermissionList(MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)mdmFunctionSubReqVo.getFunctionType()), MdmFunctionSubEntity::getFunctionType, (Object)mdmFunctionSubReqVo.getFunctionType())).in(!CollectionUtils.isEmpty((Collection)mdmFunctionSubReqVo.getParentCodeList()), MdmFunctionSubEntity::getParentCode, (Collection)mdmFunctionSubReqVo.getParentCodeList())).isNotNull(MdmFunctionSubEntity::getPermissionObj)).select(new SFunction[]{MdmFunctionSubEntity::getFunctionCode, MdmFunctionSubEntity::getParentCode}).list();
        return CrmBeanUtil.copyList((List)list, MdmFunctionSubRespVo.class);
    }

    @Override
    public List<MdmPermissionObjRespVo> objList(MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        String functionCode = mdmFunctionSubReqVo.getParentCode();
        String listConfigCode = mdmFunctionSubReqVo.getFunctionCode();
        List permissionTree = DictUtil.tree((String)"permission_obj");
        if (CollectionUtils.isEmpty((Collection)permissionTree)) {
            return Collections.emptyList();
        }
        MdmFunctionSubEntity mdmFunctionSubEntity = (MdmFunctionSubEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmFunctionSubEntity::getParentCode, (Object)functionCode)).eq(MdmFunctionSubEntity::getFunctionCode, (Object)listConfigCode)).select(new SFunction[]{MdmFunctionSubEntity::getPermissionObj}).one();
        log.info("[\u6570\u636e\u6743\u9650][\u5df2\u914d\u7f6e\u7684\u6743\u9650\u5bf9\u8c61]:{}", (Object)mdmFunctionSubEntity);
        if (mdmFunctionSubEntity == null || StringUtils.isEmpty((Object)mdmFunctionSubEntity.getPermissionObj())) {
            return permissionTree.stream().map(x -> {
                MdmPermissionObjRespVo mdmPermissionObjRespVo = new MdmPermissionObjRespVo();
                mdmPermissionObjRespVo.setSelect(YesNoEnum.yesNoEnum.ZERO.getValue());
                mdmPermissionObjRespVo.setPermissionObjCode(x.getDictCode());
                mdmPermissionObjRespVo.setPermissionObjName(x.getDictValue());
                mdmPermissionObjRespVo.setRemarks(x.getDictValue());
                return mdmPermissionObjRespVo;
            }).collect(Collectors.toList());
        }
        List<String> permissionObjList = Arrays.asList(mdmFunctionSubEntity.getPermissionObj().split(","));
        return permissionTree.stream().map(x -> {
            MdmPermissionObjRespVo mdmPermissionObjRespVo = new MdmPermissionObjRespVo();
            if (permissionObjList.contains(x.getDictCode())) {
                mdmPermissionObjRespVo.setSelect(YesNoEnum.yesNoEnum.ONE.getValue());
            } else {
                mdmPermissionObjRespVo.setSelect(YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            mdmPermissionObjRespVo.setPermissionObjCode(x.getDictCode());
            mdmPermissionObjRespVo.setPermissionObjName(x.getDictValue());
            mdmPermissionObjRespVo.setRemarks(x.getDictValue());
            return mdmPermissionObjRespVo;
        }).collect(Collectors.toList());
    }

    @Override
    @CacheEvict(allEntries=true)
    public void saveObj(MdmPermissionObjReqVo mdmPermissionObjReqVo) {
        String functionCode = mdmPermissionObjReqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u529f\u80fd\u5217\u8868\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String parentCode = mdmPermissionObjReqVo.getParentCode();
        Assert.hasText((String)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmFunctionSubEntity::getParentCode, (Object)parentCode)).eq(MdmFunctionSubEntity::getFunctionCode, (Object)functionCode)).count();
        Assert.isTrue((count != null && count > 0 ? 1 : 0) != 0, (String)"\u529f\u80fd\u5217\u8868\u4e0d\u5b58\u5728");
        List mdmPermissionObjRespVos = mdmPermissionObjReqVo.getMdmPermissionObjRespVos();
        if (CollectionUtils.isEmpty((Collection)mdmPermissionObjRespVos)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmFunctionSubEntity::getParentCode, (Object)parentCode)).eq(MdmFunctionSubEntity::getFunctionCode, (Object)functionCode)).set(MdmFunctionSubEntity::getPermissionObj, null)).update();
            return;
        }
        String collect = mdmPermissionObjRespVos.stream().filter(x -> x != null && YesNoEnum.yesNoEnum.ONE.getValue().equals(x.getSelect())).map(MdmPermissionObjRespVo::getPermissionObjCode).collect(Collectors.joining(","));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmFunctionSubEntity::getParentCode, (Object)parentCode)).eq(MdmFunctionSubEntity::getFunctionCode, (Object)functionCode)).set(MdmFunctionSubEntity::getPermissionObj, (Object)collect)).update();
    }

    @Override
    public void buttonSetUp(MdmFunctionSubButtonReqVo mdmFunctionSubButtonReqVo) {
        this.mdmFunctionSubButtonService.setUp(mdmFunctionSubButtonReqVo);
    }

    @Override
    public List<MdmButtonConfigRespVo> buttonList(MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        MdmFunctionSubButtonReqVo mdmFunctionSubButtonReqVo = new MdmFunctionSubButtonReqVo();
        mdmFunctionSubButtonReqVo.setParentCode(mdmFunctionSubReqVo.getParentCode());
        mdmFunctionSubButtonReqVo.setFunctionCode(mdmFunctionSubReqVo.getFunctionCode());
        return this.mdmFunctionSubButtonService.buttonList(mdmFunctionSubButtonReqVo);
    }

    @Override
    public void buttonRemove(List<String> ids) {
        this.mdmFunctionSubButtonService.buttonRemove(ids);
    }

    @Override
    public MdmButtonConfigRespVo buttonQuery(String id) {
        return this.mdmFunctionSubButtonService.buttonQuery(id);
    }

    @Override
    public MdmFunctionSubRespVo functionSubSearch(MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        String parentCode = mdmFunctionSubReqVo.getParentCode();
        Assert.hasText((String)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String functionCode = mdmFunctionSubReqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmFunctionSubEntity one = (MdmFunctionSubEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmFunctionSubEntity::getParentCode, (Object)parentCode)).eq(MdmFunctionSubEntity::getFunctionCode, (Object)functionCode)).one();
        return (MdmFunctionSubRespVo)CrmBeanUtil.copy((Object)one, MdmFunctionSubRespVo.class);
    }

    @Override
    public MdmFunctionSubRespVo queryCondition(MdmFunctionSubReqVo mdmFunctionSubReqVo) {
        MdmFunctionSubEntity one = (MdmFunctionSubEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)mdmFunctionSubReqVo.getId())).eq(MdmFunctionSubEntity::getFunctionCode, (Object)mdmFunctionSubReqVo.getFunctionCode())).one();
        return (MdmFunctionSubRespVo)CrmBeanUtil.copy((Object)one, MdmFunctionSubRespVo.class);
    }

    @Override
    public List<MdmFunctionRespVo> configTree(MdmFunctionReqVo mdmFunctionReqVo) {
        mdmFunctionReqVo.setPageConfig(YesNoEnum.yesNoEnum.YES.getValue());
        List<String> configFunctionCodeList = ((LambdaQueryChainWrapper)this.mdmFunctionService.lambdaQuery().eq(MdmFunctionEntity::getPageConfig, (Object)YesNoEnum.yesNoEnum.YES.getValue())).select(new SFunction[]{MdmFunctionEntity::getFunctionCode}).list().stream().filter(Objects::nonNull).map(MdmFunctionEntity::getFunctionCode).collect(Collectors.toList());
        List list = this.mdmFunctionService.lambdaQuery().list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        String functionCode = mdmFunctionReqVo.getFunctionCode();
        if (!CollectionUtils.isEmpty(configFunctionCodeList) && !StringUtils.isEmpty((Object)functionCode)) {
            configFunctionCodeList = configFunctionCodeList.stream().filter(x -> x.contains(functionCode)).collect(Collectors.toList());
        }
        List mdmFunctionRespVos = CrmBeanUtil.copyList((List)list, MdmFunctionRespVo.class);
        for (MdmFunctionRespVo mdmFunctionRespVo : mdmFunctionRespVos) {
            if (!CollectionUtils.isEmpty(configFunctionCodeList) && configFunctionCodeList.contains(mdmFunctionRespVo.getFunctionCode())) {
                mdmFunctionRespVo.setFunctionPermission(YesNoEnum.yesNoEnum.ONE.getValue());
                continue;
            }
            mdmFunctionRespVo.setFunctionPermission(YesNoEnum.yesNoEnum.ZERO.getValue());
        }
        return this.mdmFunctionService.constructFunctionTree(mdmFunctionReqVo.getFunctionName(), mdmFunctionRespVos, configFunctionCodeList);
    }
}

