/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.permission.manager;

import com.biz.crm.eunm.mdm.MdmPermissionObjEnum;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionVo;
import com.biz.crm.permission.manager.MdmDataPermissionProcessor;
import com.biz.crm.permission.model.MdmDataPermissionExtendEntity;
import com.biz.crm.permission.service.IMdmDataPermissionExtendService;
import com.biz.crm.util.JsonPropertyUtil;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmDataPermissionOrgExpandProcessor"})
public class MdmDataPermissionOrgProcessor
implements MdmDataPermissionProcessor {
    private static final Logger log = LoggerFactory.getLogger(MdmDataPermissionOrgProcessor.class);
    @Autowired
    private IMdmDataPermissionExtendService mdmDataPermissionExtendService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmDataPermissionVo mdmDataPermissionVo) {
        log.info("\u6570\u636e\u6743\u9650:\u4fdd\u5b58\uff1a\u7ec4\u7ec7\uff1a\u5165\u53c2:{}", (Object)JsonPropertyUtil.toJsonString((Object)mdmDataPermissionVo));
        String functionCode = mdmDataPermissionVo.getFunctionCode();
        String listConfigCode = mdmDataPermissionVo.getListConfigCode();
        String roleCode = mdmDataPermissionVo.getRoleCode();
        List mdmDataPermissionDetailVos = mdmDataPermissionVo.getMdmDataPermissionDetailVos();
        if (CollectionUtils.isEmpty((Collection)mdmDataPermissionDetailVos)) {
            return;
        }
        List<MdmDataPermissionExtendEntity> entityList = mdmDataPermissionDetailVos.stream().filter(x -> MdmPermissionObjEnum.ORG.getCode().equals(x.getPermissionObjCode())).map(x -> {
            MdmDataPermissionExtendEntity extendEntity = new MdmDataPermissionExtendEntity();
            String id = UUID.randomUUID().toString();
            extendEntity.setId(id);
            extendEntity.setFunctionCode(functionCode);
            extendEntity.setListConfigCode(listConfigCode);
            extendEntity.setRoleCode(roleCode);
            extendEntity.setPermissionObjCode(x.getPermissionObjCode());
            extendEntity.setPermissionResource(x.getPermissionResource());
            extendEntity.setPermissionSearchType(x.getPermissionSearchType());
            return extendEntity;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(entityList)) {
            return;
        }
        this.mdmDataPermissionExtendService.add(entityList);
    }

    @Override
    public void populate(MdmDataPermissionVo mdmDataPermissionVo) {
    }
}

