/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.bpmrole.service.MdmBpmRoleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleRelationPositionPageReqVo;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleRelationPositionReqVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRelationPositionPageRespVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRespVo;
import com.biz.crm.position.mapper.MdmPositionBpmRoleMapper;
import com.biz.crm.position.model.MdmPositionBpmRoleEntity;
import com.biz.crm.position.service.MdmPositionBpmRoleService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmPositionBpmRoleServiceExpandImpl"})
public class MdmPositionBpmRoleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPositionBpmRoleMapper, MdmPositionBpmRoleEntity>
implements MdmPositionBpmRoleService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionBpmRoleServiceImpl.class);
    @Resource
    private MdmPositionBpmRoleMapper mdmPositionBpmRoleMapper;
    @Resource
    private MdmBpmRoleService mdmBpmRoleService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addPositionBpmRole(String positionCode, String bpmRoleCode) {
        List list;
        if (StringUtils.isNotEmpty((String)positionCode) && StringUtils.isNotEmpty((String)bpmRoleCode) && CollectionUtil.listEmpty((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionBpmRoleEntity::getPositionCode, (Object)positionCode)).eq(MdmPositionBpmRoleEntity::getBpmRoleCode, (Object)bpmRoleCode)).select(new SFunction[]{BaseIdEntity::getId}).list()))) {
            MdmPositionBpmRoleEntity entity = new MdmPositionBpmRoleEntity();
            entity.setPositionCode(positionCode);
            entity.setBpmRoleCode(bpmRoleCode);
            this.save(entity);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addPositionBpmRole(String positionCode, List<String> bpmRoleCodeList) {
        if (StringUtils.isNotEmpty((String)positionCode) && CollectionUtil.listNotEmptyNotSizeZero(bpmRoleCodeList)) {
            bpmRoleCodeList.forEach(bpmRoleCode -> this.addPositionBpmRole(positionCode, (String)bpmRoleCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addPositionBpmRole(List<String> positionCodeList, String bpmRoleCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && StringUtils.isNotEmpty((String)bpmRoleCode)) {
            positionCodeList.forEach(positionCode -> this.addPositionBpmRole((String)positionCode, bpmRoleCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByPosition(String positionCode) {
        if (StringUtils.isNotEmpty((String)positionCode)) {
            this.removeByPositions(Collections.singletonList(positionCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByPositions(List<String> positionCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionBpmRoleEntity::getPositionCode, positionCodeList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByBpmRole(String bpmRoleCode) {
        if (StringUtils.isNotEmpty((String)bpmRoleCode)) {
            this.removeByBpmRoles(Collections.singletonList(bpmRoleCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByBpmRoles(List<String> bpmRoleCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(bpmRoleCodeList)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionBpmRoleEntity::getBpmRoleCode, bpmRoleCodeList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByPositionBpmRole(String positionCode, String bpmRoleCode) {
        if (StringUtils.isNotEmpty((String)positionCode) && StringUtils.isNotEmpty((String)bpmRoleCode)) {
            this.removeByPositionBpmRole(positionCode, Collections.singletonList(bpmRoleCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByPositionBpmRole(String positionCode, List<String> bpmRoleCodeList) {
        if (StringUtils.isNotEmpty((String)positionCode) && CollectionUtil.listNotEmptyNotSizeZero(bpmRoleCodeList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionBpmRoleEntity::getPositionCode, (Object)positionCode)).in(MdmPositionBpmRoleEntity::getBpmRoleCode, bpmRoleCodeList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByPositionBpmRole(List<String> positionCodeList, String bpmRoleCode) {
        if (StringUtils.isNotEmpty((String)bpmRoleCode) && CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionBpmRoleEntity::getBpmRoleCode, (Object)bpmRoleCode)).in(MdmPositionBpmRoleEntity::getPositionCode, positionCodeList)).remove();
        }
    }

    @Override
    public Set<String> findBpmRoleCodeSetByPositionCodeList(List<String> positionCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
            HashSet<String> bpmRoleCodeSet = new HashSet<String>(16);
            List positionCodeListGroup = Lists.partition(positionCodeList, (int)500);
            for (List group : positionCodeListGroup) {
                bpmRoleCodeSet.addAll(((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionBpmRoleEntity::getPositionCode, (Collection)group)).select(new SFunction[]{MdmPositionBpmRoleEntity::getBpmRoleCode}).list().stream().map(MdmPositionBpmRoleEntity::getBpmRoleCode).collect(Collectors.toSet()));
            }
            return bpmRoleCodeSet;
        }
        return Collections.emptySet();
    }

    @Override
    public List<MdmBpmRoleRespVo> getPositionBpmRoleList(String positionCode) {
        List positionRoleEntityList;
        if (StringUtils.isNotEmpty((String)positionCode) && CollectionUtil.listNotEmptyNotSizeZero((List)(positionRoleEntityList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionBpmRoleEntity::getPositionCode, (Object)positionCode)).select(new SFunction[]{MdmPositionBpmRoleEntity::getBpmRoleCode}).list()))) {
            return this.mdmBpmRoleService.queryBatchByBpmRoleCodeList(positionRoleEntityList.stream().map(MdmPositionBpmRoleEntity::getBpmRoleCode).collect(Collectors.toList()));
        }
        return new ArrayList<MdmBpmRoleRespVo>();
    }

    @Override
    public Map<String, List<String>> getPositionBpmRoleCodeGroupByPositionCodeList(List<String> positionCodeList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionBpmRoleEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionBpmRoleEntity::getPositionCode, MdmPositionBpmRoleEntity::getBpmRoleCode}).list()))) {
            return list.stream().collect(Collectors.groupingBy(MdmPositionBpmRoleEntity::getPositionCode, Collectors.mapping(MdmPositionBpmRoleEntity::getBpmRoleCode, Collectors.toList())));
        }
        return new HashMap<String, List<String>>(16);
    }

    @Override
    public Map<String, List<MdmBpmRoleRespVo>> getPositionBpmRoleGroupByPositionCodeList(List<String> positionCodeList) {
        List list;
        HashMap<String, List<MdmBpmRoleRespVo>> map = new HashMap<String, List<MdmBpmRoleRespVo>>(16);
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionBpmRoleEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionBpmRoleEntity::getPositionCode, MdmPositionBpmRoleEntity::getBpmRoleCode}).list()))) {
            List<String> bpmRoleCodeList = list.stream().map(MdmPositionBpmRoleEntity::getBpmRoleCode).collect(Collectors.toList());
            Map<String, MdmBpmRoleRespVo> bpmRoleMap = this.mdmBpmRoleService.queryBatchByBpmRoleCodeList(bpmRoleCodeList).stream().collect(Collectors.toMap(MdmBpmRoleRespVo::getBpmRoleCode, v -> v));
            Map groupMap = list.stream().collect(Collectors.groupingBy(MdmPositionBpmRoleEntity::getPositionCode, Collectors.mapping(MdmPositionBpmRoleEntity::getBpmRoleCode, Collectors.toList())));
            for (Map.Entry entry : groupMap.entrySet()) {
                ArrayList<MdmBpmRoleRespVo> roleList = new ArrayList<MdmBpmRoleRespVo>();
                for (String item : entry.getValue()) {
                    if (!bpmRoleMap.containsKey(item)) continue;
                    roleList.add(bpmRoleMap.get(item));
                }
                map.put(entry.getKey(), roleList);
            }
        }
        return map;
    }

    @Override
    public PageResult<MdmBpmRoleRelationPositionPageRespVo> findPositionNotRelateAnyBpmRoleList(MdmBpmRoleRelationPositionPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmBpmRoleRelationPositionPageRespVo> list = this.mdmPositionBpmRoleMapper.findPositionNotRelateAnyBpmRoleList((Page<MdmBpmRoleRelationPositionPageRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<String> positionCodeList = list.stream().map(MdmBpmRoleRelationPositionPageRespVo::getPositionCode).collect(Collectors.toList());
            Map<String, List<MdmBpmRoleRespVo>> map = this.getPositionBpmRoleGroupByPositionCodeList(positionCodeList);
            list.forEach(item -> {
                if (map.containsKey(item.getPositionCode())) {
                    List bpmRoleList = (List)map.get(item.getPositionCode());
                    item.setBpmRoleCode(bpmRoleList.stream().map(MdmBpmRoleRespVo::getBpmRoleCode).collect(Collectors.joining(",")));
                    item.setBpmRoleName(bpmRoleList.stream().map(MdmBpmRoleRespVo::getBpmRoleName).collect(Collectors.joining(",")));
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmBpmRoleRelationPositionPageRespVo> findPositionNotRelateCurBpmRoleList(MdmBpmRoleRelationPositionPageReqVo reqVo) {
        Assert.hasText((String)reqVo.getBpmRoleCode(), (String)"\u7f3a\u5931\u6d41\u7a0b\u89d2\u8272\u7f16\u7801");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmBpmRoleRelationPositionPageRespVo> list = this.mdmPositionBpmRoleMapper.findPositionNotRelateCurBpmRoleList((Page<MdmBpmRoleRelationPositionPageRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<String> positionCodeList = list.stream().map(MdmBpmRoleRelationPositionPageRespVo::getPositionCode).collect(Collectors.toList());
            Map<String, List<MdmBpmRoleRespVo>> map = this.getPositionBpmRoleGroupByPositionCodeList(positionCodeList);
            list.forEach(item -> {
                if (map.containsKey(item.getPositionCode())) {
                    List bpmRoleList = (List)map.get(item.getPositionCode());
                    item.setBpmRoleCode(bpmRoleList.stream().map(MdmBpmRoleRespVo::getBpmRoleCode).collect(Collectors.joining(",")));
                    item.setBpmRoleName(bpmRoleList.stream().map(MdmBpmRoleRespVo::getBpmRoleName).collect(Collectors.joining(",")));
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmBpmRoleRelationPositionPageRespVo> findPositionHasRelateCurBpmRoleList(MdmBpmRoleRelationPositionPageReqVo reqVo) {
        Assert.hasText((String)reqVo.getBpmRoleCode(), (String)"\u7f3a\u5931\u6d41\u7a0b\u89d2\u8272\u7f16\u7801");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmBpmRoleRelationPositionPageRespVo> list = this.mdmPositionBpmRoleMapper.findPositionHasRelateCurBpmRoleList((Page<MdmBpmRoleRelationPositionPageRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<String> positionCodeList = list.stream().map(MdmBpmRoleRelationPositionPageRespVo::getPositionCode).collect(Collectors.toList());
            Map<String, List<MdmBpmRoleRespVo>> map = this.getPositionBpmRoleGroupByPositionCodeList(positionCodeList);
            list.forEach(item -> {
                if (map.containsKey(item.getPositionCode())) {
                    List bpmRoleList = (List)map.get(item.getPositionCode());
                    item.setBpmRoleCode(bpmRoleList.stream().map(MdmBpmRoleRespVo::getBpmRoleCode).collect(Collectors.joining(",")));
                    item.setBpmRoleName(bpmRoleList.stream().map(MdmBpmRoleRespVo::getBpmRoleName).collect(Collectors.joining(",")));
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void positionRelationBpmRole(MdmBpmRoleRelationPositionReqVo reqVo) {
        Assert.hasText((String)reqVo.getBpmRoleCode(), (String)"\u7f3a\u5931\u6d41\u7a0b\u89d2\u8272\u7f16\u7801");
        Assert.notEmpty((Collection)reqVo.getPositionCodeList(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        MdmBpmRoleRespVo one = this.mdmBpmRoleService.detail(null, reqVo.getBpmRoleCode());
        Assert.notNull((Object)one, (String)"\u65e0\u6548\u7684\u6d41\u7a0b\u89d2\u8272\u7f16\u7801");
        this.addPositionBpmRole(reqVo.getPositionCodeList(), reqVo.getBpmRoleCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceBindBpmRole(MdmBpmRoleRelationPositionReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7f3a\u5931\u5173\u8054id");
        Assert.hasText((String)reqVo.getBpmRoleCode(), (String)"\u7f3a\u5931\u6d41\u7a0b\u89d2\u8272\u7f16\u7801");
        MdmBpmRoleRespVo one = this.mdmBpmRoleService.detail(null, reqVo.getBpmRoleCode());
        Assert.notNull((Object)one, (String)"\u65e0\u6548\u7684\u6d41\u7a0b\u89d2\u8272\u7f16\u7801");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)reqVo.getIds())).select(new SFunction[]{MdmPositionBpmRoleEntity::getPositionCode}).list();
        Assert.notEmpty((Collection)list, (String)"\u65e0\u6548\u7684\u5173\u8054id");
        this.removeByIds(reqVo.getIds());
        List<String> positionCodeList = list.stream().map(MdmPositionBpmRoleEntity::getPositionCode).collect(Collectors.toList());
        this.addPositionBpmRole(positionCodeList, one.getBpmRoleCode());
    }
}

