/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.constant.PositionOperationEnum;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionSelectRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserChangeHeadReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserChangePasswordReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserCustomerEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserForceChangePasswordReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserParentPositionSelectReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserPositionEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserPositionSelectReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelWeChatReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserSelectReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserPageRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserSelectRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.service.MdmPositionRoleService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.position.service.MdmPositionUserService;
import com.biz.crm.user.mapper.MdmUserMapper;
import com.biz.crm.user.model.MdmUserEntity;
import com.biz.crm.user.service.MdmUserRelRoleService;
import com.biz.crm.user.service.MdmUserRelWeChatService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.LoginHelpUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmUserServiceExpandImpl"})
public class MdmUserServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmUserMapper, MdmUserEntity>
implements MdmUserService {
    private static final Logger log = LoggerFactory.getLogger(MdmUserServiceImpl.class);
    @Resource
    private MdmUserMapper mdmUserMapper;
    @Resource
    private MdmPositionUserService mdmPositionUserService;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private MdmPositionRoleService mdmPositionRoleService;
    @Resource
    private MdmUserRelWeChatService mdmUserRelWeChatService;
    @Resource
    private MdmUserRelRoleService mdmUserRelRoleService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Override
    public PageResult<MdmUserPageRespVo> findList(MdmUserPageReqVo reqVo) {
        MdmOrgRespVo org;
        reqVo.setUserType(UserTypeEnum.USER.getCode());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        if (StringUtils.isNotEmpty((String)reqVo.getCode()) && (org = this.mdmOrgService.queryByOrgCode(reqVo.getCode())) != null) {
            reqVo.setOrgRuleCode(org.getRuleCode());
        }
        List<MdmUserPageRespVo> list = this.mdmUserMapper.findList((Page<MdmUserPageRespVo>)page, reqVo);
        this.setRoleCodeName(list);
        this.setLockState(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmUserRespVo query(MdmUserReqVo reqVo) {
        return this.detail(reqVo.getId(), reqVo.getUserName());
    }

    @Override
    public MdmUserRespVo detail(String id, String userName) {
        MdmUserEntity one;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)userName)) && (one = (MdmUserEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(!StringUtils.isEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(!StringUtils.isEmpty((String)userName), MdmUserEntity::getUserName, (Object)userName)).one()) != null) {
            MdmUserRespVo respVo = (MdmUserRespVo)CrmBeanUtil.copy((Object)one, MdmUserRespVo.class);
            respVo.setUserPassword("");
            respVo.setRelWeChatList(this.mdmUserRelWeChatService.findUserRelWeChatList(new MdmUserRelWeChatReqVo().setUserName(one.getUserName())));
            if (UserTypeEnum.USER.getCode().equals(respVo.getUserType())) {
                respVo.setPositionList(this.mdmPositionService.getUserAllPositionList(one.getUserName()));
            } else if (UserTypeEnum.CUSTOMER.getCode().equals(respVo.getUserType())) {
                List<MdmCustomerMsgRespVo> customerList = this.mdmCustomerMsgService.getCustomerListByUserName(one.getUserName());
                if (CollectionUtil.listNotEmptyNotSizeZero(customerList) && YesNoEnum.yesNoEnum.N.getValue().equals(ParamUtil.getParameterValue((String)"user_can_relation_many_customer"))) {
                    respVo.setCustomerCode(customerList.get(0).getCustomerCode());
                    respVo.setCustomerName(customerList.get(0).getCustomerName());
                }
                respVo.setCustomerList(customerList);
                respVo.setRoleCodeList(this.mdmUserRelRoleService.findRoleCodeListByUserName(one.getUserName()));
            }
            return respVo;
        }
        return null;
    }

    @Override
    public MdmUserRespVo queryByUserName(String userName) {
        MdmUserEntity one;
        if (StringUtils.isNotEmpty((String)userName) && (one = (MdmUserEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(MdmUserEntity::getUserName, (Object)userName)).one()) != null) {
            MdmUserRespVo copy = (MdmUserRespVo)CrmBeanUtil.copy((Object)one, MdmUserRespVo.class);
            copy.setUserPassword(null);
            return copy;
        }
        return null;
    }

    @Override
    public List<MdmUserRespVo> queryBatchByUserNameList(List<String> userNameList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList)) {
            return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(MdmUserEntity::getUserName, userNameList)).list().stream().map(x -> (MdmUserRespVo)CrmBeanUtil.copy((Object)x, MdmUserRespVo.class)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public MdmUserRespVo queryByUserCode(String userCode) {
        MdmUserEntity one;
        if (StringUtils.isNotEmpty((String)userCode) && (one = (MdmUserEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(MdmUserEntity::getUserCode, (Object)userCode)).one()) != null) {
            MdmUserRespVo copy = (MdmUserRespVo)CrmBeanUtil.copy((Object)one, MdmUserRespVo.class);
            copy.setUserPassword(null);
            return copy;
        }
        return null;
    }

    @Override
    public String getFullNameByUserName(String userName) {
        MdmUserEntity one;
        if (StringUtils.isNotEmpty((String)userName) && (one = (MdmUserEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(MdmUserEntity::getUserName, (Object)userName)).select(new SFunction[]{MdmUserEntity::getFullName}).one()) != null) {
            return one.getFullName();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmUserEditReqVo reqVo) {
        reqVo.setId(null);
        reqVo.setUserType(UserTypeEnum.USER.getCode());
        this.verifyData(reqVo);
        MdmUserEntity entity = (MdmUserEntity)CrmBeanUtil.copy((Object)reqVo, MdmUserEntity.class);
        if (StringUtils.isEmpty((String)entity.getUserCode())) {
            entity.setUserCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_USER_CODE.getCode()));
        }
        entity.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setForceChangePassword(YesNoEnum.yesNoEnum.ONE.getValue());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save(entity);
        this.updateUserPositionRelation(reqVo, entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuCodeObj != null) {
            MdmUserRespVo newObject = this.detail(entity.getId(), null);
            this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), entity.getId(), entity.getUserName(), (Object)newObject);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmUserEditReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u7f3a\u5931id");
        this.verifyData(reqVo);
        MdmUserRespVo oldObject = this.detail(reqVo.getId(), null);
        MdmUserEntity entity = (MdmUserEntity)this.getById((Serializable)((Object)reqVo.getId()));
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)entity);
        this.updateById(entity);
        this.updateUserPositionRelation(reqVo, entity);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuCodeObj != null) {
            MdmUserRespVo newObject = this.detail(reqVo.getId(), null);
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), entity.getId(), entity.getUserName(), (Object)oldObject, (Object)newObject);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmUserReqVo reqVo) {
        this.deleteBatch(reqVo.getIds());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7a7a\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(BaseIdEntity::getId, ids)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            list.forEach(item -> {
                this.mdmPositionUserService.removeByUserName(item.getUserName());
                Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
                if (menuCodeObj != null) {
                    this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), item.getId(), item.getUserName(), item);
                }
            });
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.DELETE.getCode())).update();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmUserReqVo reqVo) {
        this.enableBatch(reqVo.getIds());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        List<MdmUserEntity> list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(BaseIdEntity::getId, ids)).select(new SFunction[]{BaseIdEntity::getId, MdmUserEntity::getUserName, CrmBaseEntity::getEnableStatus}).list().stream().filter(x -> !CrmEnableStatusEnum.ENABLE.getCode().equals(x.getEnableStatus())).collect(Collectors.toList());
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
            if (menuCodeObj != null) {
                list.forEach(item -> {
                    MdmUserRespVo oldObject = (MdmUserRespVo)CrmBeanUtil.copy((Object)item, MdmUserRespVo.class);
                    MdmUserRespVo newObject = (MdmUserRespVo)CrmBeanUtil.copy((Object)item, MdmUserRespVo.class);
                    newObject.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                    this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), item.getId(), item.getUserName(), (Object)oldObject, (Object)newObject);
                });
            }
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)list.stream().map(BaseIdEntity::getId).collect(Collectors.toSet()))).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmUserReqVo reqVo) {
        this.disableBatch(reqVo.getIds());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        List<MdmUserEntity> list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(BaseIdEntity::getId, ids)).select(new SFunction[]{BaseIdEntity::getId, MdmUserEntity::getUserName, CrmBaseEntity::getEnableStatus}).list().stream().filter(x -> !CrmEnableStatusEnum.DISABLE.getCode().equals(x.getEnableStatus())).collect(Collectors.toList());
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
            if (menuCodeObj != null) {
                list.forEach(item -> {
                    MdmUserRespVo oldObject = (MdmUserRespVo)CrmBeanUtil.copy((Object)item, MdmUserRespVo.class);
                    MdmUserRespVo newObject = (MdmUserRespVo)CrmBeanUtil.copy((Object)item, MdmUserRespVo.class);
                    newObject.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                    this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), item.getId(), item.getUserName(), (Object)oldObject, (Object)newObject);
                });
            }
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)list.stream().map(BaseIdEntity::getId).collect(Collectors.toSet()))).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
            UserUtils.deleteUser(list.stream().map(MdmUserEntity::getUserName).collect(Collectors.toList()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changePassword(MdmUserChangePasswordReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        Assert.hasText((String)reqVo.getOldPassword(), (String)"\u7f3a\u5931\u539f\u5bc6\u7801");
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u65b0\u5bc6\u7801");
        MdmUserEntity user = (MdmUserEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(MdmUserEntity::getUserName, (Object)reqVo.getUserName())).one();
        Assert.notNull((Object)user, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        String oldPasswordEncryption = Md5EncryptionAndDecryption.encryPwd((String)reqVo.getOldPassword());
        String newPasswordEncryption = Md5EncryptionAndDecryption.encryPwd((String)reqVo.getNewPassword());
        Assert.isTrue((boolean)user.getUserPassword().equals(oldPasswordEncryption), (String)"\u539f\u5bc6\u7801\u8f93\u5165\u9519\u8bef");
        Assert.isTrue((!oldPasswordEncryption.equals(newPasswordEncryption) ? 1 : 0) != 0, (String)"\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e0e\u539f\u5bc6\u7801\u76f8\u540c");
        user.setUserPassword(newPasswordEncryption);
        user.setForceChangePassword(YesNoEnum.yesNoEnum.ZERO.getValue());
        this.updateById(user);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void resetMyselfPassword(MdmUserChangePasswordReqVo reqVo) {
        Assert.hasText((String)reqVo.getNewPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        UserRedis userRedis = UserUtils.getUser();
        Assert.isTrue((userRedis != null && StringUtils.isNotEmpty((String)userRedis.getUsername()) ? 1 : 0) != 0, (String)"\u8bf7\u5148\u767b\u5f55");
        MdmUserEntity user = (MdmUserEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(MdmUserEntity::getUserName, (Object)userRedis.getUsername())).one();
        Assert.notNull((Object)user, (String)"\u672a\u627e\u5230\u5f53\u524d\u7528\u6237");
        user.setUserPassword(Md5EncryptionAndDecryption.encryPwd((String)reqVo.getNewPassword()));
        user.setForceChangePassword(YesNoEnum.yesNoEnum.ZERO.getValue());
        this.updateById(user);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unlock(List<String> ids) {
        Assert.notNull(ids, (String)"\u7a7a\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(BaseIdEntity::getId, ids)).select(new SFunction[]{BaseIdEntity::getId, MdmUserEntity::getUserName, MdmUserEntity::getUserPhone, MdmUserEntity::getEmail, MdmUserEntity::getLockState}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            list.forEach(item -> LoginHelpUtil.unlock(item.getUserName(), item.getUserPhone(), item.getEmail()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unlock(MdmUserReqVo reqVo) {
        this.unlock(reqVo.getIds());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbindWeChat(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7a7a\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(BaseIdEntity::getId, ids)).select(new SFunction[]{MdmUserEntity::getUserName}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            this.mdmUserRelWeChatService.unbindByUserName(list.stream().map(MdmUserEntity::getUserName).collect(Collectors.toList()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void forceChangePassword(MdmUserForceChangePasswordReqVo reqVo) {
        Assert.notNull((Object)reqVo.getIds(), (String)"\u7f3a\u5931id");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(BaseIdEntity::getId, (Collection)reqVo.getIds())).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.notEmpty((Collection)list, (String)"\u65e0\u6548\u7684id");
        Set idSet = list.stream().map(BaseIdEntity::getId).collect(Collectors.toSet());
        reqVo.getIds().forEach(id -> Assert.isTrue((boolean)idSet.contains(id), (String)"\u65e0\u6548\u7684id"));
        String passwordEncryption = Md5EncryptionAndDecryption.encryPwd((String)reqVo.getPassword());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)reqVo.getIds())).set(MdmUserEntity::getUserPassword, (Object)passwordEncryption)).set(MdmUserEntity::getForceChangePassword, (Object)YesNoEnum.yesNoEnum.ONE.getValue())).update();
        List usernameList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(BaseIdEntity::getId, (Collection)reqVo.getIds())).select(new SFunction[]{MdmUserEntity::getUserName}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((String)x.getUserName())).map(MdmUserEntity::getUserName).collect(Collectors.toList());
        UserUtils.deleteUser(usernameList);
    }

    private void verifyData(MdmUserEditReqVo reqVo) {
        List list;
        String userName = reqVo.getUserName();
        Assert.hasText((String)userName, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getFullName(), (String)"\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        MdmUserEntity one = (MdmUserEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)userName)).one();
        if (StringUtils.isNotEmpty((String)reqVo.getUserPhone())) {
            list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getUserPhone, (Object)reqVo.getUserPhone())).list().stream().filter(x -> StringUtils.isEmpty((String)reqVo.getId()) || !reqVo.getId().equals(x.getId())).collect(Collectors.toList());
            Assert.isTrue((boolean)CollectionUtil.listEmpty(list), (String)"\u624b\u673a\u53f7\u7801\u5df2\u7ecf\u88ab\u5360\u7528");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getEmail())) {
            list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getEmail, (Object)reqVo.getEmail())).list().stream().filter(x -> StringUtils.isEmpty((String)reqVo.getId()) || !reqVo.getId().equals(x.getId())).collect(Collectors.toList());
            Assert.isTrue((boolean)CollectionUtil.listEmpty(list), (String)"\u90ae\u7bb1\u5df2\u7ecf\u88ab\u5360\u7528");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getIdentityCardNumber())) {
            list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserEntity::getIdentityCardNumber, (Object)reqVo.getIdentityCardNumber())).list().stream().filter(x -> StringUtils.isEmpty((String)reqVo.getId()) || !reqVo.getId().equals(x.getId())).collect(Collectors.toList());
            Assert.isTrue((boolean)CollectionUtil.listEmpty(list), (String)"\u8eab\u4efd\u8bc1\u53f7\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            String delMark = "";
            if (CrmDelFlagEnum.DELETE.getCode().equals(one.getDelFlag())) {
                delMark = "\uff08\u5df2\u903b\u8f91\u5220\u9664\uff09";
            }
            Assert.isNull((Object)one, (String)("\u5e10\u53f7[" + userName + "]\u5df2\u5b58\u5728" + delMark));
            Assert.hasText((String)reqVo.getUserPassword(), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            reqVo.setUserPassword(Md5EncryptionAndDecryption.encryPwd((String)reqVo.getUserPassword()));
        } else {
            MdmUserEntity byId = (MdmUserEntity)this.getById((Serializable)((Object)reqVo.getId()));
            Assert.notNull((Object)byId, (String)"\u65e0\u6548\u7684id");
            Assert.isTrue((boolean)byId.getUserName().equals(userName), (String)"\u7528\u6237\u8d26\u53f7\u4e0d\u80fd\u4fee\u6539");
            if (StringUtils.isNotEmpty((String)reqVo.getUserPassword())) {
                reqVo.setUserPassword(Md5EncryptionAndDecryption.encryPwd((String)reqVo.getUserPassword()));
            } else {
                reqVo.setUserPassword(byId.getUserPassword());
            }
        }
        UserTypeEnum userTypeEnum = UserTypeEnum.getEnumByCode((String)reqVo.getUserType());
        Assert.notNull((Object)userTypeEnum, (String)"\u7528\u6237\u7c7b\u578b\u65e0\u6548");
        switch (userTypeEnum) {
            case USER: {
                List positionReqList = reqVo.getPositionList();
                Assert.notEmpty((Collection)positionReqList, (String)"\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                int count = 0;
                for (MdmUserPositionEditReqVo item : positionReqList) {
                    item.setId(null);
                    Assert.hasText((String)item.getOrgCode(), (String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
                    Assert.hasText((String)item.getOperationType(), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    Assert.notNull((Object)item.getPrimaryFlag(), (String)"\u662f\u5426\u4e3b\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                    PositionOperationEnum positionOperationEnum = PositionOperationEnum.getEnumByCode((String)item.getOperationType());
                    Assert.notNull((Object)positionOperationEnum, (String)"\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
                    if (YesNoEnum.yesNoEnum.ONE.getValue().equals(item.getPrimaryFlag()) && ++count > 1) {
                        throw new BusinessException("\u53ea\u80fd\u6709\u4e00\u4e2a\u4e3b\u804c\u4f4d");
                    }
                    switch (positionOperationEnum) {
                        case NEW: {
                            Assert.hasText((String)item.getPositionLevelCode(), (String)"\u804c\u4f4d\u7ea7\u522b\u4e0d\u80fd\u4e3a\u7a7a");
                            item.setPositionCode("");
                            break;
                        }
                        case HISTORY: {
                            Assert.hasText((String)item.getPositionCode(), (String)"\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                            item.setPositionLevelCode("");
                            if (!StringUtils.isNotEmpty((String)item.getParentCode()) || !item.getPositionCode().equals(item.getParentCode())) break;
                            throw new BusinessException("\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u80fd\u662f\u81ea\u5df1");
                        }
                    }
                }
                if (count != 0) break;
                throw new BusinessException("\u5fc5\u987b\u9009\u62e9\u4e00\u4e2a\u4e3b\u804c\u4f4d");
            }
            case CUSTOMER: {
                if (YesNoEnum.yesNoEnum.N.getValue().equals(ParamUtil.getParameterValue((String)"user_can_relation_many_customer"))) {
                    Assert.hasText((String)reqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    break;
                }
                if (YesNoEnum.yesNoEnum.Y.getValue().equals(ParamUtil.getParameterValue((String)"user_can_relation_many_customer"))) {
                    List customerList = reqVo.getCustomerList();
                    Assert.notEmpty((Collection)customerList, (String)"\u81f3\u5c11\u5173\u8054\u4e00\u4e2a\u5ba2\u6237");
                    HashMap<String, MdmUserCustomerEditReqVo> customerUniqueMap = new HashMap<String, MdmUserCustomerEditReqVo>(16);
                    for (MdmUserCustomerEditReqVo item : customerList) {
                        Assert.hasText((String)item.getCustomerCode(), (String)"\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
                        if (customerUniqueMap.containsKey(item.getCustomerCode())) {
                            throw new BusinessException("\u4e0d\u80fd\u91cd\u590d\u5173\u8054\u5ba2\u6237\u76f8\u540c\u5ba2\u6237");
                        }
                        customerUniqueMap.put(item.getCustomerCode(), item);
                    }
                    break;
                }
                throw new BusinessException("\u5168\u5c40\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
        }
    }

    @Deprecated
    private void saveOrUpdateUserRelation(MdmUserEditReqVo reqVo, MdmUserEntity userEntity) {
        this.updateUserPositionRelation(reqVo, userEntity);
    }

    private void updateUserPositionRelation(MdmUserEditReqVo reqVo, MdmUserEntity userEntity) {
        HashMap<String, String> positionCodeMap = new HashMap<String, String>(16);
        for (MdmUserPositionEditReqVo item : reqVo.getPositionList()) {
            MdmOrgRespVo org = this.mdmOrgService.queryByOrgCode(item.getOrgCode());
            Assert.notNull((Object)org, (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            if (PositionOperationEnum.NEW.getCode().equals(item.getOperationType())) {
                MdmPositionReqVo copy = (MdmPositionReqVo)CrmBeanUtil.copy((Object)item, MdmPositionReqVo.class);
                copy.setRoleCodeList(item.getRoleList());
                copy.setBpmRoleCodeList(item.getBpmRoleList());
                copy.setPositionName(null);
                String positionCode = this.mdmPositionService.save(copy);
                positionCodeMap.put(positionCode, item.getPrimaryFlag());
                continue;
            }
            if (PositionOperationEnum.HISTORY.getCode().equals(item.getOperationType())) {
                MdmPositionRespVo mdmPositionRespVo = this.mdmPositionService.queryByPositionCode(item.getPositionCode());
                Assert.notNull((Object)mdmPositionRespVo, (String)"\u804c\u4f4d\u4e0d\u5b58\u5728");
                MdmPositionReqVo copy = (MdmPositionReqVo)CrmBeanUtil.copy((Object)mdmPositionRespVo, MdmPositionReqVo.class);
                copy.setParentCode(item.getParentCode());
                copy.setRoleCodeList(item.getRoleList());
                copy.setBpmRoleCodeList(item.getBpmRoleList());
                this.mdmPositionService.update(copy);
                positionCodeMap.put(mdmPositionRespVo.getPositionCode(), item.getPrimaryFlag());
                continue;
            }
            throw new BusinessException("\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        List primaryPositionCodeList = positionCodeMap.entrySet().stream().filter(entry -> YesNoEnum.yesNoEnum.ONE.getValue().equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        Assert.isTrue((primaryPositionCodeList.size() == 1 ? 1 : 0) != 0, (String)"\u4e00\u4e2a\u7528\u6237\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u4e3b\u804c\u4f4d");
        this.mdmPositionUserService.resetUserPosition(userEntity.getUserName(), (String)primaryPositionCodeList.get(0), new ArrayList<String>(positionCodeMap.keySet()));
    }

    @Override
    public MdmUserRespVo queryBasic(MdmUserReqVo mdmUserReqVo) {
        MdmUserEntity one = (MdmUserEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(!StringUtils.isEmpty((String)mdmUserReqVo.getUserCode()), MdmUserEntity::getUserCode, (Object)mdmUserReqVo.getUserCode())).eq(!StringUtils.isEmpty((String)mdmUserReqVo.getUserName()), MdmUserEntity::getUserName, (Object)mdmUserReqVo.getUserName())).eq(!StringUtils.isEmpty((String)mdmUserReqVo.getId()), BaseIdEntity::getId, (Object)mdmUserReqVo.getId())).eq(!StringUtils.isEmpty((String)mdmUserReqVo.getUserType()), MdmUserEntity::getUserType, (Object)mdmUserReqVo.getUserType())).one();
        return (MdmUserRespVo)CrmBeanUtil.copy((Object)one, MdmUserRespVo.class);
    }

    @Override
    public PageResult<MdmUserRespVo> pageBasic(MdmUserReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmUserRespVo> list = this.mdmUserMapper.pageBasic((Page<MdmUserRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setUserPassword(null));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmUserRespVo> listDetail(MdmUserReqVo mdmUserReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).like(!StringUtils.isEmpty((String)mdmUserReqVo.getUserName()), MdmUserEntity::getUserName, (Object)mdmUserReqVo.getUserName())).like(!StringUtils.isEmpty((String)mdmUserReqVo.getUserCode()), MdmUserEntity::getUserCode, (Object)mdmUserReqVo.getUserCode())).like(!StringUtils.isEmpty((String)mdmUserReqVo.getFullName()), MdmUserEntity::getFullName, (Object)mdmUserReqVo.getFullName())).eq(!StringUtils.isEmpty((String)mdmUserReqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)mdmUserReqVo.getEnableStatus())).eq(!StringUtils.isEmpty((String)mdmUserReqVo.getUserType()), MdmUserEntity::getUserType, (Object)mdmUserReqVo.getUserType())).list();
        return CrmBeanUtil.copyList((List)list, MdmUserRespVo.class);
    }

    @Override
    public MdmPositionUserOrgRespVo getCurUserPositionDetail() {
        UserRedis user = UserUtils.getUser();
        Assert.notNull((Object)user, (String)"\u672a\u767b\u5f55");
        Assert.hasText((String)user.getPoscode(), (String)"\u672a\u767b\u5f55");
        List<MdmPositionUserOrgRespVo> positionUserOrgList = this.mdmPositionService.findPositionUserOrgList(new MdmPositionUserOrgReqVo().setPositionCode(user.getPoscode()));
        if (CollectionUtil.listNotEmptyNotSizeZero(positionUserOrgList)) {
            return positionUserOrgList.get(0);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeUserHeadUrl(MdmUserChangeHeadReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u767b\u5f55\u540d\u79f0");
        MdmUserEntity userEntity = (MdmUserEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(MdmUserEntity::getUserName, (Object)reqVo.getUserName())).one();
        Assert.notNull((Object)userEntity, (String)"\u65e0\u6548\u7684\u7528\u6237\u767b\u5f55\u540d");
        userEntity.setUserHeadUrl(reqVo.getUserHeadUrl());
        this.updateById(userEntity);
    }

    @Override
    public List<MdmPositionSelectRespVo> findUserPositionSelectList(MdmUserPositionSelectReqVo reqVo) {
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        HashSet<String> selectedSet = new HashSet<String>(16);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            selectedSet.addAll(reqVo.getSelectedCodeList());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getSelectedCode())) {
            selectedSet.add(reqVo.getSelectedCode());
        }
        reqVo.setSelectedCodeList(new ArrayList(selectedSet));
        List<MdmPositionSelectRespVo> list = this.mdmUserMapper.findUserPositionSelectList((Page<MdmPositionSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setUnionName(this.generateUnionName(item.getOrgName(), item.getPositionName(), item.getFullName())));
        }
        return list;
    }

    @Override
    public List<MdmPositionSelectRespVo> findUserParentPositionSelectList(MdmUserParentPositionSelectReqVo reqVo) {
        Integer pageSize;
        List<String> excludeChildrenOrgCodeList;
        MdmPositionRespVo position;
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        HashSet<String> excludeTopOrgCode = new HashSet<String>(16);
        HashSet excludeOrgCodeList = new HashSet(16);
        HashSet<String> includeOrgCodeSet = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)reqVo.getChildPositionOrgCode())) {
            excludeTopOrgCode.add(reqVo.getChildPositionOrgCode());
            includeOrgCodeSet.add(reqVo.getChildPositionOrgCode());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getChildPositionCode()) && (position = this.mdmPositionService.queryByPositionCode(reqVo.getChildPositionCode())) != null) {
            List<MdmPositionRespVo> allChildrenPositionCodeList;
            if (StringUtils.isNotEmpty((String)position.getOrgCode())) {
                includeOrgCodeSet.add(position.getOrgCode());
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(allChildrenPositionCodeList = this.mdmPositionService.findAllChildrenPositionList(null, position.getPositionCode()))) {
                excludeTopOrgCode.addAll(allChildrenPositionCodeList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getOrgCode())).map(MdmPositionRespVo::getOrgCode).collect(Collectors.toSet()));
            }
        }
        if (!excludeTopOrgCode.isEmpty() && CollectionUtil.listNotEmptyNotSizeZero(excludeChildrenOrgCodeList = this.mdmOrgService.findAllChildrenOrgCodeListByList(null, new ArrayList<String>(excludeTopOrgCode)))) {
            excludeOrgCodeList.addAll(excludeChildrenOrgCodeList.stream().filter(item -> !includeOrgCodeSet.contains(item)).collect(Collectors.toList()));
        }
        if ((pageSize = reqVo.getPageSize()) == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        HashSet<String> selectedSet = new HashSet<String>(16);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            selectedSet.addAll(reqVo.getSelectedCodeList());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getSelectedCode())) {
            selectedSet.add(reqVo.getSelectedCode());
        }
        reqVo.setSelectedCodeList(new ArrayList(selectedSet));
        List<MdmPositionSelectRespVo> list = this.mdmUserMapper.findUserParentPositionSelectList((Page<MdmPositionSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo, new ArrayList<String>(excludeOrgCodeList));
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setUnionName(this.generateUnionName(item.getOrgName(), item.getPositionName(), item.getFullName())));
        }
        return list;
    }

    @Override
    public List<MdmUserSelectRespVo> findUserSelectList(MdmUserSelectReqVo reqVo) {
        reqVo.setUserType(UserTypeEnum.USER.getCode());
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        ArrayList<MdmUserSelectRespVo> list = new ArrayList<MdmUserSelectRespVo>();
        HashSet<String> codeList = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (!codeList.isEmpty()) {
            reqVo.setSelectedCodeList(new ArrayList(codeList));
        }
        if (pageSize > 0) {
            list.addAll(this.mdmUserMapper.findUserSelectList((Page<MdmUserSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo));
        }
        return list;
    }

    @Override
    public MdmUserRespVo getUserForLogin(String userName, String userPhone, String email) {
        MdmUserEntity user = null;
        if (StringUtils.isNotEmpty((String)userName)) {
            user = (MdmUserEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(MdmUserEntity::getUserName, (Object)userName)).one();
            Assert.notNull((Object)user, (String)"\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
        } else if (StringUtils.isNotEmpty((String)userPhone)) {
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(MdmUserEntity::getUserPhone, (Object)userPhone)).list();
            Assert.notEmpty((Collection)list, (String)"\u8be5\u624b\u673a\u53f7\u672a\u5bf9\u5e94\u4efb\u4f55\u7528\u6237");
            Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, (String)"\u8be5\u624b\u673a\u53f7\u5173\u8054\u4e86\u591a\u4e2a\u7528\u6237\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            user = (MdmUserEntity)list.get(0);
        } else if (StringUtils.isNotEmpty((String)email)) {
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(MdmUserEntity::getEmail, (Object)email)).list();
            Assert.notEmpty((Collection)list, (String)"\u8be5\u90ae\u7bb1\u672a\u5bf9\u5e94\u4efb\u4f55\u7528\u6237");
            Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, (String)"\u8be5\u90ae\u7bb1\u5173\u8054\u4e86\u591a\u4e2a\u7528\u6237\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            user = (MdmUserEntity)list.get(0);
        } else {
            throw new BusinessException("\u8bf7\u4f20\u5165\u67e5\u8be2\u6761\u4ef6");
        }
        return (MdmUserRespVo)CrmBeanUtil.copy((Object)user, MdmUserRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setUserForceChangePassword(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserEntity::getUserName, (Object)userName)).set(MdmUserEntity::getForceChangePassword, (Object)YesNoEnum.yesNoEnum.ONE.getValue())).update();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateUserLastLoginDateTime(String userName, String loginDateTime) {
        if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)loginDateTime)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserEntity::getUserName, (Object)userName)).set(MdmUserEntity::getLastLoginTime, (Object)loginDateTime)).update();
        }
    }

    private String generateUnionName(String orgName, String positionName, String fullName) {
        return (orgName == null ? "" : orgName) + "/" + (positionName == null ? "" : positionName) + "/" + (fullName == null ? "" : fullName);
    }

    private void setRoleCodeName(List<MdmUserPageRespVo> list) {
        Map<String, List<MdmRoleRespVo>> map;
        if (CollectionUtil.listEmpty(list)) {
            return;
        }
        List<String> collect = list.stream().filter(item -> StringUtils.isNotEmpty((String)item.getPositionCode())).map(MdmUserPageRespVo::getPositionCode).collect(Collectors.toList());
        if (CollectionUtil.listNotEmptyNotSizeZero(collect) && !(map = this.mdmPositionRoleService.getPositionRoleGroupByPositionCodeList(collect)).isEmpty()) {
            list.forEach(item -> {
                List roleList;
                if (StringUtils.isNotEmpty((String)item.getPositionCode()) && map.containsKey(item.getPositionCode()) && CollectionUtil.listNotEmptyNotSizeZero((List)(roleList = (List)map.get(item.getPositionCode())))) {
                    item.setRoleCode(roleList.stream().map(MdmRoleRespVo::getRoleCode).collect(Collectors.joining(",")));
                    item.setRoleName(roleList.stream().map(MdmRoleRespVo::getRoleName).collect(Collectors.joining(",")));
                }
            });
        }
    }

    private void setLockState(List<MdmUserPageRespVo> list) {
        if (CollectionUtil.listEmpty(list)) {
            return;
        }
        Set<String> lockUserNameSet = LoginHelpUtil.checkAndGetLockUserName(list.stream().map(MdmUserPageRespVo::getUserName).collect(Collectors.toSet()));
        list.forEach(item -> item.setLockState(!lockUserNameSet.contains(item.getUserName()) ? CrmEnableStatusEnum.ENABLE.getCode() : CrmEnableStatusEnum.DISABLE.getCode()));
    }
}

