/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalDetailRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmTerminalUserEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmTerminalUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmTerminalUserTerminalSelectReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserForceChangePasswordReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmTerminalUserControlControlRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmTerminalUserDetailRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmTerminalUserPageRespVo;
import com.biz.crm.user.service.MdmTerminalUserService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmTerminalUserController"})
@CrmGlobalLog
@Api(tags={"MDM-\u7528\u6237\u7ba1\u7406\uff08\u7ec8\u7aef\u7528\u6237\uff09"})
public class MdmTerminalUserController {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalUserController.class);
    @Autowired
    private MdmTerminalUserService mdmTerminalUserService;
    @Autowired
    private MdmUserService mdmUserService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    @CrmDictMethod
    public Result<PageResult<MdmTerminalUserPageRespVo>> pageList(@RequestBody MdmTerminalUserPageReqVo reqVo) {
        PageResult<MdmTerminalUserPageRespVo> result = this.mdmTerminalUserService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmTerminalUserEditReqVo reqVo) {
        this.mdmTerminalUserService.save(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7ec8\u7aef\u7528\u6237\u8be6\u60c5-\u6839\u636eID\u67e5\u8be2", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detailById"})
    @CrmDictMethod
    public Result<MdmTerminalUserDetailRespVo> queryById(@RequestParam(value="id", required=true) String id) {
        return Result.ok((Object)this.mdmTerminalUserService.queryByIdOrUsername(id, null));
    }

    @ApiOperation(value="\u7ec8\u7aef\u7528\u6237\u8be6\u60c5-\u6839\u636e\u7528\u6237\u767b\u5f55\u540d\u67e5\u8be2", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="\u7528\u6237\u767b\u5f55\u540d", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detailByUsername"})
    @CrmDictMethod
    public Result<MdmTerminalUserDetailRespVo> queryByName(@RequestParam(value="userName", required=true) String userName) {
        return Result.ok((Object)this.mdmTerminalUserService.queryByIdOrUsername(null, userName));
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody MdmTerminalUserEditReqVo reqVo) {
        this.mdmTerminalUserService.update(reqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        this.mdmTerminalUserService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        this.mdmUserService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        this.mdmUserService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7528\u6237\u89e3\u9501", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/unlock"})
    public Result unlock(@RequestBody List<String> ids) {
        this.mdmUserService.unlock(ids);
        return Result.ok((String)"\u89e3\u9501\u6210\u529f");
    }

    @ApiOperation(value="\u5f3a\u5236\u6279\u91cf\u4fee\u6539\u5bc6\u7801", httpMethod="POST")
    @PostMapping(value={"/forceChangePassword"})
    public Result forceChangePassword(@RequestBody MdmUserForceChangePasswordReqVo reqVo) {
        this.mdmUserService.forceChangePassword(reqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u65b0\u589e/\u7f16\u8f91\u7ec8\u7aef\u4e0b\u62c9\u5217\u8868", httpMethod="POST", notes="\u65b0\u589e:\u8fd4\u56de\u6240\u6709\u672a\u88ab\u5173\u8054\u7684\u7ec8\u7aef\uff1b\u7f16\u8f91:\u8fd4\u56de\u5f53\u524d\u7528\u6237\u5df2\u7ecf\u5173\u8054\u7684\u7ec8\u7aef\u548c\u672a\u88ab\u5176\u4ed6\u7528\u6237\u5173\u8054\u7684\u7ec8\u7aef")
    @PostMapping(value={"/getTerminalListByCondition"})
    public Result<List<MdmTerminalDetailRespVo>> getTerminalListByCondition(@RequestBody MdmTerminalUserTerminalSelectReqVo reqVo) {
        return Result.ok(this.mdmTerminalUserService.getTerminalListByCondition(reqVo));
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec8\u7aef\u7528\u6237\u65b0\u589e\u7f16\u8f91\u9875\u9762\u63a7\u5236\u53d8\u91cf")
    @GetMapping(value={"/getTerminalUserControl"})
    public Result<MdmTerminalUserControlControlRespVo> getTerminalUserControl() {
        MdmTerminalUserControlControlRespVo respVo = new MdmTerminalUserControlControlRespVo();
        respVo.setUserCanRelationManyTerminal(ParamUtil.getParameterValue((String)"user_can_relation_many_terminal"));
        return Result.ok((Object)respVo);
    }
}

