/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.config.MapperConfig;
import com.biz.crm.kms.manager.KmsConverter;
import com.biz.crm.kms.service.MdmGrabRuleService;
import com.biz.crm.nebular.mdm.kms.MdmDirectSystemVo;
import com.biz.crm.nebular.mdm.kms.MdmGrabOrderTypeVo;
import com.biz.crm.nebular.mdm.kms.MdmGrabParamVo;
import com.biz.crm.nebular.mdm.kms.MdmGrabRuleVo;
import com.biz.crm.nebular.mdm.kms.MdmRuleParamVo;
import com.biz.crm.nebular.mdm.kms.api.KmsGrabRulePageVo;
import com.biz.crm.nebular.mdm.kms.api.KmsGrabRuleVo;
import com.biz.crm.nebular.mdm.kms.api.KmsGrabStoreVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageResultVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageVo;
import com.biz.crm.nebular.mdm.kms.api.KmsResultVo;
import com.biz.crm.nebular.mdm.kms.api.KmsRuleParamRespVo;
import com.biz.crm.nebular.mdm.kms.api.KmsStoreRespVo;
import com.biz.crm.nebular.mdm.kms.api.KmsStoreVo;
import com.biz.crm.nebular.mdm.kms.api.MdmRuleParamFieldVo;
import com.biz.crm.util.StringUtils;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmGrabRuleServiceExpandImpl"})
public class MdmGrabRuleServiceImpl
implements MdmGrabRuleService {
    private static final Logger log = LoggerFactory.getLogger(MdmGrabRuleServiceImpl.class);
    @Autowired
    private KmsProperties kmsProperties;
    private static final String KMS_ID = "id";
    private static final String MDM_ID = "kms_id";

    public String convert(String id) {
        if (id == null || "".equals(id.trim())) {
            return id;
        }
        if (!id.equals(KMS_ID) && !id.equals(MDM_ID)) {
            return id;
        }
        return KMS_ID.equals(id) ? MDM_ID : KMS_ID;
    }

    @Override
    public List<MdmGrabOrderTypeVo> orderTypeList(MdmDirectSystemVo mdmDirectSystemVo) {
        String directSystemId = mdmDirectSystemVo.getDirectSystemId();
        Assert.hasText((String)directSystemId, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        String bsDirectId = mdmDirectSystemVo.getBsDirectId();
        Assert.hasText((String)bsDirectId, (String)"\u540e\u53f0\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        this.saveBatchBsInvoice(directSystemId, bsDirectId);
        ObjectNode instance = MapperConfig.instance(this.kmsProperties);
        instance.put("directSystemId", directSystemId);
        String url = this.kmsProperties.getUrl() + "/orderTypeController/findOrderTypeList";
        ParameterizedTypeReference<KmsResultVo<List<MdmGrabOrderTypeVo>>> reference = new ParameterizedTypeReference<KmsResultVo<List<MdmGrabOrderTypeVo>>>(){};
        return Optional.of(RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)instance, (ParameterizedTypeReference)reference)).map(HttpEntity::getBody).map(KmsResultVo::getData).map(x -> {
            for (MdmGrabOrderTypeVo mdmGrabOrderTypeVo : x) {
                mdmGrabOrderTypeVo.setInvoiceId(mdmGrabOrderTypeVo.getId());
            }
            return x;
        }).orElse(Collections.emptyList());
    }

    protected void saveBatchBsInvoice(String directSystemId, String bsDirectId) {
        ObjectNode bsParam = MapperConfig.instance(this.kmsProperties);
        bsParam.put("bsDirectId", bsDirectId);
        String url = this.kmsProperties.getUrl() + "/orderTypeController/findBsOrderTypeList";
        ParameterizedTypeReference<KmsResultVo<List<MdmGrabOrderTypeVo>>> reference = new ParameterizedTypeReference<KmsResultVo<List<MdmGrabOrderTypeVo>>>(){};
        Optional.of(RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)bsParam, (ParameterizedTypeReference)reference)).map(HttpEntity::getBody).filter(x -> "SUCCESS".equals(x.getCode())).map(KmsResultVo::getData).ifPresent(x -> {
            if (!CollectionUtils.isEmpty((Collection)x)) {
                String orderTypeUrl = this.kmsProperties.getUrl() + "/orderTypeController/saveOrderType?access_token=" + this.kmsProperties.getAccessToken();
                ParameterizedTypeReference<KmsResultVo<Object>> orderTypeReference = new ParameterizedTypeReference<KmsResultVo<Object>>(){};
                x.parallelStream().forEach(arg_0 -> this.lambda$null$350(directSystemId, orderTypeUrl, (ParameterizedTypeReference)orderTypeReference, arg_0));
            }
        });
    }

    @Override
    public PageResult<MdmGrabRuleVo> page(MdmGrabRuleVo mdmGrabRuleVo) {
        String directSystemId = mdmGrabRuleVo.getDirectSystemId();
        Assert.hasText((String)directSystemId, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        String bsDirectId = mdmGrabRuleVo.getBsDirectId();
        Assert.hasText((String)bsDirectId, (String)"\u540e\u53f0\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        Integer current = Optional.ofNullable(mdmGrabRuleVo.getPageNum()).orElse(1);
        Integer size = Optional.ofNullable(mdmGrabRuleVo.getPageSize()).orElse(25);
        KmsPageVo kmsPageVo = new KmsPageVo(current, size);
        KmsGrabRuleVo kmsGrabRuleVo = new KmsGrabRuleVo();
        kmsGrabRuleVo.setInvoiceId(mdmGrabRuleVo.getInvoiceId());
        kmsGrabRuleVo.setDirectSystemId(directSystemId);
        kmsGrabRuleVo.setName(mdmGrabRuleVo.getName());
        KmsGrabRulePageVo kmsGrabRulePageVo = new KmsGrabRulePageVo();
        kmsGrabRulePageVo.setUserId(this.kmsProperties.getUserId());
        kmsGrabRulePageVo.setUsername(this.kmsProperties.getUsername());
        kmsGrabRulePageVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsGrabRulePageVo.setReqVo(kmsGrabRuleVo);
        kmsGrabRulePageVo.setPage(kmsPageVo);
        String url = this.kmsProperties.getUrl() + "/grabRuleController/findGrabRuleListByPage";
        ParameterizedTypeReference<KmsResultVo<KmsPageResultVo<KmsGrabRuleVo>>> reference = new ParameterizedTypeReference<KmsResultVo<KmsPageResultVo<KmsGrabRuleVo>>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsGrabRulePageVo, (ParameterizedTypeReference)reference);
        KmsPageResultVo kmsPageResultVo = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(null);
        if (kmsPageResultVo == null || kmsPageResultVo.getRecords() == null || kmsPageResultVo.getRecords() == 0) {
            PageResult emptyPage = new PageResult();
            emptyPage.setCount(Long.valueOf(0L));
            emptyPage.setData(Collections.emptyList());
            return emptyPage;
        }
        PageResult<MdmGrabRuleVo> mdmGrabRuleVoPageResult = KmsConverter.INSTANCE.grabRule2Mdm((KmsPageResultVo<KmsGrabRuleVo>)kmsPageResultVo);
        List data = mdmGrabRuleVoPageResult.getData();
        for (MdmGrabRuleVo grabRuleVo : data) {
            grabRuleVo.setBsDirectId(bsDirectId);
            grabRuleVo.setBsInvoiceId(mdmGrabRuleVo.getBsInvoiceId());
            grabRuleVo.setDirectSystemId(directSystemId);
            grabRuleVo.setInvoiceId(mdmGrabRuleVo.getInvoiceId());
        }
        return mdmGrabRuleVoPageResult;
    }

    @Override
    public void enable(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsGrabRuleVo kmsGrabRuleVo = new KmsGrabRuleVo();
        kmsGrabRuleVo.setIds(ids);
        kmsGrabRuleVo.setComomStatus("ENABLE");
        kmsGrabRuleVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsGrabRuleVo.setUsername(kmsGrabRuleVo.getUsername());
        kmsGrabRuleVo.setUserId(kmsGrabRuleVo.getUserId());
        String url = this.kmsProperties.getUrl() + "/grabRuleController/modifyGrabRuleStatus?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsGrabRuleVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u542f\u7528\u5931\u8d25");
        }
    }

    @Override
    public void disable(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsGrabRuleVo kmsGrabRuleVo = new KmsGrabRuleVo();
        kmsGrabRuleVo.setIds(ids);
        kmsGrabRuleVo.setComomStatus("DISABLE");
        kmsGrabRuleVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsGrabRuleVo.setUsername(kmsGrabRuleVo.getUsername());
        kmsGrabRuleVo.setUserId(kmsGrabRuleVo.getUserId());
        String url = this.kmsProperties.getUrl() + "/grabRuleController/modifyGrabRuleStatus?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsGrabRuleVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u7981\u7528\u5931\u8d25");
        }
    }

    @Override
    public void remove(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsGrabRuleVo kmsGrabRuleVo = new KmsGrabRuleVo();
        kmsGrabRuleVo.setIds(ids);
        kmsGrabRuleVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsGrabRuleVo.setUsername(kmsGrabRuleVo.getUsername());
        kmsGrabRuleVo.setUserId(kmsGrabRuleVo.getUserId());
        String url = this.kmsProperties.getUrl() + "/grabRuleController/deleteGrabRuleByIds?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsGrabRuleVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public List<MdmRuleParamVo> paramList(MdmGrabRuleVo mdmGrabRuleVo) {
        String bsDirectId = mdmGrabRuleVo.getBsDirectId();
        Assert.hasText((String)bsDirectId, (String)"\u540e\u53f0\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        String bsInvoiceId = mdmGrabRuleVo.getBsInvoiceId();
        Assert.hasText((String)bsInvoiceId, (String)"\u540e\u53f0\u5355\u636e\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        ObjectNode paramMap = MapperConfig.instance(this.kmsProperties);
        paramMap.put("bsDirectId", bsDirectId);
        paramMap.put("bsInvoiceId", bsInvoiceId);
        String url = this.kmsProperties.getUrl() + "/ruleParamController/findRuleParamList";
        ParameterizedTypeReference<KmsResultVo<List<MdmRuleParamVo>>> reference = new ParameterizedTypeReference<KmsResultVo<List<MdmRuleParamVo>>>(){};
        List mdmRuleParamVos = Optional.of(RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)paramMap, (ParameterizedTypeReference)reference)).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(Collections.emptyList());
        if (CollectionUtils.isEmpty(mdmRuleParamVos)) {
            return Collections.emptyList();
        }
        return mdmRuleParamVos.stream().peek(x -> {
            String isRequired = x.getIsRequired();
            x.setBsFieldId(x.getId());
            if (!org.springframework.util.StringUtils.isEmpty((Object)isRequired) && "YES".equals(isRequired)) {
                x.setIsRequired("1");
            } else {
                x.setIsRequired("0");
            }
            x.setFieldEn(this.convert(x.getFieldEn()));
        }).collect(Collectors.toList());
    }

    @Override
    public List<KmsGrabStoreVo> findGrabStoreList(MdmGrabRuleVo mdmGrabRuleVo) {
        String directSystemId = mdmGrabRuleVo.getDirectSystemId();
        Assert.hasText((String)directSystemId, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        String invoiceId = mdmGrabRuleVo.getInvoiceId();
        Assert.hasText((String)invoiceId, (String)"\u5355\u636e\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        ObjectNode map = MapperConfig.instance(this.kmsProperties);
        map.put("directSystemId", directSystemId);
        map.put("invoiceId", invoiceId);
        String url = this.kmsProperties.getUrl() + "/ruleStoreController/findStoreGroupListForSave";
        ParameterizedTypeReference<KmsResultVo<List<KmsGrabStoreVo>>> reference = new ParameterizedTypeReference<KmsResultVo<List<KmsGrabStoreVo>>>(){};
        List kmsGrabStoreVos = Optional.of(RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)map, (ParameterizedTypeReference)reference)).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(Collections.emptyList());
        List<KmsGrabStoreVo> collect = kmsGrabStoreVos.stream().filter(MdmGrabRuleServiceImpl.distinctByKey(KmsGrabStoreVo::getId)).collect(Collectors.toList());
        for (KmsGrabStoreVo kmsGrabStoreVo : collect) {
            kmsGrabStoreVo.setChildList(this.distinctId(kmsGrabStoreVo.getChildList()));
        }
        return collect;
    }

    private List<KmsGrabStoreVo> distinctId(List<KmsGrabStoreVo> childList) {
        if (CollectionUtils.isEmpty(childList)) {
            return Collections.emptyList();
        }
        for (KmsGrabStoreVo kmsGrabStoreVo : childList) {
            kmsGrabStoreVo.setChildList(this.distinctId(kmsGrabStoreVo.getChildList()));
        }
        return childList.stream().filter(MdmGrabRuleServiceImpl.distinctByKey(KmsGrabStoreVo::getId)).collect(Collectors.toList());
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private List<KmsGrabStoreVo> filterSelect(List<KmsGrabStoreVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        for (KmsGrabStoreVo kmsGrabStoreVo : list) {
            kmsGrabStoreVo.setChildList(this.filterSelect(kmsGrabStoreVo.getChildList()));
        }
        return list.stream().filter(x -> !x.isForbidden() && org.springframework.util.StringUtils.isEmpty((Object)x.getComomStatus())).collect(Collectors.toList());
    }

    @Override
    public void save(MdmGrabRuleVo mdmGrabRuleVo) {
        String url;
        ResponseEntity entity;
        Assert.hasText((String)mdmGrabRuleVo.getAccountId(), (String)"\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmGrabRuleVo.getBsDirectId(), (String)"\u540e\u53f0\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmGrabRuleVo.getBsInvoiceId(), (String)"\u540e\u53f0\u5355\u636e\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmGrabRuleVo.getDirectSystemId(), (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmGrabRuleVo.getDirectSystemName(), (String)"\u76f4\u8425\u4f53\u7cfb\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmGrabRuleVo.getInvoiceId(), (String)"\u5355\u636e\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmGrabRuleVo.getInvoiceName(), (String)"\u5355\u636e\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmGrabRuleVo.getName(), (String)"\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)this.verifyDateFormat(mdmGrabRuleVo.getStartDate(), "HH:mm"), (String)"\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        Assert.isTrue((boolean)this.verifyDateFormat(mdmGrabRuleVo.getEndDate(), "HH:mm"), (String)"\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        Assert.isTrue((mdmGrabRuleVo.getEndDate().compareTo(mdmGrabRuleVo.getStartDate()) > 0 ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u8981\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4");
        Assert.hasText((String)mdmGrabRuleVo.getRequency(), (String)"\u6267\u884c\u95f4\u9694\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        try {
            int endMinutes = 60 * sdf.parse(mdmGrabRuleVo.getEndDate()).getHours() + sdf.parse(mdmGrabRuleVo.getEndDate()).getMinutes();
            int startMinutes = 60 * sdf.parse(mdmGrabRuleVo.getStartDate()).getHours() + sdf.parse(mdmGrabRuleVo.getStartDate()).getMinutes();
            Assert.isTrue((endMinutes - startMinutes > Integer.parseInt(mdmGrabRuleVo.getRequency()) ? 1 : 0) != 0, (String)"\u65f6\u95f4\u95f4\u9694\u8981\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u4e4b\u5dee");
        }
        catch (ParseException e) {
            log.error("[\u5355\u636e\u89c4\u5219][save]\u65f6\u95f4\u8f6c\u6362:{}", (Throwable)e);
        }
        KmsGrabRuleVo kmsGrabRuleVo = KmsConverter.INSTANCE.grabRule2Kms(mdmGrabRuleVo);
        kmsGrabRuleVo.setUserId(this.kmsProperties.getUserId());
        kmsGrabRuleVo.setUsername(this.kmsProperties.getUsername());
        kmsGrabRuleVo.setTenantryId(this.kmsProperties.getTenantryId());
        List params = kmsGrabRuleVo.getParams();
        if (!CollectionUtils.isEmpty((Collection)params)) {
            params = params.stream().peek(x -> {
                x.setFieldEn(this.convert(x.getFieldEn()));
                if ("INPUT".equals(x.getFieldClassify()) && x.getOptionName() == null) {
                    x.setOptionName("");
                }
            }).collect(Collectors.toList());
            kmsGrabRuleVo.setParams(params);
        }
        if (!HttpStatus.OK.equals((Object)(entity = RestTemplateUtils.postForEntity((String)(url = this.kmsProperties.getUrl() + "/grabRuleController/saveGrabRule?access_token=" + this.kmsProperties.getAccessToken()), null, (Object)kmsGrabRuleVo, String.class)).getStatusCode())) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25");
        }
    }

    @Override
    public void update(MdmGrabRuleVo mdmGrabRuleVo) {
        Assert.hasText((String)mdmGrabRuleVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        this.remove(Collections.singletonList(mdmGrabRuleVo.getId()));
        this.save(mdmGrabRuleVo);
    }

    @Override
    public MdmGrabRuleVo query(MdmGrabRuleVo mdmGrabRuleVo) {
        ParameterizedTypeReference<KmsResultVo<List<KmsRuleParamRespVo>>> paramReference;
        String ruleParamUrl;
        ResponseEntity paramEntity;
        List kmsRuleParamRespVos;
        String id = mdmGrabRuleVo.getId();
        Assert.hasText((String)id, (String)"\u89c4\u5219id\u4e0d\u80fd\u4e3a\u7a7a");
        String directSystemId = mdmGrabRuleVo.getDirectSystemId();
        Assert.hasText((String)directSystemId, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        String invoiceId = mdmGrabRuleVo.getInvoiceId();
        Assert.hasText((String)invoiceId, (String)"\u5355\u636e\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        String bsDirectId = mdmGrabRuleVo.getBsDirectId();
        Assert.hasText((String)bsDirectId, (String)"\u540e\u53f0\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        String bsInvoiceId = mdmGrabRuleVo.getBsInvoiceId();
        Assert.hasText((String)bsInvoiceId, (String)"\u540e\u53f0\u5355\u636e\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        ObjectNode paramMap = MapperConfig.instance(this.kmsProperties);
        paramMap.put(KMS_ID, id);
        paramMap.put("directSystemId", directSystemId);
        paramMap.put("invoiceId", invoiceId);
        paramMap.put("bsDirectId", bsDirectId);
        paramMap.put("bsInvoiceId", bsInvoiceId);
        paramMap.put("ruleId", id);
        String ruleUrl = this.kmsProperties.getUrl() + "/grabRuleController/getGrabRuleById";
        ParameterizedTypeReference<KmsResultVo<MdmGrabRuleVo>> ruleReference = new ParameterizedTypeReference<KmsResultVo<MdmGrabRuleVo>>(){};
        MdmGrabRuleVo result = Optional.of(RestTemplateUtils.exchange((String)ruleUrl, (HttpMethod)HttpMethod.POST, null, (Object)paramMap, (ParameterizedTypeReference)ruleReference)).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(null);
        if (result == null) {
            return null;
        }
        ArrayList storeIdList = new ArrayList();
        List<Object> grabStoreList = this.findGrabStoreList(mdmGrabRuleVo);
        if (!CollectionUtils.isEmpty(grabStoreList)) {
            String storeUrl = this.kmsProperties.getUrl() + "/ruleStoreController/findRuleStoreList";
            ParameterizedTypeReference<KmsResultVo<KmsPageResultVo<KmsStoreRespVo>>> storeReference = new ParameterizedTypeReference<KmsResultVo<KmsPageResultVo<KmsStoreRespVo>>>(){};
            KmsGrabRulePageVo kmsGrabRulePageVo = new KmsGrabRulePageVo();
            kmsGrabRulePageVo.setPage(new KmsPageVo(Integer.valueOf(1), Integer.valueOf(-1)));
            KmsGrabRuleVo kmsGrabRuleVo = new KmsGrabRuleVo();
            kmsGrabRuleVo.setBsDirectId(bsDirectId);
            kmsGrabRuleVo.setBsInvoiceId(bsInvoiceId);
            kmsGrabRuleVo.setTenantryId(this.kmsProperties.getTenantryId());
            kmsGrabRuleVo.setRuleId(id);
            kmsGrabRulePageVo.setReqVo(kmsGrabRuleVo);
            kmsGrabRulePageVo.setUsername(this.kmsProperties.getUsername());
            kmsGrabRulePageVo.setUserId(this.kmsProperties.getUserId());
            kmsGrabRulePageVo.setTenantryId(this.kmsProperties.getTenantryId());
            List kmsStoreRespVos = Optional.of(RestTemplateUtils.exchange((String)storeUrl, (HttpMethod)HttpMethod.POST, null, (Object)kmsGrabRulePageVo, (ParameterizedTypeReference)storeReference)).map(HttpEntity::getBody).map(KmsResultVo::getData).map(KmsPageResultVo::getRows).orElse(Collections.emptyList());
            List collect = kmsStoreRespVos.stream().filter(Objects::nonNull).filter(x -> !org.springframework.util.StringUtils.isEmpty((Object)x.getStoreName())).map(KmsStoreRespVo::getStoreName).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                while (!CollectionUtils.isEmpty(grabStoreList)) {
                    List idList = grabStoreList.stream().filter(x -> !org.springframework.util.StringUtils.isEmpty((Object)x.getName())).filter(x -> collect.contains(x.getName())).map(KmsGrabStoreVo::getId).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(idList)) {
                        storeIdList.addAll(idList.stream().map(KmsStoreVo::new).collect(Collectors.toList()));
                    }
                    grabStoreList = grabStoreList.stream().filter(x -> !CollectionUtils.isEmpty((Collection)x.getChildList())).flatMap(x -> x.getChildList().stream()).collect(Collectors.toList());
                }
            }
        }
        result.setStores(storeIdList);
        List<MdmRuleParamVo> mdmRuleParamVos = this.paramList(mdmGrabRuleVo);
        ArrayList<MdmGrabParamVo> params = new ArrayList<MdmGrabParamVo>();
        if (!CollectionUtils.isEmpty(mdmRuleParamVos) && !CollectionUtils.isEmpty(kmsRuleParamRespVos = Optional.of(paramEntity = RestTemplateUtils.exchange((String)(ruleParamUrl = this.kmsProperties.getUrl() + "/ruleParamController/findRuleParamDetailList"), (HttpMethod)HttpMethod.POST, null, (Object)paramMap, (ParameterizedTypeReference)(paramReference = new ParameterizedTypeReference<KmsResultVo<List<KmsRuleParamRespVo>>>(){}))).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(Collections.emptyList()))) {
            Map<String, String> fieldMap = kmsRuleParamRespVos.stream().collect(Collectors.toMap(KmsRuleParamRespVo::getOptionName, KmsRuleParamRespVo::getFieldCn));
            for (MdmRuleParamVo mdmRuleParamVo : mdmRuleParamVos) {
                String fieldCn = mdmRuleParamVo.getFieldCn();
                List options = mdmRuleParamVo.getOptions();
                if (!CollectionUtils.isEmpty((Collection)options)) {
                    for (MdmRuleParamFieldVo option : options) {
                        String s;
                        String optionName = option.getOptionName();
                        if (org.springframework.util.StringUtils.isEmpty((Object)optionName) || org.springframework.util.StringUtils.isEmpty((Object)(s = fieldMap.get(optionName))) || !s.equals(fieldCn)) continue;
                        MdmGrabParamVo mdmGrabParamVo = new MdmGrabParamVo();
                        mdmGrabParamVo.setFieldClassify(mdmGrabParamVo.getFieldClassify());
                        mdmGrabParamVo.setFieldCn(mdmGrabParamVo.getFieldCn());
                        mdmGrabParamVo.setFieldEn(mdmGrabParamVo.getFieldEn());
                        mdmGrabParamVo.setOptionName(option.getOptionName());
                        mdmGrabParamVo.setBsFieldId(option.getFieldId());
                        mdmRuleParamVo.setValue(option.getOptionValue());
                        params.add(mdmGrabParamVo);
                    }
                    continue;
                }
                for (KmsRuleParamRespVo kmsRuleParamRespVo : kmsRuleParamRespVos) {
                    if (!kmsRuleParamRespVo.getFieldCn().equals(mdmRuleParamVo.getFieldCn())) continue;
                    mdmRuleParamVo.setValue(kmsRuleParamRespVo.getOptionName());
                }
            }
        }
        result.setParams(params);
        result.setMdmRuleParamVos(mdmRuleParamVos);
        result.setDirectSystemId(mdmGrabRuleVo.getDirectSystemId());
        result.setBsDirectId(mdmGrabRuleVo.getBsDirectId());
        result.setInvoiceId(mdmGrabRuleVo.getInvoiceId());
        result.setBsInvoiceId(mdmGrabRuleVo.getBsInvoiceId());
        return result;
    }

    private boolean verifyDateFormat(String dataStr, String formatStr) {
        boolean flag = false;
        if (StringUtils.isNotEmpty((String)dataStr) && StringUtils.isNotEmpty((String)formatStr)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
                Date parse = sdf.parse(dataStr);
                String dateFormatStr = sdf.format(parse);
                if (dataStr.equals(dateFormatStr)) {
                    flag = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flag;
    }

    private /* synthetic */ void lambda$null$350(String string, String string2, ParameterizedTypeReference parameterizedTypeReference, MdmGrabOrderTypeVo k) {
        ObjectNode orderTypeParam = MapperConfig.instance(this.kmsProperties);
        orderTypeParam.put("directSystemId", string);
        orderTypeParam.put("bsInvoiceId", k.getBsInvoiceId());
        orderTypeParam.put("invoiceName", k.getInvoiceName());
        Optional.of(RestTemplateUtils.exchange((String)string2, (HttpMethod)HttpMethod.POST, null, (Object)orderTypeParam, (ParameterizedTypeReference)parameterizedTypeReference)).map(HttpEntity::getBody).filter(v -> "ERROR".equals(v.getCode())).ifPresent(v -> {
            throw new BusinessException(v.getMessage());
        });
    }
}

