/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.employeedirectory.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.employeedirectory.mapper.MdmEmployeeDirectoryMapper;
import com.biz.crm.employeedirectory.model.MdmEmployeeDirectoryEntity;
import com.biz.crm.employeedirectory.service.MdmEmployeeDirectoryService;
import com.biz.crm.nebular.mdm.employeedirectory.MdmEmployeeDirectoryListRespVo;
import com.biz.crm.nebular.mdm.employeedirectory.MdmEmployeeDirectoryReqVo;
import com.biz.crm.nebular.mdm.employeedirectory.MdmEmployeeDirectoryRespVo;
import com.biz.crm.nebular.mdm.permission.MdmCurrentPermissionRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PermissionUtil;
import com.biz.crm.utils.PinYinUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class MdmEmployeeDirectoryServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmEmployeeDirectoryMapper, MdmEmployeeDirectoryEntity>
implements MdmEmployeeDirectoryService {
    private static final Logger log = LoggerFactory.getLogger(MdmEmployeeDirectoryServiceImpl.class);
    @Autowired
    private MdmEmployeeDirectoryMapper mdmEmployeeDirectoryMapper;
    @Autowired
    private RedisService redisService;

    @Override
    public List<MdmEmployeeDirectoryListRespVo> findList() {
        MdmCurrentPermissionRespVo permissionList = PermissionUtil.currentUserPermissionList();
        List userPermissionList = permissionList.getUserPermissionList();
        HashSet pocCodes = new HashSet();
        userPermissionList.forEach(u -> {
            List permissionValueList = u.getPermissionValueList();
            pocCodes.addAll(new HashSet(permissionValueList));
        });
        String userRedisKeyLong = pocCodes.stream().map(String::toString).collect(Collectors.joining("-"));
        String userRedisKey = this.compress(userRedisKeyLong);
        HashSet employeeKey = (HashSet)this.redisService.get("MDM_EMPLOYEE_DIRECTORY:");
        if (ObjectUtils.isEmpty((Object)employeeKey)) {
            HashSet<String> objects = new HashSet<String>();
            objects.add(userRedisKey);
            this.redisService.set("MDM_EMPLOYEE_DIRECTORY:", objects);
        } else {
            if (employeeKey.contains(userRedisKey)) {
                List result = (List)this.redisService.get(userRedisKey);
                return result;
            }
            employeeKey.add(userRedisKey);
            this.redisService.set("MDM_EMPLOYEE_DIRECTORY:", (Object)employeeKey);
        }
        List<MdmEmployeeDirectoryRespVo> respVos = this.mdmEmployeeDirectoryMapper.findList();
        Map<String, List<MdmEmployeeDirectoryRespVo>> collect = respVos.stream().collect(Collectors.groupingBy(MdmEmployeeDirectoryRespVo::getFirstNameInitials));
        List<MdmEmployeeDirectoryListRespVo> result = collect.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> new MdmEmployeeDirectoryListRespVo((String)e.getKey(), (List)e.getValue())).collect(Collectors.toList());
        this.redisService.set(userRedisKey, result);
        return result;
    }

    public void cleanRedis() {
        HashSet o = (HashSet)this.redisService.get("MDM_EMPLOYEE_DIRECTORY:");
        o.forEach(directoryKey -> this.redisService.del(new String[]{directoryKey}));
        this.redisService.del(new String[]{"MDM_EMPLOYEE_DIRECTORY:"});
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmEmployeeDirectoryReqVo reqVo) {
        this.doCheck(reqVo);
        String nameInitials = PinYinUtil.getPinYin(reqVo.getEmployeeName());
        char chars = nameInitials.charAt(0);
        String firstNameInitials = Character.toString(chars);
        reqVo.setFirstNameInitials(firstNameInitials);
        MdmEmployeeDirectoryEntity entity = (MdmEmployeeDirectoryEntity)CrmBeanUtil.copy((Object)reqVo, MdmEmployeeDirectoryEntity.class);
        this.save(entity);
        this.cleanRedis();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteEmployeeCode(List<String> employeeCodes) {
        Assert.notNull(employeeCodes, (String)"\u7f3a\u5931\u53c2\u6570");
        List<MdmEmployeeDirectoryRespVo> list = this.mdmEmployeeDirectoryMapper.selectByEmployeeCodes(employeeCodes);
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList idList = new ArrayList();
            list.forEach(o -> idList.add(o.getId()));
            this.removeByIds(idList);
        }
        this.cleanRedis();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByPosCode(List<String> posCodes) {
        Assert.notNull(posCodes, (String)"\u7f3a\u5931\u53c2\u6570");
        List<MdmEmployeeDirectoryRespVo> list = this.mdmEmployeeDirectoryMapper.selectByPosCodes(posCodes);
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList idList = new ArrayList();
            list.forEach(o -> idList.add(o.getId()));
            this.removeByIds(idList);
        }
        this.cleanRedis();
    }

    public void doCheck(MdmEmployeeDirectoryReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getUserCode(), (String)"userCode\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getEmployeeCode(), (String)"\u5458\u5de5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getEmployeeName(), (String)"\u5458\u5de5\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOrgCode(), (String)"\u5458\u5de5\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOrgName(), (String)"\u5458\u5de5\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPosCode(), (String)"\u5458\u5de5\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPosName(), (String)"\u5458\u5de5\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPhone(), (String)"\u5458\u5de5\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public String compress(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = null;
        try {
            gzip = new GZIPOutputStream(out);
            gzip.write(str.getBytes());
            gzip.close();
            return out.toString("ISO-8859-1");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

