/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.poi.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerSupplyService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.constant.RegionLevelEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapDistrictRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapDistrictStatisticianRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeTotalVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmAmapDistrictStatisticianReqVo;
import com.biz.crm.poi.mapper.MdmAmapPoiMapper;
import com.biz.crm.poi.model.MdmAmapPoiCityEntity;
import com.biz.crm.poi.model.MdmAmapPoiEntity;
import com.biz.crm.poi.model.MdmAmapPoiTypeEntity;
import com.biz.crm.poi.service.MdmAmapPoiCityService;
import com.biz.crm.poi.service.MdmAmapPoiService;
import com.biz.crm.poi.service.MdmAmapPoiTypeService;
import com.biz.crm.poi.service.MdmAmapStatisticianService;
import com.biz.crm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PinyinUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmAmapStatisticianServiceExpandImpl"})
public class MdmAmapStatisticianServiceImpl
implements MdmAmapStatisticianService {
    private static final Logger log = LoggerFactory.getLogger(MdmAmapStatisticianServiceImpl.class);
    @Autowired
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Autowired
    private MdmTerminalService mdmTerminalService;
    @Autowired
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;
    @Autowired
    private MdmAmapPoiCityService mdmAmapPoiCityService;
    @Autowired
    private MdmTerminalMapper mdmTerminalMapper;
    @Autowired
    private MdmAmapPoiTypeService mdmAmapPoiTypeService;
    @Autowired
    private MdmAmapPoiService mdmAmapPoiService;
    @Autowired
    private MdmAmapPoiMapper mdmAmapPoiMapper;
    @Autowired
    private MdmCustomerSupplyService mdmCustomerSupplyService;

    @Override
    public List<MdmTerminalStatisticianTypeVo> statisticalType() {
        List<MdmTerminalStatisticianTypeVo> mdmTerminalStatisticianTypeVos = this.mdmTerminalService.statisticalType(new MdmTerminalVo());
        List<MdmTerminalStatisticianTypeVo> mdmCustomerStatisticianTypeVos = this.mdmCustomerMsgService.statisticalType(new MdmCustomerMsgReqVo());
        MdmTerminalStatisticianTypeVo terminal = new MdmTerminalStatisticianTypeVo();
        terminal.setStatisticianType("terminal");
        terminal.setStatisticianName("\u7ec8\u7aef");
        Integer terminalCount = mdmTerminalStatisticianTypeVos.stream().map(x -> Optional.ofNullable(x.getStatisticianCount()).orElse(0)).mapToInt(x -> x).sum();
        terminal.setStatisticianCount(terminalCount);
        terminal.setChildren(mdmTerminalStatisticianTypeVos);
        MdmTerminalStatisticianTypeVo customer = new MdmTerminalStatisticianTypeVo();
        customer.setStatisticianType("customer");
        customer.setStatisticianName("\u5ba2\u6237");
        Integer customerCount = mdmCustomerStatisticianTypeVos.stream().map(x -> Optional.ofNullable(x.getStatisticianCount()).orElse(0)).mapToInt(x -> x).sum();
        customer.setStatisticianCount(customerCount);
        customer.setChildren(mdmCustomerStatisticianTypeVos);
        return Arrays.asList(terminal, customer);
    }

    @Override
    public List<MdmAmapDistrictStatisticianRespVo> statisticalDistrict(MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo) {
        List statisticianTypeList = mdmAmapDistrictStatisticianReqVo.getStatisticianTypeList();
        if (CollectionUtils.isEmpty((Collection)statisticianTypeList)) {
            return Collections.emptyList();
        }
        ArrayList<MdmAmapDistrictStatisticianRespVo> districtStatistician = new ArrayList<MdmAmapDistrictStatisticianRespVo>();
        String regionLevel = null;
        if (!StringUtils.isEmpty((Object)mdmAmapDistrictStatisticianReqVo.getAmapDistrictCode())) {
            MdmAmapPoiCityEntity amapPoiCityEntity = (MdmAmapPoiCityEntity)((LambdaQueryChainWrapper)this.mdmAmapPoiCityService.lambdaQuery().eq(MdmAmapPoiCityEntity::getAmapCode, (Object)mdmAmapDistrictStatisticianReqVo.getAmapDistrictCode())).select(new SFunction[]{MdmAmapPoiCityEntity::getRegionCode, MdmAmapPoiCityEntity::getRegionLevel}).one();
            log.info("\u9ad8\u5fb7\u57ce\u5e02:{}", (Object)amapPoiCityEntity);
            if (amapPoiCityEntity != null) {
                String regionCode = amapPoiCityEntity.getRegionCode();
                if (!StringUtils.isEmpty((Object)regionCode)) {
                    mdmAmapDistrictStatisticianReqVo.setAmapDistrictCode(regionCode);
                }
                regionLevel = amapPoiCityEntity.getRegionLevel();
            }
        }
        if (!StringUtils.isEmpty((Object)mdmAmapDistrictStatisticianReqVo.getAmapDistrictCode())) {
            if (regionLevel != null) {
                if (RegionLevelEnum.PROVINCE.getCode().equals(regionLevel)) {
                    districtStatistician.addAll(this.mdmCustomerMsgMapper.statisticalCity(mdmAmapDistrictStatisticianReqVo));
                    districtStatistician.addAll(this.mdmTerminalMapper.statisticalCity(mdmAmapDistrictStatisticianReqVo));
                } else if (RegionLevelEnum.CITY.getCode().equals(regionLevel)) {
                    districtStatistician.addAll(this.mdmCustomerMsgMapper.statisticalDistrict(mdmAmapDistrictStatisticianReqVo));
                    districtStatistician.addAll(this.mdmTerminalMapper.statisticalDistrict(mdmAmapDistrictStatisticianReqVo));
                }
            }
        } else {
            districtStatistician.addAll(this.mdmCustomerMsgMapper.statisticalProvince(mdmAmapDistrictStatisticianReqVo));
            districtStatistician.addAll(this.mdmTerminalMapper.statisticalProvince(mdmAmapDistrictStatisticianReqVo));
        }
        if (CollectionUtils.isEmpty(districtStatistician)) {
            return Collections.emptyList();
        }
        List amapCodeList = districtStatistician.stream().map(MdmAmapDistrictStatisticianRespVo::getAmapCode).filter(amapCode -> !StringUtils.isEmpty((Object)amapCode)).collect(Collectors.toList());
        Map collect = ((LambdaQueryChainWrapper)this.mdmAmapPoiCityService.lambdaQuery().in(MdmAmapPoiCityEntity::getRegionCode, amapCodeList)).select(new SFunction[]{MdmAmapPoiCityEntity::getAmapCode, MdmAmapPoiCityEntity::getAmapName, MdmAmapPoiCityEntity::getRegionCode}).list().stream().filter(x -> !StringUtils.isEmpty((Object)x.getRegionCode())).collect(Collectors.toMap(MdmAmapPoiCityEntity::getRegionCode, Function.identity()));
        Map map = districtStatistician.stream().filter(x -> collect.containsKey(x.getAmapCode())).peek(x -> {
            MdmAmapPoiCityEntity mdmAmapPoiCityEntity = (MdmAmapPoiCityEntity)collect.get(x.getAmapCode());
            x.setAmapCode(mdmAmapPoiCityEntity.getAmapCode());
            String amapName = mdmAmapPoiCityEntity.getAmapName();
            x.setAmapName(amapName);
            if (!StringUtils.isEmpty((Object)amapName)) {
                if (amapName.endsWith("\u7701") || amapName.endsWith("\u5e02") || amapName.equals("\u53bf") || amapName.equals("\u533a")) {
                    amapName = amapName.substring(0, amapName.length() - 1);
                }
                x.setAmapPinyin(PinyinUtils.toPinLower((String)amapName, (String)""));
            }
        }).collect(Collectors.toMap(MdmAmapDistrictStatisticianRespVo::getAmapCode, Function.identity(), (x1, x2) -> {
            Integer i1 = Optional.ofNullable(x1.getAmapStatistician()).orElse(0);
            Integer i2 = Optional.ofNullable(x2.getAmapStatistician()).orElse(0);
            x1.setAmapStatistician(Integer.valueOf(i1 + i2));
            return x1;
        }));
        return new ArrayList<MdmAmapDistrictStatisticianRespVo>(map.values());
    }

    @Override
    public List<MdmTerminalStatisticianTypeVo> unCooperationStatisticalType() {
        List list = this.mdmAmapPoiTypeService.list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        Map<String, Integer> poiMap = this.mdmAmapPoiService.statisticalType().stream().collect(Collectors.toMap(MdmTerminalStatisticianTypeVo::getStatisticianType, MdmTerminalStatisticianTypeVo::getStatisticianCount));
        ArrayList<MdmTerminalStatisticianTypeVo> result = new ArrayList<MdmTerminalStatisticianTypeVo>();
        for (MdmAmapPoiTypeEntity mdmAmapPoiTypeEntity : list) {
            MdmTerminalStatisticianTypeVo mdmTerminalStatisticianTypeVo = new MdmTerminalStatisticianTypeVo();
            mdmTerminalStatisticianTypeVo.setStatisticianType(mdmAmapPoiTypeEntity.getTypeCode());
            mdmTerminalStatisticianTypeVo.setStatisticianName(mdmAmapPoiTypeEntity.getTypeName());
            mdmTerminalStatisticianTypeVo.setStatisticianCount(poiMap.get(mdmAmapPoiTypeEntity.getTypeCode()));
            ArrayList<MdmTerminalStatisticianTypeVo> children = new ArrayList<MdmTerminalStatisticianTypeVo>();
            String parentCode = mdmAmapPoiTypeEntity.getParentCode();
            if (StringUtils.isEmpty((Object)parentCode)) {
                result.add(mdmTerminalStatisticianTypeVo);
            }
            for (MdmAmapPoiTypeEntity amapPoiTypeEntity : list) {
                if (!mdmAmapPoiTypeEntity.getTypeCode().equals(amapPoiTypeEntity.getParentCode())) continue;
                MdmTerminalStatisticianTypeVo statisticianTypeVo = new MdmTerminalStatisticianTypeVo();
                statisticianTypeVo.setStatisticianType(amapPoiTypeEntity.getTypeCode());
                statisticianTypeVo.setStatisticianName(amapPoiTypeEntity.getTypeName());
                statisticianTypeVo.setStatisticianCount(poiMap.get(amapPoiTypeEntity.getTypeCode()));
                children.add(statisticianTypeVo);
            }
            mdmTerminalStatisticianTypeVo.setChildren(children);
        }
        return result;
    }

    @Override
    public List<MdmAmapDistrictStatisticianRespVo> unCooperationStatisticalDistrict(MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo) {
        String amapDistrictCode = mdmAmapDistrictStatisticianReqVo.getAmapDistrictCode();
        List<MdmAmapDistrictStatisticianRespVo> result = new ArrayList<MdmAmapDistrictStatisticianRespVo>();
        List statisticianTypeList = mdmAmapDistrictStatisticianReqVo.getStatisticianTypeList();
        if (CollectionUtils.isEmpty((Collection)statisticianTypeList)) {
            return result;
        }
        if (StringUtils.isEmpty((Object)amapDistrictCode)) {
            result = this.mdmAmapPoiMapper.statisticalProvince(mdmAmapDistrictStatisticianReqVo);
        } else {
            String regionLevel = this.obtainRegionLevel(amapDistrictCode);
            if (RegionLevelEnum.PROVINCE.getCode().equals(regionLevel)) {
                result = this.mdmAmapPoiMapper.statisticalCity(mdmAmapDistrictStatisticianReqVo);
            }
            if (RegionLevelEnum.CITY.getCode().equals(regionLevel)) {
                result = this.mdmAmapPoiMapper.statisticalDistrict(mdmAmapDistrictStatisticianReqVo);
            }
        }
        List mapCodeList = result.stream().map(MdmAmapDistrictStatisticianRespVo::getAmapCode).filter(x -> !StringUtils.isEmpty((Object)x)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(mapCodeList)) {
            Map<String, String> regionMap = ((LambdaQueryChainWrapper)this.mdmAmapPoiCityService.lambdaQuery().in(MdmAmapPoiCityEntity::getAmapCode, mapCodeList)).select(new SFunction[]{MdmAmapPoiCityEntity::getAmapCode, MdmAmapPoiCityEntity::getAmapName}).list().stream().collect(Collectors.toMap(MdmAmapPoiCityEntity::getAmapCode, MdmAmapPoiCityEntity::getAmapName));
            return result.stream().peek(x -> {
                String amapName = (String)regionMap.get(x.getAmapCode());
                x.setAmapName(amapName);
                if (!StringUtils.isEmpty((Object)amapName)) {
                    if (amapName.endsWith("\u7701") || amapName.endsWith("\u5e02") || amapName.equals("\u53bf") || amapName.equals("\u533a")) {
                        amapName = amapName.substring(0, amapName.length() - 1);
                    }
                    x.setAmapPinyin(PinyinUtils.toPinLower((String)amapName, (String)""));
                }
            }).collect(Collectors.toList());
        }
        return result;
    }

    protected String obtainRegionLevel(String amapDistrictCode) {
        return Optional.ofNullable(((LambdaQueryChainWrapper)this.mdmAmapPoiCityService.lambdaQuery().eq(MdmAmapPoiCityEntity::getAmapCode, (Object)amapDistrictCode)).select(new SFunction[]{MdmAmapPoiCityEntity::getRegionLevel}).one()).filter(x -> !StringUtils.isEmpty((Object)x.getRegionLevel())).map(MdmAmapPoiCityEntity::getRegionLevel).orElseThrow(() -> new BusinessException("\u533a\u57df\u7f16\u7801\u4e0d\u5b58\u5728:" + amapDistrictCode));
    }

    @Override
    public List<MdmAmapDistrictRespVo> district(MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo) {
        ArrayList<MdmAmapDistrictRespVo> result = new ArrayList<MdmAmapDistrictRespVo>();
        List statisticianTypeList = mdmAmapDistrictStatisticianReqVo.getStatisticianTypeList();
        if (CollectionUtils.isEmpty((Collection)statisticianTypeList)) {
            return result;
        }
        String amapDistrictCode = mdmAmapDistrictStatisticianReqVo.getAmapDistrictCode();
        if (StringUtils.isEmpty((Object)amapDistrictCode)) {
            return result;
        }
        if (!StringUtils.isEmpty((Object)mdmAmapDistrictStatisticianReqVo.getAmapDistrictCode())) {
            String regionCode;
            MdmAmapPoiCityEntity amapPoiCityEntity = (MdmAmapPoiCityEntity)((LambdaQueryChainWrapper)this.mdmAmapPoiCityService.lambdaQuery().eq(MdmAmapPoiCityEntity::getAmapCode, (Object)mdmAmapDistrictStatisticianReqVo.getAmapDistrictCode())).select(new SFunction[]{MdmAmapPoiCityEntity::getRegionCode, MdmAmapPoiCityEntity::getAmapCode, MdmAmapPoiCityEntity::getAmapCode}).one();
            log.info("\u9ad8\u5fb7\u57ce\u5e02:{}", (Object)amapPoiCityEntity);
            if (amapPoiCityEntity != null && !StringUtils.isEmpty((Object)(regionCode = amapPoiCityEntity.getRegionCode()))) {
                Map customerTypeMap = DictUtil.dictMap((String)"customer_type");
                log.info("\u5ba2\u6237\u7c7b\u578b\u5b57\u5178:{}", (Object)customerTypeMap);
                if (customerTypeMap == null) {
                    return result;
                }
                if (statisticianTypeList.stream().noneMatch(customerTypeMap::containsKey)) {
                    return result;
                }
                Set customerTypeSet = customerTypeMap.keySet();
                mdmAmapDistrictStatisticianReqVo.setAmapDistrictCode(regionCode);
                List<String> customerCodeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().eq(MdmCustomerEntity::getDistrictCode, (Object)regionCode)).in(MdmCustomerEntity::getCustomerType, customerTypeSet)).like(!StringUtils.isEmpty((Object)mdmAmapDistrictStatisticianReqVo.getCustomerOrTerminalName()), MdmCustomerEntity::getCustomerName, (Object)mdmAmapDistrictStatisticianReqVo.getCustomerOrTerminalName())).select(new SFunction[]{MdmCustomerEntity::getCustomerCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getCustomerCode())).map(MdmCustomerEntity::getCustomerCode).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(customerCodeList)) {
                    customerCodeList.forEach(x -> {
                        MdmCustomerMsgRespVo respVo = this.mdmCustomerMsgService.query(null, (String)x);
                        if (respVo != null) {
                            List mdmCustomerDockingVos;
                            MdmAmapDistrictRespVo districtRespVo = new MdmAmapDistrictRespVo();
                            districtRespVo.setAmapCode(amapPoiCityEntity.getAmapCode());
                            districtRespVo.setAmapName(amapPoiCityEntity.getAmapName());
                            districtRespVo.setStatisticianType(respVo.getCustomerType());
                            districtRespVo.setStatisticianAddress(respVo.getRegisteredAddress());
                            districtRespVo.setStatisticianCode(respVo.getCustomerCode());
                            districtRespVo.setStatisticianName(respVo.getCustomerName());
                            districtRespVo.setLongitude(respVo.getLongitude());
                            districtRespVo.setLatitude(respVo.getLatitude());
                            List mdmCustomerContactVos = respVo.getMdmCustomerContactVos();
                            if (!CollectionUtils.isEmpty((Collection)mdmCustomerContactVos)) {
                                mdmCustomerContactVos.stream().filter(k -> YesNoEnum.yesNoEnum.ONE.getValue().equals(k.getContactMain())).findAny().ifPresent(k -> {
                                    districtRespVo.setStatisticianContactName(k.getContactName());
                                    districtRespVo.setStatisticianContactPhone(k.getContactPhone());
                                });
                            }
                            if (!CollectionUtils.isEmpty((Collection)(mdmCustomerDockingVos = respVo.getMdmCustomerDockingVos()))) {
                                String fullName = mdmCustomerDockingVos.stream().map(MdmCustomerDockingRespVo::getFullName).filter(k -> !StringUtils.isEmpty((Object)k)).collect(Collectors.joining(";"));
                                districtRespVo.setStatisticianFullName(fullName);
                            }
                            result.add(districtRespVo);
                        }
                    });
                }
            }
        }
        return result;
    }

    @Override
    public List<MdmAmapDistrictRespVo> unCooperationDistrict(MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo) {
        String amapDistrictCode = mdmAmapDistrictStatisticianReqVo.getAmapDistrictCode();
        if (StringUtils.isEmpty((Object)amapDistrictCode)) {
            return Collections.emptyList();
        }
        List statisticianTypeList = mdmAmapDistrictStatisticianReqVo.getStatisticianTypeList();
        if (CollectionUtils.isEmpty((Collection)statisticianTypeList)) {
            return Collections.emptyList();
        }
        String customerOrTerminalName = mdmAmapDistrictStatisticianReqVo.getCustomerOrTerminalName();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmAmapPoiService.lambdaQuery().eq(MdmAmapPoiEntity::getAmapDistrictCode, (Object)amapDistrictCode)).in(MdmAmapPoiEntity::getTypeCode, (Collection)statisticianTypeList)).like(!StringUtils.isEmpty((Object)customerOrTerminalName), MdmAmapPoiEntity::getPoiName, (Object)customerOrTerminalName)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        return list.stream().map(x -> {
            MdmAmapDistrictRespVo respVo = new MdmAmapDistrictRespVo();
            respVo.setAmapCode(x.getAmapDistrictCode());
            respVo.setAmapName(x.getAmapDistrictName());
            respVo.setStatisticianCode(x.getId());
            respVo.setStatisticianName(x.getPoiName());
            respVo.setStatisticianName(x.getTypeCode());
            respVo.setStatisticianName(x.getAddress());
            respVo.setStatisticianContactPhone(x.getTel());
            respVo.setStatisticianContactName(x.getPoiName());
            respVo.setStatisticianFullName(x.getPoiName());
            respVo.setLongitude(x.getLongitude());
            respVo.setLatitude(x.getLatitude());
            return respVo;
        }).collect(Collectors.toList());
    }

    @Override
    public MdmTerminalStatisticianTypeTotalVo statisticalTotal() {
        MdmTerminalStatisticianTypeTotalVo result = new MdmTerminalStatisticianTypeTotalVo();
        List<MdmTerminalStatisticianTypeVo> statisticianTypeVoList = this.statisticalType();
        List<MdmTerminalStatisticianTypeVo> unCooperationStatisticalTypeList = this.unCooperationStatisticalType();
        result.setCooperationTypeList(statisticianTypeVoList);
        result.setUnUooperationTypeList(unCooperationStatisticalTypeList);
        result.setCooperationTypeCount(Integer.valueOf(statisticianTypeVoList.stream().mapToInt(x -> Optional.ofNullable(x.getStatisticianCount()).orElse(0)).sum()));
        result.setUnCooperationTypeCount(Integer.valueOf(unCooperationStatisticalTypeList.stream().mapToInt(x -> Optional.ofNullable(x.getStatisticianCount()).orElse(0)).sum()));
        return result;
    }
}

