/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.user.mapper.MdmUserRelTerminalMapper;
import com.biz.crm.user.model.MdmUserRelTerminalEntity;
import com.biz.crm.user.service.MdmUserRelTerminalService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmUserRelTerminalServiceImpl"})
public class MdmUserRelTerminalServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmUserRelTerminalMapper, MdmUserRelTerminalEntity>
implements MdmUserRelTerminalService {
    private static final Logger log = LoggerFactory.getLogger(MdmUserRelTerminalServiceImpl.class);

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(String userName, String terminalCode) {
        if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)terminalCode)) {
            this.add(userName, Collections.singletonList(terminalCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(String userName, String terminalCode, String currentFlag) {
        if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)terminalCode)) {
            if (StringUtils.isEmpty((String)currentFlag)) {
                currentFlag = YesNoEnum.yesNoEnum.ZERO.getValue();
            } else if (!YesNoEnum.yesNoEnum.ONE.getValue().equals(currentFlag) && !YesNoEnum.yesNoEnum.ZERO.getValue().equals(currentFlag)) {
                throw new BusinessException("currentFlag\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            MdmUserRelTerminalEntity one = (MdmUserRelTerminalEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelTerminalEntity::getUserName, (Object)userName)).eq(MdmUserRelTerminalEntity::getTerminalCode, (Object)terminalCode)).one();
            if (one == null) {
                MdmUserRelTerminalEntity entity = new MdmUserRelTerminalEntity();
                entity.setUserName(userName);
                entity.setTerminalCode(terminalCode);
                entity.setCurrentFlag(currentFlag);
                this.save(entity);
            } else if (currentFlag.equals(one.getCurrentFlag())) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelTerminalEntity::getUserName, (Object)userName)).eq(MdmUserRelTerminalEntity::getTerminalCode, (Object)terminalCode)).set(MdmUserRelTerminalEntity::getCurrentFlag, (Object)currentFlag)).update();
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(String userName, List<String> terminalCodeList) {
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero(terminalCodeList)) {
            Set existCodeSet = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelTerminalEntity::getUserName, (Object)userName)).in(MdmUserRelTerminalEntity::getTerminalCode, terminalCodeList)).select(new SFunction[]{MdmUserRelTerminalEntity::getTerminalCode}).list().stream().map(MdmUserRelTerminalEntity::getTerminalCode).collect(Collectors.toSet());
            HashSet<String> terminalCodeSet = new HashSet<String>(terminalCodeList);
            ArrayList<MdmUserRelTerminalEntity> entityList = new ArrayList<MdmUserRelTerminalEntity>();
            for (String terminalCode : terminalCodeSet) {
                if (existCodeSet.contains(terminalCode)) continue;
                MdmUserRelTerminalEntity entity = new MdmUserRelTerminalEntity();
                entity.setUserName(userName);
                entity.setTerminalCode(terminalCode);
                entity.setCurrentFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
                entityList.add(entity);
            }
            if (entityList.size() > 0) {
                this.saveBatch(entityList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(List<String> userNameList, String terminalCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList) && StringUtils.isNotEmpty((String)terminalCode)) {
            Set existCodeSet = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelTerminalEntity::getTerminalCode, (Object)terminalCode)).in(MdmUserRelTerminalEntity::getUserName, userNameList)).select(new SFunction[]{MdmUserRelTerminalEntity::getUserName}).list().stream().map(MdmUserRelTerminalEntity::getUserName).collect(Collectors.toSet());
            HashSet<String> userNameSet = new HashSet<String>(userNameList);
            ArrayList<MdmUserRelTerminalEntity> entityList = new ArrayList<MdmUserRelTerminalEntity>();
            for (String userName : userNameSet) {
                if (existCodeSet.contains(userName)) continue;
                MdmUserRelTerminalEntity entity = new MdmUserRelTerminalEntity();
                entity.setUserName(userName);
                entity.setTerminalCode(terminalCode);
                entity.setCurrentFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
                entityList.add(entity);
            }
            if (entityList.size() > 0) {
                this.saveBatch(entityList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(String userName, String terminalCode) {
        if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)terminalCode)) {
            this.del(userName, Collections.singletonList(terminalCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(String userName, List<String> terminalCodeList) {
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero(terminalCodeList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelTerminalEntity::getUserName, (Object)userName)).in(MdmUserRelTerminalEntity::getTerminalCode, terminalCodeList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(List<String> userNameList, String terminalCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList) && StringUtils.isNotEmpty((String)terminalCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelTerminalEntity::getTerminalCode, (Object)terminalCode)).in(MdmUserRelTerminalEntity::getUserName, userNameList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByUserName(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            this.delByUserName(Collections.singletonList(userName));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByUserName(List<String> userNameList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmUserRelTerminalEntity::getUserName, userNameList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByTerminalCode(String terminalCode) {
        if (StringUtils.isNotEmpty((String)terminalCode)) {
            this.delByTerminalCode(Collections.singletonList(terminalCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByTerminalCode(List<String> terminalCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(terminalCodeList)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmUserRelTerminalEntity::getTerminalCode, terminalCodeList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setUniqueCurrentTerminalIfExist(String userName, String terminalCode) {
        if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)terminalCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelTerminalEntity::getUserName, (Object)userName)).set(MdmUserRelTerminalEntity::getCurrentFlag, (Object)YesNoEnum.yesNoEnum.ZERO.getValue())).update();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelTerminalEntity::getUserName, (Object)userName)).eq(MdmUserRelTerminalEntity::getTerminalCode, (Object)terminalCode)).set(MdmUserRelTerminalEntity::getCurrentFlag, (Object)YesNoEnum.yesNoEnum.ONE.getValue())).update();
        }
    }

    @Override
    public List<String> findTerminalCodeListByUserName(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelTerminalEntity::getUserName, (Object)userName)).select(new SFunction[]{MdmUserRelTerminalEntity::getTerminalCode}).list().stream().map(MdmUserRelTerminalEntity::getTerminalCode).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, List<String>> getTerminalCodeListGroupByUserNameList(List<String> userNameList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList)) {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>(16);
            List listGroup = Lists.partition(userNameList, (int)500);
            for (List group : listGroup) {
                List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmUserRelTerminalEntity::getUserName, (Collection)group)).select(new SFunction[]{MdmUserRelTerminalEntity::getUserName, MdmUserRelTerminalEntity::getTerminalCode}).list();
                if (list.size() <= 0) continue;
                map.putAll(list.stream().collect(Collectors.groupingBy(MdmUserRelTerminalEntity::getUserName, Collectors.mapping(MdmUserRelTerminalEntity::getTerminalCode, Collectors.toList()))));
            }
            return map;
        }
        return Collections.emptyMap();
    }
}

