/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.bpmrole.service.MdmBpmRoleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.constant.PositionOperationEnum;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionPositionVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionCurrentUserReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionSelectReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionSelectTransportReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgPageReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionDetailRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRedisVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionReloadRedisVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionSelectRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgPageRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.mapper.MdmPositionMapper;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.model.MdmPositionRoleEntity;
import com.biz.crm.position.model.MdmPositionUserEntity;
import com.biz.crm.position.service.MdmPositionBpmRoleService;
import com.biz.crm.position.service.MdmPositionRoleService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.position.service.MdmPositionUserService;
import com.biz.crm.positionlevel.service.MdmPositionLevelService;
import com.biz.crm.role.mode.MdmRoleEntity;
import com.biz.crm.role.service.MdmRoleService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmPositionServiceExpandImpl"})
public class MdmPositionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPositionMapper, MdmPositionEntity>
implements MdmPositionService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionServiceImpl.class);
    @Resource
    private MdmPositionMapper mdmPositionMapper;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmUserService mdmUserService;
    @Resource
    private MdmPositionLevelService mdmPositionLevelService;
    @Resource
    private MdmPositionUserService mdmPositionUserService;
    @Resource
    private MdmPositionRoleService mdmPositionRoleService;
    @Resource
    private MdmRoleService mdmRoleService;
    @Resource
    private MdmPositionBpmRoleService mdmPositionBpmRoleService;
    @Resource
    private MdmBpmRoleService mdmBpmRoleService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Resource
    private RocketMQProducer rocketMQProducer;

    @Override
    public PageResult<MdmPositionPageRespVo> findList(MdmPositionPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        reqVo.setOrgRuleCode(this.mdmOrgService.getOrgRuleCode(reqVo.getCode()));
        List<MdmPositionPageRespVo> list = this.mdmPositionMapper.findList((Page<MdmPositionPageRespVo>)page, reqVo);
        this.setRoleCodeName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmPositionRespVo detail(String id, String positionCode) {
        MdmPositionRespVo resp;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (resp = this.mdmPositionMapper.detail(id, positionCode)) != null) {
            List<MdmPositionUserOrgRespVo> positionUserOrgList = this.findPositionUserOrgList(new MdmPositionUserOrgReqVo().setPositionCode(resp.getPositionCode()));
            if (CollectionUtil.listNotEmptyNotSizeZero(positionUserOrgList)) {
                resp.setUnionName(this.generateUnionName(positionUserOrgList.get(0).getOrgName(), positionUserOrgList.get(0).getPositionName(), positionUserOrgList.get(0).getFullName()));
            }
            resp.setRoleList(this.mdmPositionRoleService.getPositionRoleList(resp.getPositionCode()));
            resp.setBpmRoleList(this.mdmPositionBpmRoleService.getPositionBpmRoleList(resp.getPositionCode()));
            return resp;
        }
        return null;
    }

    @Override
    public MdmPositionRespVo queryByPositionCode(String positionCode) {
        MdmPositionEntity one;
        if (StringUtils.isNotEmpty((String)positionCode) && (one = (MdmPositionEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)positionCode)).one()) != null) {
            return (MdmPositionRespVo)CrmBeanUtil.copy((Object)one, MdmPositionRespVo.class);
        }
        return null;
    }

    @Override
    public List<MdmPositionRespVo> queryBatchByPositionCodeList(List<String> positionCodeList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(MdmPositionEntity::getPositionCode, positionCodeList)).list()))) {
            return CrmBeanUtil.copyList((List)list, MdmPositionRespVo.class);
        }
        return Collections.emptyList();
    }

    @Override
    public List<MdmPositionRespVo> queryBatchByOrgCodeList(List<String> orgCodeList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(orgCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(MdmPositionEntity::getOrgCode, orgCodeList)).list()))) {
            return CrmBeanUtil.copyList((List)list, MdmPositionRespVo.class);
        }
        return Collections.emptyList();
    }

    @Override
    public MdmPositionDetailRespVo getPositionDetail(String id, String positionCode) {
        MdmPositionEntity one;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (one = (MdmPositionEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(!StringUtils.isEmpty((String)positionCode), MdmPositionEntity::getPositionCode, (Object)positionCode)).one()) != null) {
            String userName;
            MdmPositionDetailRespVo resp = (MdmPositionDetailRespVo)CrmBeanUtil.copy((Object)one, MdmPositionDetailRespVo.class);
            if (StringUtils.isNotEmpty((String)resp.getOrgCode())) {
                resp.setOrg(this.mdmOrgService.detail(null, resp.getOrgCode()));
            }
            if (StringUtils.isNotEmpty((String)(userName = this.mdmPositionUserService.getUserNameByPositionCode(resp.getPositionCode())))) {
                resp.setUser(this.mdmUserService.queryByUserName(userName));
            }
            resp.setRoleList(this.mdmPositionRoleService.getPositionRoleList(one.getPositionCode()));
            resp.setBpmRoleList(this.mdmPositionBpmRoleService.getPositionBpmRoleList(one.getPositionCode()));
            return resp;
        }
        return null;
    }

    @Override
    public List<MdmPositionUserOrgRespVo> detailBatch(List<String> ids, List<String> positionCodeList) {
        List positionList;
        ArrayList<MdmPositionUserOrgRespVo> list = new ArrayList<MdmPositionUserOrgRespVo>();
        if ((CollectionUtil.listNotEmptyNotSizeZero(ids) || CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) && CollectionUtil.listNotEmptyNotSizeZero((List)(positionList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CollectionUtil.listNotEmptyNotSizeZero(ids), BaseIdEntity::getId, ids)).in(CollectionUtil.listNotEmptyNotSizeZero(positionCodeList), MdmPositionEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionEntity::getPositionCode}).list()))) {
            list.addAll(this.findPositionUserOrgList(new MdmPositionUserOrgReqVo().setPositionCodeList(positionList.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.toList()))));
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String save(MdmPositionReqVo reqVo) {
        reqVo.setId(null);
        MdmPositionEntity entity = (MdmPositionEntity)CrmBeanUtil.copy((Object)reqVo, MdmPositionEntity.class);
        if (StringUtils.isEmpty((String)entity.getPositionName())) {
            Assert.hasText((String)reqVo.getPositionLevelCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801");
            entity.setPositionName(this.mdmPositionLevelService.generatePositionNameByPositionLevelCode(reqVo.getPositionLevelCode()));
        }
        if (StringUtils.isEmpty((String)entity.getPositionCode())) {
            entity.setPositionCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_POSITION_CODE.getCode()));
        } else {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode}).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)"\u804c\u4f4d\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)reqVo.getParentCode())) {
            MdmPositionEntity parent = (MdmPositionEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getParentCode())).one();
            Assert.notNull((Object)parent, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(parent.getEnableStatus()), (String)"\u4e0a\u7ea7\u804c\u4f4d\u88ab\u7981\u7528");
            levelNum = parent.getLevelNum() + 1;
        }
        entity.setRuleCode(this.generateRuleCodeByParentCode(entity.getParentCode()));
        entity.setLevelNum(Integer.valueOf(levelNum));
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save(entity);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getRoleCodeList())) {
            this.mdmPositionRoleService.addRole(reqVo.getRoleCodeList(), entity.getPositionCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getBpmRoleCodeList())) {
            this.mdmPositionBpmRoleService.addPositionBpmRole(entity.getPositionCode(), reqVo.getBpmRoleCodeList());
        }
        this.sendPositionAdd(Collections.singletonList(CrmBeanUtil.copy((Object)entity, MdmPositionRespVo.class)));
        PositionUtil.deleteAllCache();
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuObject != null) {
            this.crmLogSendUtil.sendForAdd(menuObject.toString(), entity.getId(), entity.getPositionCode(), CrmBeanUtil.copy((Object)entity, MdmPositionReqVo.class));
        }
        return entity.getPositionCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmPositionReqVo reqVo) {
        String id = reqVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getPositionName(), (String)"\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        MdmPositionEntity entity = (MdmPositionEntity)this.getById((Serializable)((Object)id));
        MdmPositionReqVo oldObject = (MdmPositionReqVo)CrmBeanUtil.copy((Object)entity, MdmPositionReqVo.class);
        Assert.notNull((Object)entity, (String)"\u804c\u4f4d\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)entity.getPositionCode().equals(reqVo.getPositionCode()), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        String entityRuleCode = entity.getRuleCode();
        String parentCode = reqVo.getParentCode();
        boolean reloadRuleCode = false;
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)parentCode)) {
            Assert.isTrue((!entity.getPositionCode().equals(parentCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u80fd\u4e3a\u5f53\u524d\u804c\u4f4d");
            if (!parentCode.equals(entity.getParentCode())) {
                reloadRuleCode = true;
                MdmPositionEntity parent = (MdmPositionEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)parentCode)).one();
                Assert.notNull((Object)parent, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u5b58\u5728");
                Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(parent.getEnableStatus()), (String)"\u4e0a\u7ea7\u804c\u4f4d\u88ab\u7981\u7528");
                String parentRuleCode = parent.getRuleCode();
                Assert.hasText((String)parentRuleCode, (String)"\u4e0a\u7ea7\u804c\u4f4druleCode\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((!parentRuleCode.startsWith(entityRuleCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u80fd\u662f\u5f53\u524d\u804c\u4f4d\u7684\u4e0b\u7ea7\u804c\u4f4d");
                levelNum = parent.getLevelNum() + 1;
            }
        } else if (!StringUtils.isEmpty((String)entity.getParentCode())) {
            reloadRuleCode = true;
            reqVo.setParentCode("");
        }
        this.mdmPositionRoleService.removePositionCode(reqVo.getPositionCode());
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getRoleCodeList())) {
            this.mdmPositionRoleService.addRole(reqVo.getRoleCodeList(), entity.getPositionCode());
        }
        this.mdmPositionBpmRoleService.removeByPosition(reqVo.getPositionCode());
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getBpmRoleCodeList())) {
            this.mdmPositionBpmRoleService.addPositionBpmRole(entity.getPositionCode(), reqVo.getBpmRoleCodeList());
        }
        if (!entity.getEnableStatus().equals(reqVo.getEnableStatus()) && CrmEnableStatusEnum.DISABLE.getCode().equals(reqVo.getEnableStatus())) {
            this.disableBatch(Collections.singletonList(entity.getId()));
        }
        MdmPositionEntity updateEntity = (MdmPositionEntity)CrmBeanUtil.copy((Object)reqVo, MdmPositionEntity.class);
        this.updateById(updateEntity);
        if (reloadRuleCode) {
            String ruleCode = this.generateRuleCodeByParentCode(reqVo.getParentCode());
            this.updateCurAndChildren(entity.getPositionCode(), ruleCode, levelNum);
        }
        PositionUtil.deleteAllCache();
        this.sendPositionUpdate(Collections.singletonList(CrmBeanUtil.copy((Object)updateEntity, MdmPositionRespVo.class)));
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuObject != null) {
            this.crmLogSendUtil.sendForUpdate(menuObject.toString(), entity.getId(), entity.getPositionCode(), (Object)oldObject, CrmBeanUtil.copy((Object)updateEntity, MdmPositionReqVo.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changePositionParent(String positionCode, String parentPositionCode) {
        MdmPositionEntity position = (MdmPositionEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)positionCode)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).one();
        Assert.notNull((Object)position, (String)("\u7f16\u7801" + positionCode + "\u4e0d\u5b58\u5728"));
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)parentPositionCode)) {
            MdmPositionEntity parent = (MdmPositionEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)parentPositionCode)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).select(new SFunction[]{BaseIdEntity::getId, CrmTreeTenEntity::getLevelNum}).one();
            Assert.notNull((Object)parent, (String)("\u7f16\u7801" + parentPositionCode + "\u65e0\u6548"));
            levelNum = parent.getLevelNum() + 1;
        }
        String ruleCode = this.generateRuleCodeByParentCode(parentPositionCode);
        position.setRuleCode(ruleCode);
        position.setLevelNum(Integer.valueOf(levelNum));
        position.setParentCode(parentPositionCode);
        this.updateById(position);
        this.updateCurAndChildren(positionCode, ruleCode, levelNum);
        this.sendPositionUpdate(Collections.singletonList(CrmBeanUtil.copy((Object)position, MdmPositionRespVo.class)));
        PositionUtil.deleteAllCache();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateByPositionCode(MdmPositionReqVo reqVo) {
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmPositionEntity entity = (MdmPositionEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).one();
        Assert.notNull((Object)entity, (String)"\u804c\u4f4d\u4e0d\u5b58\u5728");
        String entityRuleCode = entity.getRuleCode();
        String parentCode = reqVo.getParentCode();
        boolean reloadRuleCode = false;
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)parentCode)) {
            Assert.isTrue((!entity.getPositionCode().equals(parentCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u80fd\u4e3a\u5f53\u524d\u804c\u4f4d");
            if (!parentCode.equals(entity.getParentCode())) {
                reloadRuleCode = true;
                MdmPositionEntity parent = (MdmPositionEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)parentCode)).one();
                Assert.notNull((Object)parent, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u5b58\u5728");
                Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(parent.getEnableStatus()), (String)"\u4e0a\u7ea7\u804c\u4f4d\u88ab\u7981\u7528");
                String parentRuleCode = parent.getRuleCode();
                Assert.hasText((String)parentRuleCode, (String)"\u4e0a\u7ea7\u804c\u4f4druleCode\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((!parentRuleCode.startsWith(entityRuleCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u80fd\u662f\u5f53\u524d\u804c\u4f4d\u7684\u4e0b\u7ea7\u804c\u4f4d");
                levelNum = parent.getLevelNum() + 1;
            }
        } else if (!StringUtils.isEmpty((String)entity.getParentCode())) {
            reloadRuleCode = true;
            entity.setParentCode("");
        }
        entity.setOrgCode(reqVo.getOrgCode());
        entity.setParentCode(reqVo.getParentCode());
        this.updateById(entity);
        if (reloadRuleCode) {
            String ruleCode = this.generateRuleCodeByParentCode(reqVo.getParentCode());
            this.updateCurAndChildren(entity.getPositionCode(), ruleCode, levelNum);
        }
        this.sendPositionUpdate(Collections.singletonList(CrmBeanUtil.copy((Object)entity, MdmPositionRespVo.class)));
        PositionUtil.deleteAllCache();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List mdmPositionEntities = this.mdmPositionMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)mdmPositionEntities)) {
            Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
            mdmPositionEntities.forEach(o -> {
                List children = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getParentCode, (Object)o.getPositionCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode}).list();
                Assert.isTrue((boolean)CollectionUtil.listEmpty((List)children), (String)("\u804c\u4f4d[" + o.getPositionName() + "]\u5b58\u5728\u4e0b\u7ea7\uff0c\u4e0d\u80fd\u5220\u9664"));
                String userNameByPrimaryPositionCode = this.mdmPositionUserService.getUserNameByPrimaryPositionCode(o.getPositionCode());
                if (StringUtils.isNotEmpty((String)userNameByPrimaryPositionCode)) {
                    String fullNameByUserName = this.mdmUserService.getFullNameByUserName(userNameByPrimaryPositionCode);
                    throw new BusinessException("\u804c\u4f4d[" + o.getPositionName() + "]\u662f\u7528\u6237[" + fullNameByUserName + "]\u7684\u4e3b\u804c\u4f4d\uff0c\u4e0d\u80fd\u5220\u9664");
                }
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                o.setRuleCode(o.getId());
                if (menuObject != null) {
                    this.crmLogSendUtil.sendForDel(menuObject.toString(), o.getId(), o.getPositionCode(), o);
                }
            });
            List<String> positionCodeList = mdmPositionEntities.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.toList());
            this.mdmPositionUserService.removeByPositionCodes(positionCodeList);
            this.mdmPositionRoleService.removePositionCodes(positionCodeList);
            this.mdmPositionBpmRoleService.removeByPositions(positionCodeList);
            this.updateBatchById(mdmPositionEntities);
            this.sendPositionDelete(CrmBeanUtil.copyList((List)mdmPositionEntities, MdmPositionRespVo.class));
            PositionUtil.deleteAllCache();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        List mdmPositionEntities = this.mdmPositionMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)mdmPositionEntities)) {
            mdmPositionEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmPositionEntities);
        this.sendPositionUpdate(CrmBeanUtil.copyList((List)mdmPositionEntities, MdmPositionRespVo.class));
        PositionUtil.deleteAllCache();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        List mdmPositionEntities = this.mdmPositionMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)mdmPositionEntities)) {
            mdmPositionEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmPositionEntities);
        this.sendPositionUpdate(CrmBeanUtil.copyList((List)mdmPositionEntities, MdmPositionRespVo.class));
        PositionUtil.deleteAllCache();
    }

    @Override
    public List<MdmPositionRespVo> findAllParentPositionList(String id, String positionCode) {
        MdmPositionEntity position;
        ArrayList<MdmPositionRespVo> list = new ArrayList<MdmPositionRespVo>();
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (position = (MdmPositionEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)positionCode), MdmPositionEntity::getPositionCode, (Object)positionCode)).one()) != null) {
            Set ruleCodeSet = TreeRuleCodeUtil.splitParentRuleCodes((String)position.getRuleCode());
            List parentList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmTreeTenEntity::getRuleCode, (Collection)ruleCodeSet)).list();
            list.addAll(CrmBeanUtil.copyList((List)parentList, MdmPositionRespVo.class));
        }
        return list;
    }

    @Override
    public List<String> findAllParentPositionCodeList(String id, String positionCode) {
        List<MdmPositionRespVo> allParentPositionList = this.findAllParentPositionList(id, positionCode);
        if (CollectionUtils.isEmpty(allParentPositionList)) {
            return Collections.emptyList();
        }
        return allParentPositionList.stream().filter(x -> !StringUtils.isEmpty((String)x.getPositionCode())).map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
    }

    @Override
    public List<MdmPositionRespVo> findAllChildrenPositionList(String id, String positionCode) {
        MdmPositionEntity position;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (position = (MdmPositionEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)positionCode), MdmPositionEntity::getPositionCode, (Object)positionCode)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one()) != null) {
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).likeRight(CrmTreeTenEntity::getRuleCode, (Object)position.getRuleCode())).list();
            return CrmBeanUtil.copyList((List)list, MdmPositionRespVo.class);
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    @Override
    public List<String> findAllChildrenPositionCodeList(String id, String positionCode) {
        MdmPositionEntity position;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (position = (MdmPositionEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)positionCode), MdmPositionEntity::getPositionCode, (Object)positionCode)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one()) != null) {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeTenEntity::getRuleCode, (Object)position.getRuleCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode}).list();
            return list.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> findAllChildrenPositionCodeListExcludeSelf(String id, String positionCode) {
        MdmPositionEntity position;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (position = (MdmPositionEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)positionCode), MdmPositionEntity::getPositionCode, (Object)positionCode)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one()) != null) {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeTenEntity::getRuleCode, (Object)position.getRuleCode())).select(new SFunction[]{BaseIdEntity::getId, MdmPositionEntity::getPositionCode}).list();
            return list.stream().filter(x -> !(!StringUtils.isEmpty((String)id) && id.equals(x.getId()) || !StringUtils.isEmpty((String)positionCode) && positionCode.equals(x.getPositionCode()))).map(MdmPositionEntity::getPositionCode).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<MdmPositionRespVo> findAllChildrenPositionListByList(List<String> ids, List<String> positionCodeList) {
        List list;
        if ((CollectionUtil.listNotEmptyNotSizeZero(ids) || CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(CollectionUtil.listNotEmptyNotSizeZero(ids), BaseIdEntity::getId, ids)).in(CollectionUtil.listNotEmptyNotSizeZero(positionCodeList), MdmPositionEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionEntity::getPositionCode, CrmTreeTenEntity::getRuleCode}).list()))) {
            List<String> likeRightRuleCodeList = list.stream().map(item -> item.getRuleCode() + "%").collect(Collectors.toList());
            return this.mdmPositionMapper.findPositionChildrenByRuleCodeList(new MdmPositionReqVo(), likeRightRuleCodeList);
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    @Override
    public List<MdmPositionRespVo> findSingleChildrenPositionList(String id, String positionCode) {
        List children;
        MdmPositionEntity position;
        ArrayList<MdmPositionRespVo> list = new ArrayList<MdmPositionRespVo>();
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (position = (MdmPositionEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)positionCode), MdmPositionEntity::getPositionCode, (Object)positionCode)).one()) != null && CollectionUtil.listNotEmptyNotSizeZero((List)(children = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getParentCode, (Object)position.getPositionCode())).list()))) {
            list.addAll(CrmBeanUtil.copyList((List)children, MdmPositionRespVo.class));
        }
        return list;
    }

    @Override
    public List<MdmPositionSelectRespVo> findPositionSelectList(MdmPositionSelectReqVo reqVo) {
        List<String> excludeChildrenOrgCodeList;
        List<String> childrenOrgCodeList;
        MdmPositionEntity position;
        MdmPositionSelectTransportReqVo transportReqVo = new MdmPositionSelectTransportReqVo();
        HashSet<String> excludeOrgCodeList = new HashSet<String>(16);
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisOrgCode())) {
            transportReqVo.setAllUnderOrgRuleCode(this.mdmOrgService.getOrgRuleCode(reqVo.getAllUnderThisOrgCode()));
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisPositionCode()) && (position = (MdmPositionEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getAllUnderThisPositionCode())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one()) != null) {
            transportReqVo.setAllUnderPositionRuleCode(position.getRuleCode());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisPositionCodeExcludeSelf()) && (position = (MdmPositionEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getAllUnderThisPositionCodeExcludeSelf())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one()) != null) {
            transportReqVo.setAllUnderPositionRuleCodeExcludeSelf(position.getRuleCode());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getNotUnderThisPositionCode()) && (position = (MdmPositionEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getNotUnderThisPositionCode())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one()) != null) {
            transportReqVo.setNotUnderPositionRuleCode(position.getRuleCode());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllAboveThisOrgCode())) {
            List<MdmOrgRespVo> allParentOrgList = this.mdmOrgService.findAllParentOrgList(null, reqVo.getAllAboveThisOrgCode());
            if (CollectionUtil.listEmpty(allParentOrgList)) {
                return new ArrayList<MdmPositionSelectRespVo>();
            }
            transportReqVo.setOrgCodeList(allParentOrgList.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList()));
        }
        if (StringUtils.isNotEmpty((String)reqVo.getNotUnderThisOrgCodeExcludeSelf()) && CollectionUtil.listNotEmptyNotSizeZero(childrenOrgCodeList = this.mdmOrgService.findAllChildrenOrgCodeList(null, reqVo.getNotUnderThisOrgCodeExcludeSelf()))) {
            excludeOrgCodeList.addAll(childrenOrgCodeList.stream().filter(item -> !item.equals(reqVo.getNotUnderThisOrgCodeExcludeSelf())).collect(Collectors.toSet()));
        }
        if (StringUtils.isNotEmpty((String)reqVo.getExcludeChildOrgOfThisPositionCode()) && StringUtils.isNotEmpty((String)reqVo.getExcludeChildOrgOfThisPositionCode()) && CollectionUtil.listNotEmptyNotSizeZero(excludeChildrenOrgCodeList = this.mdmOrgService.findAllChildrenOrgCodeListOfPositionChildrenList(Collections.singletonList(reqVo.getExcludeChildOrgOfThisPositionCode())))) {
            excludeOrgCodeList.addAll(excludeChildrenOrgCodeList);
        }
        transportReqVo.setExcludeOrgCodeList(new ArrayList(excludeOrgCodeList));
        ArrayList<MdmPositionSelectRespVo> list = new ArrayList<MdmPositionSelectRespVo>();
        HashSet<String> codeList = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (!codeList.isEmpty()) {
            reqVo.setSelectedCodeList(new ArrayList(codeList));
        }
        if (pageSize > 0) {
            list.addAll(this.mdmPositionMapper.findPositionSelectList((Page<MdmPositionSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo, transportReqVo));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setUnionName(this.generateUnionName(item.getOrgName(), item.getPositionName(), item.getFullName())));
        }
        return list;
    }

    @Override
    public MdmPositionRespVo getUserPrimaryPosition(MdmUserReqVo reqVo) {
        List<MdmPositionRespVo> positionRelation = this.mdmPositionMapper.findPositionRelation(new MdmPositionReqVo().setUserName(reqVo.getUserName()).setUserId(reqVo.getId()));
        if (CollectionUtil.listNotEmptyNotSizeZero(positionRelation)) {
            for (MdmPositionRespVo positionItem : positionRelation) {
                if (!YesNoEnum.yesNoEnum.ONE.getValue().equals(positionItem.getPrimaryFlag())) continue;
                return positionItem;
            }
        }
        return null;
    }

    @Override
    public MdmPositionUserOrgRespVo getPrimaryPositionByUserName(String userName) {
        List<MdmPositionUserOrgRespVo> positionUserOrgList;
        String primaryPositionCodeByUserName = this.mdmPositionUserService.getPrimaryPositionCodeByUserName(userName);
        if (StringUtils.isNotEmpty((String)primaryPositionCodeByUserName) && CollectionUtil.listNotEmptyNotSizeZero(positionUserOrgList = this.findPositionUserOrgList(new MdmPositionUserOrgReqVo().setPositionCode(primaryPositionCodeByUserName)))) {
            return positionUserOrgList.get(0);
        }
        return null;
    }

    @Override
    public MdmPositionRespVo getUserCurrentPosition(MdmUserReqVo reqVo) {
        MdmUserRespVo userRespVo = this.mdmUserService.detail(null, reqVo.getUserName());
        if (userRespVo != null && UserTypeEnum.USER.getCode().equals(userRespVo.getUserType()) && CollectionUtil.listNotEmptyNotSizeZero((List)userRespVo.getPositionList())) {
            MdmPositionRespVo primaryPosition = null;
            for (MdmPositionRespVo positionItem : userRespVo.getPositionList()) {
                if (YesNoEnum.yesNoEnum.ONE.getValue().equals(positionItem.getPrimaryFlag())) {
                    primaryPosition = positionItem;
                }
                if (!YesNoEnum.yesNoEnum.ONE.getValue().equals(positionItem.getCurrentFlag())) continue;
                return positionItem;
            }
            if (primaryPosition != null) {
                this.changeUserCurrentPosition(userRespVo.getUserName(), userRespVo.getPositionCode());
                return primaryPosition;
            }
        }
        return null;
    }

    @Override
    public MdmPositionRespVo getUserCurrentPositionForLogin(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            MdmUserRespVo mdmUserRespVo = this.mdmUserService.queryByUserName(userName);
            Assert.notNull((Object)mdmUserRespVo, (String)"\u672a\u627e\u5230\u7528\u6237");
            String currentPositionCode = this.getCurrentPositionCodeByUserName(userName);
            Assert.hasText((String)currentPositionCode, (String)"\u7528\u6237\u804c\u4f4d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            MdmPositionEntity one = (MdmPositionEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)currentPositionCode)).one();
            if (one != null) {
                return (MdmPositionRespVo)CrmBeanUtil.copy((Object)one, MdmPositionRespVo.class);
            }
        }
        return null;
    }

    @Override
    public MdmPositionUserOrgRespVo getCurrentPositionByUserName(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            MdmUserRespVo mdmUserRespVo = this.mdmUserService.queryByUserName(userName);
            Assert.notNull((Object)mdmUserRespVo, (String)"\u672a\u627e\u5230\u7528\u6237");
            String currentPositionCode = this.getCurrentPositionCodeByUserName(userName);
            Assert.hasText((String)currentPositionCode, (String)"\u7528\u6237\u804c\u4f4d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return this.getPositionUserOrgByPositionCode(currentPositionCode);
        }
        return null;
    }

    @Override
    public List<MdmPositionRespVo> getUserAllPositionList(MdmUserReqVo reqVo) {
        return this.getUserAllPositionList(reqVo.getUserName());
    }

    @Override
    public List<MdmPositionRespVo> getUserAllPositionList(String userName) {
        List<MdmPositionRespVo> list = this.mdmPositionMapper.findPositionRelation(new MdmPositionReqVo().setUserName(userName));
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> {
                item.setRoleList(this.mdmPositionRoleService.getPositionRoleList(item.getPositionCode()));
                item.setOperationType(PositionOperationEnum.HISTORY.getCode());
                item.setUnionName(this.generateUnionName(item.getOrgName(), item.getPositionName(), item.getFullName()));
                item.setBpmRoleList(this.mdmPositionBpmRoleService.getPositionBpmRoleList(item.getPositionCode()));
            });
        }
        return list;
    }

    @Override
    public List<MdmPositionRespVo> getUserPositionByUserCode(String userCode) {
        MdmUserRespVo mdmUserRespVo;
        if (StringUtils.isNotEmpty((String)userCode) && (mdmUserRespVo = this.mdmUserService.queryByUserCode(userCode)) != null) {
            return this.getUserAllPositionList(mdmUserRespVo.getUserName());
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeUserPrimaryPosition(MdmPositionReqVo reqVo) {
        this.changeUserCurrentPosition(reqVo.getUserName(), reqVo.getPositionCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeUserPrimaryPosition(String userName, String positionCode) {
        Assert.hasText((String)userName, (String)"\u7f3a\u5931\u7528\u6237\u767b\u5f55\u540d");
        Assert.hasText((String)positionCode, (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        List<String> positionCodeList = this.mdmPositionUserService.getPositionCodeListByUserName(userName);
        Assert.isTrue((CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && positionCodeList.contains(positionCode) ? 1 : 0) != 0, (String)("\u7528\u6237[" + userName + "]\u672a\u5173\u8054\u804c\u4f4d[" + positionCode + "]"));
        this.mdmPositionUserService.changeUserPrimaryPosition(userName, positionCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeUserCurrentPosition(MdmPositionReqVo reqVo) {
        this.changeUserCurrentPosition(reqVo.getUserName(), reqVo.getPositionCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeUserCurrentPosition(String userName, String positionCode) {
        List<MdmPositionUserOrgRespVo> positionUserOrgList;
        Assert.hasText((String)userName, (String)"\u7f3a\u5931\u7528\u6237\u767b\u5f55\u540d");
        Assert.hasText((String)positionCode, (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        List<String> positionCodeList = this.mdmPositionUserService.getPositionCodeListByUserName(userName);
        Assert.isTrue((CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && positionCodeList.contains(positionCode) ? 1 : 0) != 0, (String)("\u7528\u6237[" + userName + "]\u672a\u5173\u8054\u804c\u4f4d[" + positionCode + "]"));
        this.mdmPositionUserService.changeUserCurrentPosition(userName, positionCode);
        UserRedis user = UserUtils.getUser();
        String token = UserUtils.getToken();
        if (user != null && user.getUsername().equals(userName) && StringUtils.isNotEmpty((String)token) && CollectionUtil.listNotEmptyNotSizeZero(positionUserOrgList = this.findPositionUserOrgList(new MdmPositionUserOrgReqVo().setPositionCode(positionCode)))) {
            MdmPositionUserOrgRespVo positionUserOrg = positionUserOrgList.get(0);
            user.setPoscode(positionUserOrg.getPositionCode());
            user.setPosname(positionUserOrg.getPositionName());
            user.setOrgcode(positionUserOrg.getOrgCode());
            user.setOrgname(positionUserOrg.getOrgName());
            UserUtils.setUser((String)token, (UserRedis)user);
        }
    }

    @Override
    public MdmPositionUserOrgRespVo getPositionUserOrgByPositionCode(String positionCode) {
        List<MdmPositionUserOrgRespVo> list;
        if (StringUtils.isNotEmpty((String)positionCode) && CollectionUtil.listNotEmptyNotSizeZero(list = this.findPositionUserOrgList(new MdmPositionUserOrgReqVo().setPositionCode(positionCode)))) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<MdmPositionUserOrgRespVo> findPositionUserOrgList(MdmPositionUserOrgReqVo reqVo) {
        List childrenPositionCodeList;
        List<MdmPositionRespVo> childrenPositionList;
        List childrenOrgCodeList;
        List<MdmOrgRespVo> childrenOrgList;
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisOrgCode())) {
            childrenOrgList = this.mdmOrgService.findAllChildrenOrgList(null, reqVo.getAllUnderThisOrgCode());
            if (CollectionUtil.listEmpty(childrenOrgList)) {
                return new ArrayList<MdmPositionUserOrgRespVo>();
            }
            childrenOrgCodeList = childrenOrgList.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getOrgCodeList())) {
                reqVo.setOrgCodeList(childrenOrgCodeList);
            } else {
                reqVo.getOrgCodeList().retainAll(childrenOrgCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisOrgCodeExcludeSelf())) {
            childrenOrgList = this.mdmOrgService.findAllChildrenOrgList(null, reqVo.getAllUnderThisOrgCodeExcludeSelf());
            if (CollectionUtil.listEmpty(childrenOrgList) || childrenOrgList.size() == 1) {
                return new ArrayList<MdmPositionUserOrgRespVo>();
            }
            childrenOrgCodeList = childrenOrgList.stream().filter(item -> !item.getOrgCode().equals(reqVo.getAllUnderThisOrgCodeExcludeSelf())).map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getOrgCodeList())) {
                reqVo.setOrgCodeList(childrenOrgCodeList);
            } else {
                reqVo.getOrgCodeList().retainAll(childrenOrgCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisPositionCode())) {
            childrenPositionList = this.findAllChildrenPositionList(null, reqVo.getAllUnderThisPositionCode());
            if (CollectionUtil.listEmpty(childrenPositionList)) {
                return new ArrayList<MdmPositionUserOrgRespVo>();
            }
            childrenPositionCodeList = childrenPositionList.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getPositionCodeList())) {
                reqVo.setPositionCodeList(childrenPositionCodeList);
            } else {
                reqVo.getPositionCodeList().retainAll(childrenPositionCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisPositionCodeExcludeSelf())) {
            childrenPositionList = this.findAllChildrenPositionList(null, reqVo.getAllUnderThisPositionCodeExcludeSelf());
            if (CollectionUtil.listEmpty(childrenPositionList) || childrenPositionList.size() == 1) {
                return new ArrayList<MdmPositionUserOrgRespVo>();
            }
            childrenPositionCodeList = childrenPositionList.stream().filter(item -> !item.getPositionCode().equals(reqVo.getAllUnderThisPositionCodeExcludeSelf())).map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getPositionCodeList())) {
                reqVo.setPositionCodeList(childrenPositionCodeList);
            } else {
                reqVo.getPositionCodeList().retainAll(childrenPositionCodeList);
            }
        }
        return this.mdmPositionMapper.findPositionUserOrgList(null, reqVo);
    }

    @Override
    public PageResult<MdmPositionUserOrgPageRespVo> findPositionUserOrgPageList(MdmPositionUserOrgPageReqVo reqVo) {
        List childrenPositionCodeList;
        List<MdmPositionRespVo> childrenPositionList;
        List childrenOrgCodeList;
        List<MdmOrgRespVo> childrenOrgList;
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisOrgCode())) {
            childrenOrgList = this.mdmOrgService.findAllChildrenOrgList(null, reqVo.getAllUnderThisOrgCode());
            if (CollectionUtil.listEmpty(childrenOrgList)) {
                return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
            }
            childrenOrgCodeList = childrenOrgList.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getOrgCodeList())) {
                reqVo.setOrgCodeList(childrenOrgCodeList);
            } else {
                reqVo.getOrgCodeList().retainAll(childrenOrgCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisOrgCodeExcludeSelf())) {
            childrenOrgList = this.mdmOrgService.findAllChildrenOrgList(null, reqVo.getAllUnderThisOrgCodeExcludeSelf());
            if (CollectionUtil.listEmpty(childrenOrgList) || childrenOrgList.size() == 1) {
                return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
            }
            childrenOrgCodeList = childrenOrgList.stream().filter(item -> !item.getOrgCode().equals(reqVo.getAllUnderThisOrgCodeExcludeSelf())).map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getOrgCodeList())) {
                reqVo.setOrgCodeList(childrenOrgCodeList);
            } else {
                reqVo.getOrgCodeList().retainAll(childrenOrgCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisPositionCode())) {
            childrenPositionList = this.findAllChildrenPositionList(null, reqVo.getAllUnderThisPositionCode());
            if (CollectionUtil.listEmpty(childrenPositionList)) {
                return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
            }
            childrenPositionCodeList = childrenPositionList.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getPositionCodeList())) {
                reqVo.setPositionCodeList(childrenPositionCodeList);
            } else {
                reqVo.getPositionCodeList().retainAll(childrenPositionCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisPositionCodeExcludeSelf())) {
            childrenPositionList = this.findAllChildrenPositionList(null, reqVo.getAllUnderThisPositionCodeExcludeSelf());
            if (CollectionUtil.listEmpty(childrenPositionList) || childrenPositionList.size() == 1) {
                return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
            }
            childrenPositionCodeList = childrenPositionList.stream().filter(item -> !item.getPositionCode().equals(reqVo.getAllUnderThisPositionCodeExcludeSelf())).map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getPositionCodeList())) {
                reqVo.setPositionCodeList(childrenPositionCodeList);
            } else {
                reqVo.getPositionCodeList().retainAll(childrenPositionCodeList);
            }
        }
        List<MdmPositionUserOrgPageRespVo> list = this.mdmPositionMapper.findPositionUserOrgPageList((Page<MdmPositionUserOrgPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdatePositionOrg(MdmPositionUserOrgReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getPositionCodeList(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        Assert.notNull((Object)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        MdmOrgRespVo org = this.mdmOrgService.detail(null, reqVo.getOrgCode());
        Assert.notNull((Object)org, (String)"\u672a\u627e\u5230\u7ec4\u7ec7");
        List positionList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(MdmPositionEntity::getPositionCode, (Collection)reqVo.getPositionCodeList())).select(new SFunction[]{MdmPositionEntity::getPositionCode, MdmPositionEntity::getPositionName, MdmPositionEntity::getOrgCode}).list();
        Assert.notEmpty((Collection)positionList, (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7f16\u7801");
        Map<String, MdmPositionEntity> positionMap = positionList.stream().collect(Collectors.toMap(MdmPositionEntity::getPositionCode, v -> v));
        reqVo.getPositionCodeList().forEach(positionCode -> {
            Assert.isTrue((boolean)positionMap.containsKey(positionCode), (String)("\u804c\u4f4d\u7f16\u7801[" + positionCode + "]\u65e0\u6548"));
            MdmPositionEntity position = (MdmPositionEntity)positionMap.get(positionCode);
            List<String> excludeOrgCodeList = this.mdmOrgService.findAllChildrenOrgCodeListOfPositionChildrenList(Collections.singletonList(positionCode));
            if (CollectionUtil.listNotEmptyNotSizeZero(excludeOrgCodeList) && excludeOrgCodeList.contains(org.getOrgCode())) {
                throw new BusinessException("\u7ec4\u7ec7[" + org.getOrgName() + "]\u662f\u804c\u4f4d[" + position.getPositionName() + "]\u7684\u4e0b\u7ea7\u804c\u4f4d\u7684\u7ec4\u7ec7\u7684\u4e0b\u7ea7\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u5f53\u524d\u804c\u4f4d\u7684\u7ec4\u7ec7");
            }
            List<String> excludeParentOrgCodeList = this.mdmOrgService.findAllParentOrgCodeListOfPositionParentList(Collections.singletonList(positionCode));
            if (CollectionUtil.listNotEmptyNotSizeZero(excludeParentOrgCodeList) && excludeParentOrgCodeList.contains(org.getOrgCode())) {
                throw new BusinessException("\u7ec4\u7ec7[" + org.getOrgName() + "]\u662f\u804c\u4f4d[" + position.getPositionName() + "]\u7684\u4e0a\u7ea7\u804c\u4f4d\u7684\u7ec4\u7ec7\u7684\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u5f53\u524d\u804c\u4f4d\u7684\u7ec4\u7ec7");
            }
        });
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionEntity::getPositionCode, (Collection)reqVo.getPositionCodeList())).set(MdmPositionEntity::getOrgCode, (Object)org.getOrgCode())).update();
        this.sendPositionUpdate(this.queryBatchByPositionCodeList(reqVo.getPositionCodeList()));
        PositionUtil.deleteAllCache();
    }

    @Override
    @Klock
    @Transactional(rollbackFor={Exception.class})
    public void resetPositionRuleCode() {
        long l = System.currentTimeMillis();
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801_" + l + "_\u5f00\u59cb-----------");
        this.mdmPositionMapper.copyIdToRuleCode();
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801_" + l + "_\u7f16\u7801\u91cd\u7f6e\u6210id\u6210\u529f-----------");
        this.mdmPositionMapper.setNullNotExistParentCode();
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801_" + l + "_\u6e05\u9664\u65e0\u6548\u4e0a\u7ea7\u7f16\u7801\u6210\u529f-----------");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.and(x -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"parent_code", (Object)"")).or()).isNull((Object)"parent_code");
        });
        wrapper.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
        List list = this.mdmPositionMapper.selectList((Wrapper)wrapper);
        ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)"")).or()).eq(MdmPositionEntity::getPositionName, (Object)"")).select(new SFunction[]{MdmPositionEntity::getPositionCode, MdmPositionEntity::getPositionName}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmPositionEntity)list.get(i)).getPositionCode(), TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), 1);
            }
        }
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801_" + l + "_\u7f16\u7801\u91cd\u65b0\u751f\u6210\u6210\u529f-----------");
        PositionUtil.deleteAllCache();
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801_" + l + "_\u7f13\u5b58\u6e05\u9664\u6210\u529f-----------");
        log.info("-----------\u91cd\u7f6e\u804c\u4f4d\u964d\u7ef4\u7f16\u7801_" + l + "_\u7ed3\u675f-----------");
    }

    @Override
    public List<MdmPositionUserOrgRespVo> findPositionListByBpmRoleStartUpByOrgCode(String orgCode, String bpmRoleCode) {
        Assert.hasText((String)orgCode, (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        Assert.hasText((String)bpmRoleCode, (String)"\u7f3a\u5931\u6d41\u7a0b\u89d2\u8272\u7f16\u7801");
        List<MdmOrgRespVo> parentOrgList = this.mdmOrgService.findAllParentOrgList(null, orgCode);
        List collectOrderByLevelNumDesc = parentOrgList.stream().sorted((x1, x2) -> new BigDecimal(x2.getLevelNum()).compareTo(new BigDecimal(x1.getLevelNum()))).collect(Collectors.toList());
        List<String> collect = collectOrderByLevelNumDesc.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
        List<MdmPositionUserOrgRespVo> list = this.mdmPositionMapper.findPositionListByBpmRole(CrmDelFlagEnum.NORMAL.getCode(), CrmEnableStatusEnum.ENABLE.getCode(), bpmRoleCode, collect);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            Map<String, List<MdmPositionUserOrgRespVo>> groupByOrgMap = list.stream().collect(Collectors.groupingBy(MdmPositionUserOrgRespVo::getOrgCode));
            for (MdmOrgRespVo parentOrg : collectOrderByLevelNumDesc) {
                if (!groupByOrgMap.containsKey(parentOrg.getOrgCode())) continue;
                return groupByOrgMap.get(parentOrg.getOrgCode());
            }
        }
        return new ArrayList<MdmPositionUserOrgRespVo>();
    }

    @Override
    public Set<String> findPositionCodeSetByOrgParentAndBpmRoleCodeList(String orgCode, List<String> bpmRoleCodeList) {
        Assert.notEmpty(bpmRoleCodeList, (String)"\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> parentOrgCodeList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)orgCode)) {
            parentOrgCodeList.addAll(OrgUtil.getParentOrgCodeListIncludeSelfEnable((String)orgCode));
            if (parentOrgCodeList.size() == 0) {
                return Collections.emptySet();
            }
        }
        return new HashSet<String>(this.mdmPositionMapper.findPositionCodeListByOrgListAndBpmRoleList(parentOrgCodeList, null, bpmRoleCodeList));
    }

    @Override
    public List<MdmDataPermissionPositionVo> findPositionAndOrgList(List<String> positionCodeList) {
        if (CollectionUtils.isEmpty(positionCodeList)) {
            return Collections.emptyList();
        }
        return this.mdmPositionMapper.findPositionAndOrgList(positionCodeList);
    }

    @Override
    public List<MdmPositionRedisVo> findRedisListByPositionCodeList(List<String> positionCodeList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(MdmPositionEntity::getPositionCode, positionCodeList)).list()))) {
            return CrmBeanUtil.copyList((List)list, MdmPositionRedisVo.class);
        }
        return Collections.emptyList();
    }

    @Override
    public List<MdmPositionParentChildrenRedisVo> findRedisPositionParentListByCodeList(List<String> positionCodeList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(MdmPositionEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionEntity::getPositionCode, CrmTreeTenEntity::getRuleCode}).list()))) {
            Set parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes(list.stream().map(CrmTreeTenEntity::getRuleCode).collect(Collectors.toList()));
            List parentList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmTreeTenEntity::getRuleCode, (Collection)parentRuleCodes)).list();
            Set collect = parentList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getParentCode())).map(MdmPositionEntity::getParentCode).collect(Collectors.toSet());
            HashMap<String, String> parentPositionCodeNameMap = new HashMap<String, String>(16);
            if (!collect.isEmpty()) {
                parentPositionCodeNameMap.putAll(((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionEntity::getPositionCode, collect)).select(new SFunction[]{MdmPositionEntity::getPositionCode, MdmPositionEntity::getPositionName}).list().stream().collect(Collectors.toMap(MdmPositionEntity::getPositionCode, MdmPositionEntity::getPositionName)));
            }
            List parentRedisVoList = parentList.stream().map(item -> {
                MdmPositionRedisVo copy = (MdmPositionRedisVo)CrmBeanUtil.copy((Object)item, MdmPositionRedisVo.class);
                if (!StringUtils.isNotEmpty((String)copy.getParentCode()) || parentPositionCodeNameMap.containsKey(copy.getParentCode())) {
                    // empty if block
                }
                return copy;
            }).collect(Collectors.toList());
            ArrayList<MdmPositionParentChildrenRedisVo> result = new ArrayList<MdmPositionParentChildrenRedisVo>();
            for (MdmPositionEntity item2 : parentList) {
                MdmPositionParentChildrenRedisVo redisVo = new MdmPositionParentChildrenRedisVo();
                redisVo.setPositionCode(item2.getPositionCode());
                redisVo.setList(parentRedisVoList.stream().filter(x -> item2.getRuleCode().startsWith(x.getRuleCode())).collect(Collectors.toList()));
                result.add(redisVo);
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public List<MdmPositionParentChildrenRedisVo> findRedisPositionChildrenListByCodeList(List<String> positionCodeList) {
        List<String> likeRightRuleCodeList;
        List<MdmPositionRespVo> childrenList;
        List positionList;
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(positionList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(MdmPositionEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionEntity::getPositionCode, CrmTreeTenEntity::getRuleCode}).list())) && CollectionUtil.listNotEmptyNotSizeZero(childrenList = this.mdmPositionMapper.findPositionChildrenByRuleCodeList(new MdmPositionReqVo(), likeRightRuleCodeList = positionList.stream().map(item -> item.getRuleCode() + "%").collect(Collectors.toList())))) {
            List redisList = CrmBeanUtil.copyList(childrenList, MdmPositionRedisVo.class);
            ArrayList<MdmPositionParentChildrenRedisVo> resultList = new ArrayList<MdmPositionParentChildrenRedisVo>();
            for (MdmPositionEntity item2 : positionList) {
                MdmPositionParentChildrenRedisVo redisVo = new MdmPositionParentChildrenRedisVo();
                redisVo.setPositionCode(item2.getPositionCode());
                redisVo.setList(redisList.stream().filter(x -> x.getRuleCode().startsWith(item2.getRuleCode())).collect(Collectors.toList()));
                resultList.add(redisVo);
            }
            return resultList;
        }
        return Collections.emptyList();
    }

    @Override
    public List<MdmPositionReloadRedisVo> findRedisReloadList() {
        List all = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)all)) {
            Map<String, String> positionCodeNameMap = all.stream().collect(Collectors.toMap(MdmPositionEntity::getPositionCode, MdmPositionEntity::getPositionName));
            List redisList = all.stream().map(item -> {
                MdmPositionRedisVo copy = (MdmPositionRedisVo)CrmBeanUtil.copy((Object)item, MdmPositionRedisVo.class);
                if (StringUtils.isNotEmpty((String)copy.getParentCode())) {
                    // empty if block
                }
                return copy;
            }).collect(Collectors.toList());
            return redisList.stream().map(item -> {
                MdmPositionReloadRedisVo redisVo = new MdmPositionReloadRedisVo();
                redisVo.setPositionCode(item.getPositionCode());
                redisVo.setSelf(item);
                redisVo.setParentList(redisList.stream().filter(x -> item.getRuleCode().startsWith(x.getRuleCode())).collect(Collectors.toList()));
                redisVo.setChildrenList(redisList.stream().filter(x -> x.getRuleCode().startsWith(item.getRuleCode())).collect(Collectors.toList()));
                return redisVo;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public PageResult<MdmPositionPageRespVo> positionAndUserPage(MdmPositionCurrentUserReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        if (user == null) {
            return PageResult.empty();
        }
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        if (UserTypeEnum.CUSTOMER.getCode().equals(user.getUsertype()) || UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(user.getUsertype())) {
            reqVo.setUnderCustomerUserName(user.getUsername());
        }
        List<MdmPositionPageRespVo> mdmPositionPageRespVos = this.mdmPositionMapper.positionAndUserPage((Page<MdmPositionPageRespVo>)page, reqVo);
        return PageResult.builder().data(mdmPositionPageRespVos).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmPositionPageRespVo> findPositionAndUserByType(MdmPositionCurrentUserReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        if (user == null) {
            return PageResult.empty();
        }
        String usertype = user.getUsertype();
        if (UserTypeEnum.USER.getCode().equals(usertype)) {
            return this.positionAndUserPage(reqVo);
        }
        if (UserTypeEnum.CUSTOMER.getCode().equals(usertype) || UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(usertype)) {
            Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
            List<MdmPositionPageRespVo> mdmPositionPageRespVos = this.mdmUserService.findCustomerEmployeePage(reqVo);
            if (!CollectionUtils.isEmpty(mdmPositionPageRespVos)) {
                for (MdmPositionPageRespVo mdmPositionPageRespVo : mdmPositionPageRespVos) {
                    mdmPositionPageRespVo.setPositionCode(mdmPositionPageRespVo.getUserName());
                    mdmPositionPageRespVo.setPositionName(mdmPositionPageRespVo.getFullName());
                }
            }
            return PageResult.builder().data(mdmPositionPageRespVos).count(Long.valueOf(page.getTotal())).build();
        }
        return PageResult.empty();
    }

    protected String generateUnionName(String orgName, String positionName, String fullName) {
        return (orgName == null ? "" : orgName) + "/" + (positionName == null ? "" : positionName) + "/" + (fullName == null ? "" : fullName);
    }

    protected String generateRuleCodeByParentCode(String parentCode) {
        MdmPositionEntity parent;
        String ruleCode = "";
        boolean top = true;
        String prefix = "";
        if (StringUtils.isNotEmpty((String)parentCode) && (parent = (MdmPositionEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)parentCode)).one()) != null) {
            top = false;
            prefix = parent.getRuleCode();
        }
        List list = null;
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
        if (top) {
            wrapper.and(x -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"parent_code", (Object)"")).or()).isNull((Object)"parent_code");
            });
        } else {
            wrapper.eq((Object)"parent_code", (Object)parentCode);
        }
        list = this.mdmPositionMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)list)) {
            ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode((Integer)1);
        } else {
            LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
            for (MdmPositionEntity item : list) {
                if (!StringUtils.isNotEmpty((String)item.getRuleCode())) continue;
                try {
                    Integer integer = TreeRuleCodeUtil.getCurLevelCodeValue((String)item.getRuleCode());
                    set.add(integer);
                }
                catch (BusinessException e) {
                    throw new BusinessException("\u804c\u4f4d" + e.getMsg());
                }
            }
            int maxRuleCodeValueInLevel = TreeRuleCodeUtil.getMaxRuleCodeValueInLevel();
            for (int i = 1; i <= maxRuleCodeValueInLevel; ++i) {
                if (i == maxRuleCodeValueInLevel) {
                    throw new BusinessException("\u964d\u7ef4\u7f16\u7801\u8d8a\u754c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
                }
                if (set.contains(i)) continue;
                ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode((Integer)i);
                break;
            }
        }
        return ruleCode;
    }

    protected void updateCurAndChildren(String positionCode, String curCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionEntity::getPositionCode, (Object)positionCode)).set(CrmTreeTenEntity::getRuleCode, (Object)curCode)).set(CrmTreeTenEntity::getLevelNum, (Object)levelNum)).update();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getParentCode, (Object)positionCode)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmPositionEntity)list.get(i)).getPositionCode(), curCode + TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), levelNum + 1);
            }
        }
    }

    protected String getCurrentPositionCodeByUserName(String userName) {
        List list;
        String thisPositionCode = "";
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.mdmPositionUserService.lambdaQuery().eq(MdmPositionUserEntity::getUserName, (Object)userName)).list()))) {
            List primaryCodeList;
            boolean resetCurrent = true;
            Set positionCodeList = list.stream().map(MdmPositionUserEntity::getPositionCode).collect(Collectors.toSet());
            Map<String, MdmPositionEntity> positionCodeMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(MdmPositionEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionEntity::getPositionCode, CrmBaseEntity::getEnableStatus}).list().stream().collect(Collectors.toMap(MdmPositionEntity::getPositionCode, v -> v));
            List currentPositionCodeList = list.stream().filter(item -> YesNoEnum.yesNoEnum.ONE.getValue().equals(item.getCurrentFlag())).map(MdmPositionUserEntity::getPositionCode).collect(Collectors.toList());
            if (StringUtils.isEmpty((String)thisPositionCode) && currentPositionCodeList.size() == 1 && positionCodeMap.containsKey(currentPositionCodeList.get(0)) && CrmEnableStatusEnum.ENABLE.getCode().equals(positionCodeMap.get(currentPositionCodeList.get(0)).getEnableStatus())) {
                thisPositionCode = (String)currentPositionCodeList.get(0);
                resetCurrent = false;
            }
            if (StringUtils.isEmpty((String)thisPositionCode) && currentPositionCodeList.size() > 0) {
                for (String positionCode : currentPositionCodeList) {
                    if (!positionCodeMap.containsKey(positionCode) || !CrmEnableStatusEnum.ENABLE.getCode().equals(positionCodeMap.get(positionCode).getEnableStatus())) continue;
                    thisPositionCode = positionCode;
                    break;
                }
            }
            if (StringUtils.isEmpty((String)thisPositionCode) && (primaryCodeList = list.stream().filter(item -> YesNoEnum.yesNoEnum.ONE.getValue().equals(item.getPrimaryFlag())).map(MdmPositionUserEntity::getPositionCode).collect(Collectors.toList())).size() > 1 && positionCodeMap.containsKey(primaryCodeList.get(0)) && CrmEnableStatusEnum.ENABLE.getCode().equals(positionCodeMap.get(primaryCodeList.get(0)).getEnableStatus())) {
                thisPositionCode = (String)primaryCodeList.get(0);
            }
            if (StringUtils.isEmpty((String)thisPositionCode)) {
                for (String positionCode : positionCodeList) {
                    if (!positionCodeMap.containsKey(positionCode) || !CrmEnableStatusEnum.ENABLE.getCode().equals(positionCodeMap.get(positionCode).getEnableStatus())) continue;
                    thisPositionCode = positionCode;
                    break;
                }
            }
            if (StringUtils.isEmpty((String)thisPositionCode)) {
                throw new BusinessException("\u7528\u6237[" + userName + "]\u6ca1\u6709\u542f\u7528\u7684\u804c\u4f4d");
            }
            if (resetCurrent) {
                this.mdmPositionUserService.changeUserCurrentPosition(userName, thisPositionCode);
            }
        }
        return thisPositionCode;
    }

    protected void setRoleCodeName(List<MdmPositionPageRespVo> allList) {
        if (CollectionUtil.listEmpty(allList)) {
            return;
        }
        List partition = Lists.partition(allList, (int)500);
        for (List list : partition) {
            List positionRoleEntityList = ((LambdaQueryChainWrapper)this.mdmPositionRoleService.lambdaQuery().in(MdmPositionRoleEntity::getPositionCode, (Collection)list.stream().map(MdmPositionPageRespVo::getPositionCode).collect(Collectors.toList()))).list();
            if (!CollectionUtil.listNotEmptyNotSizeZero((List)positionRoleEntityList)) continue;
            Map<String, String> roleCodeNameMap = ((LambdaQueryChainWrapper)this.mdmRoleService.lambdaQuery().in(MdmRoleEntity::getRoleCode, (Collection)positionRoleEntityList.stream().map(MdmPositionRoleEntity::getRoleCode).distinct().collect(Collectors.toList()))).select(new SFunction[]{MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName}).list().stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName));
            Map<String, List<MdmPositionRoleEntity>> positionRoleListMap = positionRoleEntityList.stream().collect(Collectors.groupingBy(MdmPositionRoleEntity::getPositionCode));
            list.forEach(item -> {
                List relationList;
                if (positionRoleListMap.containsKey(item.getPositionCode()) && CollectionUtil.listNotEmptyNotSizeZero((List)(relationList = (List)positionRoleListMap.get(item.getPositionCode())))) {
                    ArrayList<String> codeList = new ArrayList<String>();
                    ArrayList nameList = new ArrayList();
                    for (MdmPositionRoleEntity relation : relationList) {
                        if (!roleCodeNameMap.containsKey(relation.getRoleCode())) continue;
                        codeList.add(relation.getRoleCode());
                        nameList.add(roleCodeNameMap.get(relation.getRoleCode()));
                    }
                    item.setRoleCode(String.join((CharSequence)",", codeList));
                    item.setRoleName(String.join((CharSequence)",", nameList));
                }
            });
        }
    }

    protected void sendPositionAdd(List<MdmPositionRespVo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        log.info("\u804c\u4f4d\u65b0\u589e\u53d1\u9001MQ\u6d88\u606f\uff1a{}", list);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag("POSITION_ADD_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(list));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        log.info("\u804c\u4f4d\u65b0\u589e\u53d1\u9001MQ\u6d88\u606f\u6210\u529f\uff1a{}", list);
    }

    protected void sendPositionUpdate(List<MdmPositionRespVo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        log.info("\u804c\u4f4d\u7f16\u8f91\u53d1\u9001MQ\u6d88\u606f\uff1a{}", list);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag("POSITION_UPDATE_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(list));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        log.info("\u804c\u4f4d\u7f16\u8f91\u53d1\u9001MQ\u6d88\u606f\u6210\u529f\uff1a{}", list);
    }

    protected void sendPositionDelete(List<MdmPositionRespVo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        log.info("\u804c\u4f4d\u5220\u9664\u53d1\u9001MQ\u6d88\u606f\uff1a{}", list);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag("POSITION_DELETE_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(list));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        log.info("\u804c\u4f4d\u5220\u9664\u53d1\u9001MQ\u6d88\u606f\u6210\u529f\uff1a{}", list);
    }
}

