/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customermaterial.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.cusorg.entity.MdmCusOrgEntity;
import com.biz.crm.cusorg.mapper.MdmCusOrgMapper;
import com.biz.crm.customermaterial.mapper.MdmCustomerMaterialMapper;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.mdm.MdmCusMaterialException;
import com.biz.crm.material.mapper.MdmMaterialMapper;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.nebular.mdm.customermaterial.req.MdmCustomerMaterialReqVo;
import com.biz.crm.nebular.mdm.customermaterial.resp.MdmCustomerMaterialRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MdmCustomerMaterialServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerMaterialServiceHelper.class);
    @Resource
    private MdmCustomerMaterialMapper customerMaterialMapper;
    @Resource
    private MdmCusOrgMapper cusOrgMapper;
    @Resource
    private MdmMaterialMapper materialMapper;

    public Map<String, Map<String, String>> getProductDict() {
        ArrayList dictCodes = Lists.newArrayList();
        dictCodes.add("enable_status");
        Map map = DictUtil.getDictValueMapsByCodes((List)dictCodes);
        return map;
    }

    public void convertListDate(List<MdmCustomerMaterialRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, Map<String, String>> map = this.getProductDict();
            list.forEach(o -> {
                if (Objects.nonNull(o.getEnableStatus())) {
                    o.setEnableStatusName((String)((Map)Optional.ofNullable(map.get("enable_status")).orElse(Maps.newHashMap())).get(o.getEnableStatus()));
                }
            });
        }
    }

    public void saveCheck(MdmCustomerMaterialReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getCustomerOrgCode(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getBarCode(), (String)"\u6761\u5f62\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List cusOrgEntities = this.cusOrgMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(MdmCusOrgEntity::getCustomerOrgCode, (Object)reqVo.getCustomerOrgCode()));
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)cusOrgEntities), (String)"\u60a8\u9009\u62e9\u7684\u5ba2\u6237\u7ec4\u7ec7\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9");
        AssertUtils.isTrue((cusOrgEntities.size() == 1 ? 1 : 0) != 0, (String)"\u60a8\u9009\u62e9\u7684\u5ba2\u6237\u7ec4\u7ec7\u6570\u636e\u7f16\u7801\u4e0d\u552f\u4e00,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)CrmEnableStatusEnum.ENABLE.getCode(), (CharSequence)((MdmCusOrgEntity)cusOrgEntities.get(0)).getEnableStatus()), (String)"\u60a8\u9009\u62e9\u7684\u5ba2\u6237\u7ec4\u7ec7\u6570\u636e\u5df2\u88ab\u7981\u7528");
        List mdmMaterialEntities = this.materialMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(MdmMaterialEntity::getMaterialCode, (Object)reqVo.getMaterialCode()));
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)mdmMaterialEntities), (String)"\u60a8\u9009\u62e9\u7684\u7269\u6599\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u9009\u62e9");
        AssertUtils.isTrue((mdmMaterialEntities.size() == 1 ? 1 : 0) != 0, (String)"\u60a8\u9009\u62e9\u7684\u7269\u6599\u6570\u636e\u7f16\u7801\u4e0d\u552f\u4e00,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
        AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)CrmEnableStatusEnum.ENABLE.getCode(), (CharSequence)((MdmMaterialEntity)mdmMaterialEntities.get(0)).getEnableStatus()), (String)"\u60a8\u9009\u62e9\u7684\u7269\u6599\u6570\u636e\u5df2\u88ab\u7981\u7528");
        this.checkDataExist(reqVo);
    }

    public void checkDataExist(MdmCustomerMaterialReqVo reqVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"customer_org_code", (Object)reqVo.getCustomerOrgCode())).eq((Object)"material_code", (Object)reqVo.getMaterialCode());
        List list = this.customerMaterialMapper.selectList((Wrapper)wrapper).stream().filter(x -> StringUtils.isEmpty((CharSequence)reqVo.getId()) || !reqVo.getId().equals(x.getId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BusinessException((CrmExceptionType)MdmCusMaterialException.DATA_DUPLICATE);
        }
    }
}

