/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerRelCustomerUserReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerUserRelRolePageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerUserRelRoleReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerUserRelTerminalPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerUserRelTerminalReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserChangeCurrentCustomerReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserForceChangePasswordReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserSelectReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmCustomerUserControlRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmCustomerUserPageRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmCustomerUserRelRolePageRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmCustomerUserRelTerminalPageRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserSelectRespVo;
import com.biz.crm.user.service.MdmCustomerUserService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmCustomerUserController"})
@CrmGlobalLog
@Api(tags={"MDM-\u7528\u6237\u7ba1\u7406\uff08\u5ba2\u6237\u7528\u6237\uff09"})
public class MdmCustomerUserController {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerUserController.class);
    @Autowired
    private MdmCustomerUserService mdmCustomerUserService;
    @Autowired
    private MdmUserService mdmUserService;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    @CrmDictMethod
    public Result<PageResult<MdmCustomerUserPageRespVo>> pageList(@RequestBody MdmCustomerUserPageReqVo reqVo) {
        PageResult<MdmCustomerUserPageRespVo> result = this.mdmCustomerUserService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8be6\u60c5\uff08\u5ba2\u6237\u7528\u6237\uff09", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="userName", value="\u7528\u6237\u767b\u5f55\u540d", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    @CrmDictMethod
    public Result<MdmUserRespVo> detail(@RequestParam(value="id", required=false) String id, @RequestParam(value="userName", required=false) String userName) {
        return Result.ok((Object)this.mdmCustomerUserService.query(id, userName));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmUserEditReqVo reqVo) {
        this.mdmCustomerUserService.save(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody MdmUserEditReqVo reqVo) {
        this.mdmCustomerUserService.update(reqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        this.mdmCustomerUserService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        this.mdmUserService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        this.mdmUserService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7528\u6237\u89e3\u9501", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/unlock"})
    public Result unlock(@RequestBody List<String> ids) {
        this.mdmUserService.unlock(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u89e3\u7ed1\u7528\u6237\u5168\u90e8\u5173\u8054\u5fae\u4fe1", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u7528\u6237id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/unbindWeChat"})
    public Result unbindWeChat(@RequestBody List<String> ids) {
        this.mdmUserService.unbindWeChat(ids);
        return Result.ok((String)"\u89e3\u7ed1\u6210\u529f");
    }

    @ApiOperation(value="\u5f3a\u5236\u6279\u91cf\u4fee\u6539\u5bc6\u7801", httpMethod="POST")
    @PostMapping(value={"/forceChangePassword"})
    public Result forceChangePassword(@RequestBody MdmUserForceChangePasswordReqVo reqVo) {
        this.mdmUserService.forceChangePassword(reqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u5ba2\u6237\u7528\u6237\u65b0\u589e\u7f16\u8f91\u9875\u9762\u63a7\u5236\u53d8\u91cf")
    @GetMapping(value={"/getCustomerUserControl"})
    public Result<MdmCustomerUserControlRespVo> getCustomerUserControl() {
        MdmCustomerUserControlRespVo respVo = new MdmCustomerUserControlRespVo();
        respVo.setUserCanRelationManyCustomer(ParamUtil.getParameterValue((String)"user_can_relation_many_customer"));
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u6839\u636euserName\u83b7\u53d6\u5ba2\u6237\u7528\u6237\u5173\u8054\u7684\u5168\u90e8\u5ba2\u6237", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userName", value="\u7528\u6237\u767b\u5f55\u540d", dataType="String", paramType="query")})
    @GetMapping(value={"/getUserAllCustomerList"})
    @CrmDictMethod
    public Result<List<MdmCustomerMsgRespVo>> getUserAllCustomerList(@RequestParam(value="userName") String userName) {
        return Result.ok(this.mdmCustomerMsgService.getCustomerListByUserName(userName));
    }

    @ApiOperation(value="\u5207\u6362\u5ba2\u6237\u7528\u6237\u5f53\u524d\u5ba2\u6237")
    @PostMapping(value={"/changeUserCurrentCustomer"})
    public Result changeUserCurrentCustomer(@RequestBody MdmUserChangeCurrentCustomerReqVo reqVo) {
        this.mdmCustomerUserService.changeUserCurrentCustomer(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5ba2\u6237\u7528\u6237\u5206\u9875\u5f39\u6846\u9009\u62e9\u5217\u8868")
    @PostMapping(value={"/findCustomerUserSelectPageList"})
    @CrmDictMethod
    public Result<PageResult<MdmUserSelectRespVo>> findCustomerUserSelectPageList(@RequestBody MdmUserSelectReqVo reqVo) {
        return Result.ok(this.mdmCustomerUserService.findCustomerUserSelectPageList(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u7ecf\u9500\u5546\u5173\u8054\u7684\u5ba2\u6237\u7528\u6237\u5217\u8868")
    @PostMapping(value={"/findCustomerRelCustomerUserList"})
    @CrmDictMethod
    public Result<List<MdmUserRespVo>> findCustomerRelCustomerUserList(@RequestBody MdmCustomerRelCustomerUserReqVo reqVo) {
        return Result.ok(this.mdmCustomerUserService.findCustomerRelCustomerUserList(reqVo));
    }

    @ApiOperation(value="\u5ba2\u6237\u7528\u6237\u4e0b\u62c9\u6846")
    @PostMapping(value={"/findCustomerUserSelectList"})
    public Result<List<MdmUserSelectRespVo>> findCustomerUserSelectList(@RequestBody MdmUserSelectReqVo reqVo) {
        return Result.ok(this.mdmCustomerUserService.findCustomerUserSelectList(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u672a\u5173\u8054\u4efb\u4f55\u89d2\u8272\u7684\u5ba2\u6237\u7528\u6237")
    @PostMapping(value={"/findCustomerUserNotRelAnyRole"})
    @CrmDictMethod
    public Result<PageResult<MdmCustomerUserRelRolePageRespVo>> findCustomerUserNotRelAnyRole(@RequestBody MdmCustomerUserRelRolePageReqVo reqVo) {
        return Result.ok(this.mdmCustomerUserService.findCustomerUserNotRelAnyRole(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u672a\u5173\u8054\u5f53\u524d\u89d2\u8272\u7684\u5ba2\u6237\u7528\u6237", notes="\u89d2\u8272\u7f16\u7801\u5fc5\u4f20")
    @PostMapping(value={"/findCustomerUserNotRelCurRole"})
    @CrmDictMethod
    public Result<PageResult<MdmCustomerUserRelRolePageRespVo>> findCustomerUserNotRelCurRole(@RequestBody MdmCustomerUserRelRolePageReqVo reqVo) {
        return Result.ok(this.mdmCustomerUserService.findCustomerUserNotRelCurRole(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u5df2\u5173\u8054\u5f53\u524d\u89d2\u8272\u7684\u5ba2\u6237\u7528\u6237", notes="\u89d2\u8272\u7f16\u7801\u5fc5\u4f20")
    @PostMapping(value={"/findCustomerUserHasRelCurRole"})
    @CrmDictMethod
    public Result<PageResult<MdmCustomerUserRelRolePageRespVo>> findCustomerUserHasRelCurRole(@RequestBody MdmCustomerUserRelRolePageReqVo reqVo) {
        return Result.ok(this.mdmCustomerUserService.findCustomerUserHasRelCurRole(reqVo));
    }

    @ApiOperation(value="\u6dfb\u52a0\u5ba2\u6237\u7528\u6237\u4e0e\u89d2\u8272\u5173\u8054")
    @PostMapping(value={"/bindUserRelRole"})
    public Result bindUserRelRole(@RequestBody MdmCustomerUserRelRoleReqVo reqVo) {
        this.mdmCustomerUserService.bindUserRelRole(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66ff\u6362\u5ba2\u6237\u7528\u6237\u5173\u8054\u7684\u89d2\u8272")
    @PostMapping(value={"/replaceUserRelRole"})
    public Result replaceUserRelRole(@RequestBody MdmCustomerUserRelRoleReqVo reqVo) {
        this.mdmCustomerUserService.replaceUserRelRole(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u89e3\u9664\u5ba2\u6237\u7528\u6237\u4e0e\u89d2\u8272\u5173\u8054", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u5173\u8054\u5173\u7cfbid\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/unbindUserRelRole"})
    public Result unbindUserRelRole(@RequestBody List<String> ids) {
        this.mdmCustomerUserService.unbindUserRelRole(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u672a\u5173\u8054\u4efb\u4f55\u5ba2\u6237\u7528\u6237\u7684\u7ec8\u7aef")
    @PostMapping(value={"/findTerminalNotRelAnyCustomerUser"})
    @CrmDictMethod
    public Result<PageResult<MdmCustomerUserRelTerminalPageRespVo>> findTerminalNotRelAnyCustomerUser(@RequestBody MdmCustomerUserRelTerminalPageReqVo reqVo) {
        return Result.ok(this.mdmCustomerUserService.findTerminalNotRelAnyCustomerUser(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u672a\u5173\u8054\u5f53\u524d\u5ba2\u6237\u7528\u6237\u7684\u7ec8\u7aef", notes="\u5ba2\u6237\u7528\u6237\u8d26\u53f7\u5fc5\u586b")
    @PostMapping(value={"/findTerminalNotRelCurCustomerUser"})
    @CrmDictMethod
    public Result<PageResult<MdmCustomerUserRelTerminalPageRespVo>> findTerminalNotRelCurCustomerUser(@RequestBody MdmCustomerUserRelTerminalPageReqVo reqVo) {
        return Result.ok(this.mdmCustomerUserService.findTerminalNotRelCurCustomerUser(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u5df2\u5173\u8054\u5f53\u524d\u5ba2\u6237\u7528\u6237\u7684\u7ec8\u7aef", notes="\u5ba2\u6237\u7528\u6237\u8d26\u53f7\u5fc5\u586b")
    @PostMapping(value={"/findTerminalHasRelCurCustomerUser"})
    @CrmDictMethod
    public Result<PageResult<MdmCustomerUserRelTerminalPageRespVo>> findTerminalHasRelCurCustomerUser(@RequestBody MdmCustomerUserRelTerminalPageReqVo reqVo) {
        return Result.ok(this.mdmCustomerUserService.findTerminalHasRelCurCustomerUser(reqVo));
    }

    @ApiOperation(value="\u6dfb\u52a0\u5ba2\u6237\u7528\u6237\u4e0e\u7ec8\u7aef\u7684\u5173\u8054")
    @PostMapping(value={"/bindCustomerUserRelTerminal"})
    public Result bindCustomerUserRelTerminal(@RequestBody MdmCustomerUserRelTerminalReqVo reqVo) {
        this.mdmCustomerUserService.bindCustomerUserRelTerminal(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66ff\u6362\u7ec8\u7aef\u5173\u8054\u7684\u5ba2\u6237\u7528\u6237")
    @PostMapping(value={"/replaceCustomerUserRelTerminal"})
    public Result replaceCustomerUserRelTerminal(@RequestBody MdmCustomerUserRelTerminalReqVo reqVo) {
        this.mdmCustomerUserService.replaceCustomerUserRelTerminal(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u89e3\u9664\u5ba2\u6237\u7528\u6237\u4e0e\u7ec8\u7aef\u5173\u8054")
    @PostMapping(value={"/unbindCustomerUserRelTerminal"})
    public Result unbindCustomerUserRelTerminal(@RequestBody MdmCustomerUserRelTerminalReqVo reqVo) {
        this.mdmCustomerUserService.unbindCustomerUserRelTerminal(reqVo);
        return Result.ok();
    }
}

