/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.poi.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.gaode.vo.AmapPoiPhotoVo;
import com.biz.crm.gaode.vo.AmapPoiQueryReqVo;
import com.biz.crm.gaode.vo.AmapPoiResultVo;
import com.biz.crm.gaode.vo.AmapPoiVo;
import com.biz.crm.nebular.mdm.constant.RegionLevelEnum;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.poi.mapper.MdmAmapPoiElasticsearchRepository;
import com.biz.crm.poi.model.MdmAmapPoiCityEntity;
import com.biz.crm.poi.model.MdmAmapPoiEntity;
import com.biz.crm.poi.model.MdmAmapPoiPhotoEntity;
import com.biz.crm.poi.model.MdmAmapPoiProcessEntity;
import com.biz.crm.poi.service.MdmAmapPoiAsyncService;
import com.biz.crm.poi.service.MdmAmapPoiCityService;
import com.biz.crm.poi.service.MdmAmapPoiPhotoService;
import com.biz.crm.poi.service.MdmAmapPoiProcessService;
import com.biz.crm.poi.service.MdmAmapPoiService;
import com.biz.crm.poi.service.MdmAmapPoiTypeService;
import com.biz.crm.sfa.map.GaoDeFeign;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"MdmAmapPoiAsyncServiceExpandImpl"})
public class MdmAmapPoiAsyncServiceImpl
implements MdmAmapPoiAsyncService {
    private static final Logger log = LoggerFactory.getLogger(MdmAmapPoiAsyncServiceImpl.class);
    @Resource
    private MdmAmapPoiService mdmAmapPoiService;
    @Resource
    private MdmAmapPoiPhotoService mdmAmapPoiPhotoService;
    @Resource
    private MdmAmapPoiProcessService mdmAmapPoiProcessService;
    @Resource
    private MdmAmapPoiCityService mdmAmapPoiCityService;
    @Resource
    private MdmAmapPoiTypeService mdmAmapPoiTypeService;
    @Resource
    private GaoDeFeign gaoDeFeign;
    @Resource
    private ElasticsearchTemplate elasticsearchTemplate;
    @Resource
    private MdmAmapPoiElasticsearchRepository elasticsearchRepository;
    private static Boolean createIndex = false;

    @Override
    @Async
    public void queryAndUpdateAsync(String token, UserRedis user) {
        List<String> cityList;
        if (StringUtils.isNotEmpty((String)token)) {
            ConcurrentHashMap<String, String> map = ThreadLocalUtil.get();
            if (map == null) {
                map = new ConcurrentHashMap<String, String>(16);
            }
            map.put("loginUserToken", token);
            ThreadLocalUtil.stObj(map);
        }
        if (user != null) {
            ThreadLocalUtil.setUser((UserRedis)user);
        }
        if (CollectionUtil.listEmpty(cityList = this.mdmAmapPoiCityService.getCityList())) {
            log.info("\u9ad8\u5fb7\u5730\u56fePOI=====>>\u6ca1\u6709\u8981\u6293\u53d6\u7684\u57ce\u5e02\u6570\u636e");
            return;
        }
        List<String> typeList = this.mdmAmapPoiTypeService.getTypeList();
        if (CollectionUtil.listEmpty(typeList)) {
            log.info("\u9ad8\u5fb7\u5730\u56fePOI=====>>\u6ca1\u6709\u8981\u6293\u53d6\u7684POI\u5206\u7c7b\u6570\u636e");
            return;
        }
        Set<String> processSet = this.mdmAmapPoiProcessService.getProcessList();
        HashMap<String, MdmAmapPoiCityEntity> cityEntityMap = new HashMap<String, MdmAmapPoiCityEntity>(16);
        int totalSize = cityList.size() * typeList.size();
        int i = 0;
        for (String cityCode : cityList) {
            for (String typeCode : typeList) {
                ++i;
                boolean flag = this.queryAmapPoiAndSave(processSet, cityEntityMap, cityCode, typeCode, "");
                if (flag) {
                    return;
                }
                if (i < totalSize) continue;
                this.mdmAmapPoiProcessService.deleteAllProcess();
            }
        }
    }

    protected boolean queryAmapPoiAndSave(Set<String> set, Map<String, MdmAmapPoiCityEntity> cityEntityMap, String cityCode, String typeCode, String keyword) {
        String key = cityCode + "_" + typeCode + "_" + keyword;
        if (set.contains(key)) {
            return false;
        }
        try {
            log.info("\u9ad8\u5fb7\u5730\u56fePOI=====>>\u6293\u53d6\u6570\u636e\uff1acityCode\uff1a{}\uff0ctypeCode\uff1a{}\uff0ckeyword\uff1a{}", new Object[]{cityCode, typeCode, keyword});
            int page = 1;
            int offset = 25;
            boolean endBreak = true;
            do {
                endBreak = true;
                AmapPoiQueryReqVo reqVo = new AmapPoiQueryReqVo();
                reqVo.setCitylimit(Boolean.valueOf(true));
                reqVo.setCity(cityCode);
                reqVo.setTypes(typeCode);
                reqVo.setKeywords(keyword);
                reqVo.setPage(String.valueOf(page));
                reqVo.setOffset(String.valueOf(offset));
                Result result = this.gaoDeFeign.queryKeywords(reqVo);
                if (!result.isSuccess()) continue;
                AmapPoiResultVo poiResultVo = (AmapPoiResultVo)result.getResult();
                if ("1".equals(poiResultVo.getStatus())) {
                    List updateBatch;
                    List<MdmAmapPoiEntity> collect;
                    List pois = poiResultVo.getPois();
                    if (!CollectionUtil.listNotEmptyNotSizeZero((List)pois)) continue;
                    log.info("\u9ad8\u5fb7\u5730\u56fePOI=====>>\u5f53\u524d\u6761\u4ef6\u5171\u6709\u6570\u636e\uff1a{} \u6761\uff0c\u5171 {} \u9875\uff0c\u5f53\u524d\u9875\u7801\uff1a{}\uff0c\u672c\u9875\uff1a{} \u6761", new Object[]{poiResultVo.getCount(), Integer.valueOf(poiResultVo.getCount()) / offset, page, pois.size()});
                    if ((page - 1) * offset + pois.size() < Integer.valueOf(poiResultVo.getCount())) {
                        endBreak = false;
                        ++page;
                    }
                    Set existAmapId = ((LambdaQueryChainWrapper)this.mdmAmapPoiService.lambdaQuery().in(MdmAmapPoiEntity::getAmapId, (Collection)pois.stream().map(AmapPoiVo::getId).collect(Collectors.toList()))).select(new SFunction[]{MdmAmapPoiEntity::getAmapId}).list().stream().map(MdmAmapPoiEntity::getAmapId).collect(Collectors.toSet());
                    Set amapCodeSet = pois.stream().filter(x -> StringUtils.isNotEmpty((String)x.getAdcode()) && !cityEntityMap.containsKey(x.getAdcode())).map(AmapPoiVo::getAdcode).collect(Collectors.toSet());
                    if (!amapCodeSet.isEmpty()) {
                        cityEntityMap.putAll(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmAmapPoiCityService.lambdaQuery().eq(MdmAmapPoiCityEntity::getRegionLevel, (Object)RegionLevelEnum.COUNTY.getCode())).in(MdmAmapPoiCityEntity::getAmapCode, amapCodeSet)).list().stream().collect(Collectors.toMap(MdmAmapPoiCityEntity::getAmapCode, v -> v)));
                    }
                    if (!CollectionUtil.listNotEmptyNotSizeZero(collect = pois.stream().map(x -> {
                        MdmAmapPoiEntity copy = (MdmAmapPoiEntity)CrmBeanUtil.copy((Object)x, MdmAmapPoiEntity.class);
                        copy.setId(x.getId());
                        copy.setAmapId(x.getId());
                        copy.setParentAmapId(x.getParent());
                        copy.setPoiName(x.getName());
                        copy.setTypeName(x.getType());
                        copy.setTypeCode(x.getTypecode());
                        copy.setBizType(x.getBiz_type());
                        copy.setAddress(x.getAddress());
                        if (StringUtils.isNotEmpty((String)x.getLocation())) {
                            copy.setLongitude(x.getLocation().substring(0, x.getLocation().indexOf(",")));
                            copy.setLatitude(x.getLocation().substring(x.getLocation().indexOf(",") + 1));
                            copy.setLocation(copy.getLatitude() + "," + copy.getLongitude());
                        }
                        copy.setDistance(x.getDistance());
                        copy.setTel(x.getTel());
                        copy.setPostCode(x.getPostcode());
                        copy.setWebsite(x.getWebsite());
                        copy.setEmail(x.getEmail());
                        copy.setAmapProvinceCode(x.getPcode());
                        copy.setAmapProvinceName(x.getPname());
                        if (StringUtils.isNotEmpty((String)x.getAdcode()) && cityEntityMap.containsKey(x.getAdcode())) {
                            MdmAmapPoiCityEntity cityEntity = (MdmAmapPoiCityEntity)cityEntityMap.get(x.getAdcode());
                            copy.setAmapCityCode(cityEntity.getParentCode());
                            copy.setRegionCode(cityEntity.getRegionCode());
                        }
                        copy.setAmapCityName(x.getCityname());
                        copy.setAmapDistrictCode(x.getAdcode());
                        copy.setAmapDistrictName(x.getAdname());
                        if (StringUtils.isNotEmpty((String)x.getEntr_location())) {
                            copy.setEntrLongitude(x.getEntr_location().substring(0, x.getEntr_location().indexOf(",")));
                            copy.setEntrLatitude(x.getEntr_location().substring(x.getEntr_location().indexOf(",") + 1));
                            copy.setEntrLocation(copy.getEntrLatitude() + "," + copy.getEntrLongitude());
                        }
                        copy.setNaviPoiid(x.getNavi_poiid());
                        copy.setGridCode(x.getGridcode());
                        copy.setAlias(x.getAlias());
                        copy.setBusinessArea(x.getBusiness_area());
                        copy.setTag(x.getTag());
                        if (CollectionUtil.listNotEmptyNotSizeZero((List)x.getPhotos())) {
                            copy.setPoiPhoto(((AmapPoiPhotoVo)x.getPhotos().get(0)).getUrl());
                        }
                        return copy;
                    }).collect(Collectors.toList()))) continue;
                    List saveBatch = collect.stream().filter(x -> !existAmapId.contains(x.getAmapId())).collect(Collectors.toList());
                    if (CollectionUtil.listNotEmptyNotSizeZero(saveBatch)) {
                        this.mdmAmapPoiService.saveBatch(saveBatch);
                    }
                    if (CollectionUtil.listNotEmptyNotSizeZero(updateBatch = collect.stream().filter(x -> existAmapId.contains(x.getAmapId())).collect(Collectors.toList()))) {
                        this.mdmAmapPoiService.updateBatchById(updateBatch);
                    }
                    this.saveToElasticsearch(collect);
                    ((LambdaUpdateChainWrapper)this.mdmAmapPoiPhotoService.lambdaUpdate().in(MdmAmapPoiPhotoEntity::getAmapId, (Collection)collect.stream().map(MdmAmapPoiEntity::getAmapId).collect(Collectors.toSet()))).remove();
                    List<MdmAmapPoiPhotoEntity> photos = pois.stream().flatMap(x -> x.getPhotos().stream().map(y -> {
                        MdmAmapPoiPhotoEntity photo = new MdmAmapPoiPhotoEntity();
                        photo.setAmapId(x.getId());
                        photo.setTitile(y.getTitile());
                        photo.setUrl(y.getUrl());
                        return photo;
                    })).collect(Collectors.toList());
                    if (CollectionUtil.listNotEmptyNotSizeZero(photos)) {
                        this.mdmAmapPoiPhotoService.saveBatch(photos);
                    }
                    this.saveToOtherPlace(collect, photos);
                    continue;
                }
                log.info("\u9ad8\u5fb7\u5730\u56fePOI=====>>\u6293\u53d6\u6570\u636e\u5931\u8d25\uff1a\u9519\u8bef\u7f16\u7801\uff1a{}", (Object)poiResultVo.getInfo());
                if ("DAILY_QUERY_OVER_LIMIT".equals(poiResultVo.getInfo())) {
                    log.info("\u9ad8\u5fb7\u5730\u56fePOI=====>>\u8bbf\u95ee\u5df2\u8d85\u51fa\u65e5\u8bbf\u95ee\u91cf");
                    return true;
                }
                if ("USER_DAILY_QUERY_OVER_LIMIT".equals(poiResultVo.getInfo())) {
                    log.info("\u9ad8\u5fb7\u5730\u56fePOI=====>>\u8d26\u53f7\u7ef4\u5ea6\u65e5\u8c03\u7528\u91cf\u8d85\u51fa\u9650\u5236");
                    return true;
                }
                if ("INVALID_REQUEST".equals(poiResultVo.getInfo())) {
                    log.info("\u9ad8\u5fb7\u5730\u56fePOI=====>>\u8d26\u53f7\u5904\u4e8e\u88ab\u5c01\u7981\u72b6\u6001");
                    return true;
                }
                if (!"ACCESS_TOO_FREQUENT".equals(poiResultVo.getInfo())) continue;
                log.info("\u9ad8\u5fb7\u5730\u56fePOI=====>>\u5355\u4f4d\u65f6\u95f4\u5185\u8bbf\u95ee\u8fc7\u4e8e\u9891\u7e41");
                Thread.sleep(15000L);
            } while (!endBreak);
            MdmAmapPoiProcessEntity entity = new MdmAmapPoiProcessEntity();
            entity.setCityCode(cityCode);
            entity.setPoiType(typeCode);
            entity.setPoiKeyword(keyword);
            this.mdmAmapPoiProcessService.save(entity);
            set.add(key);
        }
        catch (Exception e) {
            log.error("\u9ad8\u5fb7\u5730\u56fePOI=====>>\u6293\u53d6\u6570\u636e\u5f02\u5e38\uff1acityCode\uff1a{}\uff0ctypeCode\uff1a{}\uff0ckeyword\uff1a{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{cityCode, typeCode, keyword, e});
            e.printStackTrace();
        }
        return false;
    }

    protected void saveToElasticsearch(List<MdmAmapPoiEntity> list) {
        if (!createIndex.booleanValue()) {
            if (!this.elasticsearchTemplate.indexExists("mdm_amap_poi_index")) {
                this.elasticsearchTemplate.createIndex(MdmAmapPoiEntity.class);
            }
            createIndex = true;
        }
        this.elasticsearchRepository.saveAll(list);
    }

    protected void saveToOtherPlace(List<MdmAmapPoiEntity> list, List<MdmAmapPoiPhotoEntity> photos) {
    }

    protected List<String> getKeywordList() {
        return DictUtil.list((String)"mdm_amap_poi_keyword").stream().map(DictDataVo::getDictValue).distinct().collect(Collectors.toList());
    }
}

