/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.approval.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.approval.mapper.MdmApprovalConfigMapper;
import com.biz.crm.approval.model.MdmApprovalConfigEntity;
import com.biz.crm.approval.service.MdmApprovalConfigConditionService;
import com.biz.crm.approval.service.MdmApprovalConfigService;
import com.biz.crm.approval.service.MdmApprovalConfigSubmitterService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.MdmApprovalConfig;
import com.biz.crm.nebular.mdm.approval.req.MdmApprovalConfigConditionReqVo;
import com.biz.crm.nebular.mdm.approval.req.MdmApprovalConfigReqVo;
import com.biz.crm.nebular.mdm.approval.req.MdmApprovalConfigSubmitterReqVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigConditionRedisVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigConditionRespVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigRedisVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigRespVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigSubmitterRedisVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigSubmitterRespVo;
import com.biz.crm.util.ApprovalConfigUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmApprovalConfigServiceExpandImpl"})
public class MdmApprovalConfigServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmApprovalConfigMapper, MdmApprovalConfigEntity>
implements MdmApprovalConfigService {
    private static final Logger log = LoggerFactory.getLogger(MdmApprovalConfigServiceImpl.class);
    @Resource
    private MdmApprovalConfigMapper mdmApprovalConfigMapper;
    @Resource
    private MdmApprovalConfigConditionService mdmApprovalConfigConditionService;
    @Resource
    private MdmApprovalConfigSubmitterService mdmApprovalConfigSubmitterService;

    @Override
    public PageResult<MdmApprovalConfigRespVo> findApprovalConfigPageList(MdmApprovalConfigReqVo mdmApprovalConfigReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmApprovalConfigReqVo.getPageNum(), (Integer)mdmApprovalConfigReqVo.getPageSize());
        List<MdmApprovalConfigRespVo> list = this.mdmApprovalConfigMapper.findApprovalConfigPageList((Page<MdmApprovalConfigRespVo>)page, mdmApprovalConfigReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmApprovalConfigRespVo> findApprovalConfigList(MdmApprovalConfigReqVo reqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getMenuCode()), MdmApprovalConfigEntity::getMenuCode, (Object)reqVo.getMenuCode())).eq(StringUtils.isNotEmpty((String)reqVo.getBusinessCode()), MdmApprovalConfigEntity::getBusinessCode, (Object)reqVo.getBusinessCode())).eq(StringUtils.isNotEmpty((String)reqVo.getControlFlag()), MdmApprovalConfigEntity::getControlFlag, (Object)reqVo.getControlFlag())).eq(StringUtils.isNotEmpty((String)reqVo.getApprovalType()), MdmApprovalConfigEntity::getApprovalType, (Object)reqVo.getApprovalType())).eq(StringUtils.isNotEmpty((String)reqVo.getControlScope()), MdmApprovalConfigEntity::getControlScope, (Object)reqVo.getControlScope())).eq(StringUtils.isNotEmpty((String)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus())).like(StringUtils.isNotEmpty((String)reqVo.getBusinessName()), MdmApprovalConfigEntity::getBusinessName, (Object)reqVo.getBusinessName())).orderByDesc(CrmBaseEntity::getCreateDate)).orderByDesc(CrmBaseEntity::getCreateDateSecond)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return CrmBeanUtil.copyList((List)list, MdmApprovalConfigRespVo.class);
        }
        return Collections.emptyList();
    }

    @Override
    public MdmApprovalConfigRespVo queryById(String id) {
        Assert.hasText((String)id, (String)"\u7f3a\u5931id");
        MdmApprovalConfigEntity entity = (MdmApprovalConfigEntity)this.getById((Serializable)((Object)id));
        if (entity != null) {
            MdmApprovalConfigRespVo respVo = (MdmApprovalConfigRespVo)CrmBeanUtil.copy((Object)entity, MdmApprovalConfigRespVo.class);
            respVo.setConditionList(this.mdmApprovalConfigConditionService.findConditionList(respVo.getBusinessCode()));
            respVo.setSubmitterList(this.mdmApprovalConfigSubmitterService.findSubmitterList(respVo.getBusinessCode()));
            return respVo;
        }
        return null;
    }

    @Override
    public MdmApprovalConfigRedisVo queryForRedis(String businessCode) {
        Assert.hasText((String)businessCode, (String)"\u7f3a\u5931\u4e1a\u52a1\u7f16\u7801");
        MdmApprovalConfigEntity entity = (MdmApprovalConfigEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmApprovalConfigEntity::getBusinessCode, (Object)businessCode)).one();
        if (entity != null) {
            List<MdmApprovalConfigSubmitterRespVo> submitterList;
            MdmApprovalConfigRedisVo redisVo = (MdmApprovalConfigRedisVo)CrmBeanUtil.copy((Object)entity, MdmApprovalConfigRedisVo.class);
            List<MdmApprovalConfigConditionRespVo> conditionList = this.mdmApprovalConfigConditionService.findConditionList(businessCode);
            if (CollectionUtil.listNotEmptyNotSizeZero(conditionList)) {
                redisVo.setConditionList(CrmBeanUtil.copyList(conditionList, MdmApprovalConfigConditionRedisVo.class));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(submitterList = this.mdmApprovalConfigSubmitterService.findSubmitterList(businessCode))) {
                redisVo.setSubmitterList(CrmBeanUtil.copyList(submitterList, MdmApprovalConfigSubmitterRedisVo.class));
            }
            return redisVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmApprovalConfigReqVo reqVo) {
        reqVo.setId(null);
        this.verify(reqVo);
        MdmApprovalConfigEntity entity = (MdmApprovalConfigEntity)CrmBeanUtil.copy((Object)reqVo, MdmApprovalConfigEntity.class);
        this.save(entity);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getConditionList())) {
            this.mdmApprovalConfigConditionService.saveConditionList(reqVo.getBusinessCode(), reqVo.getConditionList());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSubmitterList())) {
            this.mdmApprovalConfigSubmitterService.saveSubmitterList(reqVo.getBusinessCode(), reqVo.getSubmitterList());
        }
        ApprovalConfigUtil.deleteCache((String)entity.getBusinessCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmApprovalConfigReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u7f3a\u5931id");
        this.verify(reqVo);
        MdmApprovalConfigEntity entity = (MdmApprovalConfigEntity)this.getById((Serializable)((Object)reqVo.getId()));
        this.mdmApprovalConfigConditionService.deleteConditionList(entity.getBusinessCode());
        this.mdmApprovalConfigSubmitterService.deleteSubmitterList(entity.getBusinessCode());
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)entity);
        this.updateById(entity);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getConditionList())) {
            this.mdmApprovalConfigConditionService.saveConditionList(reqVo.getBusinessCode(), reqVo.getConditionList());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSubmitterList())) {
            this.mdmApprovalConfigSubmitterService.saveSubmitterList(reqVo.getBusinessCode(), reqVo.getSubmitterList());
        }
        ApprovalConfigUtil.deleteCache((String)entity.getBusinessCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notNull(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            list.forEach(item -> {
                this.mdmApprovalConfigConditionService.deleteConditionList(item.getBusinessCode());
                this.mdmApprovalConfigSubmitterService.deleteSubmitterList(item.getBusinessCode());
            });
            this.removeByIds(list.stream().map(BaseIdEntity::getId).collect(Collectors.toList()));
            ApprovalConfigUtil.deleteCache(list.stream().map(MdmApprovalConfigEntity::getBusinessCode).collect(Collectors.toList()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void open(List<String> ids) {
        Assert.notNull(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        List<MdmApprovalConfigEntity> list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list().stream().filter(x -> !YesNoEnum.yesNoEnum.ONE.getValue().equals(x.getControlFlag())).collect(Collectors.toList());
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setControlFlag(YesNoEnum.yesNoEnum.ONE.getValue()));
            this.updateBatchById(list);
            ApprovalConfigUtil.deleteCache(list.stream().map(MdmApprovalConfigEntity::getBusinessCode).collect(Collectors.toList()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void close(List<String> ids) {
        Assert.notNull(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        List<MdmApprovalConfigEntity> list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list().stream().filter(x -> !YesNoEnum.yesNoEnum.ZERO.getValue().equals(x.getControlFlag())).collect(Collectors.toList());
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setControlFlag(YesNoEnum.yesNoEnum.ZERO.getValue()));
            this.updateBatchById(list);
            ApprovalConfigUtil.deleteCache(list.stream().map(MdmApprovalConfigEntity::getBusinessCode).collect(Collectors.toList()));
        }
    }

    private void verify(MdmApprovalConfigReqVo reqVo) {
        Assert.hasText((String)reqVo.getBusinessCode(), (String)"\u7f3a\u5931\u4e1a\u52a1\u7f16\u7801");
        Assert.hasText((String)reqVo.getBusinessName(), (String)"\u7f3a\u5931\u4e1a\u52a1\u540d\u79f0");
        Assert.hasText((String)reqVo.getControlFlag(), (String)"\u7f3a\u5931\u5f00\u542f\u72b6\u6001");
        Assert.isTrue((YesNoEnum.yesNoEnum.ONE.getValue().equals(reqVo.getControlFlag()) || YesNoEnum.yesNoEnum.ZERO.getValue().equals(reqVo.getControlFlag()) ? 1 : 0) != 0, (String)"\u5f00\u542f\u72b6\u6001\u9519\u8bef");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmApprovalConfigEntity::getBusinessCode, (Object)reqVo.getBusinessCode())).select(new SFunction[]{BaseIdEntity::getId}).list().stream().filter(x -> StringUtils.isEmpty((String)reqVo.getId()) || !reqVo.getId().equals(x.getId())).collect(Collectors.toList());
        Assert.isTrue((boolean)CollectionUtil.listEmpty(list), (String)"\u4e1a\u52a1\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            Assert.hasText((String)reqVo.getApprovalType(), (String)"\u7f3a\u5931\u5ba1\u6279\u7c7b\u578b");
            Assert.hasText((String)reqVo.getControlScope(), (String)"\u7f3a\u5931\u63a7\u5236\u8303\u56f4");
            if (MdmApprovalConfig.ControlScope.PART_IN_CONDITION.getValue().equals(reqVo.getControlScope()) || MdmApprovalConfig.ControlScope.PART_OUT_CONDITION.getValue().equals(reqVo.getControlScope())) {
                Assert.hasText((String)reqVo.getGroupCheckWay(), (String)"\u6761\u4ef6\u7ec4\u5224\u65ad\u903b\u8f91");
                if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getConditionList())) {
                    for (MdmApprovalConfigConditionReqVo condition : reqVo.getConditionList()) {
                        Assert.hasText((String)condition.getFieldCode(), (String)"\u7f3a\u5931\u5b57\u6bb5\u7f16\u7801");
                        Assert.hasText((String)condition.getFieldName(), (String)"\u7f3a\u5931\u5b57\u6bb5\u540d\u79f0");
                        Assert.hasText((String)condition.getFieldType(), (String)"\u7f3a\u5931\u5b57\u6bb5\u7c7b\u578b");
                        Assert.hasText((String)condition.getFieldKeywords(), (String)"\u7f3a\u5931\u5b57\u6bb5\u503c");
                        Assert.hasText((String)condition.getCompareType(), (String)"\u7f3a\u5931\u6bd4\u8f83\u7c7b\u578b");
                        Assert.hasText((String)condition.getControlFlag(), (String)"\u7f3a\u5931\u5f00\u542f\u72b6\u6001");
                        Assert.isTrue((YesNoEnum.yesNoEnum.ONE.getValue().equals(condition.getControlFlag()) || YesNoEnum.yesNoEnum.ZERO.getValue().equals(condition.getControlFlag()) ? 1 : 0) != 0, (String)"\u5f00\u542f\u72b6\u6001\u9519\u8bef");
                        if (!MdmApprovalConfig.FieldType.DICTIONARY.getValue().equals(condition.getFieldType())) continue;
                        Assert.hasText((String)condition.getFieldDataSource(), (String)"\u7f3a\u5931\u6570\u636e\u5b57\u5178");
                        Map dictMap = DictUtil.dictMap((String)condition.getFieldDataSource());
                        for (String keyword : condition.getFieldKeywords().split(",")) {
                            Assert.isTrue((boolean)dictMap.containsKey(keyword), (String)("\u6570\u636e\u5b57\u5178\u3010" + condition.getFieldDataSource() + "\u3011\u4e2d\u4e0d\u5b58\u5728\u503c\u3010" + keyword + "\u3011"));
                        }
                    }
                }
                if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSubmitterList())) {
                    for (MdmApprovalConfigSubmitterReqVo submitter : reqVo.getSubmitterList()) {
                        Assert.hasText((String)submitter.getSubmitterType(), (String)"\u7f3a\u5931\u63d0\u4ea4\u4eba\u5339\u914d\u5bf9\u8c61");
                        Assert.hasText((String)submitter.getControlFlag(), (String)"\u7f3a\u5931\u5f00\u542f\u72b6\u6001");
                        Assert.hasText((String)submitter.getFieldKeywords(), (String)"\u7f3a\u5931\u5b57\u6bb5\u503c");
                        Assert.hasText((String)submitter.getCompareType(), (String)"\u7f3a\u5931\u6bd4\u8f83\u7c7b\u578b");
                        Assert.isTrue((YesNoEnum.yesNoEnum.ONE.getValue().equals(submitter.getControlFlag()) || YesNoEnum.yesNoEnum.ZERO.getValue().equals(submitter.getControlFlag()) ? 1 : 0) != 0, (String)"\u5f00\u542f\u72b6\u6001\u9519\u8bef");
                    }
                }
            }
        }
    }
}

