/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.MdmCodeEnum;
import com.biz.crm.eunm.mdm.MdmNoticeStatusEnum;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeCommentReqVo;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeFileReqVo;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeMiniReqVo;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReadReqVo;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReceivingReqVo;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeFileRespVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeReadRespVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeRespVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.notice.mapper.MdmNoticeCommentLikesMapper;
import com.biz.crm.notice.mapper.MdmNoticeCommentMapper;
import com.biz.crm.notice.mapper.MdmNoticeFileMapper;
import com.biz.crm.notice.mapper.MdmNoticeMapper;
import com.biz.crm.notice.mapper.MdmNoticeReadMapper;
import com.biz.crm.notice.mapper.MdmNoticeReceivingMapper;
import com.biz.crm.notice.model.MdmNoticeEntity;
import com.biz.crm.notice.model.MdmNoticeFileEntity;
import com.biz.crm.notice.model.MdmNoticeReceivingEntity;
import com.biz.crm.notice.service.IMdmNoticeCommentService;
import com.biz.crm.notice.service.IMdmNoticeFileService;
import com.biz.crm.notice.service.IMdmNoticeReadService;
import com.biz.crm.notice.service.IMdmNoticeReceivingService;
import com.biz.crm.notice.service.IMdmNoticeService;
import com.biz.crm.position.service.MdmPositionRoleService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmNoticeServiceExpandImpl"})
@Transactional(rollbackFor={Exception.class})
public class MdmNoticeServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmNoticeMapper, MdmNoticeEntity>
implements IMdmNoticeService {
    private static final Logger log = LoggerFactory.getLogger(MdmNoticeServiceImpl.class);
    @Resource
    private MdmNoticeMapper mdmNoticeMapper;
    @Resource
    private MdmNoticeFileMapper noticeFileMapper;
    @Resource
    private MdmNoticeReceivingMapper noticeReceivingMapper;
    @Resource
    private MdmNoticeCommentMapper noticeCommentMapper;
    @Resource
    private MdmNoticeCommentLikesMapper noticeCommentLikesMapper;
    @Resource
    private MdmNoticeReadMapper mdmNoticeReadMapper;
    @Autowired
    private IMdmNoticeFileService iMdmNoticeFileService;
    @Autowired
    private IMdmNoticeReceivingService iMdmNoticeReceivingService;
    @Autowired
    private IMdmNoticeReadService iMdmNoticeReadService;
    @Autowired
    private MdmPositionRoleService mdmPositionRoleService;
    @Autowired
    private IMdmNoticeCommentService iMdmNoticeCommentService;
    @Resource
    private MdmOrgFeign mdmOrgFeign;

    @Override
    public PageResult<MdmNoticeRespVo> findList(MdmNoticeReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmNoticeRespVo> list = this.mdmNoticeMapper.findList((Page<MdmNoticeRespVo>)page, reqVo);
        this.setNoticeStatus(list);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List noticeCodes = list.stream().map(MdmNoticeRespVo::getNoticeCode).collect(Collectors.toList());
            MdmNoticeReadReqVo readReqVo = new MdmNoticeReadReqVo();
            readReqVo.setNoticeCodes(noticeCodes);
            readReqVo.setPageSize(Integer.valueOf(-1));
            List readRespVoList = this.iMdmNoticeReadService.findList(readReqVo).getData();
            Map<String, List<MdmNoticeReadRespVo>> readRespMap = readRespVoList.stream().collect(Collectors.groupingBy(MdmNoticeReadRespVo::getNoticeCode));
            for (MdmNoticeRespVo noticeVo : list) {
                noticeVo.setNoticeOrg(noticeVo.getCreateOrgName());
                noticeVo.setNoticeDate(noticeVo.getCreateDate());
                noticeVo.setEnableStatusName(CrmEnableStatusEnum.getDesc((String)noticeVo.getEnableStatus()));
                List<MdmNoticeReadRespVo> noticeReadRespVos = readRespMap.get(noticeVo.getNoticeCode());
                if (noticeReadRespVos != null && noticeReadRespVos.size() > 0) {
                    noticeVo.setVisitNum(Integer.valueOf(noticeReadRespVos.size()));
                    Set readusers = noticeReadRespVos.stream().map(MdmNoticeReadRespVo::getUserName).collect(Collectors.toSet());
                    noticeVo.setReadUserNum(Integer.valueOf(readusers.size()));
                    continue;
                }
                noticeVo.setVisitNum(Integer.valueOf(0));
                noticeVo.setReadUserNum(Integer.valueOf(0));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    public void setNoticeStatus(List<MdmNoticeRespVo> list) {
        for (MdmNoticeRespVo noticeRespVo : list) {
            noticeRespVo.setNoticeReleaseStatusName(YesNoEnum.yesNoEnum.getEnum((String)noticeRespVo.getNoticeReleaseStatus()).getDes());
            noticeRespVo.setNoticeTopStateName((String)MdmNoticeStatusEnum.NoticeTopStatus.GETMAP.get(noticeRespVo.getNoticeTopState()));
            noticeRespVo.setCommentStateName((String)MdmNoticeStatusEnum.NoticeCommentStatus.GETMAP.get(noticeRespVo.getCommentState()));
        }
    }

    @Override
    public PageResult<MdmNoticeRespVo> homePageList(MdmNoticeReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        final String orgCode = UserUtils.getUser().getOrgcode();
        if (StringUtils.isEmpty((String)orgCode)) {
            return PageResult.builder().data(null).count(Long.valueOf(page.getTotal())).build();
        }
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo(){
            {
                this.setOrgCode(orgCode);
            }
        };
        Result result = this.mdmOrgFeign.findAllChildrenOrgList(mdmOrgReqVo);
        List<Object> orgCodeList = null;
        if (result != null && result.isSuccess()) {
            if (CollectionUtil.listNotEmptyNotSizeZero((List)((List)result.getResult()))) {
                orgCodeList = ((List)result.getResult()).stream().map(MdmOrgRespVo::getOrgCode).distinct().collect(Collectors.toList());
                reqVo.setOrgCodeList((List)orgCodeList);
            } else {
                orgCodeList = Lists.newArrayList((Object[])new String[]{orgCode});
                reqVo.setOrgCodeList((List)orgCodeList);
            }
        }
        UserRedis user = UserUtils.getUser();
        String positionCode = user.getPoscode();
        ArrayList<String> positionCodeList = new ArrayList<String>();
        positionCodeList.add(positionCode);
        List<String> roleList = this.mdmPositionRoleService.findRoleCodeByPosition(positionCodeList);
        if (CollectionUtils.isNotEmpty(roleList)) {
            List collect = ((Stream)reqVo.getOrgCodeList().stream().sequential()).collect(Collectors.toCollection(() -> roleList));
            reqVo.setOrgCodeList(collect);
        }
        List<MdmNoticeRespVo> list = this.mdmNoticeMapper.findList((Page<MdmNoticeRespVo>)page, reqVo);
        this.setNoticeStatus(list);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List noticeCodes = list.stream().map(MdmNoticeRespVo::getNoticeCode).collect(Collectors.toList());
            MdmNoticeReadReqVo readReqVo = new MdmNoticeReadReqVo();
            readReqVo.setNoticeCodes(noticeCodes);
            readReqVo.setPageSize(Integer.valueOf(-1));
            List readRespVoList = this.iMdmNoticeReadService.findList(readReqVo).getData();
            Map<String, List<MdmNoticeReadRespVo>> readRespMap = readRespVoList.stream().collect(Collectors.groupingBy(MdmNoticeReadRespVo::getNoticeCode));
            for (MdmNoticeRespVo noticeVo : list) {
                noticeVo.setNoticeOrg(noticeVo.getCreateOrgName());
                noticeVo.setNoticeDate(noticeVo.getCreateDate());
                noticeVo.setEnableStatusName(CrmEnableStatusEnum.getDesc((String)noticeVo.getEnableStatus()));
                List<MdmNoticeReadRespVo> noticeReadRespVos = readRespMap.get(noticeVo.getNoticeCode());
                if (noticeReadRespVos != null && noticeReadRespVos.size() > 0) {
                    noticeVo.setVisitNum(Integer.valueOf(noticeReadRespVos.size()));
                    Set readusers = noticeReadRespVos.stream().map(MdmNoticeReadRespVo::getUserName).collect(Collectors.toSet());
                    noticeVo.setReadUserNum(Integer.valueOf(readusers.size()));
                    continue;
                }
                noticeVo.setVisitNum(Integer.valueOf(0));
                noticeVo.setReadUserNum(Integer.valueOf(0));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmNoticeRespVo> findListByMiniPrg(MdmNoticeMiniReqVo reqVo) {
        Long total;
        List miniPrgList;
        block9: {
            UserRedis user = UserUtils.getUser();
            Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
            reqVo.setUserName(user.getUsername());
            reqVo.setThisCode(user.getOrgcode());
            reqVo.setThisPost(user.getPoscode());
            ArrayList<String> positionCodeList = new ArrayList<String>();
            positionCodeList.add(user.getPoscode());
            List<String> roleList = this.mdmPositionRoleService.findRoleCodeByPosition(positionCodeList);
            if (CollectionUtils.isNotEmpty(roleList)) {
                roleList.add(user.getOrgcode());
                reqVo.setOrgs(roleList);
            }
            miniPrgList = this.mdmNoticeMapper.findListMiniPrg((Page<MdmNoticeRespVo>)page, reqVo, YesNoEnum.yesNoEnum.ONE.getValue());
            total = page.getTotal();
            if (this.isNoticeAdmin().booleanValue()) {
                PageResult<MdmNoticeRespVo> list = this.findList((MdmNoticeReqVo)CrmBeanUtil.copy((Object)reqVo, MdmNoticeReqVo.class));
                miniPrgList = list.getData();
                total = list.getCount();
            }
            if (CollectionUtil.listEmpty(miniPrgList)) {
                return PageResult.builder().data(miniPrgList).count(Long.valueOf(page.getTotal())).build();
            }
            this.setNoticeStatus(miniPrgList);
            ArrayList<String> notices = new ArrayList<String>();
            for (MdmNoticeRespVo mdmNoticeRespVo : miniPrgList) {
                notices.add(mdmNoticeRespVo.getNoticeCode());
            }
            if (CollectionUtil.listEmpty(notices)) break block9;
            List<MdmNoticeReadRespVo> isItRight = this.mdmNoticeReadMapper.findIsItRight(notices, reqVo.getUserName(), reqVo.getThisPost(), user.getOrgcode());
            if (CollectionUtil.listNotEmpty(isItRight)) {
                Map map = isItRight.stream().collect(Collectors.toMap(MdmNoticeReadRespVo::getNoticeCode, Function.identity(), (k1, k2) -> k2));
                for (MdmNoticeRespVo mdmNoticeRespVo : miniPrgList) {
                    if (map.containsKey(mdmNoticeRespVo.getNoticeCode())) {
                        mdmNoticeRespVo.setHaveRead("1");
                        continue;
                    }
                    mdmNoticeRespVo.setHaveRead("0");
                }
            } else {
                for (MdmNoticeRespVo mdmNoticeRespVo : miniPrgList) {
                    mdmNoticeRespVo.setHaveRead("0");
                }
            }
        }
        return PageResult.builder().data(miniPrgList).count(total).build();
    }

    @Override
    public MdmNoticeRespVo queryMiniPrgNew() {
        UserRedis user = UserUtils.getUser();
        ArrayList<String> positionCodeList = new ArrayList<String>();
        positionCodeList.add(user.getPoscode());
        List<String> roleList = this.mdmPositionRoleService.findRoleCodeByPosition(positionCodeList);
        if (CollectionUtils.isNotEmpty(roleList)) {
            roleList.add(user.getOrgcode());
        }
        List<MdmNoticeRespVo> data = this.mdmNoticeMapper.findListMiniPrgNew(roleList);
        this.setNoticeStatus(data);
        if (CollectionUtil.listEmpty(data)) {
            return new MdmNoticeRespVo();
        }
        return data.get(0);
    }

    @Override
    public MdmNoticeRespVo queryMiniPrg(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"Id\u4e0d\u80fd\u4e3a\u7a7a");
        MdmNoticeRespVo mdmNoticeRespVo = this.mdmNoticeMapper.queryMimiPrg(id);
        this.setNoticeStatus(Arrays.asList(mdmNoticeRespVo));
        AssertUtils.isNotNull((Object)mdmNoticeRespVo, (String)"\u6570\u636e\u4e0d\u5b58\u5728");
        String noticeCode = mdmNoticeRespVo.getNoticeCode();
        List<MdmNoticeFileRespVo> miniList = this.noticeFileMapper.findMiniList(noticeCode);
        if (!CollectionUtil.listEmpty(miniList)) {
            miniList.forEach(m -> m.setFileSuffix(StringUtils.isEmpty((String)m.getFileName()) ? "" : m.getFileName().substring(m.getFileName().lastIndexOf(".") + 1)));
        }
        mdmNoticeRespVo.setNoticeFileRespVos(miniList);
        this.iMdmNoticeReadService.save(mdmNoticeRespVo.getNoticeCode());
        return mdmNoticeRespVo;
    }

    @Override
    public MdmNoticeRespVo queryMiniPrgByUpBelow(String id, String upBelow) {
        AssertUtils.isNotEmpty((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)upBelow, (String)"\u7ffb\u9875\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        UserRedis user = UserUtils.getUser();
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
        mdmOrgReqVo.setOrgCode(user.getOrgcode());
        String noticeId = this.mdmNoticeMapper.queryMinPrgUpOrBelow(id, upBelow, user.getOrgcode());
        if (StringUtils.isEmpty((String)noticeId)) {
            if ("0".equals(upBelow)) {
                AssertUtils.isNotEmpty((String)noticeId, (String)"\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u6761\u4e86");
            } else {
                AssertUtils.isNotEmpty((String)noticeId, (String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u6761\u4e86");
            }
        }
        MdmNoticeRespVo mdmNoticeRespVo = this.queryMiniPrg(noticeId);
        this.setNoticeStatus(Arrays.asList(mdmNoticeRespVo));
        List<MdmNoticeFileRespVo> miniList = this.noticeFileMapper.findMiniList(mdmNoticeRespVo.getNoticeCode());
        mdmNoticeRespVo.setNoticeFileRespVos(miniList);
        this.iMdmNoticeReadService.save(mdmNoticeRespVo.getNoticeCode());
        return mdmNoticeRespVo;
    }

    @Override
    public MdmNoticeRespVo query(MdmNoticeReqVo reqVo) {
        if (null == reqVo || StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            return new MdmNoticeRespVo();
        }
        List list = this.findList(reqVo).getData();
        this.setNoticeStatus(list);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new MdmNoticeRespVo();
        }
        MdmNoticeRespVo mdmNoticeRespVo = (MdmNoticeRespVo)list.get(0);
        MdmNoticeFileReqVo fileReqVo = new MdmNoticeFileReqVo();
        fileReqVo.setNoticeCode(mdmNoticeRespVo.getNoticeCode());
        fileReqVo.setPageSize(Integer.valueOf(-1));
        List fileRespVos = this.iMdmNoticeFileService.findList(fileReqVo).getData();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)fileRespVos)) {
            mdmNoticeRespVo.setNoticeFileRespVos(fileRespVos);
        }
        MdmNoticeReceivingReqVo receivingReqVo = new MdmNoticeReceivingReqVo();
        receivingReqVo.setNoticeCode(mdmNoticeRespVo.getNoticeCode());
        receivingReqVo.setPageSize(Integer.valueOf(-1));
        List receivingRespVos = this.iMdmNoticeReceivingService.findList(receivingReqVo).getData();
        mdmNoticeRespVo.setNoticeReceivingRespVos(receivingRespVos);
        MdmNoticeCommentReqVo noticeCommentReqVo = new MdmNoticeCommentReqVo();
        noticeCommentReqVo.setNoticeId(reqVo.getId());
        noticeCommentReqVo.setPageSize(Integer.valueOf(-1));
        List commentRespVos = this.iMdmNoticeCommentService.findCommentList(noticeCommentReqVo).getData();
        mdmNoticeRespVo.setNoticeCommentRespVos(commentRespVos);
        this.iMdmNoticeReadService.save(mdmNoticeRespVo.getNoticeCode());
        return mdmNoticeRespVo;
    }

    public void saveCheck(MdmNoticeReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getNoticeTitle(), (String)"\u8bf7\u8f93\u5165\u516c\u544a\u6807\u9898");
        AssertUtils.isNotEmpty((String)reqVo.getNoticeType(), (String)"\u8bf7\u9009\u62e9\u516c\u544a\u7c7b\u578b");
        AssertUtils.isNotEmpty((String)reqVo.getBeginDate(), (String)"\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getNoticeContent(), (String)"\u8bf7\u8f93\u5165\u516c\u544a\u5185\u5bb9");
        AssertUtils.isNotEmpty((Collection)reqVo.getNoticeReceivingReqVos(), (String)"\u8bf7\u9009\u62e9\u516c\u544a\u8303\u56f4");
        LocalDateTime beginDate = null;
        try {
            beginDate = LocalDateTime.parse(reqVo.getBeginDate(), CrmDateUtils.yyyyMMddHHmmss);
        }
        catch (Exception e) {
            throw new BusinessException("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        AssertUtils.isNotEmpty((String)reqVo.getEndDate(), (String)"\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        LocalDateTime endDate = null;
        try {
            endDate = LocalDateTime.parse(reqVo.getEndDate(), CrmDateUtils.yyyyMMddHHmmss);
        }
        catch (Exception e) {
            throw new BusinessException("\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        if (!beginDate.isBefore(endDate)) {
            throw new BusinessException("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6709\u6548\u7ed3\u675f\u65f6\u95f4");
        }
        AssertUtils.isNotEmpty((String)reqVo.getNoticeContent(), (String)"\u516c\u544a\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isEmpty((String)reqVo.getNoticeTopState())) {
            reqVo.setNoticeTopState(YesNoEnum.YesNoCodeNumberEnum.NO.getCode().toString());
        }
        if (StringUtils.isEmpty((String)reqVo.getNoticeReleaseStatus())) {
            reqVo.setNoticeReleaseStatus(YesNoEnum.YesNoCodeNumberEnum.YES.getCode().toString());
        }
        if (StringUtils.isEmpty((String)reqVo.getCommentState())) {
            reqVo.setCommentState(YesNoEnum.YesNoCodeNumberEnum.NO.getCode().toString());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmNoticeReqVo reqVo) {
        this.saveCheck(reqVo);
        MdmNoticeEntity entity = (MdmNoticeEntity)CrmBeanUtil.copy((Object)reqVo, MdmNoticeEntity.class);
        String code = CodeUtil.generateCode((String)MdmCodeEnum.NoticeCode.NOTICE_CODE.getVal());
        entity.setNoticeCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        entity.setNoticeReleaseStatus(reqVo.getNoticeReleaseStatus());
        if (YesNoEnum.YesNoCodeNumberEnum.YES.getCode().toString().equals(reqVo.getNoticeTopState())) {
            String topTime = String.valueOf(System.currentTimeMillis());
            entity.setNoticeTopTime(topTime);
        } else {
            entity.setNoticeTopTime(YesNoEnum.yesNoEnum.ZERO.getValue());
        }
        entity.setNoticeReleaseStatus(reqVo.getNoticeReleaseStatus());
        this.save(entity);
        this.saveData(reqVo, entity);
    }

    public void saveData(MdmNoticeReqVo reqVo, MdmNoticeEntity entity) {
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getNoticeReceivingReqVos())) {
            List receivingEntityList = reqVo.getNoticeReceivingReqVos().stream().map(o -> {
                MdmNoticeReceivingEntity receivingEntity = new MdmNoticeReceivingEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)receivingEntity);
                receivingEntity.setId(null);
                receivingEntity.setNoticeCode(entity.getNoticeCode());
                return receivingEntity;
            }).collect(Collectors.toList());
            this.iMdmNoticeReceivingService.saveBatch(receivingEntityList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getNoticeFileReqVos())) {
            List fileEntityList = reqVo.getNoticeFileReqVos().stream().map(o -> {
                MdmNoticeFileEntity fileEntity = new MdmNoticeFileEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)fileEntity);
                fileEntity.setId(null);
                fileEntity.setNoticeCode(entity.getNoticeCode());
                return fileEntity;
            }).collect(Collectors.toList());
            this.iMdmNoticeFileService.saveBatch(fileEntityList);
        }
    }

    @Override
    public void update(MdmNoticeReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MdmNoticeEntity entity = (MdmNoticeEntity)this.getById((Serializable)((Object)reqVo.getId()));
        if (Objects.isNull(entity)) {
            throw new BusinessException("\u516c\u544a\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.saveCheck(reqVo);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)entity);
        if (YesNoEnum.YesNoCodeNumberEnum.NO.getCode().toString().equals(reqVo.getNoticeTopState())) {
            entity.setNoticeTopTime(YesNoEnum.yesNoEnum.ZERO.getValue());
        }
        if (YesNoEnum.YesNoCodeNumberEnum.YES.getCode().toString().equals(reqVo.getNoticeTopState())) {
            String topTime = String.valueOf(System.currentTimeMillis());
            entity.setNoticeTopTime(topTime);
        }
        entity.setNoticeReleaseStatus(reqVo.getNoticeReleaseStatus());
        this.updateById(entity);
        reqVo.setIds((List)Lists.newArrayList((Object[])new String[]{entity.getId()}));
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo, entity);
    }

    @Override
    public void deleteBatch(final List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MdmNoticeReqVo reqVo = new MdmNoticeReqVo(){
            {
                this.setIds(ids);
            }
        };
        reqVo.setPageSize(Integer.valueOf(-1));
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u516c\u544a\u6570\u636e\u4e0d\u5b58\u5728");
        }
        for (MdmNoticeRespVo mdmNoticeRespVo : list) {
            String noticeReleaseStatus = mdmNoticeRespVo.getNoticeReleaseStatus();
            if (!YesNoEnum.YesNoCodeNumberEnum.YES.getCode().toString().equals(noticeReleaseStatus)) continue;
            throw new BusinessException("\u516c\u544a\uff1a" + mdmNoticeRespVo.getNoticeTitle() + " \u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.mdmNoticeMapper.deleteProductsByParams(reqVo);
        List noticeCodes = list.stream().map(MdmNoticeRespVo::getNoticeCode).collect(Collectors.toList());
        reqVo.setNoticeCodes(noticeCodes);
        this.deleteBatchDate(reqVo);
    }

    public void deleteBatchDate(MdmNoticeReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getNoticeCode()) && CollectionUtil.listEmpty((List)reqVo.getNoticeCodes())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MdmNoticeFileReqVo mdmNoticeFileReqVo = new MdmNoticeFileReqVo();
        mdmNoticeFileReqVo.setNoticeCode(reqVo.getNoticeCode());
        mdmNoticeFileReqVo.setNoticeCodes(reqVo.getNoticeCodes());
        this.noticeFileMapper.deleteProductsByParams(mdmNoticeFileReqVo);
        MdmNoticeReceivingReqVo mdmNoticeReceivingReqVo = new MdmNoticeReceivingReqVo();
        mdmNoticeReceivingReqVo.setNoticeCode(reqVo.getNoticeCode());
        mdmNoticeReceivingReqVo.setNoticeCodes(reqVo.getNoticeCodes());
        this.noticeReceivingMapper.deleteProductsByParams(mdmNoticeReceivingReqVo);
        List noticeIds = reqVo.getIds();
        List<String> commentIds = this.noticeCommentMapper.selectCommentIds(noticeIds);
        if (!commentIds.isEmpty()) {
            this.noticeCommentLikesMapper.deleteProductCommentIds(commentIds);
        }
        this.noticeCommentMapper.deleteProductsByNoticeIds(noticeIds);
    }

    @Override
    public void deleteById(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmNoticeEntity mdmNoticeEntity = (MdmNoticeEntity)this.mdmNoticeMapper.selectById((Serializable)((Object)id));
        AssertUtils.isNotNull((Object)mdmNoticeEntity, (String)"\u516c\u544a\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u4e86");
        if (YesNoEnum.YesNoCodeNumberEnum.YES.getCode().toString().equals(mdmNoticeEntity.getNoticeReleaseStatus())) {
            throw new BusinessException("\u516c\u544a\uff1a" + mdmNoticeEntity.getNoticeTitle() + " \u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        MdmNoticeReqVo reqVo = (MdmNoticeReqVo)CrmBeanUtil.copy((Object)mdmNoticeEntity, MdmNoticeReqVo.class);
        MdmNoticeFileReqVo mdmNoticeFileReqVo = new MdmNoticeFileReqVo();
        mdmNoticeFileReqVo.setNoticeCode(reqVo.getNoticeCode());
        this.noticeFileMapper.deleteProductsByParams(mdmNoticeFileReqVo);
        MdmNoticeReceivingReqVo mdmNoticeReceivingReqVo = new MdmNoticeReceivingReqVo();
        mdmNoticeReceivingReqVo.setNoticeCode(reqVo.getNoticeCode());
        this.noticeReceivingMapper.deleteProductsByParams(mdmNoticeReceivingReqVo);
        String noticeId = reqVo.getId();
        List<String> noticeIds = Arrays.asList(noticeId);
        List<String> commentIds = this.noticeCommentMapper.selectCommentIds(noticeIds);
        if (!commentIds.isEmpty()) {
            this.noticeCommentLikesMapper.deleteProductCommentIds(commentIds);
        }
        this.noticeCommentMapper.deleteProductsByNoticeIds(noticeIds);
        this.mdmNoticeMapper.deleteProductsByParams(reqVo);
    }

    @Override
    public Boolean isNoticeAdmin() {
        UserRedis user = UserUtils.getUser();
        if ("admin".equals(user.getUsername())) {
            return true;
        }
        String positionCode = user.getPoscode();
        ArrayList<String> positionCodeList = new ArrayList<String>();
        positionCodeList.add(positionCode);
        List<String> roleList = this.mdmPositionRoleService.findRoleCodeByPosition(positionCodeList);
        Map roleMap = roleList.stream().collect(HashMap::new, (k, v) -> k.put(v, v), HashMap::putAll);
        if (roleMap.containsKey("ADMIN") || roleMap.containsKey("\u516c\u544a\u7ba1\u7406\u5458")) {
            return true;
        }
        return false;
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List mdmNoticeEntities = this.mdmNoticeMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)mdmNoticeEntities)) {
            mdmNoticeEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmNoticeEntities);
    }

    @Override
    public void disableBatch(List<String> ids) {
        MdmNoticeReqVo reqVo = new MdmNoticeReqVo();
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List mdmNoticeEntities = this.mdmNoticeMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)mdmNoticeEntities)) {
            mdmNoticeEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmNoticeEntities);
    }

    @Override
    public void top(String id) {
        MdmNoticeEntity mdmNoticeEntity = this.doCheck(id);
        String topTime = String.valueOf(System.currentTimeMillis());
        mdmNoticeEntity.setNoticeTopState(YesNoEnum.YesNoCodeNumberEnum.YES.getCode().toString());
        mdmNoticeEntity.setNoticeTopTime(topTime);
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)id);
        this.mdmNoticeMapper.update(mdmNoticeEntity, (Wrapper)updateWrapper);
    }

    @Override
    public void cancelTop(String id) {
        MdmNoticeEntity mdmNoticeEntity = this.doCheck(id);
        mdmNoticeEntity.setNoticeTopState(YesNoEnum.YesNoCodeNumberEnum.NO.getCode().toString());
        mdmNoticeEntity.setNoticeTopTime(YesNoEnum.yesNoEnum.ZERO.getValue());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)id);
        this.mdmNoticeMapper.update(mdmNoticeEntity, (Wrapper)updateWrapper);
    }

    @Override
    public void cancelRelease(String id) {
        MdmNoticeEntity mdmNoticeEntity = this.doCheck(id);
        mdmNoticeEntity.setNoticeReleaseStatus(YesNoEnum.YesNoCodeNumberEnum.NO.getCode().toString());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)id);
        this.mdmNoticeMapper.update(mdmNoticeEntity, (Wrapper)updateWrapper);
    }

    public MdmNoticeEntity doCheck(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmNoticeEntity mdmNoticeEntity = (MdmNoticeEntity)this.mdmNoticeMapper.selectById((Serializable)((Object)id));
        AssertUtils.isNotNull((Object)mdmNoticeEntity, (String)"\u516c\u544a\u6570\u636e\u4e0d\u5b58\u5728");
        return mdmNoticeEntity;
    }

    @Override
    public void releaseNoticeById(String id) {
        MdmNoticeEntity mdmNoticeEntity = this.doCheck(id);
        mdmNoticeEntity.setNoticeReleaseStatus(YesNoEnum.YesNoCodeNumberEnum.YES.getCode().toString());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)id);
        this.mdmNoticeMapper.update(mdmNoticeEntity, (Wrapper)updateWrapper);
    }
}

