/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationCustomerPageReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationCustomerReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRelationCustomerPageRespVo;
import com.biz.crm.position.service.MdmPositionRelationCustomerService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmPositionRelationCustomerController"})
@Api(tags={"MDM-\u804c\u4f4d\u7ba1\u7406-\u5173\u8054\u5ba2\u6237"})
@CrmGlobalLog
public class MdmPositionRelationCustomerController {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionRelationCustomerController.class);
    @Autowired
    private MdmPositionRelationCustomerService mdmPositionRelationCustomerService;

    @ApiOperation(value="\u67e5\u8be2\u672a\u5173\u8054\u4efb\u4f55\u804c\u4f4d\u7684\u5ba2\u6237")
    @PostMapping(value={"/findCustomerNotRelateAnyPosition"})
    @CrmDictMethod
    public Result<PageResult<MdmPositionRelationCustomerPageRespVo>> findCustomerNotRelateAnyPosition(@RequestBody MdmPositionRelationCustomerPageReqVo reqVo) {
        return Result.ok(this.mdmPositionRelationCustomerService.findCustomerNotRelateAnyPosition(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u672a\u5173\u8054\u5f53\u524d\u804c\u4f4d\u7684\u5ba2\u6237", notes="positionCode\u5fc5\u4f20")
    @PostMapping(value={"/findCustomerNotRelateCurPosition"})
    @CrmDictMethod
    public Result<PageResult<MdmPositionRelationCustomerPageRespVo>> findCustomerNotRelateCurPosition(@RequestBody MdmPositionRelationCustomerPageReqVo reqVo) {
        return Result.ok(this.mdmPositionRelationCustomerService.findCustomerNotRelateCurPosition(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u5df2\u5173\u8054\u5f53\u524d\u7528\u6237\u7684\u5ba2\u6237", notes="positionCode\u5fc5\u4f20")
    @PostMapping(value={"/findCustomerHasRelateCurPosition"})
    @CrmDictMethod
    public Result<PageResult<MdmPositionRelationCustomerPageRespVo>> findCustomerHasRelateCurPosition(@RequestBody MdmPositionRelationCustomerPageReqVo reqVo) {
        return Result.ok(this.mdmPositionRelationCustomerService.findCustomerHasRelateCurPosition(reqVo));
    }

    @ApiOperation(value="\u6dfb\u52a0\u5ba2\u6237\u4e0e\u804c\u4f4d\u7684\u5173\u8054", notes="\u4f20customerCodeList\u548cpositionCode")
    @PostMapping(value={"/bindRelation"})
    public Result bindRelation(@RequestBody MdmPositionRelationCustomerReqVo reqVo) {
        this.mdmPositionRelationCustomerService.bindRelation(reqVo.getCustomerCodeList(), reqVo.getPositionCode());
        return Result.ok();
    }

    @ApiOperation(value="\u66ff\u6362\u5173\u8054\u804c\u4f4d", notes="\u4f20ids\u548cpositionCode")
    @PostMapping(value={"/replaceCustomerPosition"})
    public Result replaceCustomerPosition(@RequestBody MdmPositionRelationCustomerReqVo reqVo) {
        this.mdmPositionRelationCustomerService.replaceCustomerPosition(reqVo.getIds(), reqVo.getPositionCode());
        return Result.ok();
    }

    @ApiOperation(value="\u89e3\u9664\u5ba2\u6237\u4e0e\u804c\u4f4d\u5173\u8054\u5173\u7cfb", notes="\u4f20ids", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u5173\u8054\u5173\u7cfbid\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/unbindRelation"})
    public Result unbindRelation(@RequestBody List<String> ids) {
        this.mdmPositionRelationCustomerService.unbindRelation(ids);
        return Result.ok();
    }
}

