/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.mdm.org.req.MdmOrgRelTerminalPageReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgRelTerminalReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRelTerminalPageRespVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.org.mapper.MdmOrgTerminalMapper;
import com.biz.crm.org.service.MdmOrgTerminalService;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.util.PageUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class MdmOrgTerminalServiceImpl
implements MdmOrgTerminalService {
    @Resource
    private MdmTerminalService mdmTerminalService;
    @Resource
    private MdmOrgTerminalMapper mdmOrgTerminalMapper;

    @Override
    public PageResult<MdmOrgRelTerminalPageRespVo> findOrgTerminalList(MdmOrgRelTerminalPageReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmOrgRelTerminalPageRespVo> list = this.mdmOrgTerminalMapper.findOrgTerminalList((Page<MdmOrgRelTerminalPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateTerminalOrg(MdmOrgRelTerminalReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        Assert.hasText((String)reqVo.getOriginOrgCode(), (String)"\u7f3a\u5931\u6e90\u7ec4\u7ec7\u7f16\u7801");
        Assert.notEmpty((Collection)reqVo.getTerminalCodeList(), (String)"\u7f3a\u5931\u7ec8\u7aef\u7f16\u7801");
        MdmOrgTerminalReqVo mdmOrgTerminalReqVo = new MdmOrgTerminalReqVo();
        mdmOrgTerminalReqVo.setOrgCode(reqVo.getOrgCode());
        mdmOrgTerminalReqVo.setOriginOrgCode(reqVo.getOriginOrgCode());
        mdmOrgTerminalReqVo.setTerminalCodeList(reqVo.getTerminalCodeList());
        this.mdmTerminalService.batchUpdateTerminalOrg(mdmOrgTerminalReqVo);
    }
}

