/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.approval.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.approval.mapper.MdmApprovalConfigConditionMapper;
import com.biz.crm.approval.model.MdmApprovalConfigConditionEntity;
import com.biz.crm.approval.service.MdmApprovalConfigConditionService;
import com.biz.crm.nebular.mdm.approval.req.MdmApprovalConfigConditionReqVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigConditionRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmBpmConfigConditionServiceExpandImpl"})
public class MdmApprovalConfigConditionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmApprovalConfigConditionMapper, MdmApprovalConfigConditionEntity>
implements MdmApprovalConfigConditionService {
    private static final Logger log = LoggerFactory.getLogger(MdmApprovalConfigConditionServiceImpl.class);
    @Resource
    private MdmApprovalConfigConditionMapper mdmApprovalConfigConditionMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveConditionList(String businessCode, List<MdmApprovalConfigConditionReqVo> conditionList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(conditionList)) {
            Assert.hasText((String)businessCode, (String)"\u7f3a\u5931\u4e1a\u52a1\u7f16\u7801");
            List collect = conditionList.stream().map(x -> {
                MdmApprovalConfigConditionEntity copy = (MdmApprovalConfigConditionEntity)CrmBeanUtil.copy((Object)x, MdmApprovalConfigConditionEntity.class);
                copy.setBusinessCode(businessCode);
                copy.setMenuCode(UUID.randomUUID().toString().replace("-", ""));
                return copy;
            }).collect(Collectors.toList());
            this.saveBatch(collect);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteConditionList(String businessCode) {
        Assert.hasText((String)businessCode, (String)"\u7f3a\u5931\u4e1a\u52a1\u7f16\u7801");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmApprovalConfigConditionEntity::getBusinessCode, (Object)businessCode)).remove();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteConditionList(List<String> businessCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(businessCodeList)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmApprovalConfigConditionEntity::getBusinessCode, businessCodeList)).remove();
        }
    }

    @Override
    public List<MdmApprovalConfigConditionRespVo> findConditionList(String businessCode) {
        Assert.hasText((String)businessCode, (String)"\u7f3a\u5931\u4e1a\u52a1\u7f16\u7801");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmApprovalConfigConditionEntity::getBusinessCode, (Object)businessCode)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return CrmBeanUtil.copyList((List)list, MdmApprovalConfigConditionRespVo.class);
        }
        return Collections.emptyList();
    }
}

