/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.availablelist.consumer;

import com.biz.crm.availablelist.service.CusAvailablelistService;
import com.biz.crm.availablelist.service.TerminalAvailablelistService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.nebular.mdm.availablelist.AvalibleListProductLevelChangeDto;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.utils.AvailableUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@RocketMQMessageListener(topic="${rocketmq.topic}${rocketmq.environment-variable}", selectorExpression="AVAILBLELIST_REFRSH_UPDATE_PRODUCT_LEVEL", consumerGroup="AVAILBLELIST_REFRSH_UPDATE_PRODUCT_LEVEL${rocketmq.environment-variable}")
public class ProductLevelChangeConsumer
extends AbstractRocketMQConsumer {
    private static final Logger log = LoggerFactory.getLogger(ProductLevelChangeConsumer.class);
    @Resource
    private CusAvailablelistService cusAvailablelistService;
    @Resource
    private TerminalAvailablelistService terminalAvailablelistService;

    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        log.info("\u4ea7\u54c1\u5c42\u7ea7\u53d8\u52a8\u901a\u77e5\u5f00\u59cb\uff0c--------------");
        String msg = message.getMsgBody();
        if (StringUtils.isEmpty((Object)msg)) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        List dtos = (List)JsonPropertyUtil.toObject((String)msg, List.class);
        if (CollectionUtils.isEmpty((Collection)dtos)) {
            log.info("\u4ea7\u54c1\u5c42\u7ea7code\u5217\u8868\u4e3a\u7a7a!");
            return "\u4ea7\u54c1\u5c42\u7ea7code\u5217\u8868\u4e3a\u7a7a!";
        }
        if (!AvailableUtil.refreshFlag()) {
            HashMap<String, AvalibleListProductLevelChangeDto> dtoMap = new HashMap<String, AvalibleListProductLevelChangeDto>();
            for (AvalibleListProductLevelChangeDto dto : dtos) {
                if (StringUtils.isEmpty((Object)dto.getGoodsCode())) continue;
                dtoMap.put(dto.getGoodsCode(), dto);
            }
            if (CollectionUtils.isEmpty(dtoMap)) {
                log.info("\u5546\u54c1\u7f16\u7801\u5168\u90e8\u4e3a\u7a7a!");
                return "\u5546\u54c1\u7f16\u7801\u5168\u90e8\u4e3a\u7a7a!";
            }
            this.cusAvailablelistService.reFreshProductLevel(dtoMap);
            this.terminalAvailablelistService.reFreshProductLevel(dtoMap);
        } else {
            HashSet<String> productLevelCode = new HashSet<String>();
            for (AvalibleListProductLevelChangeDto dto : dtos) {
                if (!StringUtils.isEmpty((Object)dto.getNewLevelCode())) {
                    productLevelCode.add(dto.getNewLevelCode());
                }
                if (StringUtils.isEmpty((Object)dto.getOldLevelCode())) continue;
                productLevelCode.add(dto.getOldLevelCode());
            }
            this.cusAvailablelistService.reFreshByProductLevel(new ArrayList<String>(productLevelCode));
            this.terminalAvailablelistService.reFreshByProductLevel(new ArrayList<String>(productLevelCode));
        }
        log.info("\u4ea7\u54c1\u5c42\u7ea7\u53d8\u52a8\u901a\u77e5\u7ed3\u675f\uff0c--------------");
        return "\u64cd\u4f5c\u6210\u529f";
    }
}

