/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.availablelistrule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.availablelistrule.entity.AvailableListRuleEntity;
import com.biz.crm.availablelistrule.entity.AvailableListRuleGoodsEntity;
import com.biz.crm.availablelistrule.mapper.AvailableListRuleGoodsMapper;
import com.biz.crm.availablelistrule.service.AvailableListRuleGoodsService;
import com.biz.crm.availablelistrule.utils.AvailableListRuleGoodsUtil;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleGoodsVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.util.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"availableListRuleServiceGoodsExpandImpl"})
@Service(value="availableListRuleGoodsService")
public class AvailableListRuleGoodsServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<AvailableListRuleGoodsMapper, AvailableListRuleGoodsEntity>
implements AvailableListRuleGoodsService {
    @Autowired
    private AvailableListRuleGoodsMapper availableListRuleGoodsMapper;

    @Override
    @Transactional
    public void replace(List<AvailableListRuleGoodsVo> vos, final AvailableListRuleEntity ruleEntity) {
        this.removeByMap(new HashMap<String, Object>(){
            {
                this.put("rule_code", ruleEntity.getRuleCode());
            }
        });
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        this.saveBatch(AvailableListRuleGoodsUtil.packageEntities(vos, ruleEntity));
    }

    @Override
    public List<AvailableListRuleGoodsVo> findByRuleCode(String ruleCode) {
        if (StringUtils.isEmpty((Object)ruleCode)) {
            return new ArrayList<AvailableListRuleGoodsVo>();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"rule_code", (Object)ruleCode);
        List goodsEntities = this.availableListRuleGoodsMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)goodsEntities)) {
            return new ArrayList<AvailableListRuleGoodsVo>();
        }
        ArrayList<AvailableListRuleGoodsVo> reList = new ArrayList<AvailableListRuleGoodsVo>(goodsEntities.size());
        for (AvailableListRuleGoodsEntity entity : goodsEntities) {
            AvailableListRuleGoodsVo vo = new AvailableListRuleGoodsVo();
            BeanUtils.copyProperties((Object)entity, (Object)vo);
            reList.add(vo);
        }
        return reList;
    }

    @Override
    public List<AvailableListRuleGoodsVo> findByRuleCodes(List<String> ruleCodes) {
        List vos = null;
        ValidateUtils.validate(ruleCodes, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u53ef\u591f\u89c4\u5219\u7f16\u53f7\uff01");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(AvailableListRuleGoodsEntity::getRuleCode, ruleCodes)).list();
        vos = CrmBeanUtil.copyList((List)list, AvailableListRuleGoodsVo.class);
        if (CollectionUtil.listEmpty((List)vos)) {
            return Lists.newArrayList();
        }
        return vos;
    }
}

