/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.biz.crm.config.CrmDataSource;
import com.biz.crm.config.DynamicDataSourceContextHolder;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CrmDataSourceAspect {
    private static final Logger log = LoggerFactory.getLogger(CrmDataSourceAspect.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@within(CrmDataSource)||@annotation(CrmDataSource)")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        CrmDataSource annotation;
        CrmDataSource clsAnnotation = pjp.getTarget().getClass().getAnnotation(CrmDataSource.class);
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        CrmDataSource methodAnnotation = method.getAnnotation(CrmDataSource.class);
        log.info("\u7c7b\u6ce8\u89e3:{}", (Object)clsAnnotation);
        log.info("\u65b9\u6cd5\u6ce8\u89e3:{}", (Object)methodAnnotation);
        CrmDataSource crmDataSource = annotation = methodAnnotation != null ? methodAnnotation : clsAnnotation;
        if (annotation != null) {
            DynamicDataSourceContextHolder.setDataSourceType(annotation.value().name());
        }
        try {
            Object object = pjp.proceed();
            return object;
        }
        finally {
            DynamicDataSourceContextHolder.removeDataSourceType();
        }
    }
}

