/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.poi.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalStatisticianTypeVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmAmapDistrictStatisticianReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmAmapDistrictStatisticianRespVo;
import com.biz.crm.poi.model.MdmAmapPoiCityEntity;
import com.biz.crm.poi.service.MdmAmapPoiCityService;
import com.biz.crm.poi.service.MdmAmapStatisticianService;
import com.biz.crm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.util.PinyinUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmAmapStatisticianServiceExpandImpl"})
public class MdmAmapStatisticianServiceImpl
implements MdmAmapStatisticianService {
    private static final Logger log = LoggerFactory.getLogger(MdmAmapStatisticianServiceImpl.class);
    @Autowired
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Autowired
    private MdmTerminalService mdmTerminalService;
    @Autowired
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;
    @Autowired
    private MdmAmapPoiCityService mdmAmapPoiCityService;
    @Autowired
    private MdmTerminalMapper mdmTerminalMapper;

    @Override
    public List<MdmTerminalStatisticianTypeVo> statisticalType() {
        List<MdmTerminalStatisticianTypeVo> mdmTerminalStatisticianTypeVos = this.mdmTerminalService.statisticalType(new MdmTerminalVo());
        List<MdmTerminalStatisticianTypeVo> mdmCustomerStatisticianTypeVos = this.mdmCustomerMsgService.statisticalType(new MdmCustomerMsgReqVo());
        MdmTerminalStatisticianTypeVo terminal = new MdmTerminalStatisticianTypeVo();
        terminal.setStatisticianType("terminal");
        terminal.setStatisticianName("\u7ec8\u7aef");
        Integer terminalCount = mdmTerminalStatisticianTypeVos.stream().map(x -> Optional.ofNullable(x.getStatisticianCount()).orElse(0)).mapToInt(x -> x).sum();
        terminal.setStatisticianCount(terminalCount);
        MdmTerminalStatisticianTypeVo customer = new MdmTerminalStatisticianTypeVo();
        terminal.setStatisticianType("customer");
        terminal.setStatisticianName("\u5ba2\u6237");
        Integer customerCount = mdmCustomerStatisticianTypeVos.stream().map(x -> Optional.ofNullable(x.getStatisticianCount()).orElse(0)).mapToInt(x -> x).sum();
        customer.setStatisticianCount(customerCount);
        return Arrays.asList(terminal, customer);
    }

    @Override
    public List<MdmAmapDistrictStatisticianRespVo> statisticalDistrict(MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo) {
        List statisticianTypeList = mdmAmapDistrictStatisticianReqVo.getStatisticianTypeList();
        if (CollectionUtils.isEmpty((Collection)statisticianTypeList)) {
            return Collections.emptyList();
        }
        ArrayList<MdmAmapDistrictStatisticianRespVo> districtStatistician = new ArrayList<MdmAmapDistrictStatisticianRespVo>();
        if (!StringUtils.isEmpty((Object)mdmAmapDistrictStatisticianReqVo.getParentCode())) {
            String regionCode;
            MdmAmapPoiCityEntity amapPoiCityEntity = (MdmAmapPoiCityEntity)((LambdaQueryChainWrapper)this.mdmAmapPoiCityService.lambdaQuery().eq(MdmAmapPoiCityEntity::getAmapCode, (Object)mdmAmapDistrictStatisticianReqVo.getParentCode())).select(new SFunction[]{MdmAmapPoiCityEntity::getRegionCode}).one();
            log.info("\u9ad8\u5fb7\u57ce\u5e02:{}", (Object)amapPoiCityEntity);
            if (amapPoiCityEntity != null && !StringUtils.isEmpty((Object)(regionCode = amapPoiCityEntity.getRegionCode()))) {
                mdmAmapDistrictStatisticianReqVo.setParentCode(regionCode);
            }
        }
        if (!StringUtils.isEmpty((Object)mdmAmapDistrictStatisticianReqVo.getParentCode())) {
            districtStatistician.addAll(this.mdmCustomerMsgMapper.statisticalCity(mdmAmapDistrictStatisticianReqVo));
            districtStatistician.addAll(this.mdmTerminalMapper.statisticalCity(mdmAmapDistrictStatisticianReqVo));
        } else {
            districtStatistician.addAll(this.mdmCustomerMsgMapper.statisticalProvince(mdmAmapDistrictStatisticianReqVo));
            districtStatistician.addAll(this.mdmTerminalMapper.statisticalProvince(mdmAmapDistrictStatisticianReqVo));
        }
        if (CollectionUtils.isEmpty(districtStatistician)) {
            return Collections.emptyList();
        }
        List amapCodeList = districtStatistician.stream().map(MdmAmapDistrictStatisticianRespVo::getAmapCode).filter(amapCode -> !StringUtils.isEmpty((Object)amapCode)).collect(Collectors.toList());
        Map collect = ((LambdaQueryChainWrapper)this.mdmAmapPoiCityService.lambdaQuery().in(MdmAmapPoiCityEntity::getRegionCode, amapCodeList)).select(new SFunction[]{MdmAmapPoiCityEntity::getAmapCode, MdmAmapPoiCityEntity::getAmapName, MdmAmapPoiCityEntity::getRegionCode}).list().stream().filter(x -> !StringUtils.isEmpty((Object)x.getRegionCode())).collect(Collectors.toMap(MdmAmapPoiCityEntity::getRegionCode, Function.identity()));
        return districtStatistician.stream().filter(x -> collect.containsKey(x.getAmapCode())).peek(x -> {
            MdmAmapPoiCityEntity mdmAmapPoiCityEntity = (MdmAmapPoiCityEntity)collect.get(x.getAmapCode());
            x.setAmapCode(mdmAmapPoiCityEntity.getAmapCode());
            String amapName = mdmAmapPoiCityEntity.getAmapName();
            x.setAmapName(amapName);
            if (!StringUtils.isEmpty((Object)amapName)) {
                if (amapName.endsWith("\u7701") || amapName.endsWith("\u5e02") || amapName.equals("\u53bf") || amapName.equals("\u533a")) {
                    amapName = amapName.substring(0, amapName.length() - 1);
                }
                x.setAmapPinyin(PinyinUtils.toPinLower((String)amapName, (String)""));
            }
        }).collect(Collectors.toList());
    }
}

