/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.MdmCustomerOrTerminalEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalCustomerElasticsearchPageReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalCustomerElasticsearchRespVo;
import com.biz.crm.terminal.mapper.MdmTerminalElasticsearchRepository;
import com.biz.crm.terminal.model.MdmTerminalCustomerElasticsearchEntity;
import com.biz.crm.terminal.service.MdmTerminalElasticsearchService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.GeoDistanceQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class MdmTerminalElasticsearchServiceImpl
implements MdmTerminalElasticsearchService {
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private MdmTerminalElasticsearchRepository elasticsearchRepository;

    @Override
    public PageResult<MdmTerminalCustomerElasticsearchRespVo> listWithPage(MdmTerminalCustomerElasticsearchPageReqVo pageReqVo) {
        Assert.hasText((String)pageReqVo.getLongitude(), (String)"\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)pageReqVo.getLatitude(), (String)"\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((pageReqVo.getDistance() != null && pageReqVo.getDistance() != 0.0 ? 1 : 0) != 0, (String)"\u8ddd\u79bb\u4e0d\u80fd\u4e3a\u7a7a\u62160");
        double latitude = Double.parseDouble(pageReqVo.getLatitude());
        double longitude = Double.parseDouble(pageReqVo.getLongitude());
        PageResult pageResult = new PageResult();
        pageResult.setCount(Long.valueOf(Long.parseLong("0")));
        pageResult.setData(new ArrayList());
        if (!this.elasticsearchTemplate.indexExists("mdm_terminal_customer_index3")) {
            return pageResult;
        }
        if (pageReqVo.getPageNum() == null || pageReqVo.getPageNum() <= 0) {
            pageReqVo.setPageNum(Integer.valueOf(1));
        }
        if (pageReqVo.getPageSize() == null || pageReqVo.getPageSize() == 0) {
            pageReqVo.setPageSize(Integer.valueOf(25));
        }
        GeoDistanceQueryBuilder builder = QueryBuilders.geoDistanceQuery((String)"placePoint").point(latitude, longitude).distance(pageReqVo.getDistance().doubleValue(), DistanceUnit.METERS);
        GeoDistanceSortBuilder sortBuilder = (GeoDistanceSortBuilder)SortBuilders.geoDistanceSort((String)"placePoint", (double)latitude, (double)longitude).unit(DistanceUnit.METERS).order(SortOrder.ASC);
        BoolQueryBuilder builder1 = QueryBuilders.boolQuery();
        if (StringUtils.isNotBlank((CharSequence)pageReqVo.getPositionCodes())) {
            builder1.must((QueryBuilder)QueryBuilders.matchQuery((String)"positionCodes.keyword", (Object)pageReqVo.getPositionCodes()));
        }
        if (StringUtils.isNotBlank((CharSequence)pageReqVo.getName())) {
            builder1.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"name", (Object)pageReqVo.getName()));
        }
        NativeSearchQuery nativeSearchQueryBuilder = new NativeSearchQueryBuilder().withIndices(new String[]{"mdm_terminal_customer_index3"}).withQuery((QueryBuilder)builder1).withFilter((QueryBuilder)builder).withSort((SortBuilder)sortBuilder).withPageable((Pageable)PageRequest.of((int)(pageReqVo.getPageNum() - 1), (int)pageReqVo.getPageSize())).build();
        AggregatedPage scroll = this.elasticsearchTemplate.queryForPage((SearchQuery)nativeSearchQueryBuilder, MdmTerminalCustomerElasticsearchEntity.class);
        List list = scroll.getContent();
        this.translationType(list);
        pageResult.setData(list.stream().map(item -> ((MdmTerminalCustomerElasticsearchRespVo)CrmBeanUtil.copy((Object)item, MdmTerminalCustomerElasticsearchRespVo.class)).setDistance((int)(GeoDistance.PLANE.calculate(Double.parseDouble(item.getLatitude()), Double.parseDouble(item.getLongitude()), latitude, longitude, DistanceUnit.METERS) + 0.5))).collect(Collectors.toList()));
        pageResult.setCount(Long.valueOf(scroll.getTotalElements()));
        return pageResult;
    }

    public void translationType(List<MdmTerminalCustomerElasticsearchEntity> list) {
        if (CollectionUtil.listNotEmpty(list)) {
            list.forEach(o -> {
                if (o.getClientType().equals(SfaVisitEnum.ClientType.DEALER.getVal())) {
                    o.setClientTypeName(SfaVisitEnum.ClientType.DEALER.getDesc());
                    if (StringUtils.isNotEmpty((CharSequence)o.getClientSubclass())) {
                        o.setClientSubclassName((String)MdmCustomerOrTerminalEnum.customerType.GETMAP.get(o.getClientSubclass()));
                    }
                } else if (o.getClientType().equals(SfaVisitEnum.ClientType.TERMINAL.getVal())) {
                    o.setClientTypeName(SfaVisitEnum.ClientType.TERMINAL.getDesc());
                    if (StringUtils.isNotEmpty((CharSequence)o.getClientSubclass())) {
                        o.setClientSubclassName((String)MdmCustomerOrTerminalEnum.terminalType.GETMAP.get(o.getClientSubclass()));
                    }
                }
            });
        }
    }

    @Override
    public void add(MdmTerminalVo mdmTerminalVo, MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        if (!this.elasticsearchTemplate.indexExists("mdm_terminal_customer_index3")) {
            this.elasticsearchTemplate.createIndex(MdmTerminalCustomerElasticsearchEntity.class);
        }
        if (!(mdmTerminalVo == null || StringUtils.isEmpty((CharSequence)mdmTerminalVo.getLongitude()) || StringUtils.isEmpty((CharSequence)mdmTerminalVo.getLatitude()) || CollectionUtils.isEmpty((Collection)mdmTerminalVo.getSupplys()))) {
            List supplys;
            List mainContact;
            MdmTerminalCustomerElasticsearchEntity elasticsearchEntity = (MdmTerminalCustomerElasticsearchEntity)CrmBeanUtil.copy((Object)mdmTerminalVo, MdmTerminalCustomerElasticsearchEntity.class);
            elasticsearchEntity.setName(mdmTerminalVo.getTerminalName());
            elasticsearchEntity.setCode(mdmTerminalVo.getTerminalCode());
            elasticsearchEntity.setPlacePoint(mdmTerminalVo.getLatitude() + "," + mdmTerminalVo.getLongitude());
            List contacts = mdmTerminalVo.getContacts();
            if (!CollectionUtils.isEmpty((Collection)contacts) && !CollectionUtils.isEmpty(mainContact = mdmTerminalVo.getContacts().stream().filter(x -> YesNoEnum.yesNoEnum.ONE.getValue().equals(x.getContactMain())).collect(Collectors.toList()))) {
                elasticsearchEntity.setContactName(((MdmTerminalContactVo)mainContact.get(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).getContactName());
            }
            supplys = (supplys = mdmTerminalVo.getSupplys()) == null ? new ArrayList() : supplys;
            elasticsearchEntity.setPositionCodes(supplys.stream().map(MdmTerminalSupplyVo::getPositionCode).collect(Collectors.joining(";")));
            if (!CollectionUtils.isEmpty((Collection)mdmTerminalVo.getContacts())) {
                elasticsearchEntity.setContactPhone(mdmTerminalVo.getContacts().stream().map(MdmTerminalContactVo::getContactPhone).collect(Collectors.joining(";")));
            }
            elasticsearchEntity.setAddress(mdmTerminalVo.getTerminalAddress());
            elasticsearchEntity.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
            elasticsearchEntity.setClientSubclass(mdmTerminalVo.getTerminalType());
            elasticsearchEntity.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
            elasticsearchEntity.setClientSubclass(mdmTerminalVo.getTerminalType());
            this.elasticsearchRepository.save(elasticsearchEntity);
            return;
        }
        if (!(mdmCustomerMsgReqVo == null || StringUtils.isEmpty((CharSequence)mdmCustomerMsgReqVo.getLongitude()) || StringUtils.isEmpty((CharSequence)mdmCustomerMsgReqVo.getLatitude()) || CollectionUtils.isEmpty((Collection)mdmCustomerMsgReqVo.getMdmCustomerDockingVos()))) {
            List mainContact;
            MdmTerminalCustomerElasticsearchEntity elasticsearchEntity = (MdmTerminalCustomerElasticsearchEntity)CrmBeanUtil.copy((Object)mdmCustomerMsgReqVo, MdmTerminalCustomerElasticsearchEntity.class);
            elasticsearchEntity.setName(mdmCustomerMsgReqVo.getUserName());
            elasticsearchEntity.setCode(mdmCustomerMsgReqVo.getCustomerCode());
            elasticsearchEntity.setPlacePoint(mdmCustomerMsgReqVo.getLatitude() + "," + mdmCustomerMsgReqVo.getLongitude());
            if (!CollectionUtils.isEmpty((Collection)mdmCustomerMsgReqVo.getMdmCustomerContactVos()) && !CollectionUtils.isEmpty(mainContact = mdmCustomerMsgReqVo.getMdmCustomerContactVos().stream().filter(x -> YesNoEnum.yesNoEnum.ONE.getValue().equals(x.getContactMain())).collect(Collectors.toList()))) {
                elasticsearchEntity.setContactName(((MdmCustomerContactReqVo)mainContact.get(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).getContactName());
            }
            if (mdmCustomerMsgReqVo.getMdmCustomerDockingVos() != null) {
                elasticsearchEntity.setPositionCodes(mdmCustomerMsgReqVo.getMdmCustomerDockingVos().stream().map(MdmCustomerDockingReqVo::getPositionCode).collect(Collectors.joining(";")));
            }
            elasticsearchEntity.setContactPhone(mdmCustomerMsgReqVo.getCustomerContact());
            elasticsearchEntity.setAddress(mdmCustomerMsgReqVo.getRegisteredAddress());
            elasticsearchEntity.setClientType(SfaVisitEnum.ClientType.DEALER.getVal());
            elasticsearchEntity.setClientSubclass(mdmCustomerMsgReqVo.getCustomerType());
            this.elasticsearchRepository.save(elasticsearchEntity);
        }
    }
}

