/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.user.mapper.MdmUserRelRoleMapper;
import com.biz.crm.user.model.MdmUserRelRoleEntity;
import com.biz.crm.user.service.MdmUserRelRoleService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmUserRelRoleServiceExpandImpl"})
public class MdmUserRelRoleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmUserRelRoleMapper, MdmUserRelRoleEntity>
implements MdmUserRelRoleService {
    private static final Logger log = LoggerFactory.getLogger(MdmUserRelRoleServiceImpl.class);
    @Resource
    private MdmUserRelRoleMapper mdmUserRelRoleMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(String userName, String roleCode) {
        if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)roleCode)) {
            this.add(userName, Collections.singletonList(roleCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(String userName, List<String> roleCodeList) {
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero(roleCodeList)) {
            Set existCodeSet = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelRoleEntity::getUserName, (Object)userName)).in(MdmUserRelRoleEntity::getRoleCode, roleCodeList)).select(new SFunction[]{MdmUserRelRoleEntity::getRoleCode}).list().stream().map(MdmUserRelRoleEntity::getRoleCode).collect(Collectors.toSet());
            HashSet<String> roleCodeSet = new HashSet<String>(roleCodeList);
            ArrayList<MdmUserRelRoleEntity> entityList = new ArrayList<MdmUserRelRoleEntity>();
            for (String roleCode : roleCodeSet) {
                if (existCodeSet.contains(roleCode)) continue;
                MdmUserRelRoleEntity entity = new MdmUserRelRoleEntity();
                entity.setUserName(userName);
                entity.setRoleCode(roleCode);
                entityList.add(entity);
            }
            if (entityList.size() > 0) {
                this.saveBatch(entityList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(List<String> userNameList, String roleCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList) && StringUtils.isNotEmpty((String)roleCode)) {
            Set existCodeSet = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelRoleEntity::getRoleCode, (Object)roleCode)).in(MdmUserRelRoleEntity::getUserName, userNameList)).select(new SFunction[]{MdmUserRelRoleEntity::getUserName}).list().stream().map(MdmUserRelRoleEntity::getUserName).collect(Collectors.toSet());
            HashSet<String> userNameSet = new HashSet<String>(userNameList);
            ArrayList<MdmUserRelRoleEntity> entityList = new ArrayList<MdmUserRelRoleEntity>();
            for (String userName : userNameSet) {
                if (existCodeSet.contains(userName)) continue;
                MdmUserRelRoleEntity entity = new MdmUserRelRoleEntity();
                entity.setUserName(userName);
                entity.setRoleCode(roleCode);
                entityList.add(entity);
            }
            if (entityList.size() > 0) {
                this.saveBatch(entityList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(String userName, String roleCode) {
        if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)roleCode)) {
            this.del(userName, Collections.singletonList(roleCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(String userName, List<String> roleCodeList) {
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero(roleCodeList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelRoleEntity::getUserName, (Object)userName)).in(MdmUserRelRoleEntity::getRoleCode, roleCodeList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(List<String> userNameList, String roleCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList) && StringUtils.isNotEmpty((String)roleCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmUserRelRoleEntity::getRoleCode, (Object)roleCode)).in(MdmUserRelRoleEntity::getUserName, userNameList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByUserName(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            this.delByUserName(Collections.singletonList(userName));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByUserName(List<String> userNameList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmUserRelRoleEntity::getUserName, userNameList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByRoleCode(String roleCode) {
        if (StringUtils.isNotEmpty((String)roleCode)) {
            this.delByRoleCode(Collections.singletonList(roleCode));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delByRoleCode(List<String> roleCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(roleCodeList)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmUserRelRoleEntity::getRoleCode, roleCodeList)).remove();
        }
    }

    @Override
    public List<String> findRoleCodeListByUserName(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmUserRelRoleEntity::getUserName, (Object)userName)).select(new SFunction[]{MdmUserRelRoleEntity::getRoleCode}).list().stream().map(MdmUserRelRoleEntity::getRoleCode).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceUserRelRole(List<String> ids, String roleCode) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(ids) && StringUtils.isNotEmpty((String)roleCode) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list()))) {
            List<String> userNameList = list.stream().map(MdmUserRelRoleEntity::getUserName).collect(Collectors.toList());
            this.removeByIds(ids);
            this.add(userNameList, roleCode);
        }
    }
}

