/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.customer.mapper.MdmCustomerTagMapper;
import com.biz.crm.customer.model.MdmCustomerTagEntity;
import com.biz.crm.customer.service.MdmCustomerTagService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTagReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTagRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdmCustomerTagServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCustomerTagMapper, MdmCustomerTagEntity>
implements MdmCustomerTagService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerTagServiceImpl.class);
    @Autowired
    private MdmCustomerTagMapper mdmCustomerTagMapper;

    @Override
    public List<MdmCustomerTagRespVo> findList(MdmCustomerTagReqVo reqVo) {
        List<MdmCustomerTagRespVo> list = this.mdmCustomerTagMapper.findList(reqVo);
        return list;
    }

    @Override
    public void save(MdmCustomerTagReqVo reqVo) {
        this.doCheck(reqVo);
        MdmCustomerTagEntity entity = (MdmCustomerTagEntity)CrmBeanUtil.copy((Object)reqVo, MdmCustomerTagEntity.class);
        this.save(entity);
    }

    @Override
    public void delete(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"\u4e3b\u952eId\u4e0d\u80fd\u4e3a\u7a7a");
        MdmCustomerTagEntity entity = (MdmCustomerTagEntity)this.mdmCustomerTagMapper.selectById((Serializable)((Object)id));
        AssertUtils.isNotNull((Object)entity, (String)"\u6807\u7b7e\u4e0d\u5b58\u5728");
        if (YesNoEnum.yesNoEnum.ZERO.getValue().equals(entity.getTagType())) {
            throw new BusinessException("\u6b64\u6807\u7b7e\u4e0d\u53ef\u5220\u9664");
        }
        this.removeById((Serializable)((Object)id));
    }

    public void doCheck(MdmCustomerTagReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getTagType(), (String)"\u6807\u7b7e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getTagDescription(), (String)"\u6807\u7b7e\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

