/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sync.service.impl;

import com.biz.crm.annotation.Klock;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.function.model.MdmFunctionEntity;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.sync.MdmFunctionEngineSyncVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncBaseReqVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncFunctionReqVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.sync.config.MdmSyncParameterParser;
import com.biz.crm.sync.config.MdmSyncProperty;
import com.biz.crm.sync.service.MdmFunctionSyncService;
import com.biz.crm.tableconfig.manager.MdmColumnConfigConverter;
import com.biz.crm.tableconfig.model.MdmColumnConfigEntity;
import com.biz.crm.tableconfig.model.MdmFunctionSubButtonEntity;
import com.biz.crm.tableconfig.model.MdmFunctionSubEntity;
import com.biz.crm.tableconfig.service.IMdmColumnConfigService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubButtonService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubService;
import com.biz.crm.util.CrmBeanUtil;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmFunctionSyncServiceExpandImpl"})
public class MdmFunctionSyncServiceImpl
implements MdmFunctionSyncService {
    private static final Logger log = LoggerFactory.getLogger(MdmFunctionSyncServiceImpl.class);
    @Autowired
    private MdmSyncProperty mdmSyncProperty;
    @Autowired
    private MdmFunctionService mdmFunctionService;
    @Autowired
    private IMdmFunctionSubService mdmFunctionSubService;
    @Autowired
    private IMdmFunctionSubButtonService mdmFunctionSubButtonService;
    @Autowired
    private IMdmColumnConfigService mdmColumnConfigService;
    @Autowired
    private RedisService redisService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock
    public void functionSync(MdmSyncFunctionReqVo mdmSyncFunctionReqVo) {
        List functionCodeList = mdmSyncFunctionReqVo.getFunctionCodeList();
        if (YesNoEnum.YesNoCodeNumberEnum.YES.getCode().equals(mdmSyncFunctionReqVo.getDeleted())) {
            this.backUpFunction();
            this.backUpFunctionSub();
            this.backUpFunctionSubButton();
            this.backUpColumn();
        }
        MdmFunctionEngineSyncVo mdmFunctionEngineSyncVo = MdmSyncParameterParser.obtainOriginalData((MdmSyncBaseReqVo)mdmSyncFunctionReqVo, this.mdmSyncProperty, "/mdm/mdmfunction/syncList", mdmSyncFunctionReqVo, MdmFunctionEngineSyncVo.class);
        this.saveFunction(mdmFunctionEngineSyncVo);
        this.saveListConfig(functionCodeList, mdmFunctionEngineSyncVo);
        this.saveButton(functionCodeList, mdmFunctionEngineSyncVo);
        this.saveColumn(functionCodeList, mdmFunctionEngineSyncVo);
        try {
            this.redisService.delBatch("mdm_column:*");
            this.redisService.delBatch("mdmFunctionSub:*");
            this.redisService.delBatch("mdm_button:*");
        }
        catch (Exception e) {
            log.info("\u6e05\u9664\u7f13\u5b58\u5931\u8d25,\u9700\u8981\u624b\u52a8\u6e05\u9664button,column\u7f13\u5b58");
        }
    }

    protected void backUpColumn() {
        List list = this.mdmColumnConfigService.lambdaQuery().list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            this.redisService.lSetAll("mdm_column:bak", (Collection)list, 2592000L);
            this.mdmColumnConfigService.lambdaUpdate().remove();
        }
    }

    protected void backUpFunctionSubButton() {
        List list = this.mdmFunctionSubButtonService.lambdaQuery().list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            this.redisService.lSetAll("mdmFunctionSubButton:bak", (Collection)list, 2592000L);
            this.mdmFunctionSubButtonService.lambdaUpdate().remove();
        }
    }

    protected void backUpFunctionSub() {
        List list = this.mdmFunctionSubService.lambdaQuery().list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            this.redisService.lSetAll("mdmFunctionSub:bak", (Collection)list, 2592000L);
            this.mdmFunctionSubService.lambdaUpdate().remove();
        }
    }

    protected void backUpFunction() {
        List list = this.mdmFunctionService.lambdaQuery().list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            this.redisService.lSetAll("mdm_function:bak", (Collection)list, 2592000L);
            this.mdmFunctionService.lambdaUpdate().remove();
        }
    }

    protected void saveColumn(List<String> functionCodeList, MdmFunctionEngineSyncVo mdmFunctionEngineSyncVo) {
        List<MdmColumnConfigEntity> configEntities;
        List columnConfigRespVoList = mdmFunctionEngineSyncVo.getMdmColumnConfigRespVoList();
        if (!CollectionUtils.isEmpty((Collection)columnConfigRespVoList) && !CollectionUtils.isEmpty(configEntities = MdmColumnConfigConverter.INSTANCE.respVo2Entity(columnConfigRespVoList))) {
            this.mdmColumnConfigService.saveOrUpdateBatch(configEntities);
        }
    }

    protected void saveButton(List<String> functionCodeList, MdmFunctionEngineSyncVo mdmFunctionEngineSyncVo) {
        List buttonEntityList;
        List subButtonRespVoList = mdmFunctionEngineSyncVo.getMdmFunctionSubButtonRespVoList();
        if (!CollectionUtils.isEmpty((Collection)subButtonRespVoList) && !CollectionUtils.isEmpty((Collection)(buttonEntityList = CrmBeanUtil.copyList((List)subButtonRespVoList, MdmFunctionSubButtonEntity.class)))) {
            this.mdmFunctionSubButtonService.saveOrUpdateBatch(buttonEntityList);
        }
    }

    protected void saveListConfig(List<String> functionCodeList, MdmFunctionEngineSyncVo mdmFunctionEngineSyncVo) {
        List mdmFunctionSubRespVoList = mdmFunctionEngineSyncVo.getMdmFunctionSubRespVoList();
        Assert.notEmpty((Collection)mdmFunctionSubRespVoList, (String)"\u5217\u8868\u7f3a\u5931");
        List mdmFunctionSubEntityList = CrmBeanUtil.copyList((List)mdmFunctionSubRespVoList, MdmFunctionSubEntity.class);
        log.info("\u5bfc\u5165\u5217\u8868\u96c6\u5408:{}", (Object)mdmFunctionSubEntityList);
        if (!CollectionUtils.isEmpty((Collection)mdmFunctionSubEntityList)) {
            this.mdmFunctionSubService.saveOrUpdateBatch(mdmFunctionSubEntityList);
        }
    }

    protected void saveFunction(MdmFunctionEngineSyncVo mdmFunctionEngineSyncVo) {
        List mdmFunctionRespVoList = mdmFunctionEngineSyncVo.getMdmFunctionRespVoList();
        Assert.notEmpty((Collection)mdmFunctionRespVoList, (String)"\u83dc\u5355\u7f3a\u5931");
        List mdmFunctionEntities = CrmBeanUtil.copyList((List)mdmFunctionRespVoList, MdmFunctionEntity.class);
        log.info("\u5bfc\u5165\u83dc\u5355\u96c6\u5408:{}", (Object)mdmFunctionEntities);
        if (!CollectionUtils.isEmpty((Collection)mdmFunctionEntities)) {
            this.mdmFunctionService.saveOrUpdateBatch(mdmFunctionEntities);
        }
    }
}

