/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.product.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;

public class MdmProductProvider {
    public String findListProvider(Map<String, Object> map) {
        final MdmProductReqVo vo = (MdmProductReqVo)map.get("vo");
        final List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){
            {
                this.SELECT("a.*, b.product_level_name");
                this.FROM("mdm_product a");
                this.LEFT_OUTER_JOIN("mdm_product_level b on a.product_level_code=b.product_level_code");
                if (StringUtils.isNotEmpty((String)vo.getProductType())) {
                    this.WHERE("a.product_type = #{vo.productType}");
                }
                if (StringUtils.isNotEmpty((String)vo.getEnableStatus())) {
                    this.WHERE("a.enable_status = #{vo.enableStatus}");
                }
                if (StringUtils.isNotEmpty((String)vo.getSaleUnit())) {
                    this.WHERE("a.sale_unit = #{vo.saleUnit}");
                }
                if (StringUtils.isNotEmpty((String)vo.getBaseUnit())) {
                    this.WHERE("a.base_unit = #{vo.baseUnit}");
                }
                if (StringUtils.isNotEmpty((String)vo.getIsShelf())) {
                    this.WHERE("a.is_shelf = #{vo.isShelf}");
                }
                if (StringUtils.isNotEmpty((String)vo.getBarCode())) {
                    this.WHERE("a.bar_code like " + ProviderUtil.bindPercent(vo.getBarCode(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getProductCode())) {
                    this.WHERE("a.product_code like " + ProviderUtil.bindPercent(vo.getProductCode(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getProductName())) {
                    this.WHERE("a.product_name like " + ProviderUtil.bindPercent(vo.getProductName(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getRuleCode())) {
                    this.WHERE("b.rule_code like " + ProviderUtil.bindPercent(vo.getRuleCode(), MdmProviderEnum.SQL_JOIN_RIGHT));
                }
                if (StringUtils.isNotEmpty((String)vo.getProductLevelName())) {
                    this.WHERE("b.product_level_name like " + ProviderUtil.bindPercent(vo.getProductLevelName(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (CollectionUtil.listNotEmptyNotSizeZero((List)cvo)) {
                    this.WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
                }
                this.ORDER_BY(" a.create_date desc, a.create_date_second desc");
            }
        }.toString();
    }
}

