/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.kms.manager.KmsConverter;
import com.biz.crm.kms.service.MdmSellPartyService;
import com.biz.crm.nebular.mdm.kms.MdmSellPartyVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageResultVo;
import com.biz.crm.nebular.mdm.kms.api.KmsPageVo;
import com.biz.crm.nebular.mdm.kms.api.KmsResultVo;
import com.biz.crm.nebular.mdm.kms.api.KmsSellPartyPageReqVo;
import com.biz.crm.nebular.mdm.kms.api.KmsSellPartyReqVo;
import com.biz.crm.nebular.mdm.kms.api.KmsSellPartyVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmSellPartyServiceExpandImpl"})
public class MdmSellPartyServiceImpl
implements MdmSellPartyService {
    private static final Logger log = LoggerFactory.getLogger(MdmSellPartyServiceImpl.class);
    @Autowired
    private KmsProperties kmsProperties;

    @Override
    public PageResult<MdmSellPartyVo> page(MdmSellPartyVo mdmSellPartyVo) {
        List data;
        Integer current = Optional.ofNullable(mdmSellPartyVo.getPageNum()).orElse(1);
        Integer size = Optional.ofNullable(mdmSellPartyVo.getPageSize()).orElse(25);
        KmsPageVo kmsPageVo = new KmsPageVo(current, size);
        KmsSellPartyReqVo kmsSellPartyReqVo = new KmsSellPartyReqVo();
        String directSystemId = mdmSellPartyVo.getDirectSystemId();
        Assert.hasText((String)directSystemId, (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        kmsSellPartyReqVo.setDirectSystemId(directSystemId);
        kmsSellPartyReqVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsSellPartyReqVo.setSearchValue(mdmSellPartyVo.getSellPartyName());
        KmsSellPartyPageReqVo kmsSellPartyPageReqVo = new KmsSellPartyPageReqVo();
        kmsSellPartyPageReqVo.setPage(kmsPageVo);
        kmsSellPartyPageReqVo.setReqVo(kmsSellPartyReqVo);
        kmsSellPartyPageReqVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsSellPartyPageReqVo.setUserId(this.kmsProperties.getUserId());
        kmsSellPartyPageReqVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/sell/party/findByPage";
        ParameterizedTypeReference<KmsResultVo<KmsPageResultVo<KmsSellPartyVo>>> reference = new ParameterizedTypeReference<KmsResultVo<KmsPageResultVo<KmsSellPartyVo>>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsSellPartyPageReqVo, (ParameterizedTypeReference)reference);
        KmsPageResultVo mdmSellPartyVoKmsPageResultVo = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(null);
        if (mdmSellPartyVoKmsPageResultVo == null) {
            PageResult mdmSellPartyVoPageResult = new PageResult();
            mdmSellPartyVoPageResult.setCount(Long.valueOf(0L));
            mdmSellPartyVoPageResult.setData(new ArrayList());
            return mdmSellPartyVoPageResult;
        }
        PageResult<MdmSellPartyVo> mdmSellPartyVoPageResult = KmsConverter.INSTANCE.sellPartyPage((KmsPageResultVo<KmsSellPartyVo>)mdmSellPartyVoKmsPageResultVo);
        if (mdmSellPartyVoPageResult != null && !CollectionUtils.isEmpty((Collection)(data = mdmSellPartyVoPageResult.getData()))) {
            data.forEach(x -> {
                x.setDirectSystemId(mdmSellPartyVo.getDirectSystemId());
                x.setDirectSystemName(mdmSellPartyVo.getDirectSystemName());
            });
        }
        return mdmSellPartyVoPageResult;
    }

    @Override
    public void save(MdmSellPartyVo mdmSellPartyVo) {
        Assert.hasText((String)mdmSellPartyVo.getDirectSystemId(), (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmSellPartyVo.getSellPartyCode(), (String)"\u552e\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmSellPartyVo.getSellPartyName(), (String)"\u552e\u8fbe\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        List<MdmSellPartyVo> list = this.list(mdmSellPartyVo);
        if (!CollectionUtils.isEmpty(list)) {
            for (MdmSellPartyVo sellPartyVo : list) {
                if (!mdmSellPartyVo.getSellPartyCode().equals(sellPartyVo.getSellPartyCode())) continue;
                throw new BusinessException("\u5f53\u524d\u552e\u8fbe\u65b9\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
        }
        KmsSellPartyVo kmsSellPartyVo = KmsConverter.INSTANCE.mdm2SellParty(mdmSellPartyVo);
        kmsSellPartyVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsSellPartyVo.setUserId(this.kmsProperties.getUserId());
        kmsSellPartyVo.setUsername(this.kmsProperties.getUsername());
        kmsSellPartyVo.setId(null);
        String url = this.kmsProperties.getUrl() + "/sell/party/saveSellParty?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsSellPartyVo, String.class);
        String body = (String)entity.getBody();
        log.info("body:{}", (Object)body);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25");
        }
    }

    @Override
    public void update(MdmSellPartyVo mdmSellPartyVo) {
        Assert.hasText((String)mdmSellPartyVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmSellPartyVo.getDirectSystemId(), (String)"\u76f4\u8425\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmSellPartyVo.getSellPartyCode(), (String)"\u552e\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmSellPartyVo.getSellPartyName(), (String)"\u552e\u8fbe\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        List<MdmSellPartyVo> list = this.list(mdmSellPartyVo);
        if (!CollectionUtils.isEmpty(list)) {
            for (MdmSellPartyVo sellPartyVo : list) {
                if (!mdmSellPartyVo.getSellPartyCode().equals(sellPartyVo.getSellPartyCode())) continue;
                throw new BusinessException("\u552e\u8fbe\u65b9\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
        }
        KmsSellPartyVo kmsSellPartyVo = KmsConverter.INSTANCE.mdm2SellParty(mdmSellPartyVo);
        kmsSellPartyVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsSellPartyVo.setUserId(this.kmsProperties.getUserId());
        kmsSellPartyVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/sell/party/saveSellParty?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsSellPartyVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u7f16\u8f91\u5931\u8d25");
        }
    }

    @Override
    public void delete(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsSellPartyVo kmsSellPartyVo = new KmsSellPartyVo();
        kmsSellPartyVo.setIds(ids);
        kmsSellPartyVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsSellPartyVo.setUserId(this.kmsProperties.getUserId());
        kmsSellPartyVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/sell/party/deleteBatch?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsSellPartyVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public void enable(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsSellPartyVo kmsSellPartyVo = new KmsSellPartyVo();
        kmsSellPartyVo.setIds(ids);
        kmsSellPartyVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsSellPartyVo.setUserId(this.kmsProperties.getUserId());
        kmsSellPartyVo.setUsername(this.kmsProperties.getUsername());
        kmsSellPartyVo.setFieldEn("status");
        kmsSellPartyVo.setStatus("ENABLE");
        String url = this.kmsProperties.getUrl() + "/sell/party/editBatch?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsSellPartyVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u542f\u7528\u5931\u8d25");
        }
    }

    @Override
    public void disable(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        KmsSellPartyVo kmsSellPartyVo = new KmsSellPartyVo();
        kmsSellPartyVo.setIds(ids);
        kmsSellPartyVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsSellPartyVo.setUserId(this.kmsProperties.getUserId());
        kmsSellPartyVo.setUsername(this.kmsProperties.getUsername());
        kmsSellPartyVo.setFieldEn("status");
        kmsSellPartyVo.setStatus("DISABLE");
        String url = this.kmsProperties.getUrl() + "/sell/party/editBatch?access_token=" + this.kmsProperties.getAccessToken();
        ResponseEntity entity = RestTemplateUtils.postForEntity((String)url, null, (Object)kmsSellPartyVo, String.class);
        if (!HttpStatus.OK.equals((Object)entity.getStatusCode())) {
            throw new BusinessException("\u7981\u7528\u5931\u8d25");
        }
    }

    protected boolean valid() {
        return !StringUtils.isEmpty((Object)this.kmsProperties.getAccessToken());
    }

    @Override
    public List<MdmSellPartyVo> list(MdmSellPartyVo mdmSellPartyVo) {
        if (!this.valid()) {
            return new ArrayList<MdmSellPartyVo>();
        }
        String directSystemId = mdmSellPartyVo.getDirectSystemId();
        if (StringUtils.isEmpty((Object)directSystemId)) {
            return new ArrayList<MdmSellPartyVo>();
        }
        KmsSellPartyPageReqVo kmsSellPartyPageReqVo = new KmsSellPartyPageReqVo();
        kmsSellPartyPageReqVo.setDirectSystemId(directSystemId);
        kmsSellPartyPageReqVo.setTenantryId(this.kmsProperties.getTenantryId());
        kmsSellPartyPageReqVo.setUserId(this.kmsProperties.getUserId());
        kmsSellPartyPageReqVo.setUsername(this.kmsProperties.getUsername());
        String url = this.kmsProperties.getUrl() + "/sell/party/findByList";
        ParameterizedTypeReference<KmsResultVo<List<KmsSellPartyVo>>> reference = new ParameterizedTypeReference<KmsResultVo<List<KmsSellPartyVo>>>(){};
        ResponseEntity entity = RestTemplateUtils.exchange((String)url, (HttpMethod)HttpMethod.POST, null, (Object)kmsSellPartyPageReqVo, (ParameterizedTypeReference)reference);
        List kmsSellPartyVos = Optional.ofNullable(entity).map(HttpEntity::getBody).map(KmsResultVo::getData).orElse(null);
        if (CollectionUtils.isEmpty((Collection)kmsSellPartyVos)) {
            return new ArrayList<MdmSellPartyVo>();
        }
        List<MdmSellPartyVo> mdmSellPartyVos = KmsConverter.INSTANCE.sellParty2Mdm(kmsSellPartyVos);
        String sellPartyName = mdmSellPartyVo.getSellPartyName();
        return mdmSellPartyVos.stream().filter(x -> StringUtils.isEmpty((Object)sellPartyName) || x.getSellPartyName().contains(sellPartyName)).collect(Collectors.toList());
    }
}

