/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.material.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.material.MdmMaterialReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;

public class MdmMaterialProvider {
    public String findListProvider(Map<String, Object> map) {
        final MdmMaterialReqVo vo = (MdmMaterialReqVo)map.get("vo");
        final List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){
            {
                this.SELECT("a.*,b.product_level_name");
                this.FROM("mdm_material a");
                this.LEFT_OUTER_JOIN("mdm_product_level b on a.product_level_code=b.product_level_code");
                if (StringUtils.isNotEmpty((String)vo.getEnableStatus())) {
                    this.WHERE("a.enable_status = #{vo.enableStatus}");
                }
                if (StringUtils.isNotEmpty((String)vo.getSaleCompany())) {
                    this.WHERE("a.sale_company = #{vo.saleCompany}");
                }
                if (StringUtils.isNotEmpty((String)vo.getMaterialType())) {
                    this.WHERE("a.material_type = #{vo.materialType}");
                }
                if (StringUtils.isNotEmpty((String)vo.getSaleUnit())) {
                    this.WHERE("a.sale_unit = #{vo.saleUnit}");
                }
                if (StringUtils.isNotEmpty((String)vo.getBaseUnit())) {
                    this.WHERE("a.base_unit = #{vo.baseUnit}");
                }
                if (StringUtils.isNotEmpty((String)vo.getMaterialCode())) {
                    this.WHERE("a.material_code like " + ProviderUtil.bindPercent(vo.getMaterialCode(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getMaterialName())) {
                    this.WHERE("a.material_name like " + ProviderUtil.bindPercent(vo.getMaterialName(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getAiCode())) {
                    this.WHERE("a.ai_code like " + ProviderUtil.bindPercent(vo.getAiCode(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getRuleCode())) {
                    this.WHERE("a.rule_code like " + ProviderUtil.bindPercent(vo.getRuleCode(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (CollectionUtil.listNotEmptyNotSizeZero((List)cvo)) {
                    this.WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
                }
                this.ORDER_BY("a.create_date desc,a.create_date_second desc");
            }
        }.toString();
    }
}

