/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.poi.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.poi.req.MdmAmapPoiDistanceReqVo;
import com.biz.crm.nebular.mdm.poi.req.MdmAmapPoiReqVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapPoiDistanceRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapPoiRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeVo;
import com.biz.crm.poi.mapper.MdmAmapPoiMapper;
import com.biz.crm.poi.model.MdmAmapPoiEntity;
import com.biz.crm.poi.service.MdmAmapPoiService;
import com.biz.crm.util.PageUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmAmapPoiServiceExpandImpl"})
public class MdmAmapPoiServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmAmapPoiMapper, MdmAmapPoiEntity>
implements MdmAmapPoiService {
    private static final Logger log = LoggerFactory.getLogger(MdmAmapPoiServiceImpl.class);
    @Resource
    private MdmAmapPoiMapper mdmAmapPoiMapper;

    @Override
    public PageResult<MdmAmapPoiRespVo> findAmapPoiList(MdmAmapPoiReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmAmapPoiRespVo> list = this.mdmAmapPoiMapper.findAmapPoiList((Page<MdmAmapPoiRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmAmapPoiDistanceRespVo> findAmapPoiDistancePageList(MdmAmapPoiDistanceReqVo reqVo) {
        Assert.hasText((String)reqVo.getLongitude(), (String)"\u7f3a\u5931\u7ecf\u5ea6");
        Assert.hasText((String)reqVo.getLatitude(), (String)"\u7f3a\u5931\u7eac\u5ea6");
        Assert.hasText((String)reqVo.getDistance(), (String)"\u7f3a\u5931\u8ddd\u79bb");
        if (new BigDecimal(reqVo.getDistance()).compareTo(new BigDecimal("50000")) > 0) {
            reqVo.setDistance("50000");
        }
        BigDecimal divide = new BigDecimal(reqVo.getDistance()).divide(new BigDecimal("111190"), 6, RoundingMode.HALF_UP);
        reqVo.setMaxLongitude(new BigDecimal(reqVo.getLongitude()).add(divide).toString());
        reqVo.setMinLongitude(new BigDecimal(reqVo.getLongitude()).subtract(divide).toString());
        reqVo.setMaxLatitude(new BigDecimal(reqVo.getLatitude()).add(divide).toString());
        reqVo.setMinLatitude(new BigDecimal(reqVo.getLatitude()).subtract(divide).toString());
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmAmapPoiDistanceRespVo> list = this.mdmAmapPoiMapper.findAmapPoiDistancePageList((Page<MdmAmapPoiDistanceRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmTerminalStatisticianTypeVo> statisticalType() {
        return this.mdmAmapPoiMapper.statisticalType();
    }
}

