/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.event.listener;

import com.alibaba.fastjson.JSON;
import com.biz.crm.customer.event.CustomerChangeEvent;
import com.biz.crm.customer.handler.CustomerChangeHandler;
import com.biz.crm.nebular.mdm.customer.CustomerChangeHandlerReqVo;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class CustomerEventListener {
    private static final Logger log = LoggerFactory.getLogger(CustomerEventListener.class);
    @Autowired(required=false)
    private List<CustomerChangeHandler> customerChangeHandlers;

    @EventListener
    @Async
    public void onCustomerChangeEvent(CustomerChangeEvent event) {
        CustomerChangeHandlerReqVo vo = (CustomerChangeHandlerReqVo)event.getSource();
        log.info("\u5ba2\u6237\u4fe1\u606f\u6539\u53d8\u4e8b\u4ef6\u76d1\u542c:{}", (Object)JSON.toJSONString((Object)vo));
        if (CollectionUtils.isNotEmpty(this.customerChangeHandlers)) {
            this.customerChangeHandlers.forEach(a -> a.handler(vo));
        }
        log.info("\u5ba2\u6237\u4fe1\u606f\u6539\u53d8\u4e8b\u4ef6\u76d1\u542c\u5904\u7406\u5b8c\u6210");
    }
}

