/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.MdmSfaAppletLoginService;
import com.biz.crm.login.service.MdmSystemLoginService;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.login.MdmAppletLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginTypeControlVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelWeChatReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserLoginLogRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelWeChatRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.user.service.MdmUserLoginLogAsyncService;
import com.biz.crm.user.service.MdmUserLoginLogService;
import com.biz.crm.user.service.MdmUserRelWeChatService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CookiesUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.LoginHelpUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmSfaAppletLoginServiceExpandImpl"})
public class MdmSfaAppletLoginServiceImpl
implements MdmSfaAppletLoginService {
    private static final Logger log = LoggerFactory.getLogger(MdmSfaAppletLoginServiceImpl.class);
    @Autowired
    private MdmUserRelWeChatService mdmUserRelWeChatService;
    @Resource
    private MdmUserService mdmUserService;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmUserLoginLogService mdmUserLoginLogService;
    @Resource
    private MdmUserLoginLogAsyncService mdmUserLoginLogAsyncService;
    @Resource
    private MdmSystemLoginService mdmSystemLoginService;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private MdmCustomerROrgService mdmCustomerROrgService;
    @Resource
    private MdmOrgService mdmOrgService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo login(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u8d26\u53f7");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        LoginHelpUtil.checkLock((String)reqVo.getUserName(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.USER_NAME);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(reqVo.getUserName(), null, null);
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        } else {
            LoginHelpUtil.addError((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo, true, false, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByPhone(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        LoginHelpUtil.checkLock((String)reqVo.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        } else {
            LoginHelpUtil.addError((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo, true, false, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByEmail(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getPassword(), (String)"\u7f3a\u5931\u5bc6\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        LoginHelpUtil.checkLock((String)reqVo.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        if (Md5EncryptionAndDecryption.checkPwd((String)reqVo.getPassword(), (String)user.getUserPassword())) {
            LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        } else {
            LoginHelpUtil.addError((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        }
        return this.doLoginThisSystem(user, reqVo, true, false, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByPhoneVerification(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        LoginHelpUtil.checkLock((String)reqVo.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE);
        String userName = LoginHelpUtil.checkVerificationCode((String)reqVo.getFromType(), (String)reqVo.getVerificationCode(), (String)reqVo.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getUserPhone().equals(user.getUserPhone()), (String)"\u624b\u673a\u53f7\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        return this.doLoginThisSystem(user, reqVo, true, false, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByEmailVerification(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        LoginHelpUtil.checkLock((String)reqVo.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL);
        String userName = LoginHelpUtil.checkVerificationCode((String)reqVo.getFromType(), (String)reqVo.getVerificationCode(), (String)reqVo.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getEmail().equals(user.getEmail()), (String)"\u90ae\u7bb1\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        return this.doLoginThisSystem(user, reqVo, true, false, true);
    }

    @Override
    public void sendVerificationForLoginByMessage(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        LoginHelpUtil.checkLock((String)reqVo.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        LoginHelpUtil.checkLock((String)user.getUserName(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.USER_NAME);
        LoginHelpUtil.checkLock((String)user.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL);
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        String verification = LoginHelpUtil.saveLoginVerificationCodeRelUser((String)reqVo.getFromType(), (String)user.getUserName(), (String)user.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
        LoginHelpUtil.sendVerificationCode((String)reqVo.getFromType(), (String)verification, (String)user.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
    }

    @Override
    public void sendVerificationForLoginByEmail(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getOpenId(), (String)"\u7f3a\u5931openId");
        LoginHelpUtil.checkLock((String)reqVo.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        LoginHelpUtil.checkLock((String)user.getUserName(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.USER_NAME);
        LoginHelpUtil.checkLock((String)user.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE);
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        String verification = LoginHelpUtil.saveLoginVerificationCodeRelUser((String)reqVo.getFromType(), (String)user.getUserName(), (String)user.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
        LoginHelpUtil.sendVerificationCode((String)reqVo.getFromType(), (String)verification, (String)user.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN);
    }

    @Override
    public void checkPhoneExistAndUsable(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        LoginHelpUtil.checkLock((String)reqVo.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
    }

    @Override
    public void checkEmailExistAndUsable(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        LoginHelpUtil.checkLock((String)reqVo.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
    }

    @Override
    public void sendVerificationForLoginAndResetByMessage(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        LoginHelpUtil.checkLock((String)reqVo.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, reqVo.getUserPhone(), null);
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        String verification = LoginHelpUtil.saveLoginVerificationCodeRelUser((String)reqVo.getFromType(), (String)user.getUserName(), (String)user.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
        LoginHelpUtil.sendVerificationCode((String)reqVo.getFromType(), (String)verification, (String)user.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
    }

    @Override
    public void sendVerificationForLoginAndResetByEmail(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        LoginHelpUtil.checkLock((String)reqVo.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(null, null, reqVo.getEmail());
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        String verification = LoginHelpUtil.saveLoginVerificationCodeRelUser((String)reqVo.getFromType(), (String)user.getUserName(), (String)user.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
        LoginHelpUtil.sendVerificationCode((String)reqVo.getFromType(), (String)verification, (String)user.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginAndResetByPhoneVerification(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserPhone(), (String)"\u7f3a\u5931\u624b\u673a\u53f7");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        String userName = LoginHelpUtil.checkVerificationCode((String)reqVo.getFromType(), (String)reqVo.getVerificationCode(), (String)reqVo.getUserPhone(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.PHONE, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getUserPhone().equals(user.getUserPhone()), (String)"\u624b\u673a\u53f7\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        return this.doLoginThisSystem(user, reqVo, false, true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginAndResetByEmailVerification(MdmAppletLoginReqVo reqVo) {
        Assert.hasText((String)reqVo.getEmail(), (String)"\u7f3a\u5931\u90ae\u7bb1");
        Assert.hasText((String)reqVo.getVerificationCode(), (String)"\u7f3a\u5931\u9a8c\u8bc1\u7801");
        String userName = LoginHelpUtil.checkVerificationCode((String)reqVo.getFromType(), (String)reqVo.getVerificationCode(), (String)reqVo.getEmail(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.EMAIL, (LoginHelpUtil.VerificationCodeType)LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(userName, null, null);
        Assert.isTrue((boolean)reqVo.getEmail().equals(user.getEmail()), (String)"\u90ae\u7bb1\u5173\u8054\u7528\u6237\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        return this.doLoginThisSystem(user, reqVo, false, true, false);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MdmLoginRespVo loginByOpenId(MdmAppletLoginReqVo reqVo) {
        String openId = reqVo.getOpenId();
        Assert.hasText((String)openId, (String)"\u7f3a\u5931openId");
        List<MdmUserRelWeChatRespVo> list = this.mdmUserRelWeChatService.getBindUserListByOpenId(openId, LoginFromTypeEnum.APPLET_SFA.getValue());
        Assert.notEmpty(list, (String)"\u5fae\u4fe1\u672a\u7ed1\u5b9a\u4efb\u4f55\u7528\u6237");
        Assert.isTrue((list.size() == 1 ? 1 : 0) != 0, (String)"\u5fae\u4fe1\u7ed1\u5b9a\u4e86\u591a\u4e2a\u7528\u6237");
        MdmUserRelWeChatRespVo one = list.get(0);
        if (YesNoEnum.yesNoEnum.Y.getValue().equals(ParamUtil.getParameterValue((String)"sfa_applet_user_unique_flag"))) {
            List<MdmUserRelWeChatRespVo> userRelList = this.mdmUserRelWeChatService.getBindWeChatListByUserName(one.getUserName(), LoginFromTypeEnum.APPLET_SFA.getValue());
            Assert.isTrue((userRelList.size() == 1 ? 1 : 0) != 0, (String)"\u7528\u6237\u7ed1\u5b9a\u4e86\u591a\u4e2a\u5fae\u4fe1\uff0c\u8bf7\u5148\u5728\u540e\u53f0\u89e3\u7ed1");
        }
        Assert.isTrue((boolean)YesNoEnum.yesNoEnum.ONE.getValue().equals(one.getLoginStatus()), (String)"\u5904\u4e8e\u9000\u51fa\u767b\u5f55\u72b6\u6001\uff0c\u9700\u8981\u91cd\u65b0\u767b\u5f55");
        LoginHelpUtil.checkLock((String)one.getUserName(), (LoginHelpUtil.AccountType)LoginHelpUtil.AccountType.USER_NAME);
        MdmUserRespVo user = this.mdmUserService.getUserForLogin(one.getUserName(), null, null);
        LoginHelpUtil.checkUserType((String)user.getUserType(), (String)reqVo.getFromType());
        LoginHelpUtil.checkUserLogin((String)user.getEnableStatus(), (String)user.getStartTime(), (String)user.getEndTime());
        LoginHelpUtil.unlock((String)user.getUserName(), (String)user.getUserPhone(), (String)user.getEmail());
        return this.doLoginThisSystem(user, reqVo, true, false, false);
    }

    @Override
    public MdmLoginTypeControlVo getLoginTypeControlConfig() {
        return this.mdmSystemLoginService.getLoginTypeControlConfig();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logout() {
        UserRedis user = UserUtils.getUser();
        if (user != null) {
            if (StringUtils.isNotEmpty((CharSequence)user.getOpenId())) {
                this.mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            UserUtils.logout();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logoutFromType() {
        UserRedis user = UserUtils.getUser();
        if (user != null) {
            if (StringUtils.isNotEmpty((CharSequence)user.getOpenId())) {
                this.mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            UserUtils.logout((String)LoginFromTypeEnum.APPLET_SFA.getValue());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logoutAll() {
        UserRedis user = UserUtils.getUser();
        if (user != null) {
            if (StringUtils.isNotEmpty((CharSequence)user.getOpenId())) {
                this.mdmUserRelWeChatService.changeLoginStatus(LoginFromTypeEnum.APPLET_SFA.getValue(), user.getOpenId(), YesNoEnum.yesNoEnum.ZERO.getValue());
            }
            UserUtils.deleteUser((String)user.getUsername());
        }
    }

    protected MdmLoginRespVo doLoginThisSystem(MdmUserRespVo user, MdmAppletLoginReqVo reqVo, boolean getLastLoginLog, boolean resetPassword, boolean bind) {
        if (bind && StringUtils.isNotEmpty((CharSequence)reqVo.getOpenId())) {
            MdmUserRelWeChatReqVo bindReq = new MdmUserRelWeChatReqVo();
            CrmBeanUtil.copyProperties((Object)reqVo, (Object)bindReq);
            bindReq.setUserName(user.getUserName());
            bindReq.setOriginModule(reqVo.getFromType());
            bindReq.setLoginStatus(YesNoEnum.yesNoEnum.ONE.getValue());
            this.mdmUserRelWeChatService.bind(bindReq);
        }
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        String token = UUID.randomUUID().toString().replaceAll("-", "");
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(user.getUserName());
        userRedis.setRealname(user.getFullName());
        userRedis.setUsertype(user.getUserType());
        mdmLoginRespVo.setUserCode(user.getUserCode());
        mdmLoginRespVo.setLoginUserToken(token);
        mdmLoginRespVo.setUserName(user.getUserName());
        mdmLoginRespVo.setFullName(user.getFullName());
        mdmLoginRespVo.setUserType(user.getUserType());
        mdmLoginRespVo.setLanguage(userRedis.getLanguage());
        if (UserTypeEnum.USER.getCode().equals(user.getUserType())) {
            MdmPositionUserOrgRespVo positionUserOrg = this.mdmPositionService.getCurrentPositionByUserName(user.getUserName());
            userRedis.setPoscode(positionUserOrg.getPositionCode());
            userRedis.setPosname(positionUserOrg.getPositionName());
            userRedis.setOrgcode(positionUserOrg.getOrgCode());
            userRedis.setOrgname(positionUserOrg.getOrgName());
            mdmLoginRespVo.setPositionCode(positionUserOrg.getPositionCode());
            mdmLoginRespVo.setPositionName(positionUserOrg.getPositionName());
            mdmLoginRespVo.setOrgCode(positionUserOrg.getOrgCode());
            mdmLoginRespVo.setOrgName(positionUserOrg.getOrgName());
        } else if (UserTypeEnum.CUSTOMER.getCode().equals(user.getUserType()) || UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(user.getUserType())) {
            MdmCustomerMsgRespVo customer = this.mdmCustomerMsgService.getUserCurrentCustomer(user.getUserName());
            if (customer == null) {
                throw new BusinessException("\u5f53\u524d\u8d26\u53f7\u672a\u5173\u8054\u53ef\u7528\u7684\u5ba2\u6237\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            Map<String, List<String>> orgCodeListMap = this.mdmCustomerROrgService.findOrgCodeList(Collections.singletonList(customer.getCustomerCode()));
            String orgCode = null;
            String orgName = null;
            if (orgCodeListMap.containsKey(customer.getCustomerCode())) {
                List<String> orgCodeList = orgCodeListMap.get(customer.getCustomerCode());
                Map<String, String> orgNameMap = this.mdmOrgService.findOrgNameMap(orgCodeList);
                orgName = orgCodeList.stream().map(orgNameMap::get).collect(Collectors.joining(","));
                orgCode = String.join((CharSequence)",", orgCodeList);
            }
            userRedis.setCustcode(customer.getCustomerCode());
            userRedis.setCustname(customer.getCustomerName());
            userRedis.setOrgcode(orgCode);
            userRedis.setOrgname(orgName);
            mdmLoginRespVo.setCustomerCode(customer.getCustomerCode());
            mdmLoginRespVo.setCustomerName(customer.getCustomerName());
            mdmLoginRespVo.setOrgCode(orgCode);
            mdmLoginRespVo.setOrgName(orgName);
            mdmLoginRespVo.setMdmCustomerMsgRespVo(customer);
        }
        userRedis.setFromtype(reqVo.getFromType());
        UserUtils.setUser((String)token, (UserRedis)userRedis);
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        HttpServletResponse response = HttpServletRequestUtil.getResponse();
        CookiesUtil.doCoke((HttpServletRequest)request, (HttpServletResponse)response, (String)token, (String)"loginUserToken");
        if (getLastLoginLog) {
            MdmUserLoginLogRespVo lastLoginLog = this.mdmUserLoginLogService.getLastLoginLog(user.getUserName(), null);
            mdmLoginRespVo.setLastLoginLog(lastLoginLog);
        }
        if (resetPassword) {
            mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
            this.mdmUserService.setUserForceChangePassword(user.getUserName());
        } else if (YesNoEnum.yesNoEnum.ONE.getValue().equals(user.getForceChangePassword())) {
            mdmLoginRespVo.setResetPassword(YesNoEnum.yesNoEnum.ONE.getValue());
        }
        this.mdmUserLoginLogAsyncService.saveLoginLog(request, user.getUserName(), user.getFullName(), reqVo.getFromType(), DateUtil.dateNowHms());
        return mdmLoginRespVo;
    }
}

