/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.parametermanage.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.parametermanage.req.MdmParameterManageReqVo;
import com.biz.crm.nebular.mdm.parametermanage.resp.MdmParameterManageRespVo;
import com.biz.crm.parameter.vo.ParameterVo;
import com.biz.crm.parametermanage.mapper.MdmParameterManageMapper;
import com.biz.crm.parametermanage.model.MdmParameterManageEntity;
import com.biz.crm.parametermanage.service.MdmParameterManageService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmParameterManageServiceExpandImpl"})
public class MdmParameterManageServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmParameterManageMapper, MdmParameterManageEntity>
implements MdmParameterManageService {
    private static final Logger log = LoggerFactory.getLogger(MdmParameterManageServiceImpl.class);
    @Resource
    private MdmParameterManageMapper mdmParameterManageMapper;

    @Override
    public PageResult<MdmParameterManageRespVo> findList(MdmParameterManageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmParameterManageRespVo> list = this.mdmParameterManageMapper.findList((Page<MdmParameterManageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmParameterManageRespVo query(MdmParameterManageReqVo reqVo) {
        MdmParameterManageEntity one;
        if ((StringUtils.isNotEmpty((String)reqVo.getId()) || StringUtils.isNotEmpty((String)reqVo.getParameterCode())) && (one = (MdmParameterManageEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).eq(StringUtils.isNotEmpty((String)reqVo.getParameterCode()), MdmParameterManageEntity::getParameterCode, (Object)reqVo.getParameterCode())).one()) != null) {
            return (MdmParameterManageRespVo)CrmBeanUtil.copy((Object)one, MdmParameterManageRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmParameterManageReqVo reqVo) {
        this.verify(reqVo);
        MdmParameterManageEntity entity = (MdmParameterManageEntity)CrmBeanUtil.copy((Object)reqVo, MdmParameterManageEntity.class);
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmParameterManageReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u7f3a\u5931id");
        this.verify(reqVo);
        MdmParameterManageEntity entity = (MdmParameterManageEntity)this.getById((Serializable)((Object)reqVo.getId()));
        Assert.notNull((Object)entity, (String)"\u65e0\u6548\u7684id");
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmParameterManageEntity.class));
        ParamUtil.deleteRedisCache((String)entity.getParameterCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).select(new SFunction[]{MdmParameterManageEntity::getParameterCode}).list();
        if (list != null) {
            list.stream().map(MdmParameterManageEntity::getParameterCode).forEach(ParamUtil::deleteRedisCache);
        }
        this.removeByIds(ids);
    }

    @Override
    public void deleteAllCache() {
        List list = this.lambdaQuery().select(new SFunction[]{MdmParameterManageEntity::getParameterCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            this.deleteCacheByCodeList(list.stream().map(MdmParameterManageEntity::getParameterCode).collect(Collectors.toList()));
        }
    }

    @Override
    public void deleteCacheByIds(List<String> ids) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(ids) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).select(new SFunction[]{MdmParameterManageEntity::getParameterCode}).list()))) {
            this.deleteCacheByCodeList(list.stream().map(MdmParameterManageEntity::getParameterCode).collect(Collectors.toList()));
        }
    }

    @Override
    public void deleteCacheByCodeList(List<String> codes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(codes)) {
            codes.forEach(ParamUtil::deleteRedisCache);
        }
    }

    @Override
    public List<ParameterVo> getParameterRedisList(List<String> parameterCodeList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(parameterCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmParameterManageEntity::getParameterCode, parameterCodeList)).list()))) {
            return CrmBeanUtil.copyList((List)list, ParameterVo.class);
        }
        return new ArrayList<ParameterVo>();
    }

    private void verify(MdmParameterManageReqVo reqVo) {
        Assert.hasText((String)reqVo.getParameterCode(), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getParameterName(), (String)"\u53c2\u6570\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDefaultValue(), (String)"\u9ed8\u8ba4\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getParameterValue(), (String)"\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmParameterManageEntity::getParameterCode, (Object)reqVo.getParameterCode())).select(new SFunction[]{BaseIdEntity::getId}).list().stream().filter(x -> StringUtils.isEmpty((String)reqVo.getId()) || !reqVo.getId().equals(x.getId())).collect(Collectors.toList());
        Assert.isTrue((boolean)CollectionUtil.listEmpty(list), (String)"\u53c2\u6570\u91cd\u590d");
    }
}

