/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.kms.config;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.KmsSyncEnum;
import com.biz.crm.kms.config.KmsProperties;
import com.biz.crm.util.DictUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.util.StringUtils;

public class MapperConfig {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String ERROR_MSG = "KMS\u540c\u6b65\u5931\u8d25";

    public static ObjectNode instance(KmsProperties kmsProperties) {
        ObjectNode objectNode = MAPPER.createObjectNode();
        objectNode.put("tenantryId", kmsProperties.getTenantryId());
        objectNode.put("userId", kmsProperties.getUserId());
        objectNode.put("username", kmsProperties.getUsername());
        return objectNode;
    }

    public static ObjectNode instance() {
        return MAPPER.createObjectNode();
    }

    public static ObjectNode instance(KmsProperties kmsProperties, int current, int size) {
        ObjectNode objectNode = MAPPER.createObjectNode();
        objectNode.put("tenantryId", kmsProperties.getTenantryId());
        objectNode.put("userId", kmsProperties.getUserId());
        objectNode.put("username", kmsProperties.getUsername());
        ObjectNode page = MAPPER.createObjectNode();
        page.put("current", current);
        page.put("size", size);
        objectNode.set("page", (JsonNode)page);
        return objectNode;
    }

    public static boolean valid(KmsProperties kmsProperties) {
        return kmsProperties != null && !StringUtils.isEmpty((Object)kmsProperties.getAccessToken());
    }

    public static boolean validStore(KmsProperties kmsProperties) {
        return MapperConfig.valid(kmsProperties) && MapperConfig.storeSync();
    }

    public static boolean validProduct(KmsProperties kmsProperties) {
        return MapperConfig.valid(kmsProperties) && MapperConfig.productSync();
    }

    public static boolean storeSync() {
        String kmsSync = DictUtil.dictValue((String)KmsSyncEnum.KMS_SYNC.getCode(), (String)KmsSyncEnum.KMS_SYNC.getCode());
        String kmsStoreSync = DictUtil.dictValue((String)KmsSyncEnum.KMS_SYNC.getCode(), (String)KmsSyncEnum.KMS_STORE.getCode());
        String code = String.valueOf(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        return code.equals(kmsSync) && code.equals(kmsStoreSync);
    }

    public static boolean productSync() {
        String kmsSync = DictUtil.dictValue((String)KmsSyncEnum.KMS_SYNC.getCode(), (String)KmsSyncEnum.KMS_SYNC.getCode());
        String kmsProductSync = DictUtil.dictValue((String)KmsSyncEnum.KMS_SYNC.getCode(), (String)KmsSyncEnum.KMS_PRODUCT.getCode());
        String code = String.valueOf(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        return code.equals(kmsSync) && code.equals(kmsProductSync);
    }
}

