/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.TerminalSupplyTypeEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCorrelatedTerminalReplaceReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCorrelatedTerminalReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTerminalReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTerminalRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalSupplyDetailVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.terminal.mapper.MdmTerminalSupplyMapper;
import com.biz.crm.terminal.model.MdmTerminalSupplyDetailEntity;
import com.biz.crm.terminal.model.MdmTerminalSupplyEntity;
import com.biz.crm.terminal.service.MdmTerminalSupplyDetailService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmTerminalSupplyServiceExpandImpl"})
public class MdmTerminalSupplyServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmTerminalSupplyMapper, MdmTerminalSupplyEntity>
implements MdmTerminalSupplyService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalSupplyServiceImpl.class);
    @Autowired
    private MdmTerminalSupplyDetailService mdmTerminalSupplyDetailService;
    @Autowired
    private MdmTerminalSupplyMapper mdmTerminalSupplyMapper;
    @Autowired
    private MdmPositionService mdmPositionService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByCodes(List<String> terminalCodes) {
        if (CollectionUtils.isEmpty(terminalCodes)) {
            return;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalSupplyEntity::getTerminalCode, terminalCodes)).select(new SFunction[]{BaseIdEntity::getId}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List supplyIds = list.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)this.mdmTerminalSupplyDetailService.lambdaUpdate().in(MdmTerminalSupplyDetailEntity::getSupplyId, supplyIds)).remove();
        this.removeByIds(supplyIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setUpSupply(MdmTerminalVo mdmTerminalVo) {
        String terminalCode = mdmTerminalVo.getTerminalCode();
        org.springframework.util.Assert.hasText((String)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalSupplyEntity::getTerminalCode, (Object)terminalCode)).select(new SFunction[]{BaseIdEntity::getId}).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List supplyIds = list.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)this.mdmTerminalSupplyDetailService.lambdaUpdate().in(MdmTerminalSupplyDetailEntity::getSupplyId, supplyIds)).remove();
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmTerminalSupplyEntity::getTerminalCode, (Object)terminalCode)).remove();
        if (CollectionUtil.listEmpty((List)mdmTerminalVo.getSupplys())) {
            return;
        }
        List supplys = mdmTerminalVo.getSupplys();
        if (!CollectionUtils.isEmpty((Collection)supplys)) {
            for (MdmTerminalSupplyVo supply : supplys) {
                List details;
                if (StringUtils.isEmpty((String)supply.getSupplyType())) {
                    supply.setSupplyType(TerminalSupplyTypeEnum.DEFAULT.getValue());
                }
                supply.setId(UUID.randomUUID().toString());
                supply.setTerminalCode(terminalCode);
                org.springframework.util.Assert.hasText((String)supply.getSupplyType(), (String)"\u7f3a\u5931\u4f9b\u8d27\u5173\u7cfb\u7c7b\u578b");
                if (TerminalSupplyTypeEnum.CUSTOMER_USER.getValue().equals(supply.getSupplyType())) {
                    org.springframework.util.Assert.hasText((String)supply.getCustomerCode(), (String)"\u7f3a\u5931\u5ba2\u6237");
                }
                if (!CollectionUtils.isEmpty((Collection)(details = supply.getDetails()))) {
                    for (MdmTerminalSupplyDetailVo detail : details) {
                        org.springframework.util.Assert.hasText((String)detail.getCode(), (String)("[\u7ec8\u7aef:{" + terminalCode + "}]\u4f9b\u8d27\u5173\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
                        org.springframework.util.Assert.hasText((String)detail.getName(), (String)("[\u7ec8\u7aef:{" + terminalCode + "}]\u4f9b\u8d27\u5173\u7cfb\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
                        org.springframework.util.Assert.hasText((String)detail.getDataType(), (String)("[\u7ec8\u7aef:{" + terminalCode + "}]\u4f9b\u8d27\u5173\u7cfb\u4ea7\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
                        detail.setId(UUID.randomUUID().toString());
                        detail.setSupplyId(supply.getId());
                    }
                    this.mdmTerminalSupplyDetailService.saveBatch(CrmBeanUtil.copyList((List)details, MdmTerminalSupplyDetailEntity.class));
                }
                this.save(CrmBeanUtil.copy((Object)supply, MdmTerminalSupplyEntity.class));
            }
        }
    }

    @Override
    public List<MdmTerminalSupplyVo> findByTerminalCode(String terminalCode) {
        org.springframework.util.Assert.hasText((String)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<Object> list = this.mdmTerminalSupplyMapper.queryDetails(terminalCode);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<MdmTerminalSupplyVo>();
        }
        List supplyIds = list.stream().map(UuidVo::getId).collect(Collectors.toList());
        List supplyDetailEntities = ((LambdaQueryChainWrapper)this.mdmTerminalSupplyDetailService.lambdaQuery().in(MdmTerminalSupplyDetailEntity::getSupplyId, supplyIds)).list();
        if (!CollectionUtils.isEmpty((Collection)supplyDetailEntities)) {
            Map<String, List<MdmTerminalSupplyDetailEntity>> detailsMap = supplyDetailEntities.stream().collect(Collectors.groupingBy(MdmTerminalSupplyDetailEntity::getSupplyId));
            for (MdmTerminalSupplyVo mdmTerminalSupplyVo : list) {
                List<MdmTerminalSupplyDetailEntity> source = detailsMap.get(mdmTerminalSupplyVo.getId());
                if (source == null) {
                    mdmTerminalSupplyVo.setDetails(new ArrayList());
                    continue;
                }
                List detailVos = CrmBeanUtil.copyList(source, MdmTerminalSupplyDetailVo.class);
                mdmTerminalSupplyVo.setDetails(detailVos);
            }
        } else {
            list = list.stream().peek(x -> x.setDetails(new ArrayList())).collect(Collectors.toList());
        }
        return list;
    }

    @Override
    public void customerRelationTerminal(MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo) {
        List oldTerminalCodeList;
        String customerCode = mdmCustomerCorrelatedTerminalReqVo.getCustomerCode();
        org.springframework.util.Assert.hasText((String)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Set terminalCodeList = mdmCustomerCorrelatedTerminalReqVo.getTerminalCodeList();
        org.springframework.util.Assert.notEmpty((Collection)terminalCodeList, (String)"\u7ec8\u7aef\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalSupplyEntity::getCustomerCode, (Object)customerCode)).in(MdmTerminalSupplyEntity::getTerminalCode, (Collection)terminalCodeList)).select(new SFunction[]{MdmTerminalSupplyEntity::getTerminalCode}).list();
        if (!CollectionUtils.isEmpty((Collection)list) && !CollectionUtils.isEmpty(oldTerminalCodeList = list.stream().filter(x -> x != null && !StringUtils.isEmpty((String)x.getTerminalCode())).map(MdmTerminalSupplyEntity::getTerminalCode).collect(Collectors.toList()))) {
            terminalCodeList.removeIf(oldTerminalCodeList::contains);
        }
        if (CollectionUtils.isEmpty((Collection)terminalCodeList)) {
            return;
        }
        List collect = terminalCodeList.stream().map(x -> {
            MdmTerminalSupplyEntity mdmTerminalSupplyEntity = new MdmTerminalSupplyEntity();
            mdmTerminalSupplyEntity.setId(UUID.randomUUID().toString());
            mdmTerminalSupplyEntity.setTerminalCode(x);
            mdmTerminalSupplyEntity.setCustomerCode(customerCode);
            mdmTerminalSupplyEntity.setSupplyType(TerminalSupplyTypeEnum.DEFAULT.getValue());
            return mdmTerminalSupplyEntity;
        }).collect(Collectors.toList());
        this.saveBatch(collect);
    }

    @Override
    public PageResult<MdmCustomerTerminalRespVo> correlatedCustomerPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo) {
        org.springframework.util.Assert.hasText((String)mdmCustomerTerminalReqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Page page = PageUtil.buildPage((Integer)mdmCustomerTerminalReqVo.getPageNum(), (Integer)mdmCustomerTerminalReqVo.getPageSize());
        List<MdmCustomerTerminalRespVo> list = this.mdmTerminalSupplyMapper.correlatedCustomerPage((Page<MdmCustomerTerminalRespVo>)page, mdmCustomerTerminalReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmCustomerTerminalRespVo> unCorrelatedAnyCustomerPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo) {
        Page page = new Page((long)mdmCustomerTerminalReqVo.getPageNum().intValue(), (long)mdmCustomerTerminalReqVo.getPageSize().intValue());
        List<MdmCustomerTerminalRespVo> list = this.mdmTerminalSupplyMapper.uncorrelatedAnyCustomer((Page<MdmCustomerTerminalRespVo>)page, mdmCustomerTerminalReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmCustomerTerminalRespVo> unCorrelatedCurrentCustomerPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo) {
        String customerCode = mdmCustomerTerminalReqVo.getCustomerCode();
        org.springframework.util.Assert.hasText((String)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List mdmTerminalSupplyEntities = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalSupplyEntity::getCustomerCode, (Object)customerCode)).select(new SFunction[]{MdmTerminalSupplyEntity::getTerminalCode}).list();
        if (!CollectionUtils.isEmpty((Collection)mdmTerminalSupplyEntities)) {
            List terminalCodeList = mdmTerminalSupplyEntities.stream().filter(x -> x != null && !StringUtils.isEmpty((String)x.getTerminalCode())).map(MdmTerminalSupplyEntity::getTerminalCode).distinct().collect(Collectors.toList());
            mdmCustomerTerminalReqVo.setTerminalCodeList(terminalCodeList);
        }
        Page page = new Page((long)mdmCustomerTerminalReqVo.getPageNum().intValue(), (long)mdmCustomerTerminalReqVo.getPageSize().intValue());
        List<MdmCustomerTerminalRespVo> list = this.mdmTerminalSupplyMapper.uncorrelatedAnyCustomer((Page<MdmCustomerTerminalRespVo>)page, mdmCustomerTerminalReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void replaceCustomer(MdmCustomerCorrelatedTerminalReplaceReqVo mdmCustomerCorrelatedTerminalReplaceReqVo) {
        Assert.hasText((String)mdmCustomerCorrelatedTerminalReplaceReqVo.getOldCustomerCode(), (String)"\u539f\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmCustomerCorrelatedTerminalReplaceReqVo.getNewCustomerCode(), (String)"\u65b0\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)mdmCustomerCorrelatedTerminalReplaceReqVo.getTerminalCodeList(), (String)"\u7ec8\u7aef\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmTerminalSupplyEntity::getCustomerCode, (Object)mdmCustomerCorrelatedTerminalReplaceReqVo.getOldCustomerCode())).in(MdmTerminalSupplyEntity::getTerminalCode, (Collection)mdmCustomerCorrelatedTerminalReplaceReqVo.getTerminalCodeList())).set(MdmTerminalSupplyEntity::getCustomerCode, (Object)mdmCustomerCorrelatedTerminalReplaceReqVo.getNewCustomerCode())).update();
    }

    @Override
    public void unbind(MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo) {
        org.springframework.util.Assert.hasText((String)mdmCustomerCorrelatedTerminalReqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        org.springframework.util.Assert.notEmpty((Collection)mdmCustomerCorrelatedTerminalReqVo.getTerminalCodeList(), (String)"\u7ec8\u7aef\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmTerminalSupplyEntity::getCustomerCode, (Object)mdmCustomerCorrelatedTerminalReqVo.getCustomerCode())).in(MdmTerminalSupplyEntity::getTerminalCode, (Collection)mdmCustomerCorrelatedTerminalReqVo.getTerminalCodeList())).set(MdmTerminalSupplyEntity::getCustomerCode, null)).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addTerminalPosition(List<String> terminalCodeList, String positionCode) {
        MdmPositionRespVo one;
        if (CollectionUtil.listNotEmptyNotSizeZero(terminalCodeList) && StringUtils.isNotEmpty((String)positionCode) && (one = this.mdmPositionService.queryByPositionCode(positionCode)) != null) {
            this.addTerminalPosition(terminalCodeList, positionCode, one.getOrgCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addTerminalPosition(List<String> terminalCodeList, String positionCode, String orgCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero(terminalCodeList) && StringUtils.isNotEmpty((String)positionCode)) {
            terminalCodeList.forEach(terminalCode -> {
                MdmTerminalSupplyEntity entity = new MdmTerminalSupplyEntity();
                entity.setTerminalCode(terminalCode);
                entity.setPositionCode(positionCode);
                entity.setOrgCode(orgCode);
                entity.setSupplyType(TerminalSupplyTypeEnum.DEFAULT.getValue());
                this.save(entity);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbindByIds(List<String> ids) {
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            this.removeByIds(ids);
            ((LambdaUpdateChainWrapper)this.mdmTerminalSupplyDetailService.lambdaUpdate().in(MdmTerminalSupplyDetailEntity::getSupplyId, ids)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceRelationPosition(List<String> ids, String positionCode) {
        MdmPositionRespVo one;
        if (CollectionUtil.listNotEmptyNotSizeZero(ids) && StringUtils.isNotEmpty((String)positionCode) && (one = this.mdmPositionService.queryByPositionCode(positionCode)) != null) {
            this.replaceRelationPosition(ids, positionCode, one.getOrgCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceRelationPosition(List<String> ids, String positionCode, String orgCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero(ids) && StringUtils.isNotEmpty((String)positionCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(MdmTerminalSupplyEntity::getPositionCode, (Object)positionCode)).set(MdmTerminalSupplyEntity::getOrgCode, (Object)orgCode)).update();
        }
    }

    @Override
    public List<String> findTerminalByCustomer(List<String> customerCodeList) {
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        List partition = Lists.partition(customerCodeList, (int)500);
        for (List part : partition) {
            list.addAll(((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalSupplyEntity::getCustomerCode, (Collection)part)).select(new SFunction[]{MdmTerminalSupplyEntity::getTerminalCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((String)x.getTerminalCode())).map(MdmTerminalSupplyEntity::getTerminalCode).collect(Collectors.toList()));
        }
        return list;
    }

    @Override
    public List<String> findCustomerCodeListByTerminalCode(String terminalCode) {
        Set set;
        List collect;
        List list;
        if (StringUtils.isNotEmpty((String)terminalCode) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalSupplyEntity::getTerminalCode, (Object)terminalCode)).list())) && CollectionUtil.listNotEmptyNotSizeZero(collect = list.stream().filter(x -> StringUtils.isNotEmpty((String)x.getCustomerCode())).collect(Collectors.toList())) && !(set = collect.stream().map(MdmTerminalSupplyEntity::getCustomerCode).collect(Collectors.toSet())).isEmpty()) {
            return new ArrayList<String>(set);
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> findTerminalByPositionCodeList(List<String> positionCodeList) {
        if (CollectionUtils.isEmpty(positionCodeList)) {
            return new ArrayList<String>();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalSupplyEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmTerminalSupplyEntity::getTerminalCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((String)x.getTerminalCode())).map(MdmTerminalSupplyEntity::getTerminalCode).distinct().collect(Collectors.toList());
    }

    @Override
    public List<MdmTerminalSupplyVo> findTerminalSupply(MdmTerminalVo mdmTerminalVo) {
        if (CollectionUtils.isEmpty((Collection)mdmTerminalVo.getTerminalCodeList())) {
            return new ArrayList<MdmTerminalSupplyVo>();
        }
        return this.mdmTerminalSupplyMapper.findTerminalSupply(mdmTerminalVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addCustomerUserTerminalSupply(List<String> terminalCodeList, String userName) {
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero(terminalCodeList)) {
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalSupplyEntity::getSupplyType, (Object)TerminalSupplyTypeEnum.CUSTOMER_USER.getValue())).eq(MdmTerminalSupplyEntity::getUserName, (Object)userName)).list();
            Set terminalCodeSet = list.stream().map(MdmTerminalSupplyEntity::getTerminalCode).collect(Collectors.toSet());
            for (String terminalCode : terminalCodeList) {
                if (terminalCodeSet.contains(terminalCode)) continue;
                MdmTerminalSupplyEntity supply = new MdmTerminalSupplyEntity();
                supply.setSupplyType(TerminalSupplyTypeEnum.CUSTOMER_USER.getValue());
                supply.setTerminalCode(terminalCode);
                supply.setUserName(userName);
                this.save(supply);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delCustomerUserTerminalSupply(List<String> terminalCodeList, String userName) {
        List list;
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero(terminalCodeList) && (list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalSupplyEntity::getSupplyType, (Object)TerminalSupplyTypeEnum.CUSTOMER_USER.getValue())).eq(MdmTerminalSupplyEntity::getUserName, (Object)userName)).in(MdmTerminalSupplyEntity::getTerminalCode, terminalCodeList)).list()).size() > 0) {
            List supplyIds = list.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)this.mdmTerminalSupplyDetailService.lambdaUpdate().in(MdmTerminalSupplyDetailEntity::getSupplyId, supplyIds)).remove();
            this.removeByIds(supplyIds);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceCustomerUserTerminalSupply(List<String> terminalCodeList, String userName, String newUserName) {
        List list;
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero(terminalCodeList) && StringUtils.isNotEmpty((String)newUserName) && (list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalSupplyEntity::getSupplyType, (Object)TerminalSupplyTypeEnum.CUSTOMER_USER.getValue())).eq(MdmTerminalSupplyEntity::getUserName, (Object)userName)).in(MdmTerminalSupplyEntity::getTerminalCode, terminalCodeList)).list()).size() > 0) {
            Set terminalCodeSet = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalSupplyEntity::getSupplyType, (Object)TerminalSupplyTypeEnum.CUSTOMER_USER.getValue())).eq(MdmTerminalSupplyEntity::getUserName, (Object)newUserName)).in(MdmTerminalSupplyEntity::getTerminalCode, terminalCodeList)).select(new SFunction[]{MdmTerminalSupplyEntity::getTerminalCode}).list().stream().map(MdmTerminalSupplyEntity::getTerminalCode).collect(Collectors.toSet());
            list.forEach(item -> {
                if (!terminalCodeSet.contains(item.getTerminalCode())) {
                    item.setUserName(newUserName);
                    this.updateById(item);
                } else {
                    ((LambdaUpdateChainWrapper)this.mdmTerminalSupplyDetailService.lambdaUpdate().eq(MdmTerminalSupplyDetailEntity::getSupplyId, (Object)item.getId())).remove();
                    this.removeById((Serializable)((Object)item.getId()));
                }
            });
        }
    }

    @Override
    public List<MdmCustomerRespVo> findBySupply(MdmTerminalSupplyVo mdmTerminalSupplyVo) {
        mdmTerminalSupplyVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        mdmTerminalSupplyVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        return this.mdmTerminalSupplyMapper.findBySupply(mdmTerminalSupplyVo);
    }
}

