/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReadReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeReadRespVo;
import com.biz.crm.notice.service.IMdmNoticeReadService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmNoticeReadController"})
@Api(tags={"\u516c\u544a\u8bfb\u53d6\u4fe1\u606f "})
public class MdmNoticeReadController {
    private static final Logger log = LoggerFactory.getLogger(MdmNoticeReadController.class);
    @Autowired
    private IMdmNoticeReadService mdmNoticeReadService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<MdmNoticeReadRespVo>> list(@RequestBody MdmNoticeReadReqVo mdmNoticeReadReqVo) {
        PageResult<MdmNoticeReadRespVo> result = this.mdmNoticeReadService.findList(mdmNoticeReadReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<MdmNoticeReadRespVo> query(@RequestBody MdmNoticeReadReqVo mdmNoticeReadReqVo) {
        MdmNoticeReadRespVo respVo = this.mdmNoticeReadService.query(mdmNoticeReadReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u516c\u544a\u8bfb\u53d6\u65b0\u589e", httpMethod="GET")
    @GetMapping(value={"/readSign"})
    @CrmLog
    public Result save(@RequestParam(value="noticeCode") String noticeCode) {
        this.mdmNoticeReadService.save(noticeCode);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody MdmNoticeReadReqVo mdmNoticeReadReqVo) {
        this.mdmNoticeReadService.update(mdmNoticeReadReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.mdmNoticeReadService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.mdmNoticeReadService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.mdmNoticeReadService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }
}

