/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.mdm.ApprovalType;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.kms.service.MdmStoreService;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmCustomerTerminalVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalCurrentAndSubVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalDistanceContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalSelectReqVo;
import com.biz.crm.nebular.mdm.terminal.req.TerminalChangeHandlerReqVo;
import com.biz.crm.nebular.mdm.terminal.req.UpdateCoordinateReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalSelectRespVo;
import com.biz.crm.nebular.sfa.tpmact.SfaTpmOrgRCusVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.region.service.MdmRegionService;
import com.biz.crm.terminal.event.TerminalChangeEvent;
import com.biz.crm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.model.MdmTerminalROrgEntity;
import com.biz.crm.terminal.model.MdmTerminalSupplyEntity;
import com.biz.crm.terminal.service.MdmTerminalContactService;
import com.biz.crm.terminal.service.MdmTerminalElasticsearchService;
import com.biz.crm.terminal.service.MdmTerminalROrgService;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.terminal.vo.UpdateTerminalCusOrgCodeVo;
import com.biz.crm.util.ActivityUtils;
import com.biz.crm.util.ApprovalConfigUtil;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CustomerOrgUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.ReflectUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"MdmTerminalServiceExpandImpl"})
public class MdmTerminalServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmTerminalMapper, MdmTerminalEntity>
implements MdmTerminalService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalServiceImpl.class);
    private static final int PARTION_SIZE = 500;
    private static final int INITIAL_CAPACITY = 16;
    @Resource
    private MdmTerminalMapper mdmTerminalMapper;
    @Autowired
    private MdmTerminalContactService mdmTerminalContactService;
    @Autowired
    private MdmTerminalSupplyService mdmTerminalSupplyService;
    @Autowired
    private MdmOrgService mdmOrgService;
    @Autowired
    private MdmPositionService mdmPositionService;
    @Autowired
    private RocketMQProducer rocketMQProducer;
    @Value(value="${rocketmq.topic}${rocketmq.environment-variable}")
    private String topic;
    @Autowired
    private MdmTerminalROrgService mdmTerminalROrgService;
    @Autowired
    private TaActBaseFeign taActBaseFeign;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Autowired
    private MdmTerminalElasticsearchService elasticsearchService;
    @Autowired
    private MdmStoreService mdmStoreService;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Resource
    private ApplicationContext applicationContext;

    @Override
    public PageResult<MdmTerminalVo> findList(MdmTerminalVo mdmTerminalReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmTerminalReqVo.getPageNum(), (Integer)mdmTerminalReqVo.getPageSize());
        if (!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getCode())) {
            List<String> orgCodeList = this.mdmOrgService.findAllChildrenOrgCodeList(null, mdmTerminalReqVo.getCode());
            mdmTerminalReqVo.setOrgCodeList(orgCodeList);
        }
        List<MdmTerminalVo> list = this.mdmTerminalMapper.findList((Page<MdmTerminalVo>)page, mdmTerminalReqVo);
        this.setUpOrgName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    protected void setUpOrgName(List<MdmTerminalVo> list) {
        Collection<List<String>> values;
        List<String> orgCodeList;
        Map<String, String> orgNameMap;
        Map<String, List<String>> terminalOrgMap;
        List<String> terminalCodeList;
        if (!(org.springframework.util.CollectionUtils.isEmpty(list) || org.springframework.util.CollectionUtils.isEmpty(terminalCodeList = list.stream().map(MdmTerminalVo::getTerminalCode).filter(terminalCode -> !StringUtils.isEmpty((CharSequence)terminalCode)).collect(Collectors.toList())) || ObjectUtils.isEmpty(terminalOrgMap = this.mdmTerminalROrgService.findOrgCodeList(terminalCodeList)) || ObjectUtils.isEmpty(orgNameMap = this.mdmOrgService.findOrgNameMap(orgCodeList = (values = terminalOrgMap.values()).stream().flatMap(Collection::stream).distinct().collect(Collectors.toList()))))) {
            for (MdmTerminalVo mdmTerminalVo : list) {
                List<String> currentOrgCodeList = terminalOrgMap.get(mdmTerminalVo.getTerminalCode());
                if (org.springframework.util.CollectionUtils.isEmpty(currentOrgCodeList)) continue;
                String orgName = currentOrgCodeList.stream().filter(x -> !StringUtils.isEmpty((CharSequence)x)).distinct().map(orgNameMap::get).collect(Collectors.joining(","));
                mdmTerminalVo.setOrgName(orgName);
                mdmTerminalVo.setOrgCode(currentOrgCodeList.stream().filter(x -> !StringUtils.isEmpty((CharSequence)x)).distinct().collect(Collectors.joining(",")));
            }
        }
    }

    @Override
    public MdmTerminalVo query(String id, String terminalCode) {
        if (StringUtils.isEmpty((CharSequence)id) && StringUtils.isEmpty((CharSequence)terminalCode)) {
            return null;
        }
        MdmTerminalVo mdmTerminalVo = this.mdmTerminalMapper.query(id, terminalCode);
        if (mdmTerminalVo == null) {
            return null;
        }
        String code = mdmTerminalVo.getTerminalCode();
        Assert.hasText((String)code, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        mdmTerminalVo.setContacts(this.mdmTerminalContactService.findByTerminalCode(code));
        mdmTerminalVo.setSupplys(this.mdmTerminalSupplyService.findByTerminalCode(code));
        this.setUpOrgName(Collections.singletonList(mdmTerminalVo));
        return mdmTerminalVo;
    }

    @Override
    public MdmTerminalVo queryByTerminalCode(String terminalCode) {
        MdmTerminalEntity mdmTerminalentity;
        if (StringUtils.isNotEmpty((CharSequence)terminalCode) && null != (mdmTerminalentity = (MdmTerminalEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalEntity::getTerminalCode, (Object)terminalCode)).one())) {
            return (MdmTerminalVo)CrmBeanUtil.copy((Object)mdmTerminalentity, MdmTerminalVo.class);
        }
        return null;
    }

    @Override
    public List<MdmTerminalVo> queryBatchByTerminalCodeList(List<String> terminalCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(terminalCodeList)) {
            return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalEntity::getTerminalCode, terminalCodeList)).list().stream().map(x -> (MdmTerminalVo)CrmBeanUtil.copy((Object)x, MdmTerminalVo.class)).collect(Collectors.toList());
        }
        return new ArrayList<MdmTerminalVo>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String save(MdmTerminalVo mdmTerminalVo) {
        AssertUtils.isNotEmpty((String)mdmTerminalVo.getTerminalName(), (String)"\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isEmpty((CharSequence)mdmTerminalVo.getTerminalCode())) {
            mdmTerminalVo.setTerminalCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_TERMINAL.getCode()));
        } else {
            Integer count = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalEntity::getTerminalCode, (Object)mdmTerminalVo.getTerminalCode())).count();
            Assert.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)(mdmTerminalVo.getTerminalCode() + "\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728"));
        }
        if (StringUtils.isNotEmpty((CharSequence)mdmTerminalVo.getActApproveStatus())) {
            if (ActApproveStatusEnum.CREATE.getCode().equals(mdmTerminalVo.getActApproveStatus())) {
                mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.SUBMIT.getValue());
            }
            if (ActApproveStatusEnum.APPROVING.getCode().equals(mdmTerminalVo.getActApproveStatus())) {
                mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.APPROVAL.getValue());
            }
            if (ActApproveStatusEnum.APPROVED.getCode().equals(mdmTerminalVo.getActApproveStatus())) {
                mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
            }
            if (ActApproveStatusEnum.REJECTED.getCode().equals(mdmTerminalVo.getActApproveStatus())) {
                mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.REJECT.getValue());
            }
            if (ActApproveStatusEnum.INTERRUPT.getCode().equals(mdmTerminalVo.getActApproveStatus())) {
                mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.RECOVER.getValue());
            }
            if (ActApproveStatusEnum.CLOSED.getCode().equals(mdmTerminalVo.getActApproveStatus())) {
                mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.CLOSE.getValue());
            }
        }
        if ((StringUtils.isEmpty((CharSequence)mdmTerminalVo.getActApproveStatus()) || !MdmBpmStatusEnum.PASS.getValue().equals(mdmTerminalVo.getActApproveStatus())) && StringUtils.isNotEmpty((CharSequence)mdmTerminalVo.getApprovalBusinessCode())) {
            ApprovalType approvalType = ApprovalConfigUtil.checkAndGet((String)mdmTerminalVo.getApprovalBusinessCode(), (Object)mdmTerminalVo);
            mdmTerminalVo.setApprovalType(approvalType.getValue());
            if (approvalType == ApprovalType.NULL) {
                mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
            } else {
                mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.SUBMIT.getValue());
            }
        }
        if (StringUtils.isEmpty((CharSequence)mdmTerminalVo.getApprovalType())) {
            mdmTerminalVo.setApprovalType(ApprovalType.NULL.getValue());
            mdmTerminalVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        }
        mdmTerminalVo.setId(UUID.randomUUID().toString());
        MdmTerminalEntity entity = (MdmTerminalEntity)CrmBeanUtil.copy((Object)mdmTerminalVo, MdmTerminalEntity.class);
        this.setRegionName(entity);
        this.save(entity);
        Map map = DictUtil.dictMap((String)"terminal_add_section");
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("contact_information"))) {
            this.mdmTerminalContactService.setUpContact(mdmTerminalVo);
        }
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("supply_relationship"))) {
            this.mdmTerminalSupplyService.setUpSupply(mdmTerminalVo);
        }
        this.mdmTerminalROrgService.setUpTerminalRelationOrg(mdmTerminalVo);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuCodeObj != null) {
            this.crmLogSendUtil.sendForAdd(menuCodeObj.toString(), entity.getId(), entity.getTerminalCode(), (Object)entity);
        }
        if (MdmBpmStatusEnum.PASS.getValue().equals(entity.getActApproveStatus())) {
            this.sendInsertMsg(JsonPropertyUtil.toJsonStringNotEmptyVal((Object)entity));
            this.sendChangeMsg(Collections.singletonList(mdmTerminalVo.getTerminalCode()));
            this.sendAchievementMsg(mdmTerminalVo.getTerminalCode(), mdmTerminalVo.getFromType());
        }
        this.elasticsearchService.add(mdmTerminalVo);
        this.mdmStoreService.add(mdmTerminalVo);
        this.terminalChangeSendEvent(TerminalChangeHandlerReqVo.builder().terminalCode(entity.getTerminalCode()).currentOrgCode(entity.getOrgCode()).build());
        return mdmTerminalVo.getTerminalCode();
    }

    private void sendAchievementMsg(String terminalCode, String fromType) {
        ArrayList list = Lists.newArrayList();
        list.add(terminalCode);
        list.add(fromType);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag("INSERT_CLIENT_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonStringNotEmptyVal((Object)list));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveAndSubmit(MdmTerminalVo mdmTerminalVo) {
        String approvalBusinessCode = mdmTerminalVo.getApprovalBusinessCode();
        Assert.hasText((String)approvalBusinessCode, (String)"\u7f3a\u5931\u5ba1\u6279\u914d\u7f6e\u4e1a\u52a1\u7f16\u7801\uff0c\u4e0d\u80fd\u81ea\u52a8\u53d1\u8d77");
        MdmApprovalConfigVo config = ApprovalConfigUtil.getConfig((String)approvalBusinessCode);
        String terminalCode = this.save(mdmTerminalVo);
        MdmTerminalEntity terminal = (MdmTerminalEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalEntity::getTerminalCode, (Object)terminalCode)).one();
        if (MdmBpmStatusEnum.SUBMIT.getValue().equals(terminal.getActApproveStatus())) {
            if (ApprovalType.STATUS.getValue().equals(terminal.getApprovalType())) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmTerminalEntity::getTerminalCode, (Object)terminalCode)).set(MdmTerminalEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.APPROVAL.getValue())).update();
                this.elasticsearchService.updateById(terminal.getId(), Collections.singletonMap("actApproveStatus", MdmBpmStatusEnum.APPROVAL.getValue()));
            }
            if (ApprovalType.BPM.getValue().equals(terminal.getApprovalType())) {
                String workFlowKey = mdmTerminalVo.getWorkFlowKey();
                if (StringUtils.isEmpty((CharSequence)workFlowKey)) {
                    Assert.notNull((Object)config, (String)"\u672a\u627e\u5230\u5ba1\u6279\u914d\u7f6e");
                    Assert.hasText((String)config.getDefaultWorkFlowKey(), (String)"\u5ba1\u6279\u914d\u7f6e\u7f3a\u5931\u6d41\u7a0bkey");
                    workFlowKey = config.getDefaultWorkFlowKey();
                }
                UserRedis user = UserUtils.getUser();
                StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
                startProcessReqVo.setCallBackFeign("MdmTerminalCallBackFeign");
                startProcessReqVo.setProcessKey(workFlowKey);
                startProcessReqVo.setUserCode(user.getUsername());
                startProcessReqVo.setPosCode(user.getPoscode());
                startProcessReqVo.setTitle(StringUtils.isNotEmpty((CharSequence)mdmTerminalVo.getTitle()) ? mdmTerminalVo.getTitle() : "\u5ba2\u6237\u65b0\u589e\u9ed8\u8ba4\u63d0\u4ea4\u6d41\u7a0b");
                startProcessReqVo.setFormNo(terminal.getId());
                startProcessReqVo.setRemark(StringUtils.isNotEmpty((CharSequence)mdmTerminalVo.getApproveRemarks()) ? mdmTerminalVo.getApproveRemarks() : "");
                startProcessReqVo.setFormType(StringUtils.isNotEmpty((CharSequence)mdmTerminalVo.getFromType()) ? mdmTerminalVo.getFromType() : "MDM");
                startProcessReqVo.setCostType("terminal");
                startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
                startProcessReqVo.setBusinessCode(terminal.getTerminalCode());
                startProcessReqVo.setFileList(CollectionUtil.listNotEmptyNotSizeZero((List)mdmTerminalVo.getActivityFileList()) ? mdmTerminalVo.getActivityFileList() : null);
                String processNo = ActivityUtils.startProcess((StartProcessReqVo)startProcessReqVo);
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmTerminalEntity::getTerminalCode, (Object)terminalCode)).set(MdmTerminalEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.APPROVAL.getValue())).set(MdmTerminalEntity::getProcessCode, (Object)processNo)).update();
                this.elasticsearchService.updateById(terminal.getId(), Collections.singletonMap("actApproveStatus", MdmBpmStatusEnum.APPROVAL.getValue()));
            }
        }
        return terminalCode;
    }

    @Override
    public String validateSaveParamFromSfa(MdmTerminalVo reqVo) {
        Assert.notNull((Object)reqVo, (String)"\u7a7a\u53c2\u6570");
        List list = DictUtil.list((String)"mdm_unique_check_terminal_add_from_sfa");
        for (DictDataVo dictDataVo : list) {
            String dictCode = dictDataVo.getDictCode();
            String dictValue = dictDataVo.getDictValue();
            Object filedValueByName = ReflectUtil.getFiledValueByName((Object)reqVo, (String)dictCode);
            if (filedValueByName == null || !StringUtils.isNotEmpty((CharSequence)filedValueByName.toString())) continue;
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)dictValue, (Object)filedValueByName.toString());
            wrapper.select(new String[]{"id", "act_approve_status"});
            List terminalEntityList = this.mdmTerminalMapper.selectList((Wrapper)wrapper);
            if (terminalEntityList.size() > 1) {
                throw new BusinessException("\u5b58\u5728\u591a\u4e2a\u91cd\u590d\u7ec8\u7aef\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u505c\u7528\u91cd\u590d\u7ec8\u7aef");
            }
            if (terminalEntityList.size() != 1) continue;
            MdmTerminalEntity terminalEntity = (MdmTerminalEntity)terminalEntityList.get(0);
            String actApproveStatus = terminalEntity.getActApproveStatus();
            if (ActApproveStatusEnum.APPROVING.getCode().equals(actApproveStatus)) {
                throw new BusinessException("\u5b58\u5728\u4e00\u4e2a\u5ba1\u6279\u4e2d\u7684\u91cd\u590d\u7ec8\u7aef\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4eba\u5458\u5ba1\u6279\u540e\u518d\u8fdb\u884c\u65b0\u589e");
            }
            return terminalEntity.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmTerminalVo mdmTerminalVo) {
        String terminalCode = mdmTerminalVo.getTerminalCode();
        Assert.hasText((String)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String id = mdmTerminalVo.getId();
        Assert.hasText((String)id, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmTerminalVo oldObject = this.queryById(mdmTerminalVo);
        MdmTerminalEntity entity = (MdmTerminalEntity)this.getById((Serializable)((Object)mdmTerminalVo.getId()));
        Assert.notNull((Object)entity, (String)"\u7ec8\u7aef\u4e0d\u5b58\u5728");
        long count = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalEntity::getTerminalCode, (Object)terminalCode)).select(new SFunction[]{BaseIdEntity::getId}).list().stream().filter(x -> !id.equals(x.getId())).count();
        Assert.isTrue((count < 1L ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u7f16\u7801\u5df2\u5b58\u5728");
        MdmTerminalEntity copy = (MdmTerminalEntity)CrmBeanUtil.copy((Object)mdmTerminalVo, MdmTerminalEntity.class);
        this.setRegionName(copy);
        this.updateById(copy);
        Map map = DictUtil.dictMap((String)"terminal_add_section");
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("contact_information"))) {
            this.mdmTerminalContactService.setUpContact(mdmTerminalVo);
        }
        if (map != null && YesNoEnum.yesNoEnum.Y.getValue().equals(map.get("supply_relationship"))) {
            this.mdmTerminalSupplyService.setUpSupply(mdmTerminalVo);
        }
        this.mdmTerminalROrgService.setUpTerminalRelationOrg(mdmTerminalVo);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        MdmTerminalVo newObject = this.queryById(mdmTerminalVo);
        if (menuCodeObj != null) {
            this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), mdmTerminalVo.getId(), newObject.getTerminalCode(), (Object)oldObject, (Object)newObject);
        }
        if (MdmBpmStatusEnum.PASS.getValue().equals(entity.getActApproveStatus())) {
            this.elasticsearchService.add(mdmTerminalVo);
            this.sendChangeMsg(Collections.singletonList(mdmTerminalVo.getTerminalCode()));
        }
        this.mdmStoreService.update(mdmTerminalVo);
        this.terminalChangeSendEvent(TerminalChangeHandlerReqVo.builder().terminalCode(entity.getTerminalCode()).oldOrgCode(oldObject.getOrgCode()).currentOrgCode(entity.getOrgCode()).build());
    }

    @Override
    public void updateCoordinate(List<UpdateCoordinateReqVo> updateCoordinateReqVos) {
        if (CollectionUtils.isEmpty(updateCoordinateReqVos)) {
            return;
        }
        for (UpdateCoordinateReqVo updateCoordinateReqVo : updateCoordinateReqVos) {
            String terminalCode = updateCoordinateReqVo.getTerminalCode();
            if (com.biz.crm.util.StringUtils.isEmpty((String)terminalCode)) continue;
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmTerminalEntity::getTerminalCode, (Object)terminalCode)).set(MdmTerminalEntity::getLongitude, (Object)updateCoordinateReqVo.getLongitude())).set(MdmTerminalEntity::getLatitude, (Object)updateCoordinateReqVo.getLatitude())).update();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAndSubmit(MdmTerminalVo mdmTerminalVo) {
        this.update(mdmTerminalVo);
        String terminalCode = mdmTerminalVo.getTerminalCode();
        MdmTerminalEntity terminal = (MdmTerminalEntity)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalEntity::getTerminalCode, (Object)terminalCode)).one();
        if (MdmBpmStatusEnum.SUBMIT.getValue().equals(terminal.getActApproveStatus()) || MdmBpmStatusEnum.RECOVER.getValue().equals(terminal.getActApproveStatus()) || MdmBpmStatusEnum.REJECT.getValue().equals(terminal.getActApproveStatus())) {
            if (ApprovalType.STATUS.getValue().equals(terminal.getApprovalType())) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmTerminalEntity::getTerminalCode, (Object)terminalCode)).set(MdmTerminalEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.APPROVAL.getValue())).update();
                this.elasticsearchService.updateById(terminal.getId(), Collections.singletonMap("actApproveStatus", MdmBpmStatusEnum.APPROVAL.getValue()));
            } else if (ApprovalType.BPM.getValue().equals(terminal.getApprovalType())) {
                Assert.hasText((String)mdmTerminalVo.getApprovalBusinessCode(), (String)"\u7f3a\u5931\u5ba1\u6279\u914d\u7f6e\u7f16\u7801");
                String workFlowKey = mdmTerminalVo.getWorkFlowKey();
                if (StringUtils.isEmpty((CharSequence)workFlowKey)) {
                    MdmApprovalConfigVo config = ApprovalConfigUtil.getConfig((String)mdmTerminalVo.getApprovalBusinessCode());
                    Assert.notNull((Object)config, (String)("\u672a\u627e\u5230\u5ba1\u6279\u914d\u7f6e\u7f16\u7801" + mdmTerminalVo.getApprovalBusinessCode()));
                    Assert.hasText((String)config.getDefaultWorkFlowKey(), (String)"\u5ba1\u6279\u914d\u7f6e\u672a\u914d\u7f6e\u9ed8\u8ba4\u6d41\u7a0bkey");
                    workFlowKey = config.getDefaultWorkFlowKey();
                }
                UserRedis user = UserUtils.getUser();
                StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
                startProcessReqVo.setCallBackFeign("MdmTerminalCallBackFeign");
                startProcessReqVo.setProcessKey(workFlowKey);
                startProcessReqVo.setUserCode(user.getUsername());
                startProcessReqVo.setPosCode(user.getPoscode());
                startProcessReqVo.setTitle(StringUtils.isNotEmpty((CharSequence)mdmTerminalVo.getTitle()) ? mdmTerminalVo.getTitle() : "\u7ec8\u7aef\u7f16\u8f91\u9ed8\u8ba4\u63d0\u4ea4\u6d41\u7a0b");
                startProcessReqVo.setFormNo(terminal.getId());
                startProcessReqVo.setRemark(StringUtils.isNotEmpty((CharSequence)mdmTerminalVo.getApproveRemarks()) ? mdmTerminalVo.getApproveRemarks() : "");
                startProcessReqVo.setFormType(StringUtils.isNotEmpty((CharSequence)mdmTerminalVo.getFromType()) ? mdmTerminalVo.getFromType() : "MDM");
                startProcessReqVo.setCostType("terminal");
                startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
                startProcessReqVo.setBusinessCode(terminal.getTerminalCode());
                startProcessReqVo.setFileList(CollectionUtil.listNotEmptyNotSizeZero((List)mdmTerminalVo.getActivityFileList()) ? mdmTerminalVo.getActivityFileList() : null);
                String no = ActivityUtils.startProcess((StartProcessReqVo)startProcessReqVo);
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmTerminalEntity::getTerminalCode, (Object)terminalCode)).set(MdmTerminalEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.APPROVAL.getValue())).set(MdmTerminalEntity::getProcessCode, (Object)no)).update();
                this.elasticsearchService.updateById(terminal.getId(), Collections.singletonMap("actApproveStatus", MdmBpmStatusEnum.APPROVAL.getValue()));
            } else {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmTerminalEntity::getTerminalCode, (Object)terminalCode)).set(MdmTerminalEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).update();
                this.elasticsearchService.updateById(terminal.getId(), Collections.singletonMap("actApproveStatus", MdmBpmStatusEnum.PASS.getValue()));
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e");
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        if (CollectionUtil.listEmpty((List)list)) {
            return;
        }
        List<String> terminalCodes = list.stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList());
        this.mdmTerminalContactService.deleteByCodes(terminalCodes);
        this.mdmTerminalSupplyService.deleteByCodes(terminalCodes);
        ((LambdaUpdateChainWrapper)this.mdmTerminalROrgService.lambdaUpdate().in(MdmTerminalROrgEntity::getTerminalCode, terminalCodes)).remove();
        this.mdmStoreService.remove(terminalCodes);
        this.removeByIds(ids);
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuCodeObj != null) {
            list.forEach(item -> this.crmLogSendUtil.sendForDel(menuCodeObj.toString(), item.getId(), item.getTerminalCode(), item));
        }
        this.elasticsearchService.delete(ids);
        this.sendChangeMsg(list.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e");
        }
        List<MdmTerminalEntity> list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).select(new SFunction[]{BaseIdEntity::getId, MdmTerminalEntity::getTerminalCode, CrmBaseEntity::getEnableStatus}).list().stream().filter(x -> !CrmEnableStatusEnum.ENABLE.getCode().equals(x.getEnableStatus())).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
        this.sendChangeMsg(list.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList()));
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuCodeObj != null) {
            list.forEach(item -> {
                MdmTerminalVo oldObject = (MdmTerminalVo)CrmBeanUtil.copy((Object)item, MdmTerminalVo.class);
                oldObject.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                MdmTerminalVo newObject = (MdmTerminalVo)CrmBeanUtil.copy((Object)item, MdmTerminalVo.class);
                newObject.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), item.getId(), item.getTerminalCode(), (Object)oldObject, (Object)newObject);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        if (CollectionUtil.listEmpty(ids)) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e");
        }
        List<MdmTerminalEntity> list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).select(new SFunction[]{BaseIdEntity::getId, MdmTerminalEntity::getTerminalCode, CrmBaseEntity::getEnableStatus}).list().stream().filter(x -> !CrmEnableStatusEnum.DISABLE.getCode().equals(x.getEnableStatus())).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        this.sendChangeMsg(list.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList()));
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuCodeObj != null) {
            list.forEach(item -> {
                MdmTerminalVo oldObject = (MdmTerminalVo)CrmBeanUtil.copy((Object)item, MdmTerminalVo.class);
                oldObject.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                MdmTerminalVo newObject = (MdmTerminalVo)CrmBeanUtil.copy((Object)item, MdmTerminalVo.class);
                newObject.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                this.crmLogSendUtil.sendForUpdate(menuCodeObj.toString(), item.getId(), item.getTerminalCode(), (Object)oldObject, (Object)newObject);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateCusOrgCode(UpdateTerminalCusOrgCodeVo vo) {
        if (CollectionUtil.listEmpty(vo.getTerminalCodeList()) || StringUtils.isEmpty((CharSequence)vo.getCustomerOrgCode())) {
            throw new BusinessException("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u6216\u7ec8\u7aef\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalEntity::getTerminalCode, vo.getTerminalCodeList())).select(new SFunction[]{MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getActApproveStatus}).list();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmTerminalEntity::getTerminalCode, vo.getTerminalCodeList())).set(MdmTerminalEntity::getCustomerOrgCode, (Object)vo.getCustomerOrgCode())).update();
        this.sendChangeMsg(list.stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList()));
    }

    @Override
    public List<String> findByOrgCodeList(List<String> list) {
        if (CollectionUtil.listEmpty(list)) {
            return new ArrayList<String>();
        }
        List<String> terminalCodeList = this.mdmTerminalROrgService.findTerminalCodeByOrg(list);
        if (org.springframework.util.CollectionUtils.isEmpty(terminalCodeList)) {
            return new ArrayList<String>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmTerminalEntity::getTerminalCode, terminalCodeList)).select(new SFunction[]{MdmTerminalEntity::getTerminalCode}).list().stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> getTerminalCodeNameMap(List<String> terminalCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(terminalCodeList)) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            List partition = Lists.partition(terminalCodeList, (int)500);
            for (List group : partition) {
                map.putAll(((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalEntity::getTerminalCode, (Collection)group)).select(new SFunction[]{MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getTerminalName}).list().stream().collect(Collectors.toMap(MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getTerminalName)));
            }
            return map;
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, String> findOrgCodeByTerminalCodeList(List<String> terminalCodeList) {
        if (CollectionUtil.listEmpty(terminalCodeList)) {
            return Collections.emptyMap();
        }
        return this.mdmTerminalROrgService.findOrgCodeByTerminalCodeList(terminalCodeList);
    }

    @Override
    public Map<String, List<String>> findOrgCodeListByTerminalCodeList(List<String> terminalCodeList) {
        return this.mdmTerminalROrgService.findOrgCodeList(terminalCodeList);
    }

    @Override
    public List<MdmTerminalVo> findCurrentAndSubTerminalList(List<String> orgCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(orgCodes)) {
            return new ArrayList<MdmTerminalVo>();
        }
        List allOrgCodeList = OrgUtil.getChildrenOrgCodeListIncludeSelfEnable(orgCodes);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)allOrgCodeList)) {
            return new ArrayList<MdmTerminalVo>();
        }
        MdmTerminalCurrentAndSubVo mdmTerminalCurrentAndSubVo = new MdmTerminalCurrentAndSubVo();
        mdmTerminalCurrentAndSubVo.setPageNum(Integer.valueOf(0));
        mdmTerminalCurrentAndSubVo.setPageSize(Integer.valueOf(Integer.MAX_VALUE));
        mdmTerminalCurrentAndSubVo.setOrgCodeList(allOrgCodeList);
        return CrmBeanUtil.copyList((List)this.findTerminalAndContactList(mdmTerminalCurrentAndSubVo).getData(), MdmTerminalVo.class);
    }

    @Override
    public List<MdmTerminalVo> listCondition(MdmTerminalVo mdmTerminalReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmTerminalReqVo.getPageNum(), (Integer)mdmTerminalReqVo.getPageSize());
        page.setSearchCount(false);
        return this.mdmTerminalMapper.listCondition(mdmTerminalReqVo, (Page<MdmTerminalVo>)page);
    }

    protected void sendInsertMsg(String msg) {
        log.info("\u7ec8\u7aef\u65b0\u589e\u6d88\u606f\u901a\u77e5:{}", (Object)msg);
        if (StringUtils.isBlank((CharSequence)msg)) {
            return;
        }
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTopic(this.topic);
        rocketMQMessageBody.setTag("TERMINAL_NEW_OR_PASS");
        rocketMQMessageBody.setMsgBody(msg);
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }

    private void sendChangeMsg(List<String> terminalCodeList) {
        log.info("\u7ec8\u7aef\u53d8\u52a8\u6d88\u606f\u901a\u77e5:{}", terminalCodeList);
        if (CollectionUtil.listEmpty(terminalCodeList)) {
            return;
        }
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTopic(this.topic);
        rocketMQMessageBody.setTag("TERMINAL_AVAILBLELIST_REFRSH");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(terminalCodeList));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }

    @Override
    public List<MdmTerminalVo> findPositionTerminalList(String posId, String posCode) {
        if (StringUtils.isEmpty((CharSequence)posCode) && StringUtils.isEmpty((CharSequence)posId)) {
            return new ArrayList<MdmTerminalVo>();
        }
        return this.mdmTerminalMapper.findPositionTerminalList(posId, posCode).stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).collect(Collectors.toList());
    }

    @Override
    public List<MdmTerminalVo> findPositionTerminalListByPositionCodeList(List<String> positionCodeList) {
        if (CollectionUtil.listEmpty(positionCodeList)) {
            return new ArrayList<MdmTerminalVo>();
        }
        return this.mdmTerminalMapper.findPositionsTerminalList(positionCodeList).stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).collect(Collectors.toList());
    }

    @Override
    public List<MdmTerminalVo> findCurrentAndSybPositionTerminalList(String posId, String posCode) {
        List<String> positionCodeList = this.mdmPositionService.findAllChildrenPositionCodeList(posId, posCode);
        if (CollectionUtil.listEmpty(positionCodeList)) {
            return new ArrayList<MdmTerminalVo>();
        }
        return this.mdmTerminalMapper.findPositionsTerminalList(positionCodeList).stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateTerminalOrg(MdmOrgTerminalReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getTerminalCodeList(), (String)"\u7f3a\u5931\u7ec8\u7aef\u7f16\u7801");
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getOriginOrgCode())) {
            this.mdmTerminalROrgService.replaceOrg(reqVo.getTerminalCodeList(), reqVo.getOriginOrgCode(), reqVo.getOrgCode());
        } else {
            this.mdmTerminalROrgService.setUp(reqVo.getTerminalCodeList(), reqVo.getOrgCode());
        }
        List<String> sendTerminalCodeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmTerminalEntity::getTerminalCode, (Collection)reqVo.getTerminalCodeList())).select(new SFunction[]{MdmTerminalEntity::getTerminalCode}).list().stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList());
        if (CollectionUtil.listNotEmptyNotSizeZero(sendTerminalCodeList)) {
            this.sendChangeMsg(sendTerminalCodeList);
        }
    }

    @Override
    public PageResult<MdmTerminalContactPageVo> userTerminalContactPage(MdmTerminalContactPageReqVo mdmTerminalContactPageReqVo) {
        String positionCode = mdmTerminalContactPageReqVo.getPositionCode();
        List positionCodeList = mdmTerminalContactPageReqVo.getPositionCodeList() != null ? mdmTerminalContactPageReqVo.getPositionCodeList() : new ArrayList();
        List<Object> terminalCodeList = new ArrayList();
        if (!StringUtils.isEmpty((CharSequence)mdmTerminalContactPageReqVo.getPositionCode()) || CollectionUtil.listNotEmptyNotSizeZero((List)mdmTerminalContactPageReqVo.getPositionCodeList())) {
            if (StringUtils.isNotEmpty((CharSequence)mdmTerminalContactPageReqVo.getPositionCode())) {
                if (CollectionUtil.listNotEmptyNotSizeZero((List)positionCodeList)) {
                    positionCodeList.retainAll(Collections.singletonList(positionCode));
                } else {
                    positionCodeList.add(positionCode);
                }
            }
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)positionCodeList)) {
                List<MdmTerminalVo> positionTerminalList = this.findPositionTerminalListByPositionCodeList(positionCodeList);
                log.info("[\u7ec8\u7aef\u7ba1\u7406][\u7ec8\u7aef\u53ca\u4e3b\u8054\u7cfb\u4eba\u5206\u9875]\u804c\u4f4d\u5173\u8054\u7ec8\u7aef:{}", positionTerminalList);
                if (org.springframework.util.CollectionUtils.isEmpty(positionTerminalList)) {
                    return new PageResult();
                }
                terminalCodeList = positionTerminalList.stream().map(MdmTerminalVo::getTerminalCode).collect(Collectors.toList());
            }
        }
        mdmTerminalContactPageReqVo.setTerminalCodeList(terminalCodeList);
        Page page = PageUtil.buildPage((Integer)mdmTerminalContactPageReqVo.getPageNum(), (Integer)mdmTerminalContactPageReqVo.getPageSize());
        mdmTerminalContactPageReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmTerminalContactPageVo> list = !StringUtils.isEmpty((CharSequence)mdmTerminalContactPageReqVo.getLatitude()) && !StringUtils.isEmpty((CharSequence)mdmTerminalContactPageReqVo.getLongitude()) ? this.mdmTerminalMapper.distancePage((Page<MdmTerminalContactPageVo>)page, mdmTerminalContactPageReqVo) : this.mdmTerminalMapper.userTerminalContactPage((Page<MdmTerminalContactPageVo>)page, mdmTerminalContactPageReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmTerminalContactPageVo> terminalContactPage(MdmTerminalContactPageReqVo mdmTerminalContactPageReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmTerminalContactPageReqVo.getPageNum(), (Integer)mdmTerminalContactPageReqVo.getPageSize());
        mdmTerminalContactPageReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List positionCodeList = mdmTerminalContactPageReqVo.getPositionCodeList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)positionCodeList)) {
            ThreadLocalUtil.delObj();
        }
        List<MdmTerminalContactPageVo> list = this.mdmTerminalMapper.userTerminalContactPage((Page<MdmTerminalContactPageVo>)page, mdmTerminalContactPageReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmTerminalContactPageVo> sfaFindTerminalContactPage(List<String> terminalCodes) {
        ArrayList<MdmTerminalContactPageVo> data = new ArrayList<MdmTerminalContactPageVo>();
        List list = Lists.partition(terminalCodes, (int)500);
        list.forEach(l -> {
            MdmTerminalContactPageReqVo reqVo = new MdmTerminalContactPageReqVo((List)l){
                final /* synthetic */ List val$l;
                {
                    this.val$l = list;
                    this.setTerminalCodeList(this.val$l);
                    this.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
                }
            };
            List<MdmTerminalContactPageVo> terminalList = this.mdmTerminalMapper.userTerminalContactPage(null, reqVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(terminalList)) {
                data.addAll(terminalList);
            }
        });
        return data;
    }

    @Override
    public List<MdmOrgRespVo> detailBatch(MdmTerminalVo vo) {
        List<String> orgCodeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(!org.springframework.util.CollectionUtils.isEmpty((Collection)vo.getTerminalCodeList()), MdmTerminalEntity::getTerminalCode, new Object[]{vo.getTerminalCode()})).like(!StringUtils.isEmpty((CharSequence)vo.getTerminalName()), MdmTerminalEntity::getTerminalName, (Object)vo.getTerminalName())).select(new SFunction[]{MdmTerminalEntity::getOrgCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((CharSequence)x.getOrgCode())).map(MdmTerminalEntity::getOrgCode).distinct().collect(Collectors.toList());
        if (org.springframework.util.CollectionUtils.isEmpty(orgCodeList)) {
            return new ArrayList<MdmOrgRespVo>();
        }
        return this.mdmOrgService.detailBatch(null, orgCodeList);
    }

    @Override
    public List<MdmTerminalVo> customerTerminalList(MdmCustomerTerminalVo mdmCustomerTerminalVo) {
        Map<String, List<MdmOrgRespVo>> orgGroupByTerminalCodeList;
        Page page = PageUtil.buildPage((Integer)mdmCustomerTerminalVo.getPageNum(), (Integer)mdmCustomerTerminalVo.getPageSize());
        List customerCodeList = mdmCustomerTerminalVo.getCustomerCodeList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCodeList)) {
            List<String> terminalByCustomer = this.mdmTerminalSupplyService.findTerminalByCustomer(customerCodeList);
            if (org.springframework.util.CollectionUtils.isEmpty(terminalByCustomer)) {
                return new ArrayList<MdmTerminalVo>();
            }
            mdmCustomerTerminalVo.setTerminalCodeList(terminalByCustomer);
        }
        page.setSearchCount(false);
        List<MdmTerminalVo> collect = this.mdmTerminalMapper.customerTerminalList((Page<MdmTerminalVo>)page, mdmCustomerTerminalVo).stream().filter(x -> MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus())).collect(Collectors.toList());
        if (!collect.isEmpty() && YesNoEnum.yesNoEnum.Y.getValue().equals(mdmCustomerTerminalVo.getIsQueryTerminalOrgList()) && !(orgGroupByTerminalCodeList = this.mdmTerminalROrgService.findOrgGroupByTerminalCodeList(collect.stream().map(MdmTerminalVo::getTerminalCode).collect(Collectors.toList()))).isEmpty()) {
            collect.forEach(x -> x.setOrgList((List)orgGroupByTerminalCodeList.get(x.getTerminalCode())));
        }
        return collect;
    }

    @Override
    public Long findPositionRelationTerminalCount(String positionCode) {
        if (StringUtils.isEmpty((CharSequence)positionCode)) {
            return 0L;
        }
        List<MdmPositionRespVo> position = this.mdmPositionService.findAllChildrenPositionList(null, positionCode);
        if (org.springframework.util.CollectionUtils.isEmpty(position)) {
            return 0L;
        }
        List<String> positionCodeList = position.stream().map(MdmPositionRespVo::getPositionCode).filter(code -> !StringUtils.isEmpty((CharSequence)code)).collect(Collectors.toList());
        List<String> collect = this.mdmTerminalSupplyService.findTerminalByPositionCodeList(positionCodeList);
        if (!collect.isEmpty()) {
            return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmTerminalEntity::getTerminalCode, collect)).list().size();
        }
        return 0L;
    }

    @Override
    public Long findPositionRelationTerminalCustomerCount(String positionCode) {
        if (StringUtils.isEmpty((CharSequence)positionCode)) {
            return 0L;
        }
        List<MdmPositionRespVo> position = this.mdmPositionService.findAllChildrenPositionList(null, positionCode);
        if (org.springframework.util.CollectionUtils.isEmpty(position)) {
            return 0L;
        }
        List positionCodeList = position.stream().map(MdmPositionRespVo::getPositionCode).filter(code -> !StringUtils.isEmpty((CharSequence)code)).collect(Collectors.toList());
        Set collect = ((LambdaQueryChainWrapper)this.mdmTerminalSupplyService.lambdaQuery().in(MdmTerminalSupplyEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmTerminalSupplyEntity::getTerminalCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((CharSequence)x.getTerminalCode())).map(MdmTerminalSupplyEntity::getTerminalCode).collect(Collectors.toSet());
        if (!collect.isEmpty()) {
            return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmTerminalEntity::getTerminalCode, collect)).list().size();
        }
        return 0L;
    }

    @Override
    public MdmTerminalVo findDetailByRegisterOrName(String licenseRegisterNumber, String terminalName) {
        Assert.isTrue((!StringUtils.isEmpty((CharSequence)licenseRegisterNumber) || !StringUtils.isEmpty((CharSequence)terminalName) ? 1 : 0) != 0, (String)"\u8425\u4e1a\u6ce8\u518c\u53f7\u6216\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        MdmTerminalVo mdmTerminalVo = this.mdmTerminalMapper.findDetailByRegisterOrName(licenseRegisterNumber, terminalName);
        log.info("\u7ec8\u7aef\u4fe1\u606f:{},\u5165\u53c2:{}", (Object)mdmTerminalVo, (Object)(licenseRegisterNumber + ":" + terminalName));
        if (mdmTerminalVo == null) {
            return null;
        }
        String terminalCode = mdmTerminalVo.getTerminalCode();
        Assert.hasText((String)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        mdmTerminalVo.setContacts(this.mdmTerminalContactService.findByTerminalCode(terminalCode));
        mdmTerminalVo.setSupplys(this.mdmTerminalSupplyService.findByTerminalCode(terminalCode));
        this.setUpOrgName(Collections.singletonList(mdmTerminalVo));
        return mdmTerminalVo;
    }

    @Override
    public PageResult<MdmTerminalContactPageVo> distanceContactPage(MdmTerminalDistanceContactPageReqVo mdmTerminalDistanceContactPageReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmTerminalDistanceContactPageReqVo.getPageNum(), (Integer)mdmTerminalDistanceContactPageReqVo.getPageSize());
        List<MdmTerminalContactPageVo> list = this.mdmTerminalMapper.distanceContactPage((Page<MdmTerminalContactPageVo>)page, mdmTerminalDistanceContactPageReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmTerminalSelectRespVo> findTerminalSelectList(MdmTerminalSelectReqVo reqVo) {
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        ArrayList<MdmTerminalSelectRespVo> list = new ArrayList<MdmTerminalSelectRespVo>(16);
        HashSet<String> codeList = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (!codeList.isEmpty()) {
            reqVo.setSelectedCodeList(new ArrayList(codeList));
        }
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        if (pageSize > 0) {
            list.addAll(this.mdmTerminalMapper.findTerminalSelectList((Page<MdmTerminalSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo, null, null));
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submit(MdmTerminalVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getWorkFlowKey(), (String)"\u8bf7\u9009\u62e9\u6d41\u7a0b");
        MdmTerminalEntity entity = (MdmTerminalEntity)this.getById((Serializable)((Object)reqVo.getId()));
        if (!ApprovalType.BPM.getValue().equals(entity.getApprovalType())) {
            throw new BusinessException("\u8be5\u6761\u6570\u636e\u4e0d\u80fd\u53d1\u8d77\u6d41\u7a0b\u5ba1\u6279");
        }
        if (MdmBpmStatusEnum.PASS.getValue().equals(entity.getActApproveStatus())) {
            throw new BusinessException("\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\u4e0d\u80fd\u53d1\u8d77\u6d41\u7a0b");
        }
        if (MdmBpmStatusEnum.APPROVAL.getValue().equals(entity.getActApproveStatus())) {
            throw new BusinessException("\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u4e0d\u80fd\u53d1\u8d77\u6d41\u7a0b");
        }
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("MdmTerminalCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setFormType(StringUtils.isNotEmpty((CharSequence)reqVo.getFromType()) ? reqVo.getFromType() : "MDM");
        startProcessReqVo.setCostType("terminal");
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(String.valueOf(System.currentTimeMillis()));
        startProcessReqVo.setBusinessCode(entity.getTerminalCode());
        startProcessReqVo.setFileList(reqVo.getActivityFileList());
        String processNo = ActivityUtils.startProcess((StartProcessReqVo)startProcessReqVo);
        entity.setProcessCode(processNo);
        entity.setActApproveStatus(MdmBpmStatusEnum.APPROVAL.getValue());
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void callback(ActivitiCallBackVo reqVo) {
        MdmTerminalEntity entity = (MdmTerminalEntity)this.getById((Serializable)((Object)reqVo.getFormNo()));
        if (Objects.isNull(entity)) {
            return;
        }
        boolean sendMq = false;
        if (Indicator.CON_BPM_DOING.getCode() == reqVo.getProcessState().intValue()) {
            entity.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
            sendMq = true;
        }
        if (Indicator.CON_BPM_PASS.getCode() == reqVo.getProcessState().intValue()) {
            entity.setActApproveStatus(MdmBpmStatusEnum.REJECT.getValue());
        }
        if (Indicator.CON_BPM_REJECT.getCode() == reqVo.getProcessState().intValue()) {
            entity.setActApproveStatus(MdmBpmStatusEnum.RECOVER.getValue());
        }
        this.updateById(entity);
        if (sendMq) {
            this.sendChangeMsg(Collections.singletonList(entity.getTerminalCode()));
            this.sendAchievementMsg(entity.getTerminalCode(), entity.getFromType());
            MdmTerminalVo query = this.query(reqVo.getFormNo(), null);
            this.elasticsearchService.add(query);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void statusApprovalSubmit(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7a7a\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        Assert.notEmpty((Collection)list, (String)"\u65e0\u6548\u7684id");
        list.forEach(x -> {
            Assert.isTrue((boolean)ApprovalType.STATUS.getValue().equals(x.getApprovalType()), (String)"\u8be5\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u72b6\u6001\u5ba1\u6279");
            Assert.isTrue((!MdmBpmStatusEnum.APPROVAL.getValue().equals(x.getActApproveStatus()) ? 1 : 0) != 0, (String)"\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u72b6\u6001\u5ba1\u6279");
            Assert.isTrue((!MdmBpmStatusEnum.PASS.getValue().equals(x.getActApproveStatus()) ? 1 : 0) != 0, (String)"\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u72b6\u6001\u5ba1\u6279");
            x.setActApproveStatus(MdmBpmStatusEnum.APPROVAL.getValue());
        });
        this.updateBatchById(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void statusApprovalReject(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7a7a\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        Assert.notEmpty((Collection)list, (String)"\u65e0\u6548\u7684id");
        list.forEach(x -> {
            Assert.isTrue((boolean)ApprovalType.STATUS.getValue().equals(x.getApprovalType()), (String)"\u8be5\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u72b6\u6001\u5ba1\u6279");
            Assert.isTrue((boolean)MdmBpmStatusEnum.APPROVAL.getValue().equals(x.getActApproveStatus()), (String)"\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u624d\u80fd\u9a73\u56de");
            x.setActApproveStatus(MdmBpmStatusEnum.REJECT.getValue());
        });
        this.updateBatchById(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void statusApprovalAgree(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7a7a\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        Assert.notEmpty((Collection)list, (String)"\u65e0\u6548\u7684id");
        list.forEach(x -> {
            Assert.isTrue((boolean)ApprovalType.STATUS.getValue().equals(x.getApprovalType()), (String)"\u8be5\u6570\u636e\u4e0d\u80fd\u63d0\u4ea4\u72b6\u6001\u5ba1\u6279");
            Assert.isTrue((boolean)MdmBpmStatusEnum.APPROVAL.getValue().equals(x.getActApproveStatus()), (String)"\u5ba1\u6279\u4e2d\u7684\u6570\u636e\u624d\u80fd\u901a\u8fc7");
            x.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        });
        this.updateBatchById(list);
        this.sendInsertMsgForApprovalAgree(list);
    }

    protected void sendInsertMsgForApprovalAgree(List<MdmTerminalEntity> list) {
        if (null == list) {
            return;
        }
        for (MdmTerminalEntity mdmTerminalEntity : list) {
            this.sendInsertMsg(JsonPropertyUtil.toJsonStringNotEmptyVal((Object)mdmTerminalEntity));
        }
    }

    @Override
    public List<MdmTerminalSupplyVo> findTerminalSupply(MdmTerminalVo mdmTerminalVo) {
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)mdmTerminalVo.getTerminalCodeList())) {
            return new ArrayList<MdmTerminalSupplyVo>();
        }
        return this.mdmTerminalSupplyService.findTerminalSupply(mdmTerminalVo);
    }

    @Override
    public PageResult<MdmTerminalContactPageVo> findTerminalAndContactList(MdmTerminalCurrentAndSubVo mdmTerminalCurrentAndSubVo) {
        String positionCode;
        Page page = PageUtil.buildPage((Integer)mdmTerminalCurrentAndSubVo.getPageNum(), (Integer)mdmTerminalCurrentAndSubVo.getPageSize());
        String orgCode = mdmTerminalCurrentAndSubVo.getCurrentAndSubOrgCode();
        if (!StringUtils.isEmpty((CharSequence)orgCode)) {
            List allOrgCodeList = OrgUtil.getChildrenOrgCodeListIncludeSelfEnable((String)orgCode);
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)allOrgCodeList)) {
                return PageResult.empty();
            }
            mdmTerminalCurrentAndSubVo.setOrgCodeList(allOrgCodeList);
        }
        if (!StringUtils.isEmpty((CharSequence)(positionCode = mdmTerminalCurrentAndSubVo.getPositionCode()))) {
            List currentAndSubPositionCodeList = PositionUtil.getChildrenPositionCodeListIncludeSelfEnable((String)positionCode);
            mdmTerminalCurrentAndSubVo.setPositionCodeList(currentAndSubPositionCodeList);
        }
        List<MdmTerminalContactPageVo> terminalAndContactList = this.mdmTerminalMapper.findTerminalAndContactList((Page<MdmTerminalVo>)page, mdmTerminalCurrentAndSubVo);
        return PageResult.builder().data(terminalAndContactList).count(Long.valueOf(page.getTotal())).build();
    }

    private MdmTerminalVo queryById(MdmTerminalVo mdmTerminalVo) {
        MdmTerminalVo query = new MdmTerminalVo();
        query.setId(mdmTerminalVo.getId());
        List<MdmTerminalVo> mdmTerminalVos = this.listCondition(query);
        if (mdmTerminalVos.isEmpty()) {
            return new MdmTerminalVo();
        }
        return mdmTerminalVos.get(0);
    }

    private void setRegionName(MdmTerminalEntity entity) {
        if (StringUtils.isNotEmpty((CharSequence)entity.getProvinceCode()) || StringUtils.isNotEmpty((CharSequence)entity.getCityCode()) || StringUtils.isNotEmpty((CharSequence)entity.getDistrictCode())) {
            HashSet<String> regionCodeSet = new HashSet<String>(16);
            if (StringUtils.isNotEmpty((CharSequence)entity.getProvinceCode())) {
                regionCodeSet.add(entity.getProvinceCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getCityCode())) {
                regionCodeSet.add(entity.getCityCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getDistrictCode())) {
                regionCodeSet.add(entity.getDistrictCode());
            }
            MdmRegionService mdmRegionService = (MdmRegionService)SpringApplicationContextUtil.getApplicationContext().getBean(MdmRegionService.class);
            Map<String, String> regionCodeNameMap = mdmRegionService.getRegionCodeNameMap(new ArrayList<String>(regionCodeSet));
            entity.setProvinceName(regionCodeNameMap.get(entity.getProvinceCode()));
            entity.setCityName(regionCodeNameMap.get(entity.getCityCode()));
            entity.setDistrictName(regionCodeNameMap.get(entity.getDistrictCode()));
        }
    }

    @Override
    public List<MdmTerminalStatisticianTypeVo> statisticalType(MdmTerminalVo mdmTerminalVo) {
        List<MdmTerminalStatisticianTypeVo> statisticalType = this.mdmTerminalMapper.statisticalType(mdmTerminalVo);
        if (!org.springframework.util.CollectionUtils.isEmpty(statisticalType)) {
            Map terminalType2 = DictUtil.dictMap((String)"terminal_type");
            return statisticalType.stream().filter(x -> terminalType2.containsKey(x.getStatisticianType())).peek(x -> x.setStatisticianName((String)terminalType2.get(x.getStatisticianType()))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean checkTerminalCodeRelByOrgCodeList(List<String> orgCodeList, String terminalCode) {
        Map<String, List<String>> orgCodeGroupListMap = this.mdmTerminalROrgService.findOrgCodeList(Collections.singletonList(terminalCode));
        if (!orgCodeGroupListMap.isEmpty()) {
            List<String> strings = orgCodeGroupListMap.get(terminalCode);
            strings.retainAll(orgCodeList);
            if (!strings.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean checkTerminalCodeRelByCustomerCodeList(List<String> customerCodeList, String terminalCode) {
        List<String> list = this.mdmTerminalSupplyService.findCustomerCodeListByTerminalCode(terminalCode);
        if (list.size() > 0) {
            list.retainAll(customerCodeList);
            if (list.size() > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<String> checkTerminalCodeRelByOrgOrCusCode(SfaTpmOrgRCusVo orgRCusVo) {
        String terminalCode = orgRCusVo.getTerminalCode();
        List orgRCusList = orgRCusVo.getOrgRCusList();
        ArrayList<String> ids = new ArrayList<String>();
        orgRCusList.forEach(data -> {
            List orgCodeList;
            Boolean flag;
            if (data.getCustomerCode() != null) {
                Boolean flag2 = this.checkTerminalCodeRelByCustomerCodeList(Lists.newArrayList((Object[])new String[]{data.getCustomerCode()}), terminalCode);
                if (flag2.booleanValue()) {
                    ids.add(data.getId());
                }
            } else if (data.getOrgCode() != null && (flag = this.checkTerminalCodeRelByOrgCodeList(orgCodeList = OrgUtil.getChildrenOrgCodeListIncludeSelf((String)data.getOrgCode()), terminalCode)).booleanValue()) {
                ids.add(data.getId());
            }
        });
        return ids;
    }

    @Override
    public List<MdmTerminalVo> findTerminalByCustomerOrgCodeList(List<String> customerOrgCodeList) {
        List entityList;
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(customerOrgCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = CustomerOrgUtil.getChildrenCustomerOrgCodeListIncludeSelfEnable(customerOrgCodeList.stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x)).distinct().collect(Collectors.toList())))) && CollectionUtil.listNotEmptyNotSizeZero((List)(entityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(MdmTerminalEntity::getActApproveStatus, (Object)MdmBpmStatusEnum.PASS.getValue())).in(MdmTerminalEntity::getCustomerOrgCode, (Collection)list)).list()))) {
            return CrmBeanUtil.copyList((List)entityList, MdmTerminalVo.class);
        }
        return new ArrayList<MdmTerminalVo>();
    }

    private void terminalChangeSendEvent(TerminalChangeHandlerReqVo vo) {
        this.applicationContext.publishEvent((ApplicationEvent)new TerminalChangeEvent(vo));
    }
}

