/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.product.event.listener;

import com.alibaba.fastjson.JSON;
import com.biz.crm.nebular.mdm.product.req.ProductChangeHandlerReqVo;
import com.biz.crm.product.event.ProductChangeEvent;
import com.biz.crm.product.handler.ProductChangeHandler;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class ProductEventListener {
    private static final Logger log = LoggerFactory.getLogger(ProductEventListener.class);
    @Autowired(required=false)
    private List<ProductChangeHandler> productChangeHandlers;

    @Async
    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT)
    public void onProductChangeEvent(ProductChangeEvent event) {
        ProductChangeHandlerReqVo vo = (ProductChangeHandlerReqVo)event.getSource();
        log.info("\u5546\u54c1\u4fe1\u606f\u6539\u53d8\u4e8b\u4ef6\u76d1\u542c:{}", (Object)JSON.toJSONString((Object)vo));
        if (CollectionUtils.isNotEmpty(this.productChangeHandlers)) {
            this.productChangeHandlers.forEach(a -> a.handler(vo));
        }
        log.info("\u5546\u54c1\u4fe1\u606f\u6539\u53d8\u4e8b\u4ef6\u76d1\u542c\u5904\u7406\u5b8c\u6210");
    }
}

