/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sync.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.function.model.MdmFunctionEntity;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.sync.MdmFunctionEngineSyncVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncBaseReqVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncFunctionReqVo;
import com.biz.crm.sync.config.MdmSyncParameterParser;
import com.biz.crm.sync.config.MdmSyncProperty;
import com.biz.crm.sync.service.MdmFunctionSyncService;
import com.biz.crm.tableconfig.model.MdmColumnConfigEntity;
import com.biz.crm.tableconfig.model.MdmFunctionSubButtonEntity;
import com.biz.crm.tableconfig.model.MdmFunctionSubEntity;
import com.biz.crm.tableconfig.service.IMdmColumnConfigService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubButtonService;
import com.biz.crm.tableconfig.service.IMdmFunctionSubService;
import com.biz.crm.util.CrmBeanUtil;
import io.jsonwebtoken.lang.Collections;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmFunctionSyncServiceExpandImpl"})
public class MdmFunctionSyncServiceImpl
implements MdmFunctionSyncService {
    private static final Logger log = LoggerFactory.getLogger(MdmFunctionSyncServiceImpl.class);
    @Autowired
    private MdmSyncProperty mdmSyncProperty;
    @Autowired
    private MdmFunctionService mdmFunctionService;
    @Autowired
    private IMdmFunctionSubService mdmFunctionSubService;
    @Autowired
    private IMdmFunctionSubButtonService mdmFunctionSubButtonService;
    @Autowired
    private IMdmColumnConfigService mdmColumnConfigService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void functionSync(MdmSyncFunctionReqVo mdmSyncFunctionReqVo) {
        List functionCodeList = mdmSyncFunctionReqVo.getFunctionCodeList();
        MdmFunctionEngineSyncVo mdmFunctionEngineSyncVo = MdmSyncParameterParser.obtainOriginalData((MdmSyncBaseReqVo)mdmSyncFunctionReqVo, this.mdmSyncProperty, "/mdm/mdmfunction/syncList", mdmSyncFunctionReqVo, MdmFunctionEngineSyncVo.class);
        this.saveFunction(mdmFunctionEngineSyncVo);
        this.saveListConfig(functionCodeList, mdmFunctionEngineSyncVo);
        this.saveButton(functionCodeList, mdmFunctionEngineSyncVo);
        this.saveColumn(functionCodeList, mdmFunctionEngineSyncVo);
    }

    protected void saveColumn(List<String> functionCodeList, MdmFunctionEngineSyncVo mdmFunctionEngineSyncVo) {
        List columnConfigRespVoList = mdmFunctionEngineSyncVo.getMdmColumnConfigRespVoList();
        if (!CollectionUtils.isEmpty((Collection)columnConfigRespVoList)) {
            List columnKeyList = ((LambdaQueryChainWrapper)this.mdmColumnConfigService.lambdaQuery().in(!CollectionUtils.isEmpty(functionCodeList), MdmColumnConfigEntity::getParentCode, functionCodeList)).select(new SFunction[]{MdmColumnConfigEntity::getParentCode, MdmColumnConfigEntity::getFunctionCode, MdmColumnConfigEntity::getField}).list().stream().map(x -> x.getParentCode() + ":" + x.getFunctionCode() + ":" + x.getField()).collect(Collectors.toList());
            List configEntities = columnConfigRespVoList.stream().filter(x -> !columnKeyList.contains(x.getParentCode() + ":" + x.getFunctionCode() + ":" + x.getField())).map(x -> (MdmColumnConfigEntity)CrmBeanUtil.copy((Object)x, MdmColumnConfigEntity.class)).peek(x -> x.setId(null)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(configEntities)) {
                this.mdmColumnConfigService.saveBatch(configEntities);
            }
        }
    }

    protected void saveButton(List<String> functionCodeList, MdmFunctionEngineSyncVo mdmFunctionEngineSyncVo) {
        List subButtonRespVoList = mdmFunctionEngineSyncVo.getMdmFunctionSubButtonRespVoList();
        if (!CollectionUtils.isEmpty((Collection)subButtonRespVoList)) {
            List buttonKeyList = ((LambdaQueryChainWrapper)this.mdmFunctionSubButtonService.lambdaQuery().in(!CollectionUtils.isEmpty(functionCodeList), MdmFunctionSubButtonEntity::getParentCode, functionCodeList)).select(new SFunction[]{MdmFunctionSubButtonEntity::getParentCode, MdmFunctionSubButtonEntity::getFunctionCode, MdmFunctionSubButtonEntity::getButtonCode}).list().stream().map(x -> x.getParentCode() + ":" + x.getFunctionCode() + ":" + x.getButtonCode()).collect(Collectors.toList());
            List buttonEntityList = subButtonRespVoList.stream().filter(x -> !buttonKeyList.contains(x.getParentCode() + ":" + x.getFunctionCode() + ":" + x.getButtonCode())).map(x -> (MdmFunctionSubButtonEntity)CrmBeanUtil.copy((Object)x, MdmFunctionSubButtonEntity.class)).peek(x -> x.setId(null)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(buttonEntityList)) {
                this.mdmFunctionSubButtonService.saveBatch(buttonEntityList);
            }
        }
    }

    protected void saveListConfig(List<String> functionCodeList, MdmFunctionEngineSyncVo mdmFunctionEngineSyncVo) {
        List mdmFunctionSubRespVoList = mdmFunctionEngineSyncVo.getMdmFunctionSubRespVoList();
        Assert.notEmpty((Collection)mdmFunctionSubRespVoList, (String)"\u5217\u8868\u7f3a\u5931");
        List functionSubKeyList = ((LambdaQueryChainWrapper)this.mdmFunctionSubService.lambdaQuery().in(!Collections.isEmpty(functionCodeList), MdmFunctionSubEntity::getParentCode, functionCodeList)).select(new SFunction[]{MdmFunctionSubEntity::getParentCode, MdmFunctionSubEntity::getFunctionCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getParentCode()) && !StringUtils.isEmpty((Object)x.getFunctionCode())).map(x -> x.getParentCode() + ":" + x.getFunctionCode()).collect(Collectors.toList());
        List mdmFunctionSubEntityList = mdmFunctionSubRespVoList.stream().filter(x -> !functionSubKeyList.contains(x.getParentCode() + ":" + x.getFunctionCode())).map(x -> (MdmFunctionSubEntity)CrmBeanUtil.copy((Object)x, MdmFunctionSubEntity.class)).peek(x -> x.setId(null)).collect(Collectors.toList());
        log.info("\u5bfc\u5165\u5217\u8868\u96c6\u5408:{}", mdmFunctionSubEntityList);
        if (!CollectionUtils.isEmpty(mdmFunctionSubEntityList)) {
            this.mdmFunctionSubService.saveBatch(mdmFunctionSubEntityList);
        }
    }

    protected void saveFunction(MdmFunctionEngineSyncVo mdmFunctionEngineSyncVo) {
        List mdmFunctionRespVoList = mdmFunctionEngineSyncVo.getMdmFunctionRespVoList();
        Assert.notEmpty((Collection)mdmFunctionRespVoList, (String)"\u83dc\u5355\u7f3a\u5931");
        List functionKeyList = this.mdmFunctionService.lambdaQuery().select(new SFunction[]{MdmFunctionEntity::getFunctionCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getFunctionCode())).map(MdmFunctionEntity::getFunctionCode).collect(Collectors.toList());
        List mdmFunctionEntities = mdmFunctionRespVoList.stream().filter(x -> !functionKeyList.contains(x.getFunctionCode())).map(x -> (MdmFunctionEntity)CrmBeanUtil.copy((Object)x, MdmFunctionEntity.class)).peek(x -> x.setId(null)).collect(Collectors.toList());
        log.info("\u5bfc\u5165\u83dc\u5355\u96c6\u5408:{}", mdmFunctionEntities);
        if (!CollectionUtils.isEmpty(mdmFunctionEntities)) {
            this.mdmFunctionService.saveBatch(mdmFunctionEntities);
        }
    }
}

