/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelationTerminalPageRespVo;
import com.biz.crm.terminal.service.MdmTerminalROrgService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.user.mapper.MdmUserRelationTerminalMapper;
import com.biz.crm.user.service.MdmUserRelationTerminalService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmUserRelationTerminalServiceExpandImpl"})
public class MdmUserRelationTerminalServiceImpl
implements MdmUserRelationTerminalService {
    @Resource
    private MdmUserRelationTerminalMapper mdmUserRelationTerminalMapper;
    @Resource
    private MdmTerminalSupplyService mdmTerminalSupplyService;
    @Resource
    private MdmTerminalROrgService mdmTerminalROrgService;

    @Override
    public PageResult<MdmUserRelationTerminalPageRespVo> findTerminalNotRelateAnyUser(MdmUserRelationTerminalPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmUserRelationTerminalPageRespVo> list = this.mdmUserRelationTerminalMapper.findTerminalNotRelateAnyUser((Page<MdmUserRelationTerminalPageRespVo>)page, reqVo);
        this.setOrgName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmUserRelationTerminalPageRespVo> findTerminalNotRelateCurUser(MdmUserRelationTerminalPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmUserRelationTerminalPageRespVo> list = this.mdmUserRelationTerminalMapper.findTerminalNotRelateCurUser((Page<MdmUserRelationTerminalPageRespVo>)page, reqVo);
        this.setOrgName(list);
        this.setPositionCodeName(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmUserRelationTerminalPageRespVo> findTerminalHasRelateCurUser(MdmUserRelationTerminalPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmUserRelationTerminalPageRespVo> list = this.mdmUserRelationTerminalMapper.findTerminalHasRelateCurUser((Page<MdmUserRelationTerminalPageRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setId(item.getSupplyId()));
        }
        this.setOrgName(list);
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    protected void setOrgName(List<MdmUserRelationTerminalPageRespVo> list) {
        if (CollectionUtil.listEmpty(list)) {
            return;
        }
        Map<String, List<MdmOrgRespVo>> map = this.mdmTerminalROrgService.findOrgGroupByTerminalCodeList(list.stream().map(MdmUserRelationTerminalPageRespVo::getTerminalCode).collect(Collectors.toList()));
        list.forEach(item -> {
            if (map.containsKey(item.getTerminalCode())) {
                List orgList = (List)map.get(item.getTerminalCode());
                item.setOrgName(orgList.stream().map(MdmOrgRespVo::getOrgName).collect(Collectors.joining(",")));
            }
        });
    }

    protected void setPositionCodeName(List<MdmUserRelationTerminalPageRespVo> list) {
        Map<String, MdmPositionRespVo> positionMap;
        List terminalCodeList;
        List<MdmTerminalSupplyVo> terminalSupplyList;
        List positionCodeList;
        if (CollectionUtil.listNotEmptyNotSizeZero(list) && CollectionUtil.listNotEmptyNotSizeZero(positionCodeList = (terminalSupplyList = this.mdmTerminalSupplyService.findTerminalSupply(new MdmTerminalVo().setTerminalCodeList(terminalCodeList = list.stream().map(MdmUserRelationTerminalPageRespVo::getTerminalCode).collect(Collectors.toList())))).stream().map(MdmTerminalSupplyVo::getPositionCode).filter(StringUtils::isNotEmpty).collect(Collectors.toList())) && !(positionMap = PositionUtil.getPositionByCodeList(positionCodeList).stream().collect(Collectors.toMap(MdmPositionRespVo::getPositionCode, v -> v))).isEmpty()) {
            Map collect = terminalSupplyList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getPositionCode())).collect(Collectors.groupingBy(MdmTerminalSupplyVo::getTerminalCode, Collectors.mapping(MdmTerminalSupplyVo::getPositionCode, Collectors.toList())));
            list.forEach(item -> {
                if (collect.containsKey(item.getTerminalCode())) {
                    List positionCodeListInThisTerminal = (List)collect.get(item.getTerminalCode());
                    ArrayList positionListInThisTerminal = new ArrayList();
                    for (String positionCode : positionCodeListInThisTerminal) {
                        if (!positionMap.containsKey(positionCode)) continue;
                        positionListInThisTerminal.add(positionMap.get(positionCode));
                    }
                    item.setPositionCode(positionListInThisTerminal.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.joining(",")));
                    item.setPositionName(positionListInThisTerminal.stream().map(MdmPositionRespVo::getPositionName).collect(Collectors.joining(",")));
                }
            });
        }
    }
}

