/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.coderule.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.annotation.Klock;
import com.biz.crm.coderule.mapper.MdmCodeRuleMapper;
import com.biz.crm.coderule.model.MdmCodeRuleEntity;
import com.biz.crm.coderule.service.MdmCodeRuleGeneratorService;
import com.biz.crm.coderule.service.MdmCodeRuleService;
import com.biz.crm.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmCodeRuleGeneratorServiceImpl"})
public class MdmCodeRuleGeneratorServiceImpl
implements MdmCodeRuleGeneratorService {
    private static final Logger log = LoggerFactory.getLogger(MdmCodeRuleGeneratorServiceImpl.class);
    @Resource
    private MdmCodeRuleMapper mdmCodeRuleMapper;
    @Resource
    private MdmCodeRuleService mdmCodeRuleService;

    @Override
    @Klock(keys={"code_generator", "#ruleCode"}, waitTime=10L, leaseTime=5L)
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public List<String> generateCodeList(String ruleCode, Integer number) {
        Assert.hasText((String)ruleCode, (String)"\u7f16\u7801\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)number, (String)"\u7f16\u7801\u4e2a\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((number >= 1 ? 1 : 0) != 0, (String)"\u81f3\u5c11\u751f\u6210\u4e00\u4e2a\u7f16\u7801");
        ArrayList<String> list = new ArrayList<String>();
        MdmCodeRuleEntity rule = (MdmCodeRuleEntity)((LambdaQueryChainWrapper)this.mdmCodeRuleService.lambdaQuery().eq(MdmCodeRuleEntity::getRuleCode, (Object)ruleCode)).one();
        Assert.notNull((Object)rule, (String)("\u672a\u627e\u5230\u7f16\u7801\u89c4\u5219\uff1a" + ruleCode));
        Date now = new Date();
        String prefix = rule.getPrefix() == null ? "" : rule.getPrefix();
        String dateStr = "";
        if (StringUtils.isNotEmpty((String)rule.getDateFormat())) {
            SimpleDateFormat sdf = new SimpleDateFormat(rule.getDateFormat());
            dateStr = sdf.format(now);
        }
        Integer currentValue = rule.getCurrentValue();
        int numberLength = rule.getCodeLength() - prefix.length() - dateStr.length();
        for (int i = 1; i <= number; ++i) {
            Integer n = currentValue;
            Integer n2 = currentValue = Integer.valueOf(currentValue + 1);
            list.add(prefix + dateStr + String.format("%0" + numberLength + "d", currentValue));
        }
        rule.setCurrentValue(currentValue);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        rule.setGenerateDate(sdf.format(now));
        this.mdmCodeRuleService.updateById(rule);
        return list;
    }
}

