/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.customer.mapper.MdmCustomerMediaMapper;
import com.biz.crm.customer.model.MdmCustomerMediaEntity;
import com.biz.crm.customer.service.MdmCustomerMediaService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerUploadVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmCustomerMediaServiceExpandImpl"})
public class MdmCustomerMediaServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCustomerMediaMapper, MdmCustomerMediaEntity>
implements MdmCustomerMediaService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerMediaServiceImpl.class);
    @Autowired
    private MdmCustomerMediaMapper mdmCustomerMediaMapper;
    private static final Integer URL_TYPE_CERTIFICATE = 1;
    private static final Integer URL_TYPE_CORPORATE = 2;

    @Override
    public void setUpMedia(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        String customerCode = mdmCustomerMsgReqVo.getCustomerCode();
        if (!StringUtils.isEmpty((String)customerCode)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerMediaEntity::getCustomerCode, (Object)customerCode)).remove();
            List<MdmCustomerMediaEntity> certificateImageEntities = this.setUpCertificateImage(mdmCustomerMsgReqVo);
            List<MdmCustomerMediaEntity> corporateEntities = this.setUpCorporateImage(mdmCustomerMsgReqVo);
            if (!CollectionUtils.isEmpty(certificateImageEntities) || !CollectionUtils.isEmpty(corporateEntities)) {
                ArrayList<MdmCustomerMediaEntity> list = new ArrayList<MdmCustomerMediaEntity>(certificateImageEntities.size() + corporateEntities.size());
                list.addAll(certificateImageEntities);
                list.addAll(corporateEntities);
                this.saveBatch(list);
            }
        }
    }

    protected List<MdmCustomerMediaEntity> setUpCertificateImage(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List certificateImageList = mdmCustomerMsgReqVo.getCertificateImageList();
        if (CollectionUtils.isEmpty((Collection)certificateImageList)) {
            return Collections.emptyList();
        }
        return certificateImageList.stream().filter(x -> !StringUtils.isEmpty((String)x)).map(x -> {
            MdmCustomerMediaEntity mdmCustomerMediaEntity = new MdmCustomerMediaEntity();
            mdmCustomerMediaEntity.setCustomerCode(mdmCustomerMsgReqVo.getCustomerCode());
            mdmCustomerMediaEntity.setUrl(x);
            mdmCustomerMediaEntity.setUrlType(URL_TYPE_CERTIFICATE);
            return mdmCustomerMediaEntity;
        }).collect(Collectors.toList());
    }

    protected List<MdmCustomerMediaEntity> setUpCorporateImage(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List corporateIdentityImageList = mdmCustomerMsgReqVo.getCorporateIdentityImageList();
        if (CollectionUtils.isEmpty((Collection)corporateIdentityImageList)) {
            return Collections.emptyList();
        }
        return corporateIdentityImageList.stream().filter(x -> !StringUtils.isEmpty((String)x.getFileName()) && !StringUtils.isEmpty((String)x.getUrl())).map(x -> {
            MdmCustomerMediaEntity mdmCustomerMediaEntity = new MdmCustomerMediaEntity();
            mdmCustomerMediaEntity.setCustomerCode(mdmCustomerMsgReqVo.getCustomerCode());
            mdmCustomerMediaEntity.setUrlType(URL_TYPE_CORPORATE);
            mdmCustomerMediaEntity.setFileName(x.getFileName());
            mdmCustomerMediaEntity.setUrl(x.getUrl());
            return mdmCustomerMediaEntity;
        }).collect(Collectors.toList());
    }

    @Override
    public void setUpCustomer(MdmCustomerMsgRespVo mdmCustomerMsgRespVo) {
        String customerCode = mdmCustomerMsgRespVo.getCustomerCode();
        if (StringUtils.isEmpty((String)customerCode)) {
            return;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerMediaEntity::getCustomerCode, (Object)customerCode)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List certificateList = list.stream().filter(x -> URL_TYPE_CERTIFICATE.equals(x.getUrlType())).map(MdmCustomerMediaEntity::getUrl).collect(Collectors.toList());
            mdmCustomerMsgRespVo.setCertificateImageList(certificateList);
            List corporateList = list.stream().filter(x -> URL_TYPE_CORPORATE.equals(x.getUrlType())).map(x -> {
                MdmCustomerUploadVo mdmCustomerUploadVo = new MdmCustomerUploadVo();
                mdmCustomerUploadVo.setId(x.getId());
                mdmCustomerUploadVo.setCustomerCode(x.getCustomerCode());
                mdmCustomerUploadVo.setFileName(x.getFileName());
                mdmCustomerUploadVo.setUrl(x.getUrl());
                return mdmCustomerUploadVo;
            }).collect(Collectors.toList());
            mdmCustomerMsgRespVo.setCorporateIdentityImageList(corporateList);
        }
    }
}

