/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.customer.mapper.MdmCustomerROrgMapper;
import com.biz.crm.customer.model.MdmCustomerROrgEntity;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmCustomerROrgServiceExpandImpl"})
public class MdmCustomerROrgServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCustomerROrgMapper, MdmCustomerROrgEntity>
implements MdmCustomerROrgService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerROrgServiceImpl.class);
    @Resource
    private MdmOrgService mdmOrgService;

    @Override
    public Map<String, List<String>> findOrgCodeList(List<String> customerCodeList) {
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return Collections.emptyMap();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerROrgEntity::getCustomerCode, customerCodeList)).select(new SFunction[]{MdmCustomerROrgEntity::getOrgCode, MdmCustomerROrgEntity::getCustomerCode}).list().stream().collect(Collectors.groupingBy(MdmCustomerROrgEntity::getCustomerCode, Collectors.mapping(MdmCustomerROrgEntity::getOrgCode, Collectors.toList())));
    }

    @Override
    public Map<String, List<MdmOrgRespVo>> findOrgGroupByCustomerCodeList(List<String> customerCodeList) {
        if (CollectionUtil.listEmpty(customerCodeList)) {
            return Collections.emptyMap();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerROrgEntity::getCustomerCode, customerCodeList)).select(new SFunction[]{MdmCustomerROrgEntity::getCustomerCode, MdmCustomerROrgEntity::getOrgCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            HashMap<String, List<MdmOrgRespVo>> map = new HashMap<String, List<MdmOrgRespVo>>(16);
            Map<String, MdmOrgRespVo> orgMap = ((LambdaQueryChainWrapper)this.mdmOrgService.lambdaQuery().in(MdmOrgEntity::getOrgCode, (Collection)list.stream().map(MdmCustomerROrgEntity::getOrgCode).collect(Collectors.toSet()))).list().stream().collect(Collectors.toMap(MdmOrgEntity::getOrgCode, v -> (MdmOrgRespVo)CrmBeanUtil.copy((Object)v, MdmOrgRespVo.class)));
            Map groupMap = list.stream().collect(Collectors.groupingBy(MdmCustomerROrgEntity::getCustomerCode, Collectors.mapping(MdmCustomerROrgEntity::getOrgCode, Collectors.toList())));
            for (Map.Entry entry : groupMap.entrySet()) {
                ArrayList<MdmOrgRespVo> orgList = new ArrayList<MdmOrgRespVo>();
                for (String item : entry.getValue()) {
                    if (!orgMap.containsKey(item)) continue;
                    orgList.add(orgMap.get(item));
                }
                map.put(entry.getKey(), orgList);
            }
            return map;
        }
        return Collections.emptyMap();
    }

    @Override
    public List<String> findOrgCodeByCustomerCode(String customerCode) {
        if (StringUtils.isEmpty((Object)customerCode)) {
            return new ArrayList<String>();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCustomerROrgEntity::getCustomerCode, (Object)customerCode)).select(new SFunction[]{MdmCustomerROrgEntity::getOrgCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getOrgCode())).map(MdmCustomerROrgEntity::getOrgCode).distinct().collect(Collectors.toList());
    }

    @Override
    public List<String> findCustomerByOrgCodeList(List<String> orgCodeList) {
        if (CollectionUtils.isEmpty(orgCodeList)) {
            return new ArrayList<String>();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerROrgEntity::getOrgCode, orgCodeList)).select(new SFunction[]{MdmCustomerROrgEntity::getCustomerCode}).list().stream().filter(x -> !StringUtils.isEmpty((Object)x)).map(MdmCustomerROrgEntity::getCustomerCode).distinct().collect(Collectors.toList());
    }

    @Override
    public List<MdmCustomerROrgEntity> findByOrgCodeList(List<String> orgCodeList) {
        if (CollectionUtils.isEmpty(orgCodeList)) {
            return new ArrayList<MdmCustomerROrgEntity>();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerROrgEntity::getOrgCode, orgCodeList)).list();
    }

    @Override
    public void setUpOrg(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List<String> orgCodeList;
        String customerCode = mdmCustomerMsgReqVo.getCustomerCode();
        Assert.hasText((String)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerROrgEntity::getCustomerCode, (Object)customerCode)).remove();
        String orgCode = mdmCustomerMsgReqVo.getOrgCode();
        if (!StringUtils.isEmpty((Object)orgCode) && !CollectionUtils.isEmpty(orgCodeList = Arrays.asList(orgCode.split(",")))) {
            List entityList = orgCodeList.stream().map(x -> {
                MdmCustomerROrgEntity mdmCustomerROrgEntity = new MdmCustomerROrgEntity();
                mdmCustomerROrgEntity.setOrgCode(x);
                mdmCustomerROrgEntity.setCustomerCode(customerCode);
                return mdmCustomerROrgEntity;
            }).collect(Collectors.toList());
            this.saveBatch(entityList);
        }
    }

    @Override
    public void setUpOrg(List<String> customerCodeList, String orgCode) {
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmCustomerROrgEntity::getCustomerCode, customerCodeList)).remove();
        if (StringUtils.isEmpty((Object)orgCode)) {
            return;
        }
        List<String> orgCodeList = Arrays.asList(orgCode.split(","));
        ArrayList<MdmCustomerROrgEntity> list = new ArrayList<MdmCustomerROrgEntity>();
        for (String customerCode : customerCodeList) {
            for (String currentOrgCode : orgCodeList) {
                MdmCustomerROrgEntity mdmCustomerROrgEntity = new MdmCustomerROrgEntity();
                mdmCustomerROrgEntity.setCustomerCode(customerCode);
                mdmCustomerROrgEntity.setOrgCode(currentOrgCode);
                list.add(mdmCustomerROrgEntity);
            }
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.saveBatch(list);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceOrg(List<String> customerCodeList, String originOrgCode, String orgCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero(customerCodeList) && !StringUtils.isEmpty((Object)originOrgCode) && !StringUtils.isEmpty((Object)orgCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmCustomerROrgEntity::getCustomerCode, customerCodeList)).eq(MdmCustomerROrgEntity::getOrgCode, (Object)originOrgCode)).remove();
            Set collect = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerROrgEntity::getCustomerCode, customerCodeList)).eq(MdmCustomerROrgEntity::getOrgCode, (Object)orgCode)).select(new SFunction[]{MdmCustomerROrgEntity::getCustomerCode, MdmCustomerROrgEntity::getOrgCode}).list().stream().map(MdmCustomerROrgEntity::getCustomerCode).collect(Collectors.toSet());
            List entityList = customerCodeList.stream().filter(item -> !collect.contains(item)).map(item -> {
                MdmCustomerROrgEntity entity = new MdmCustomerROrgEntity();
                entity.setCustomerCode(item);
                entity.setOrgCode(orgCode);
                return entity;
            }).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(entityList)) {
                this.saveBatch(entityList);
            }
        }
    }
}

