/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.dict.mapper.MdmDictTypeMapper;
import com.biz.crm.dict.model.MdmDictAttrConfEntity;
import com.biz.crm.dict.model.MdmDictDataEntity;
import com.biz.crm.dict.model.MdmDictTypeEntity;
import com.biz.crm.dict.service.MdmDictAttrConfService;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.dict.service.MdmDictTypeService;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.dict.req.MdmDictTypeReqVo;
import com.biz.crm.nebular.mdm.dict.resp.DictAttrConfRedisVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataRedisVo;
import com.biz.crm.nebular.mdm.dict.resp.DictGroupRedisVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictAttrConfRespVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictDataRespVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictTypeRespVo;
import com.biz.crm.nebular.mdm.sync.MdmDictEngineSyncVo;
import com.biz.crm.nebular.mdm.sync.MdmSyncStandardDictReqVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmDictTypeServiceExpandImpl"})
public class MdmDictTypeServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmDictTypeMapper, MdmDictTypeEntity>
implements MdmDictTypeService {
    private static final Logger log = LoggerFactory.getLogger(MdmDictTypeServiceImpl.class);
    @Resource
    private MdmDictTypeMapper mdmDictTypeMapper;
    @Resource
    private MdmDictDataService mdmDictDataService;
    @Resource
    private MdmDictAttrConfService mdmDictAttrConfService;

    @Override
    public PageResult<MdmDictTypeRespVo> findList(MdmDictTypeReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmDictTypeRespVo> list = this.mdmDictTypeMapper.findList((Page<MdmDictTypeRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmDictTypeRespVo query(String id, String dictTypeCode) {
        if (StringUtils.isEmpty((String)dictTypeCode) && StringUtils.isEmpty((String)id)) {
            return null;
        }
        MdmDictTypeEntity one = (MdmDictTypeEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)dictTypeCode), MdmDictTypeEntity::getDictTypeCode, (Object)dictTypeCode)).one();
        if (one != null) {
            return (MdmDictTypeRespVo)CrmBeanUtil.copy((Object)one, MdmDictTypeRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmDictTypeReqVo reqVo) {
        Assert.hasText((String)reqVo.getDictTypeCode(), (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((!reqVo.getDictTypeCode().contains("/") ? 1 : 0) != 0, (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u5b57\u7b26\u201c/\u201d");
        Assert.isTrue((!reqVo.getDictTypeCode().contains(",") ? 1 : 0) != 0, (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u5b57\u7b26\u201c,\u201d");
        Assert.hasText((String)reqVo.getDictTypeName(), (String)"\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictTypeModule(), (String)"\u6a21\u5757\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictTypeEntity::getDictTypeCode, (Object)reqVo.getDictTypeCode())).list();
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        MdmDictTypeEntity entity = (MdmDictTypeEntity)CrmBeanUtil.copy((Object)reqVo, MdmDictTypeEntity.class);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmDictTypeReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictTypeCode(), (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictTypeName(), (String)"\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictTypeModule(), (String)"\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmDictTypeEntity entity = (MdmDictTypeEntity)this.getById((Serializable)((Object)reqVo.getId()));
        Assert.notNull((Object)entity, (String)"id\u65e0\u6548");
        Assert.isTrue((boolean)entity.getDictTypeCode().equals(reqVo.getDictTypeCode()), (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)entity);
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e");
        List entities = this.listByIds(ids);
        entities.forEach(item -> {
            this.mdmDictDataService.deleteByDictTypeCode(item.getDictTypeCode());
            this.mdmDictAttrConfService.deleteByDictTypeCode(item.getDictTypeCode());
            DictUtil.deleteRedisCache((String)item.getDictTypeCode());
        });
        this.removeByIds(ids);
    }

    @Override
    public void deleteAllCache() {
        List list = this.lambdaQuery().select(new SFunction[]{MdmDictTypeEntity::getDictTypeCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            this.deleteCacheByCodeList(list.stream().map(MdmDictTypeEntity::getDictTypeCode).collect(Collectors.toList()));
        }
    }

    @Override
    public void deleteCacheByIds(List<String> ids) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(ids) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).select(new SFunction[]{MdmDictTypeEntity::getDictTypeCode}).list()))) {
            this.deleteCacheByCodeList(list.stream().map(MdmDictTypeEntity::getDictTypeCode).collect(Collectors.toList()));
        }
    }

    @Override
    public void deleteCacheByCodeList(List<String> codeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(codeList)) {
            codeList.forEach(DictUtil::deleteRedisCache);
        }
    }

    @Override
    public List<DictGroupRedisVo> getDictGroupRedisList(List<String> dictTypeCodeList) {
        ArrayList<DictGroupRedisVo> list = new ArrayList<DictGroupRedisVo>();
        dictTypeCodeList.forEach(dictTypeCode -> {
            DictGroupRedisVo group = this.getDictGroupRedis((String)dictTypeCode);
            if (group != null) {
                list.add(group);
            }
        });
        return list;
    }

    @Override
    public MdmDictEngineSyncVo obtainSyncList(MdmSyncStandardDictReqVo mdmSyncStandardDictReqVo) {
        List mdmDictTypeEntities = ((LambdaQueryChainWrapper)this.lambdaQuery().in(!CollectionUtils.isEmpty((Collection)mdmSyncStandardDictReqVo.getDictTypeCodeList()), MdmDictTypeEntity::getDictTypeCode, (Collection)mdmSyncStandardDictReqVo.getDictTypeCodeList())).list();
        List mdmDictDataEntities = ((LambdaQueryChainWrapper)this.mdmDictDataService.lambdaQuery().in(!CollectionUtils.isEmpty((Collection)mdmSyncStandardDictReqVo.getDictTypeCodeList()), MdmDictDataEntity::getDictTypeCode, (Collection)mdmSyncStandardDictReqVo.getDictTypeCodeList())).list();
        List mdmDictAttrConfEntities = ((LambdaQueryChainWrapper)this.mdmDictAttrConfService.lambdaQuery().in(!CollectionUtils.isEmpty((Collection)mdmSyncStandardDictReqVo.getDictTypeCodeList()), MdmDictAttrConfEntity::getDictTypeCode, (Collection)mdmSyncStandardDictReqVo.getDictTypeCodeList())).list();
        MdmDictEngineSyncVo mdmDictEngineSyncVo = new MdmDictEngineSyncVo();
        mdmDictEngineSyncVo.setMdmDictTypeRespVoList(CrmBeanUtil.copyList((List)mdmDictTypeEntities, MdmDictTypeRespVo.class));
        mdmDictEngineSyncVo.setMdmDictDataRespVoList(CrmBeanUtil.copyList((List)mdmDictDataEntities, MdmDictDataRespVo.class));
        mdmDictEngineSyncVo.setMdmDictAttrConfRespVoList(CrmBeanUtil.copyList((List)mdmDictAttrConfEntities, MdmDictAttrConfRespVo.class));
        return mdmDictEngineSyncVo;
    }

    private DictGroupRedisVo getDictGroupRedis(String dictTypeCode) {
        DictGroupRedisVo respVo = null;
        respVo = new DictGroupRedisVo();
        List<MdmDictDataRespVo> respVoList = this.mdmDictDataService.queryByDictTypeCode(dictTypeCode);
        if (CollectionUtil.listNotEmptyNotSizeZero(respVoList)) {
            List<MdmDictDataRespVo> dataTree = this.generateTreeByParentDictCode(respVoList);
            ArrayList<DictDataRedisVo> dataList = new ArrayList<DictDataRedisVo>();
            for (MdmDictDataRespVo item : dataTree) {
                DictDataRedisVo copy = (DictDataRedisVo)CrmBeanUtil.copy((Object)item, DictDataRedisVo.class);
                copy.setPath(dictTypeCode + "/" + item.getDictCode());
                copy.setParentDictCode(null);
                this.setChildren(item.getChildren(), copy, dataList);
                dataList.add(copy);
            }
            respVo.setDictTypeCode(dictTypeCode);
            respVo.setDataList(dataList);
            List list = this.mdmDictAttrConfService.findList(dictTypeCode).stream().sorted((x1, x2) -> new BigDecimal(x2.getShowOrder()).compareTo(new BigDecimal(x1.getShowOrder()))).collect(Collectors.toList());
            if (list.size() > 0) {
                respVo.setConfList(CrmBeanUtil.copyList(list, DictAttrConfRedisVo.class));
            }
        }
        return respVo;
    }

    private void setChildren(List<MdmDictDataRespVo> children, DictDataRedisVo node, List<DictDataRedisVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(children)) {
            for (MdmDictDataRespVo child : children) {
                DictDataRedisVo copy = (DictDataRedisVo)CrmBeanUtil.copy((Object)child, DictDataRedisVo.class);
                copy.setParentDictCode(node.getDictCode());
                copy.setPath(node.getPath() + "/" + copy.getDictCode());
                if (CollectionUtil.listNotEmptyNotSizeZero((List)child.getChildren())) {
                    this.setChildren(child.getChildren(), copy, list);
                }
                list.add(copy);
            }
        }
    }

    private List<MdmDictDataRespVo> generateTreeByParentDictCode(List<MdmDictDataRespVo> totalList) {
        totalList = totalList.stream().sorted(Comparator.comparing(MdmDictDataRespVo::getDictSort)).collect(Collectors.toList());
        ArrayList<MdmDictDataRespVo> treeList = new ArrayList<MdmDictDataRespVo>();
        ArrayList<Object> curLevelList = new ArrayList<Object>();
        ArrayList<Object> restList = new ArrayList<Object>();
        Map<String, MdmDictDataRespVo> totalMap = totalList.stream().collect(Collectors.toMap(MdmDictDataRespVo::getDictCode, v -> v));
        for (MdmDictDataRespVo mdmDictDataRespVo : totalList) {
            if (StringUtils.isEmpty((String)mdmDictDataRespVo.getParentDictCode()) || !totalMap.containsKey(mdmDictDataRespVo.getParentDictCode())) {
                treeList.add(mdmDictDataRespVo);
                curLevelList.add(mdmDictDataRespVo);
                continue;
            }
            restList.add(mdmDictDataRespVo);
        }
        while (curLevelList.size() > 0 && restList.size() > 0) {
            ArrayList<MdmDictDataRespVo> restTempList = new ArrayList<MdmDictDataRespVo>();
            ArrayList<MdmDictDataRespVo> arrayList = new ArrayList<MdmDictDataRespVo>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(MdmDictDataRespVo::getDictCode, MdmDictDataRespVo::getDictCode));
            LinkedHashMap curLevelChildrenMap = new LinkedHashMap(16);
            for (MdmDictDataRespVo mdmDictDataRespVo : restList) {
                if (curLevelMap.containsKey(mdmDictDataRespVo.getParentDictCode())) {
                    arrayList.add(mdmDictDataRespVo);
                    ArrayList<MdmDictDataRespVo> childrenList = new ArrayList<MdmDictDataRespVo>();
                    if (curLevelChildrenMap.containsKey(mdmDictDataRespVo.getParentDictCode())) {
                        childrenList.addAll((Collection)curLevelChildrenMap.get(mdmDictDataRespVo.getParentDictCode()));
                    }
                    childrenList.add(mdmDictDataRespVo);
                    curLevelChildrenMap.put(mdmDictDataRespVo.getParentDictCode(), childrenList);
                    continue;
                }
                restTempList.add(mdmDictDataRespVo);
            }
            for (MdmDictDataRespVo mdmDictDataRespVo : curLevelList) {
                if (!curLevelChildrenMap.containsKey(mdmDictDataRespVo.getDictCode())) continue;
                mdmDictDataRespVo.setChildren((List)curLevelChildrenMap.get(mdmDictDataRespVo.getDictCode()));
            }
            curLevelList.clear();
            curLevelList.addAll(arrayList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }
}

