/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.utils;

import com.biz.crm.base.BusinessException;
import com.biz.crm.utils.CrmMdmResourceReader;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrmIpResourceUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrmIpResourceUtil.class);

    public static CityResponse getCityResponse(String clientIp) {
        try {
            InetAddress ipAddress = InetAddress.getByName(clientIp);
            return IpResourceReader.READER.city(ipAddress);
        }
        catch (GeoIp2Exception | IOException e) {
            LOGGER.error("\u83b7\u53d6\u884c\u653f\u533a\u57df\u5931\u8d25:{}", e);
            throw new BusinessException("\u83b7\u53d6\u884c\u653f\u533a\u57df\u5931\u8d25");
        }
    }

    private static class IpResourceReader {
        static DatabaseReader READER;

        private IpResourceReader() {
        }

        static {
            CrmMdmResourceReader crmResource = new CrmMdmResourceReader();
            InputStream resource = crmResource.getResource("/GeoLite2-City.mmdb");
            try {
                READER = new DatabaseReader.Builder(resource).build();
            }
            catch (IOException e) {
                LOGGER.error("\u8bfb\u53d6\u884c\u653f\u533a\u57df\u8d44\u6e90\u5931\u8d25:{}", (Throwable)e);
            }
        }
    }
}

