/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.poi.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapDistrictRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapDistrictStatisticianRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeTotalVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmAmapAreaReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmAmapDistrictStatisticianReqVo;
import com.biz.crm.poi.service.MdmAmapStatisticianService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmAmapStatisticsController"})
@Api(tags={"mdm-\u5ba2\u6237\u4e0e\u7ec8\u7aef\u5206\u5e03\u7edf\u8ba1"})
@CrmGlobalLog
public class MdmAmapStatisticianController {
    private static final Logger log = LoggerFactory.getLogger(MdmAmapStatisticianController.class);
    @Autowired
    private MdmAmapStatisticianService mdmAmapStatisticianService;

    @ApiOperation(value="\u67e5\u8be2\u67e5\u8be2\u6240\u6709\u7c7b\u578b\u7edf\u8ba1")
    @GetMapping(value={"/statisticalTotal"})
    public Result<MdmTerminalStatisticianTypeTotalVo> statisticalTotal() {
        return Result.ok((Object)this.mdmAmapStatisticianService.statisticalTotal());
    }

    @ApiOperation(value="\u67e5\u8be2\u5df2\u5408\u4f5c\u5ba2\u6237\u6216\u7ec8\u7aef\u7c7b\u578b\u7edf\u8ba1")
    @GetMapping(value={"/statisticalType"})
    public Result<List<MdmTerminalStatisticianTypeVo>> statisticalType() {
        MdmTerminalStatisticianTypeTotalVo result = new MdmTerminalStatisticianTypeTotalVo();
        this.mdmAmapStatisticianService.statisticalType(result);
        return Result.ok((Object)result.getCooperationTypeList());
    }

    @ApiOperation(value="\u67e5\u8be2\u5df2\u5408\u4f5c\u5ba2\u6237\u6216\u7ec8\u7aef\u533a\u57df\u7edf\u8ba1")
    @PostMapping(value={"/statisticalDistrict"})
    public Result<List<MdmAmapDistrictStatisticianRespVo>> statisticalDistrict(@RequestBody MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo) {
        return Result.ok(this.mdmAmapStatisticianService.statisticalDistrict(mdmAmapDistrictStatisticianReqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u672a\u5408\u4f5c\u5ba2\u6237\u6216\u7ec8\u7aef\u7c7b\u578b\u7edf\u8ba1")
    @GetMapping(value={"/unCooperationStatisticalType"})
    public Result<List<MdmTerminalStatisticianTypeVo>> unCooperationStatisticalType() {
        MdmTerminalStatisticianTypeTotalVo result = new MdmTerminalStatisticianTypeTotalVo();
        this.mdmAmapStatisticianService.unCooperationStatisticalType(result);
        return Result.ok((Object)result.getUnUooperationTypeList());
    }

    @ApiOperation(value="\u67e5\u8be2\u672a\u5408\u4f5c\u533a\u57df\u7edf\u8ba1")
    @PostMapping(value={"/unCooperationStatisticalDistrict"})
    public Result<List<MdmAmapDistrictStatisticianRespVo>> unCooperationStatisticalDistrict(@RequestBody MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo) {
        return Result.ok(this.mdmAmapStatisticianService.unCooperationStatisticalDistrict(mdmAmapDistrictStatisticianReqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u5df2\u5408\u4f5c\u7684\u6253\u70b9\u7edf\u8ba1")
    @PostMapping(value={"/district"})
    public Result<List<MdmAmapDistrictRespVo>> district(@RequestBody MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo) {
        return Result.ok(this.mdmAmapStatisticianService.district(mdmAmapDistrictStatisticianReqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u672a\u5408\u4f5c\u7684\u6253\u70b9\u7edf\u8ba1")
    @PostMapping(value={"/unCooperationDistrict"})
    public Result<List<MdmAmapDistrictRespVo>> unCooperationDistrict(@RequestBody MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo) {
        return Result.ok(this.mdmAmapStatisticianService.unCooperationDistrict(mdmAmapDistrictStatisticianReqVo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u83b7\u53d6\u5730\u56fe\u9759\u6001\u8d44\u6e90")
    @PostMapping(value={"/obtainMapData"})
    public ResponseEntity<byte[]> obtainMapData(@RequestBody MdmAmapAreaReqVo mdmAmapAreaReqVo) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        headers.add("Content-Disposition", "attachment; filename=map.json");
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");
        headers.add("Last-Modified", LocalDateTime.now().toString());
        headers.add("ETag", String.valueOf(System.currentTimeMillis()));
        String amapDistrictCode = mdmAmapAreaReqVo.getAmapDistrictCode();
        String province = mdmAmapAreaReqVo.getProvince();
        StringBuilder sb = new StringBuilder();
        sb.append(File.separator);
        sb.append("map");
        sb.append(File.separator);
        if (!StringUtils.isEmpty((Object)amapDistrictCode)) {
            sb.append("citys").append(File.separator).append(".json");
        } else if (!StringUtils.isEmpty((Object)province)) {
            sb.append("province").append(File.separator).append(".json");
        } else {
            sb.append("china.json");
        }
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(sb.toString());
        Assert.notNull((Object)inputStream, (String)(sb.toString() + "\u8d44\u6e90\u4e0d\u5b58\u5728"));
        byte[] body = null;
        try {
            body = new byte[inputStream.available()];
            inputStream.read(body);
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)body);
            return responseEntity;
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u5730\u56fe\u8d44\u6e90\u5931\u8d25:{}", (Throwable)e);
            ResponseEntity<byte[]> responseEntity = null;
            return responseEntity;
        }
        finally {
            inputStream.close();
        }
    }
}

